/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.PooledDataSource;
import com.zaxxer.sparsebits.SparseBitSet;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.util.PSQLState;
import org.sleuthkit.datamodel.AbstractContent;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.Blackboard;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardArtifactTag;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.CarvedFileContainer;
import org.sleuthkit.datamodel.CarvingResult;
import org.sleuthkit.datamodel.CaseDbAccessManager;
import org.sleuthkit.datamodel.CaseDbConnectionInfo;
import org.sleuthkit.datamodel.CaseDbSchemaVersionNumber;
import org.sleuthkit.datamodel.CommunicationsManager;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentTag;
import org.sleuthkit.datamodel.DataSource;
import org.sleuthkit.datamodel.DerivedFile;
import org.sleuthkit.datamodel.Directory;
import org.sleuthkit.datamodel.Examiner;
import org.sleuthkit.datamodel.File;
import org.sleuthkit.datamodel.FileSystem;
import org.sleuthkit.datamodel.FsContent;
import org.sleuthkit.datamodel.Image;
import org.sleuthkit.datamodel.IngestJobInfo;
import org.sleuthkit.datamodel.IngestModuleInfo;
import org.sleuthkit.datamodel.LayoutFile;
import org.sleuthkit.datamodel.LocalDirectory;
import org.sleuthkit.datamodel.LocalFile;
import org.sleuthkit.datamodel.LocalFilesDataSource;
import org.sleuthkit.datamodel.Report;
import org.sleuthkit.datamodel.SlackFile;
import org.sleuthkit.datamodel.SleuthkitJNI;
import org.sleuthkit.datamodel.Tag;
import org.sleuthkit.datamodel.TagName;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.TskDataException;
import org.sleuthkit.datamodel.TskFileRange;
import org.sleuthkit.datamodel.TskUnsupportedSchemaVersionException;
import org.sleuthkit.datamodel.VersionNumber;
import org.sleuthkit.datamodel.VirtualDirectory;
import org.sleuthkit.datamodel.Volume;
import org.sleuthkit.datamodel.VolumeSystem;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;
import org.sqlite.SQLiteJDBCLoader;

public class SleuthkitCase {
    private static final int MAX_DB_NAME_LEN_BEFORE_TIMESTAMP = 47;
    private static final CaseDbSchemaVersionNumber CURRENT_DB_SCHEMA_VERSION = new CaseDbSchemaVersionNumber(8, 2);
    private static final long BASE_ARTIFACT_ID = Long.MIN_VALUE;
    private static final Logger logger = Logger.getLogger(SleuthkitCase.class.getName());
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private static final int IS_REACHABLE_TIMEOUT_MS = 1000;
    private static final String SQL_ERROR_CONNECTION_GROUP = "08";
    private static final String SQL_ERROR_AUTHENTICATION_GROUP = "28";
    private static final String SQL_ERROR_PRIVILEGE_GROUP = "42";
    private static final String SQL_ERROR_RESOURCE_GROUP = "53";
    private static final String SQL_ERROR_LIMIT_GROUP = "54";
    private static final String SQL_ERROR_INTERNAL_GROUP = "xx";
    private static final int MIN_USER_DEFINED_TYPE_ID = 10000;
    private static final String[] CORE_TABLE_NAMES = new String[]{"tsk_db_info", "tsk_objects", "tsk_image_info", "tsk_image_names", "tsk_vs_info", "tsk_vs_parts", "tsk_fs_info", "tsk_file_layout", "tsk_files", "tsk_files_path", "tsk_files_derived", "tsk_files_derived_method", "tag_names", "content_tags", "blackboard_artifact_tags", "blackboard_artifacts", "blackboard_attributes", "blackboard_artifact_types", "blackboard_attribute_types", "data_source_info", "file_encoding_types", "ingest_module_types", "ingest_job_status_types", "ingest_modules", "ingest_jobs", "ingest_job_modules", "account_types", "accounts", "account_relationships", "review_statuses", "reports"};
    private static final Set<String> CORE_TABLE_NAMES_SET = new HashSet<String>(Arrays.asList(CORE_TABLE_NAMES));
    private static final String[] CORE_INDEX_NAMES = new String[]{"parObjId", "layout_objID", "artifact_objID", "artifact_artifact_objID", "artifact_typeID", "attrsArtifactID", "mime_type", "file_extension", "relationships_account1", "relationships_account2", "relationships_relationship_source_obj_id", "relationships_date_time", "relationships_relationship_type", "relationships_data_source_obj_id"};
    private static final Set<String> CORE_INDEX_NAMES_SET = new HashSet<String>(Arrays.asList(CORE_INDEX_NAMES));
    private static final String TSK_VERSION_KEY = "TSK_VER";
    private static final String SCHEMA_MAJOR_VERSION_KEY = "SCHEMA_MAJOR_VERSION";
    private static final String SCHEMA_MINOR_VERSION_KEY = "SCHEMA_MINOR_VERSION";
    private static final String CREATION_SCHEMA_MAJOR_VERSION_KEY = "CREATION_SCHEMA_MAJOR_VERSION";
    private static final String CREATION_SCHEMA_MINOR_VERSION_KEY = "CREATION_SCHEMA_MINOR_VERSION";
    private final ConnectionPool connections;
    private final Map<Long, VirtualDirectory> rootIdsToCarvedFileDirs = new HashMap<Long, VirtualDirectory>();
    private final Map<Long, FileSystem> fileSystemIdMap = new HashMap<Long, FileSystem>();
    private final ArrayList<ErrorObserver> sleuthkitCaseErrorObservers = new ArrayList();
    private final String databaseName;
    private final String dbPath;
    private final TskData.DbType dbType;
    private final String caseDirPath;
    private SleuthkitJNI.CaseDbHandle caseHandle;
    private String dbBackupPath;
    private Map<Integer, BlackboardArtifact.Type> typeIdToArtifactTypeMap;
    private Map<Integer, BlackboardAttribute.Type> typeIdToAttributeTypeMap;
    private Map<String, BlackboardArtifact.Type> typeNameToArtifactTypeMap;
    private Map<String, BlackboardAttribute.Type> typeNameToAttributeTypeMap;
    private final Map<Long, SparseBitSet> hasChildrenBitSetMap = new HashMap<Long, SparseBitSet>();
    private long nextArtifactId;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final Object communicationsMgrInstanceLock = new Object();
    private CommunicationsManager communicationsMgrInstance = null;
    private final Object blackboardInstanceLock = new Object();
    private Blackboard blackboardInstance = null;
    private CaseDbAccessManager dbAccessManagerInstance = null;
    private final Map<String, Set<Long>> deviceIdToDatasourceObjIdMap = new HashMap<String, Set<Long>>();
    private final Map<Long, Content> frequentlyUsedContentMap = new HashMap<Long, Content>();
    private Examiner cachedCurrentExaminer = null;

    public static void tryConnect(CaseDbConnectionInfo info) throws TskCoreException {
        if (info.getHost() == null || info.getHost().isEmpty()) {
            throw new TskCoreException(bundle.getString("DatabaseConnectionCheck.MissingHostname"));
        }
        if (info.getPort() == null || info.getPort().isEmpty()) {
            throw new TskCoreException(bundle.getString("DatabaseConnectionCheck.MissingPort"));
        }
        if (info.getUserName() == null || info.getUserName().isEmpty()) {
            throw new TskCoreException(bundle.getString("DatabaseConnectionCheck.MissingUsername"));
        }
        if (info.getPassword() == null || info.getPassword().isEmpty()) {
            throw new TskCoreException(bundle.getString("DatabaseConnectionCheck.MissingPassword"));
        }
        try {
            Class.forName("org.postgresql.Driver");
            Connection conn = DriverManager.getConnection("jdbc:postgresql://" + info.getHost() + ":" + info.getPort() + "/postgres", info.getUserName(), info.getPassword());
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException ex) {
            String result;
            block14: {
                String sqlState = ex.getSQLState().toLowerCase();
                if (sqlState.startsWith(SQL_ERROR_CONNECTION_GROUP)) {
                    try {
                        if (InetAddress.getByName(info.getHost()).isReachable(1000)) {
                            result = bundle.getString("DatabaseConnectionCheck.Port");
                            break block14;
                        }
                        result = bundle.getString("DatabaseConnectionCheck.HostnameOrPort");
                    }
                    catch (IOException any) {
                        result = bundle.getString("DatabaseConnectionCheck.Everything");
                    }
                    catch (MissingResourceException any) {
                        result = bundle.getString("DatabaseConnectionCheck.Everything");
                    }
                } else {
                    result = sqlState.startsWith(SQL_ERROR_AUTHENTICATION_GROUP) ? bundle.getString("DatabaseConnectionCheck.Authentication") : (sqlState.startsWith(SQL_ERROR_PRIVILEGE_GROUP) ? bundle.getString("DatabaseConnectionCheck.Access") : (sqlState.startsWith(SQL_ERROR_RESOURCE_GROUP) ? bundle.getString("DatabaseConnectionCheck.ServerDiskSpace") : (sqlState.startsWith(SQL_ERROR_LIMIT_GROUP) ? bundle.getString("DatabaseConnectionCheck.ServerRestart") : (sqlState.startsWith(SQL_ERROR_INTERNAL_GROUP) ? bundle.getString("DatabaseConnectionCheck.InternalServerIssue") : bundle.getString("DatabaseConnectionCheck.Connection")))));
                }
            }
            throw new TskCoreException(result);
        }
        catch (ClassNotFoundException ex) {
            throw new TskCoreException(bundle.getString("DatabaseConnectionCheck.Installation"));
        }
    }

    private SleuthkitCase(String dbPath, SleuthkitJNI.CaseDbHandle caseHandle, TskData.DbType dbType) throws Exception {
        Class.forName("org.sqlite.JDBC");
        this.dbPath = dbPath;
        this.dbType = dbType;
        java.io.File dbFile = new java.io.File(dbPath);
        this.caseDirPath = dbFile.getParentFile().getAbsolutePath();
        this.databaseName = dbFile.getName();
        this.connections = new SQLiteConnections(dbPath);
        this.caseHandle = caseHandle;
        this.init();
        this.logSQLiteJDBCDriverInfo();
    }

    private SleuthkitCase(String host, int port, String dbName, String userName, String password, SleuthkitJNI.CaseDbHandle caseHandle, String caseDirPath, TskData.DbType dbType) throws Exception {
        this.dbPath = "";
        this.databaseName = dbName;
        this.dbType = dbType;
        this.caseDirPath = caseDirPath;
        this.connections = new PostgreSQLConnections(host, port, dbName, userName, password);
        this.caseHandle = caseHandle;
        this.init();
    }

    private void init() throws Exception {
        this.typeIdToArtifactTypeMap = new ConcurrentHashMap<Integer, BlackboardArtifact.Type>();
        this.typeIdToAttributeTypeMap = new ConcurrentHashMap<Integer, BlackboardAttribute.Type>();
        this.typeNameToArtifactTypeMap = new ConcurrentHashMap<String, BlackboardArtifact.Type>();
        this.typeNameToAttributeTypeMap = new ConcurrentHashMap<String, BlackboardAttribute.Type>();
        this.initBlackboardArtifactTypes();
        this.initBlackboardAttributeTypes();
        this.initNextArtifactId();
        this.updateDatabaseSchema(null);
        CaseDbConnection connection = this.connections.getConnection();
        this.initIngestModuleTypes(connection);
        this.initIngestStatusTypes(connection);
        this.initReviewStatuses(connection);
        this.initEncodingTypes(connection);
        this.populateHasChildrenMap(connection);
        this.updateExaminers(connection);
        connection.close();
    }

    static Set<String> getCoreTableNames() {
        return CORE_TABLE_NAMES_SET;
    }

    static Set<String> getCoreIndexNames() {
        return CORE_INDEX_NAMES_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getHasChildren(Content c) {
        long objId = c.getId();
        long mapIndex = objId / Integer.MAX_VALUE;
        int mapValue = (int)(objId % Integer.MAX_VALUE);
        Map<Long, SparseBitSet> map = this.hasChildrenBitSetMap;
        synchronized (map) {
            if (this.hasChildrenBitSetMap.containsKey(mapIndex)) {
                return this.hasChildrenBitSetMap.get(mapIndex).get(mapValue);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHasChildren(Long objId) {
        long mapIndex = objId / Integer.MAX_VALUE;
        int mapValue = (int)(objId % Integer.MAX_VALUE);
        Map<Long, SparseBitSet> map = this.hasChildrenBitSetMap;
        synchronized (map) {
            if (this.hasChildrenBitSetMap.containsKey(mapIndex)) {
                this.hasChildrenBitSetMap.get(mapIndex).set(mapValue);
            } else {
                SparseBitSet bitSet = new SparseBitSet();
                bitSet.set(mapValue);
                this.hasChildrenBitSetMap.put(mapIndex, bitSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommunicationsManager getCommunicationsManager() throws TskCoreException {
        Object object = this.communicationsMgrInstanceLock;
        synchronized (object) {
            if (null == this.communicationsMgrInstance) {
                this.communicationsMgrInstance = new CommunicationsManager(this);
            }
            return this.communicationsMgrInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blackboard getBlackboard() {
        Object object = this.blackboardInstanceLock;
        synchronized (object) {
            if (null == this.blackboardInstance) {
                this.blackboardInstance = new Blackboard(this);
            }
            return this.blackboardInstance;
        }
    }

    public synchronized CaseDbAccessManager getCaseDbAccessManager() throws TskCoreException {
        if (null == this.dbAccessManagerInstance) {
            this.dbAccessManagerInstance = new CaseDbAccessManager(this);
        }
        return this.dbAccessManagerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBlackboardArtifactTypes() throws SQLException, TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            for (BlackboardArtifact.ARTIFACT_TYPE type : BlackboardArtifact.ARTIFACT_TYPE.values()) {
                try {
                    statement.execute("INSERT INTO blackboard_artifact_types (artifact_type_id, type_name, display_name) VALUES (" + type.getTypeID() + " , '" + type.getLabel() + "', '" + type.getDisplayName() + "')");
                }
                catch (SQLException ex) {
                    resultSet = connection.executeQuery(statement, "SELECT COUNT(*) AS count FROM blackboard_artifact_types WHERE artifact_type_id = '" + type.getTypeID() + "'");
                    resultSet.next();
                    if (resultSet.getLong("count") == 0L) {
                        throw ex;
                    }
                    resultSet.close();
                    resultSet = null;
                }
                this.typeIdToArtifactTypeMap.put(type.getTypeID(), new BlackboardArtifact.Type(type));
                this.typeNameToArtifactTypeMap.put(type.getLabel(), new BlackboardArtifact.Type(type));
            }
            if (this.dbType == TskData.DbType.POSTGRESQL) {
                int newPrimaryKeyIndex = Collections.max(Arrays.asList(BlackboardArtifact.ARTIFACT_TYPE.values())).getTypeID() + 1;
                statement.execute("ALTER SEQUENCE blackboard_artifact_types_artifact_type_id_seq RESTART WITH " + newPrimaryKeyIndex);
            }
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBlackboardAttributeTypes() throws SQLException, TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            for (BlackboardAttribute.ATTRIBUTE_TYPE type : BlackboardAttribute.ATTRIBUTE_TYPE.values()) {
                try {
                    statement.execute("INSERT INTO blackboard_attribute_types (attribute_type_id, type_name, display_name, value_type) VALUES (" + type.getTypeID() + ", '" + type.getLabel() + "', '" + type.getDisplayName() + "', '" + type.getValueType().getType() + "')");
                }
                catch (SQLException ex) {
                    resultSet = connection.executeQuery(statement, "SELECT COUNT(*) AS count FROM blackboard_attribute_types WHERE attribute_type_id = '" + type.getTypeID() + "'");
                    resultSet.next();
                    if (resultSet.getLong("count") == 0L) {
                        throw ex;
                    }
                    resultSet.close();
                    resultSet = null;
                }
                this.typeIdToAttributeTypeMap.put(type.getTypeID(), new BlackboardAttribute.Type(type));
                this.typeNameToAttributeTypeMap.put(type.getLabel(), new BlackboardAttribute.Type(type));
            }
            if (this.dbType == TskData.DbType.POSTGRESQL) {
                int newPrimaryKeyIndex = Collections.max(Arrays.asList(BlackboardAttribute.ATTRIBUTE_TYPE.values())).getTypeID() + 1;
                statement.execute("ALTER SEQUENCE blackboard_attribute_types_attribute_type_id_seq RESTART WITH " + newPrimaryKeyIndex);
            }
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNextArtifactId() throws SQLException, TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT MAX(artifact_id) AS max_artifact_id FROM blackboard_artifacts");
            resultSet.next();
            this.nextArtifactId = resultSet.getLong("max_artifact_id") + 1L;
            if (this.nextArtifactId == 1L) {
                this.nextArtifactId = Long.MIN_VALUE;
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        connection.close();
        this.releaseSingleUserCaseReadLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIngestModuleTypes(CaseDbConnection connection) throws SQLException, TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            for (IngestModuleInfo.IngestModuleType type : IngestModuleInfo.IngestModuleType.values()) {
                try {
                    statement.execute("INSERT INTO ingest_module_types (type_id, type_name) VALUES (" + type.ordinal() + ", '" + type.toString() + "');");
                }
                catch (SQLException ex) {
                    resultSet = connection.executeQuery(statement, "SELECT COUNT(*) as count FROM ingest_module_types WHERE type_id = " + type.ordinal() + ";");
                    resultSet.next();
                    if (resultSet.getLong("count") == 0L) {
                        throw ex;
                    }
                    resultSet.close();
                    resultSet = null;
                }
            }
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIngestStatusTypes(CaseDbConnection connection) throws SQLException, TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            for (IngestJobInfo.IngestJobStatusType type : IngestJobInfo.IngestJobStatusType.values()) {
                try {
                    statement.execute("INSERT INTO ingest_job_status_types (type_id, type_name) VALUES (" + type.ordinal() + ", '" + type.toString() + "');");
                }
                catch (SQLException ex) {
                    resultSet = connection.executeQuery(statement, "SELECT COUNT(*) as count FROM ingest_job_status_types WHERE type_id = " + type.ordinal() + ";");
                    resultSet.next();
                    if (resultSet.getLong("count") == 0L) {
                        throw ex;
                    }
                    resultSet.close();
                    resultSet = null;
                }
            }
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReviewStatuses(CaseDbConnection connection) throws SQLException, TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            for (BlackboardArtifact.ReviewStatus status : BlackboardArtifact.ReviewStatus.values()) {
                try {
                    statement.execute("INSERT INTO review_statuses (review_status_id, review_status_name, display_name) VALUES (" + status.getID() + ",'" + status.getName() + "','" + status.getDisplayName() + "')");
                }
                catch (SQLException ex) {
                    resultSet = connection.executeQuery(statement, "SELECT COUNT(*) as count FROM review_statuses WHERE review_status_id = " + status.getID());
                    resultSet.next();
                    if (resultSet.getLong("count") == 0L) {
                        throw ex;
                    }
                    resultSet.close();
                    resultSet = null;
                }
            }
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEncodingTypes(CaseDbConnection connection) throws SQLException, TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            for (TskData.EncodingType type : TskData.EncodingType.values()) {
                try {
                    statement.execute("INSERT INTO file_encoding_types (encoding_type, name) VALUES (" + type.getType() + " , '" + type.name() + "')");
                }
                catch (SQLException ex) {
                    resultSet = connection.executeQuery(statement, "SELECT COUNT(*) as count FROM file_encoding_types WHERE encoding_type = " + type.getType());
                    resultSet.next();
                    if (resultSet.getLong("count") == 0L) {
                        throw ex;
                    }
                    resultSet.close();
                    resultSet = null;
                }
            }
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    private void updateExaminers(CaseDbConnection connection) throws SQLException, TskCoreException {
        String loginName = System.getProperty("user.name");
        if (loginName.isEmpty()) {
            logger.log(Level.SEVERE, "Cannot determine logged in user name");
            return;
        }
        this.acquireSingleUserCaseWriteLock();
        Statement statement = connection.createStatement();
        try {
            String query = "INTO tsk_examiners (login_name) VALUES ('" + loginName + "')";
            switch (this.getDatabaseType()) {
                case POSTGRESQL: {
                    query = "INSERT " + query + " ON CONFLICT DO NOTHING";
                    break;
                }
                case SQLITE: {
                    query = "INSERT OR IGNORE " + query;
                    break;
                }
                default: {
                    throw new TskCoreException("Unknown DB Type: " + this.getDatabaseType().name());
                }
            }
            statement.execute(query);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error inserting row in tsk_examiners", ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateHasChildrenMap(CaseDbConnection connection) throws TskCoreException {
        long timestamp = System.currentTimeMillis();
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select distinct par_obj_id from tsk_objects");
            Map<Long, SparseBitSet> map = this.hasChildrenBitSetMap;
            synchronized (map) {
                while (resultSet.next()) {
                    this.setHasChildren(resultSet.getLong("par_obj_id"));
                }
            }
            long delay = System.currentTimeMillis() - timestamp;
            logger.log(Level.INFO, "Time to initialize parent node cache: {0} ms", delay);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error populating parent node cache", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseWriteLock();
    }

    void addDataSourceToHasChildrenMap() throws TskCoreException {
        try (CaseDbConnection connection = this.connections.getConnection();){
            this.populateHasChildrenMap(connection);
        }
    }

    private void updateDatabaseSchema(String dbPath) throws Exception {
        CaseDbConnection connection = this.connections.getConnection();
        ResultSet resultSet = null;
        Statement statement = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            int dbSchemaMajorVersion;
            connection.beginTransaction();
            boolean hasMinorVersion = false;
            ResultSet columns = connection.getConnection().getMetaData().getColumns(null, null, "tsk_db_info", "schema%");
            while (columns.next()) {
                if (!columns.getString("COLUMN_NAME").equals("schema_minor_ver")) continue;
                hasMinorVersion = true;
            }
            int dbSchemaMinorVersion = 0;
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT schema_ver" + (hasMinorVersion ? ", schema_minor_ver" : "") + " FROM tsk_db_info");
            if (resultSet.next()) {
                dbSchemaMajorVersion = resultSet.getInt("schema_ver");
                if (hasMinorVersion) {
                    dbSchemaMinorVersion = resultSet.getInt("schema_minor_ver");
                }
            } else {
                throw new TskCoreException();
            }
            CaseDbSchemaVersionNumber dbSchemaVersion = new CaseDbSchemaVersionNumber(dbSchemaMajorVersion, dbSchemaMinorVersion);
            resultSet.close();
            resultSet = null;
            statement.close();
            statement = null;
            if (!CURRENT_DB_SCHEMA_VERSION.isCompatible(dbSchemaVersion)) {
                throw new TskUnsupportedSchemaVersionException("Unsupported DB schema version " + dbSchemaVersion + ", the highest supported schema version is " + CURRENT_DB_SCHEMA_VERSION.getMajor() + ".X");
            }
            if (dbSchemaVersion.compareTo(CURRENT_DB_SCHEMA_VERSION) < 0) {
                if (null != dbPath) {
                    String backupFilePath = dbPath + ".schemaVer" + dbSchemaVersion.toString() + ".backup";
                    this.copyCaseDB(backupFilePath);
                    this.dbBackupPath = backupFilePath;
                }
                dbSchemaVersion = this.updateFromSchema2toSchema3(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema3toSchema4(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema4toSchema5(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema5toSchema6(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema6toSchema7(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema7toSchema7dot1(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema7dot1toSchema7dot2(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema7dot2toSchema8dot0(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema8dot0toSchema8dot1(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema8dot1toSchema8dot2(dbSchemaVersion, connection);
                statement = connection.createStatement();
                connection.executeUpdate(statement, "UPDATE tsk_db_info SET schema_ver = " + dbSchemaVersion.getMajor() + ", schema_minor_ver = " + dbSchemaVersion.getMinor());
                statement.close();
                statement = null;
            }
            connection.commitTransaction();
        }
        catch (Exception ex) {
            try {
                connection.rollbackTransaction();
                throw ex;
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                connection.close();
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        connection.close();
        this.releaseSingleUserCaseWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyCaseDB(String newDBPath) throws IOException {
        if (this.dbPath.isEmpty()) {
            throw new IOException("Copying case database files is not supported for this type of case database");
        }
        InputStream in = null;
        OutputStream out = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            FileInputStream inFile = new FileInputStream(this.dbPath);
            in = new BufferedInputStream(inFile);
            FileOutputStream outFile = new FileOutputStream(newDBPath);
            out = new BufferedOutputStream(outFile);
            int bytesRead = in.read();
            while (bytesRead != -1) {
                out.write(bytesRead);
                bytesRead = in.read();
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not close streams after db copy", e);
            }
            this.releaseSingleUserCaseWriteLock();
        }
    }

    private void logSQLiteJDBCDriverInfo() {
        try {
            logger.info(String.format("sqlite-jdbc version %s loaded in %s mode", SQLiteJDBCLoader.getVersion(), SQLiteJDBCLoader.isNativeMode() ? "native" : "pure-java"));
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error querying case database mode", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private CaseDbSchemaVersionNumber updateFromSchema2toSchema3(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 2) {
            return schemaVersion;
        }
        Statement statement = null;
        Statement updateStatement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            statement.execute("CREATE TABLE tag_names (tag_name_id INTEGER PRIMARY KEY, display_name TEXT UNIQUE, description TEXT NOT NULL, color TEXT NOT NULL)");
            statement.execute("CREATE TABLE content_tags (tag_id INTEGER PRIMARY KEY, obj_id INTEGER NOT NULL, tag_name_id INTEGER NOT NULL, comment TEXT NOT NULL, begin_byte_offset INTEGER NOT NULL, end_byte_offset INTEGER NOT NULL)");
            statement.execute("CREATE TABLE blackboard_artifact_tags (tag_id INTEGER PRIMARY KEY, artifact_id INTEGER NOT NULL, tag_name_id INTEGER NOT NULL, comment TEXT NOT NULL)");
            statement.execute("CREATE TABLE reports (report_id INTEGER PRIMARY KEY, path TEXT NOT NULL, crtime INTEGER NOT NULL, src_module_name TEXT NOT NULL, report_name TEXT NOT NULL)");
            statement.execute("ALTER TABLE tsk_image_info ADD COLUMN size INTEGER;");
            statement.execute("ALTER TABLE tsk_image_info ADD COLUMN md5 TEXT;");
            statement.execute("ALTER TABLE tsk_image_info ADD COLUMN display_name TEXT;");
            statement.execute("ALTER TABLE tsk_fs_info ADD COLUMN display_name TEXT;");
            statement.execute("ALTER TABLE tsk_files ADD COLUMN meta_seq INTEGER;");
            statement.execute("ALTER TABLE blackboard_attributes ADD COLUMN artifact_type_id INTEGER NULL NOT NULL DEFAULT -1;");
            statement.execute("CREATE INDEX attribute_artifactTypeId ON blackboard_attributes(artifact_type_id);");
            statement.execute("CREATE INDEX attribute_valueText ON blackboard_attributes(value_text);");
            statement.execute("CREATE INDEX attribute_valueInt32 ON blackboard_attributes(value_int32);");
            statement.execute("CREATE INDEX attribute_valueInt64 ON blackboard_attributes(value_int64);");
            statement.execute("CREATE INDEX attribute_valueDouble ON blackboard_attributes(value_double);");
            resultSet = statement.executeQuery("SELECT attrs.artifact_id AS artifact_id, arts.artifact_type_id AS artifact_type_id FROM blackboard_attributes AS attrs INNER JOIN blackboard_artifacts AS arts WHERE attrs.artifact_id = arts.artifact_id;");
            updateStatement = connection.createStatement();
            while (resultSet.next()) {
                long artifactId = resultSet.getLong("artifact_id");
                int artifactTypeId = resultSet.getInt("artifact_type_id");
                updateStatement.executeUpdate("UPDATE blackboard_attributes SET artifact_type_id = " + artifactTypeId + " WHERE blackboard_attributes.artifact_id = " + artifactId + ";");
            }
            resultSet.close();
            resultSet = null;
            HashMap<String, TagName> tagNames = new HashMap<String, TagName>();
            for (BlackboardArtifact artifact : this.getBlackboardArtifacts(BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_FILE)) {
                TagName tagName;
                Content content = this.getContentById(artifact.getObjectID());
                String name = "";
                String comment = "";
                ArrayList<BlackboardAttribute> attributes = this.getBlackboardAttributes(artifact);
                for (BlackboardAttribute blackboardAttribute : attributes) {
                    if (blackboardAttribute.getAttributeTypeID() == BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TAG_NAME.getTypeID()) {
                        name = blackboardAttribute.getValueString();
                        continue;
                    }
                    if (blackboardAttribute.getAttributeTypeID() != BlackboardAttribute.ATTRIBUTE_TYPE.TSK_COMMENT.getTypeID()) continue;
                    comment = blackboardAttribute.getValueString();
                }
                if (name.isEmpty()) continue;
                if (tagNames.containsKey(name)) {
                    tagName = (TagName)tagNames.get(name);
                } else {
                    tagName = this.addTagName(name, "", TagName.HTML_COLOR.NONE);
                    tagNames.put(name, tagName);
                }
                this.addContentTag(content, tagName, comment, 0L, content.getSize() - 1L);
            }
            for (BlackboardArtifact artifact : this.getBlackboardArtifacts(BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_ARTIFACT)) {
                void var14_23;
                long taggedArtifactId = -1L;
                String name = "";
                String comment = "";
                ArrayList<BlackboardAttribute> attributes = this.getBlackboardAttributes(artifact);
                for (BlackboardAttribute attribute : attributes) {
                    if (attribute.getAttributeTypeID() == BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TAG_NAME.getTypeID()) {
                        name = attribute.getValueString();
                        continue;
                    }
                    if (attribute.getAttributeTypeID() == BlackboardAttribute.ATTRIBUTE_TYPE.TSK_COMMENT.getTypeID()) {
                        comment = attribute.getValueString();
                        continue;
                    }
                    if (attribute.getAttributeTypeID() != BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TAGGED_ARTIFACT.getTypeID()) continue;
                    taggedArtifactId = attribute.getValueLong();
                }
                if (taggedArtifactId == -1L || name.isEmpty()) continue;
                if (tagNames.containsKey(name)) {
                    TagName tagName = (TagName)tagNames.get(name);
                } else {
                    TagName tagName = this.addTagName(name, "", TagName.HTML_COLOR.NONE);
                    tagNames.put(name, tagName);
                }
                this.addBlackboardArtifactTag(this.getBlackboardArtifact(taggedArtifactId), (TagName)var14_23, comment);
            }
            statement.execute("DELETE FROM blackboard_attributes WHERE artifact_id IN (SELECT artifact_id FROM blackboard_artifacts WHERE artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_FILE.getTypeID() + " OR artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_ARTIFACT.getTypeID() + ");");
            statement.execute("DELETE FROM blackboard_artifacts WHERE artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_FILE.getTypeID() + " OR artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_ARTIFACT.getTypeID() + ";");
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(3, 0);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeStatement(updateStatement);
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeStatement(updateStatement);
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        connection.close();
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema3toSchema4(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 3) {
            return schemaVersion;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Statement queryStatement = null;
        ResultSet queryResultSet = null;
        Statement updateStatement = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            updateStatement = connection.createStatement();
            statement.execute("ALTER TABLE tsk_files ADD COLUMN mime_type TEXT;");
            resultSet = statement.executeQuery("SELECT files.obj_id AS obj_id, attrs.value_text AS value_text FROM tsk_files AS files, blackboard_attributes AS attrs, blackboard_artifacts AS arts WHERE files.obj_id = arts.obj_id AND arts.artifact_id = attrs.artifact_id AND arts.artifact_type_id = 1 AND attrs.attribute_type_id = 62");
            while (resultSet.next()) {
                updateStatement.executeUpdate("UPDATE tsk_files SET mime_type = '" + resultSet.getString("value_text") + "' WHERE tsk_files.obj_id = " + resultSet.getInt("obj_id") + ";");
            }
            resultSet.close();
            statement.execute("ALTER TABLE blackboard_attribute_types ADD COLUMN value_type INTEGER NOT NULL DEFAULT -1;");
            resultSet = statement.executeQuery("SELECT * FROM blackboard_attribute_types AS types");
            while (resultSet.next()) {
                int attributeTypeId = resultSet.getInt("attribute_type_id");
                String attributeLabel = resultSet.getString("type_name");
                if (attributeTypeId >= 10000) continue;
                updateStatement.executeUpdate("UPDATE blackboard_attribute_types SET value_type = " + BlackboardAttribute.ATTRIBUTE_TYPE.fromLabel(attributeLabel).getValueType().getType() + " WHERE blackboard_attribute_types.attribute_type_id = " + attributeTypeId + ";");
            }
            resultSet.close();
            queryStatement = connection.createStatement();
            statement.execute("CREATE TABLE data_source_info (obj_id INTEGER PRIMARY KEY, device_id TEXT NOT NULL, time_zone TEXT NOT NULL, FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id));");
            resultSet = statement.executeQuery("SELECT * FROM tsk_objects WHERE par_obj_id IS NULL");
            while (resultSet.next()) {
                long objectId = resultSet.getLong("obj_id");
                String timeZone = "";
                queryResultSet = queryStatement.executeQuery("SELECT tzone FROM tsk_image_info WHERE obj_id = " + objectId);
                if (queryResultSet.next()) {
                    timeZone = queryResultSet.getString("tzone");
                }
                queryResultSet.close();
                updateStatement.executeUpdate("INSERT INTO data_source_info (obj_id, device_id, time_zone) VALUES(" + objectId + ", '" + UUID.randomUUID().toString() + "' , '" + timeZone + "');");
            }
            resultSet.close();
            statement.execute("ALTER TABLE tsk_files ADD COLUMN data_source_obj_id BIGINT NOT NULL DEFAULT -1;");
            resultSet = statement.executeQuery("SELECT tsk_files.obj_id AS obj_id, par_obj_id FROM tsk_files, tsk_objects WHERE tsk_files.obj_id = tsk_objects.obj_id");
            while (resultSet.next()) {
                long fileId = resultSet.getLong("obj_id");
                long dataSourceId = this.getDataSourceObjectId(connection, fileId);
                updateStatement.executeUpdate("UPDATE tsk_files SET data_source_obj_id = " + dataSourceId + " WHERE obj_id = " + fileId + ";");
            }
            resultSet.close();
            statement.execute("CREATE TABLE ingest_module_types (type_id INTEGER PRIMARY KEY, type_name TEXT NOT NULL)");
            statement.execute("CREATE TABLE ingest_job_status_types (type_id INTEGER PRIMARY KEY, type_name TEXT NOT NULL)");
            if (this.dbType.equals((Object)TskData.DbType.SQLITE)) {
                statement.execute("CREATE TABLE ingest_modules (ingest_module_id INTEGER PRIMARY KEY, display_name TEXT NOT NULL, unique_name TEXT UNIQUE NOT NULL, type_id INTEGER NOT NULL, version TEXT NOT NULL, FOREIGN KEY(type_id) REFERENCES ingest_module_types(type_id));");
                statement.execute("CREATE TABLE ingest_jobs (ingest_job_id INTEGER PRIMARY KEY, obj_id BIGINT NOT NULL, host_name TEXT NOT NULL, start_date_time BIGINT NOT NULL, end_date_time BIGINT NOT NULL, status_id INTEGER NOT NULL, settings_dir TEXT, FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id), FOREIGN KEY(status_id) REFERENCES ingest_job_status_types(type_id));");
            } else {
                statement.execute("CREATE TABLE ingest_modules (ingest_module_id BIGSERIAL PRIMARY KEY, display_name TEXT NOT NULL, unique_name TEXT UNIQUE NOT NULL, type_id INTEGER NOT NULL, version TEXT NOT NULL, FOREIGN KEY(type_id) REFERENCES ingest_module_types(type_id));");
                statement.execute("CREATE TABLE ingest_jobs (ingest_job_id BIGSERIAL PRIMARY KEY, obj_id BIGINT NOT NULL, host_name TEXT NOT NULL, start_date_time BIGINT NOT NULL, end_date_time BIGINT NOT NULL, status_id INTEGER NOT NULL, settings_dir TEXT, FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id), FOREIGN KEY(status_id) REFERENCES ingest_job_status_types(type_id));");
            }
            statement.execute("CREATE TABLE ingest_job_modules (ingest_job_id INTEGER, ingest_module_id INTEGER, pipeline_position INTEGER, PRIMARY KEY(ingest_job_id, ingest_module_id), FOREIGN KEY(ingest_job_id) REFERENCES ingest_jobs(ingest_job_id), FOREIGN KEY(ingest_module_id) REFERENCES ingest_modules(ingest_module_id));");
            this.initIngestModuleTypes(connection);
            this.initIngestStatusTypes(connection);
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(4, 0);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(queryResultSet);
            SleuthkitCase.closeStatement(queryStatement);
            SleuthkitCase.closeStatement(updateStatement);
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(queryResultSet);
        SleuthkitCase.closeStatement(queryStatement);
        SleuthkitCase.closeStatement(updateStatement);
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema4toSchema5(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 4) {
            return schemaVersion;
        }
        Statement statement = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            statement.execute("CREATE TABLE review_statuses (review_status_id INTEGER PRIMARY KEY, review_status_name TEXT NOT NULL, display_name TEXT NOT NULL)");
            statement.execute("ALTER TABLE blackboard_artifacts ADD COLUMN review_status_id INTEGER NOT NULL DEFAULT " + BlackboardArtifact.ReviewStatus.UNDECIDED.getID());
            statement.execute("CREATE TABLE file_encoding_types (encoding_type INTEGER PRIMARY KEY, name TEXT NOT NULL);");
            this.initEncodingTypes(connection);
            this.initReviewStatuses(connection);
            statement.execute("ALTER TABLE tsk_files_path ADD COLUMN encoding_type INTEGER NOT NULL DEFAULT 0;");
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(5, 0);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema5toSchema6(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 5) {
            return schemaVersion;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            statement.execute("CREATE TABLE IF NOT EXISTS review_statuses (review_status_id INTEGER PRIMARY KEY, review_status_name TEXT NOT NULL, display_name TEXT NOT NULL)");
            resultSet = connection.executeQuery(statement, "SELECT COUNT(*) AS count FROM review_statuses");
            resultSet.next();
            if (resultSet.getLong("count") == 0L) {
                statement.execute("ALTER TABLE blackboard_artifacts ADD COLUMN review_status_id INTEGER NOT NULL DEFAULT " + BlackboardArtifact.ReviewStatus.UNDECIDED.getID());
            }
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(6, 0);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema6toSchema7(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 6) {
            return schemaVersion;
        }
        Statement statement = null;
        Statement updstatement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            updstatement = connection.createStatement();
            statement.execute("ALTER TABLE tsk_files ADD COLUMN extension TEXT");
            resultSet = connection.executeQuery(statement, "SELECT obj_id,name FROM tsk_files");
            while (resultSet.next()) {
                long objID = resultSet.getLong("obj_id");
                String name = resultSet.getString("name");
                updstatement.executeUpdate("UPDATE tsk_files SET extension = '" + SleuthkitCase.escapeSingleQuotes(SleuthkitCase.extractExtension(name)) + "' WHERE obj_id = " + objID);
            }
            statement.execute("CREATE INDEX file_extension ON tsk_files ( extension )");
            statement.execute("ALTER TABLE blackboard_artifacts ADD COLUMN artifact_obj_id INTEGER NOT NULL DEFAULT -1");
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(7, 0);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            SleuthkitCase.closeStatement(updstatement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeStatement(updstatement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema7toSchema7dot1(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 7) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 0) {
            return schemaVersion;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            if (schemaVersion.getMinor() == 0) {
                statement.execute("ALTER TABLE tsk_db_info ADD COLUMN schema_minor_ver INTEGER DEFAULT 1");
            }
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(7, 1);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema7dot1toSchema7dot2(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 7) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 1) {
            return schemaVersion;
        }
        Statement statement = null;
        Statement updstatement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            statement.execute("ALTER TABLE blackboard_artifacts ADD COLUMN data_source_obj_id INTEGER NOT NULL DEFAULT -1");
            updstatement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT artifact_id, obj_id FROM blackboard_artifacts");
            while (resultSet.next()) {
                long artifact_id = resultSet.getLong("artifact_id");
                long obj_id = resultSet.getLong("obj_id");
                long data_source_obj_id = this.getDataSourceObjectId(connection, obj_id);
                updstatement.executeUpdate("UPDATE blackboard_artifacts SET data_source_obj_id = " + data_source_obj_id + " WHERE artifact_id = " + artifact_id);
            }
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            SleuthkitCase.closeStatement(updstatement);
            statement = connection.createStatement();
            statement.execute("ALTER TABLE tag_names ADD COLUMN knownStatus INTEGER NOT NULL DEFAULT " + TskData.FileKnown.UNKNOWN.getFileKnownValue());
            if (this.dbType.equals((Object)TskData.DbType.SQLITE)) {
                statement.execute("CREATE TABLE account_types (account_type_id INTEGER PRIMARY KEY, type_name TEXT UNIQUE NOT NULL, display_name TEXT NOT NULL)");
                statement.execute("CREATE TABLE accounts (account_id INTEGER PRIMARY KEY, account_type_id INTEGER NOT NULL, account_unique_identifier TEXT NOT NULL,  UNIQUE(account_type_id, account_unique_identifier) , FOREIGN KEY(account_type_id) REFERENCES account_types(account_type_id))");
                statement.execute("CREATE TABLE account_relationships (relationship_id INTEGER PRIMARY KEY, account1_id INTEGER NOT NULL, account2_id INTEGER NOT NULL, relationship_source_obj_id INTEGER NOT NULL,  date_time INTEGER, relationship_type INTEGER NOT NULL, data_source_obj_id INTEGER NOT NULL, UNIQUE(account1_id, account2_id, relationship_source_obj_id), FOREIGN KEY(account1_id) REFERENCES accounts(account_id), FOREIGN KEY(account2_id) REFERENCES accounts(account_id), FOREIGN KEY(relationship_source_obj_id) REFERENCES tsk_objects(obj_id), FOREIGN KEY(data_source_obj_id) REFERENCES tsk_objects(obj_id))");
            } else {
                statement.execute("CREATE TABLE account_types (account_type_id BIGSERIAL PRIMARY KEY, type_name TEXT UNIQUE NOT NULL, display_name TEXT NOT NULL)");
                statement.execute("CREATE TABLE accounts (account_id BIGSERIAL PRIMARY KEY, account_type_id INTEGER NOT NULL, account_unique_identifier TEXT NOT NULL,  UNIQUE(account_type_id, account_unique_identifier) , FOREIGN KEY(account_type_id) REFERENCES account_types(account_type_id))");
                statement.execute("CREATE TABLE account_relationships  (relationship_id BIGSERIAL PRIMARY KEY, account1_id INTEGER NOT NULL, account2_id INTEGER NOT NULL, relationship_source_obj_id INTEGER NOT NULL, date_time BIGINT, relationship_type INTEGER NOT NULL, data_source_obj_id INTEGER NOT NULL, UNIQUE(account1_id, account2_id, relationship_source_obj_id), FOREIGN KEY(account1_id) REFERENCES accounts(account_id), FOREIGN KEY(account2_id) REFERENCES accounts(account_id), FOREIGN KEY(relationship_source_obj_id) REFERENCES tsk_objects(obj_id), FOREIGN KEY(data_source_obj_id) REFERENCES tsk_objects(obj_id))");
            }
            statement.execute("CREATE INDEX artifact_artifact_objID ON blackboard_artifacts(artifact_obj_id)");
            statement.execute("CREATE INDEX relationships_account1  ON account_relationships(account1_id)");
            statement.execute("CREATE INDEX relationships_account2  ON account_relationships(account2_id)");
            statement.execute("CREATE INDEX relationships_relationship_source_obj_id  ON account_relationships(relationship_source_obj_id)");
            statement.execute("CREATE INDEX relationships_date_time  ON account_relationships(date_time)");
            statement.execute("CREATE INDEX relationships_relationship_type  ON account_relationships(relationship_type)");
            statement.execute("CREATE INDEX relationships_data_source_obj_id  ON account_relationships(data_source_obj_id)");
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(7, 2);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            SleuthkitCase.closeStatement(updstatement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeStatement(updstatement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema7dot2toSchema8dot0(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 7) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 2) {
            return schemaVersion;
        }
        Statement updateSchemaStatement = connection.createStatement();
        Statement getExistingReportsStatement = connection.createStatement();
        ResultSet resultSet = null;
        ResultSet existingReports = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            updateSchemaStatement.execute("ALTER TABLE reports RENAME TO old_reports");
            updateSchemaStatement.execute("CREATE TABLE reports (obj_id BIGSERIAL PRIMARY KEY, path TEXT NOT NULL, crtime INTEGER NOT NULL, src_module_name TEXT NOT NULL, report_name TEXT NOT NULL, FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id))");
            existingReports = getExistingReportsStatement.executeQuery("SELECT * FROM old_reports");
            while (existingReports.next()) {
                String path = existingReports.getString(2);
                long crtime = existingReports.getInt(3);
                String sourceModule = existingReports.getString(4);
                String reportName = existingReports.getString(5);
                PreparedStatement insertObjectStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_OBJECT, 1);
                insertObjectStatement.clearParameters();
                insertObjectStatement.setNull(1, -5);
                insertObjectStatement.setLong(2, TskData.ObjectType.REPORT.getObjectType());
                connection.executeUpdate(insertObjectStatement);
                resultSet = insertObjectStatement.getGeneratedKeys();
                if (!resultSet.next()) {
                    throw new TskCoreException(String.format("Failed to INSERT report %s (%s) in tsk_objects table", reportName, path));
                }
                long objectId = resultSet.getLong(1);
                PreparedStatement insertReportStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_REPORT);
                insertReportStatement.clearParameters();
                insertReportStatement.setLong(1, objectId);
                insertReportStatement.setString(2, path);
                insertReportStatement.setLong(3, crtime);
                insertReportStatement.setString(4, sourceModule);
                insertReportStatement.setString(5, reportName);
                connection.executeUpdate(insertReportStatement);
            }
            updateSchemaStatement.execute("DROP TABLE old_reports");
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(8, 0);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeResultSet(existingReports);
            SleuthkitCase.closeStatement(updateSchemaStatement);
            SleuthkitCase.closeStatement(getExistingReportsStatement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeResultSet(existingReports);
        SleuthkitCase.closeStatement(updateSchemaStatement);
        SleuthkitCase.closeStatement(getExistingReportsStatement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema8dot0toSchema8dot1(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 8) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 0) {
            return schemaVersion;
        }
        Statement statement = connection.createStatement();
        this.acquireSingleUserCaseWriteLock();
        try {
            if (this.dbType.equals((Object)TskData.DbType.SQLITE)) {
                statement.execute("CREATE TABLE tsk_examiners (examiner_id INTEGER PRIMARY KEY, login_name TEXT NOT NULL, display_name TEXT, UNIQUE(login_name) )");
                statement.execute("ALTER TABLE content_tags ADD COLUMN examiner_id INTEGER REFERENCES tsk_examiners(examiner_id) DEFAULT NULL");
                statement.execute("ALTER TABLE blackboard_artifact_tags ADD COLUMN examiner_id INTEGER REFERENCES tsk_examiners(examiner_id) DEFAULT NULL");
            } else {
                statement.execute("CREATE TABLE tsk_examiners (examiner_id BIGSERIAL PRIMARY KEY, login_name TEXT NOT NULL, display_name TEXT, UNIQUE(login_name))");
                statement.execute("ALTER TABLE content_tags ADD COLUMN examiner_id BIGINT REFERENCES tsk_examiners(examiner_id) DEFAULT NULL");
                statement.execute("ALTER TABLE blackboard_artifact_tags ADD COLUMN examiner_id BIGINT REFERENCES tsk_examiners(examiner_id) DEFAULT NULL");
            }
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(8, 1);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema8dot1toSchema8dot2(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 8) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 1) {
            return schemaVersion;
        }
        Statement statement = connection.createStatement();
        this.acquireSingleUserCaseWriteLock();
        try {
            statement.execute("ALTER TABLE tsk_image_info ADD COLUMN sha1 TEXT DEFAULT NULL");
            statement.execute("ALTER TABLE tsk_image_info ADD COLUMN sha256 TEXT DEFAULT NULL");
            statement.execute("ALTER TABLE data_source_info ADD COLUMN acquisition_details TEXT");
            statement.execute("CREATE TABLE tsk_db_info_extended (name TEXT PRIMARY KEY, value TEXT NOT NULL)");
            ResultSet result = statement.executeQuery("SELECT tsk_ver FROM tsk_db_info");
            result.next();
            statement.execute("INSERT INTO tsk_db_info_extended (name, value) VALUES ('TSK_VER', '" + result.getLong("tsk_ver") + "')");
            statement.execute("INSERT INTO tsk_db_info_extended (name, value) VALUES ('SCHEMA_MAJOR_VERSION', '8')");
            statement.execute("INSERT INTO tsk_db_info_extended (name, value) VALUES ('SCHEMA_MINOR_VERSION', '2')");
            statement.execute("INSERT INTO tsk_db_info_extended (name, value) VALUES ('CREATION_SCHEMA_MAJOR_VERSION', '0')");
            statement.execute("INSERT INTO tsk_db_info_extended (name, value) VALUES ('CREATION_SCHEMA_MINOR_VERSION', '0')");
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(8, 2);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    static String extractExtension(String fileName) {
        int i = fileName.lastIndexOf(".");
        if (i <= 0 || i + 1 >= fileName.length()) {
            return "";
        }
        String ext = fileName.substring(i + 1);
        return ext.toLowerCase();
    }

    @Deprecated
    public int getSchemaVersion() {
        return this.getDBSchemaVersion().getMajor();
    }

    public VersionNumber getDBSchemaVersion() {
        return CURRENT_DB_SCHEMA_VERSION;
    }

    public TskData.DbType getDatabaseType() {
        return this.dbType;
    }

    public String getBackupDatabasePath() {
        return this.dbBackupPath;
    }

    public CaseDbTransaction beginTransaction() throws TskCoreException {
        return new CaseDbTransaction(this, this.connections.getConnection());
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDbDirPath() {
        return this.caseDirPath;
    }

    public void acquireSingleUserCaseWriteLock() {
        if (this.dbType == TskData.DbType.SQLITE) {
            this.rwLock.writeLock().lock();
        }
    }

    public void releaseSingleUserCaseWriteLock() {
        if (this.dbType == TskData.DbType.SQLITE) {
            this.rwLock.writeLock().unlock();
        }
    }

    public void acquireSingleUserCaseReadLock() {
        if (this.dbType == TskData.DbType.SQLITE) {
            this.rwLock.readLock().lock();
        }
    }

    public void releaseSingleUserCaseReadLock() {
        if (this.dbType == TskData.DbType.SQLITE) {
            this.rwLock.readLock().unlock();
        }
    }

    public static SleuthkitCase openCase(String dbPath) throws TskCoreException {
        try {
            SleuthkitJNI.CaseDbHandle caseHandle = SleuthkitJNI.openCaseDb(dbPath);
            return new SleuthkitCase(dbPath, caseHandle, TskData.DbType.SQLITE);
        }
        catch (TskUnsupportedSchemaVersionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TskCoreException("Failed to open case database at " + dbPath, ex);
        }
    }

    public static SleuthkitCase openCase(String databaseName, CaseDbConnectionInfo info, String caseDir) throws TskCoreException {
        try {
            SleuthkitJNI.CaseDbHandle caseHandle = SleuthkitJNI.openCaseDb(databaseName, info);
            return new SleuthkitCase(info.getHost(), Integer.parseInt(info.getPort()), databaseName, info.getUserName(), info.getPassword(), caseHandle, caseDir, info.getDbType());
        }
        catch (PropertyVetoException exp) {
            throw new TskCoreException(exp.getMessage(), exp);
        }
        catch (TskUnsupportedSchemaVersionException ex) {
            throw ex;
        }
        catch (Exception exp) {
            SleuthkitCase.tryConnect(info);
            throw new TskCoreException(exp.getMessage(), exp);
        }
    }

    public static SleuthkitCase newCase(String dbPath) throws TskCoreException {
        try {
            SleuthkitJNI.CaseDbHandle caseHandle = SleuthkitJNI.newCaseDb(dbPath);
            return new SleuthkitCase(dbPath, caseHandle, TskData.DbType.SQLITE);
        }
        catch (Exception ex) {
            throw new TskCoreException("Failed to create case database at " + dbPath, ex);
        }
    }

    public static SleuthkitCase newCase(String caseName, CaseDbConnectionInfo info, String caseDirPath) throws TskCoreException {
        String databaseName = SleuthkitCase.createCaseDataBaseName(caseName);
        try {
            SleuthkitJNI.CaseDbHandle caseHandle = SleuthkitJNI.newCaseDb(databaseName, info);
            return new SleuthkitCase(info.getHost(), Integer.parseInt(info.getPort()), databaseName, info.getUserName(), info.getPassword(), caseHandle, caseDirPath, info.getDbType());
        }
        catch (PropertyVetoException exp) {
            throw new TskCoreException(exp.getMessage(), exp);
        }
        catch (Exception exp) {
            SleuthkitCase.tryConnect(info);
            throw new TskCoreException(exp.getMessage(), exp);
        }
    }

    private static String createCaseDataBaseName(String candidateDbName) {
        String dbName;
        if (!candidateDbName.isEmpty()) {
            dbName = candidateDbName.replaceAll("[^\\p{ASCII}]", "_");
            dbName = dbName.replaceAll("[\\p{Cntrl}]", "_");
            dbName = dbName.replaceAll("[ /?:'\"\\\\]", "_");
            if ((dbName = dbName.toLowerCase()).length() > 0 && !Character.isLetter(dbName.codePointAt(0)) && dbName.codePointAt(0) != 95) {
                dbName = "_" + dbName;
            }
            if (dbName.length() > 47) {
                dbName = dbName.substring(0, 47);
            }
        } else {
            dbName = "_";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date date = new Date();
        dbName = dbName + "_" + dateFormat.format(date);
        return dbName;
    }

    public Examiner getCurrentExaminer() throws TskCoreException {
        ResultSet resultSet;
        CaseDbConnection connection;
        String loginName;
        block7: {
            if (this.cachedCurrentExaminer != null) {
                return this.cachedCurrentExaminer;
            }
            loginName = System.getProperty("user.name");
            if (loginName == null || loginName.isEmpty()) {
                throw new TskCoreException("Failed to determine logged in user name.");
            }
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            resultSet = null;
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_EXAMINER_BY_LOGIN_NAME);
            statement.clearParameters();
            statement.setString(1, loginName);
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block7;
            Examiner examiner = this.cachedCurrentExaminer = new Examiner(resultSet.getLong("examiner_id"), resultSet.getString("login_name"), resultSet.getString("display_name"));
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return examiner;
        }
        try {
            try {
                throw new TskCoreException("Error getting examaminer for name = " + loginName);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting examaminer for name = " + loginName, ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    Examiner getExaminerById(long id) throws TskCoreException {
        ResultSet resultSet;
        CaseDbConnection connection;
        block5: {
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            resultSet = null;
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_EXAMINER_BY_ID);
            statement.clearParameters();
            statement.setLong(1, id);
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block5;
            Examiner examiner = new Examiner(resultSet.getLong("examiner_id"), resultSet.getString("login_name"), resultSet.getString("full_name"));
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return examiner;
        }
        try {
            try {
                throw new TskCoreException("Error getting examaminer for id = " + id);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting examaminer for id = " + id, ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public SleuthkitJNI.CaseDbHandle.AddImageProcess makeAddImageProcess(String timeZone, boolean addUnallocSpace, boolean noFatFsOrphans, String imageCopyPath) {
        return this.caseHandle.initAddImageProcess(timeZone, addUnallocSpace, noFatFsOrphans, imageCopyPath, this);
    }

    public List<Content> getRootObjects() throws TskCoreException {
        ArrayList<AbstractContent> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT obj_id, type FROM tsk_objects WHERE par_obj_id IS NULL");
            ArrayList<ObjectInfo> infos = new ArrayList<ObjectInfo>();
            while (rs.next()) {
                infos.add(new ObjectInfo(rs.getLong("obj_id"), TskData.ObjectType.valueOf(rs.getShort("type"))));
            }
            ArrayList<AbstractContent> rootObjs = new ArrayList<AbstractContent>();
            block10: for (ObjectInfo i : infos) {
                if (null == i.type) continue;
                switch (i.type) {
                    case IMG: {
                        rootObjs.add(this.getImageById(i.id));
                        continue block10;
                    }
                    case ABSTRACTFILE: {
                        AbstractFile af = this.getAbstractFileById(i.id);
                        if (af instanceof VirtualDirectory) {
                            rootObjs.add(af);
                            continue block10;
                        }
                        throw new TskCoreException("Parentless object has wrong type to be a root (ABSTRACTFILE, but not VIRTUAL_DIRECTORY: " + (Object)((Object)i.type));
                    }
                    case REPORT: {
                        continue block10;
                    }
                }
                throw new TskCoreException("Parentless object has wrong type to be a root: " + (Object)((Object)i.type));
            }
            arrayList = rootObjs;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting root objects", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    List<Long> getDataSourceObjIds(String deviceId) throws TskCoreException {
        Map<String, Set<Long>> map = this.deviceIdToDatasourceObjIdMap;
        synchronized (map) {
            ArrayList<Long> arrayList;
            if (this.deviceIdToDatasourceObjIdMap.containsKey(deviceId)) {
                return new ArrayList<Long>((Collection)this.deviceIdToDatasourceObjIdMap.get(deviceId));
            }
            CaseDbConnection connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            Statement s = null;
            ResultSet rs = null;
            try {
                s = connection.createStatement();
                rs = connection.executeQuery(s, "SELECT obj_id FROM data_source_info WHERE device_id = '" + deviceId + "'");
                ArrayList<Long> dataSourceObjIds = new ArrayList<Long>();
                while (rs.next()) {
                    dataSourceObjIds.add(rs.getLong("obj_id"));
                    long ds_obj_id = rs.getLong("obj_id");
                    if (this.deviceIdToDatasourceObjIdMap.containsKey(deviceId)) {
                        this.deviceIdToDatasourceObjIdMap.get(deviceId).add(ds_obj_id);
                        continue;
                    }
                    this.deviceIdToDatasourceObjIdMap.put(deviceId, new HashSet<Long>(Arrays.asList(ds_obj_id)));
                }
                arrayList = dataSourceObjIds;
            }
            catch (SQLException ex) {
                try {
                    throw new TskCoreException("Error getting data sources", ex);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(rs);
                    SleuthkitCase.closeStatement(s);
                    connection.close();
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
            }
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return arrayList;
        }
    }

    public List<DataSource> getDataSources() throws TskCoreException {
        ArrayList<DataSource> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement statement = null;
        ResultSet resultSet = null;
        Statement statement2 = null;
        ResultSet resultSet2 = null;
        try {
            statement = connection.createStatement();
            statement2 = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT ds.obj_id, ds.device_id, ds.time_zone, img.type, img.ssize, img.size, img.md5, img.sha1, img.sha256, img.display_name FROM data_source_info AS ds LEFT JOIN tsk_image_info AS img ON ds.obj_id = img.obj_id");
            ArrayList<DataSource> dataSourceList = new ArrayList<DataSource>();
            Map<Long, List<String>> imagePathsMap = this.getImagePaths();
            while (resultSet.next()) {
                AbstractContent dataSource;
                Long objectId = resultSet.getLong("obj_id");
                String deviceId = resultSet.getString("device_id");
                String timezone = resultSet.getString("time_zone");
                String type = resultSet.getString("type");
                if (type == null) {
                    resultSet2 = connection.executeQuery(statement2, "SELECT name FROM tsk_files WHERE tsk_files.obj_id = " + objectId);
                    String dsName = resultSet2.next() ? resultSet2.getString("name") : "";
                    resultSet2.close();
                    TskData.TSK_FS_NAME_TYPE_ENUM dirType = TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
                    TskData.TSK_FS_META_TYPE_ENUM metaType = TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
                    TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
                    short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
                    String parentPath = "/";
                    dataSource = new LocalFilesDataSource(this, objectId, objectId, deviceId, dsName, dirType, metaType, dirFlag, metaFlags, timezone, null, TskData.FileKnown.UNKNOWN, parentPath);
                } else {
                    Long ssize = resultSet.getLong("ssize");
                    Long size = resultSet.getLong("size");
                    String md5 = resultSet.getString("md5");
                    String sha1 = resultSet.getString("sha1");
                    String sha256 = resultSet.getString("sha256");
                    String name = resultSet.getString("display_name");
                    List<String> imagePaths = imagePathsMap.get(objectId);
                    if (name == null) {
                        if (imagePaths.size() > 0) {
                            String path = imagePaths.get(0);
                            name = new java.io.File(path).getName();
                        } else {
                            name = "";
                        }
                    }
                    dataSource = new Image(this, objectId, Long.valueOf(type), deviceId, ssize, name, imagePaths.toArray(new String[imagePaths.size()]), timezone, md5, sha1, sha256, size);
                }
                dataSourceList.add((DataSource)((Object)dataSource));
            }
            arrayList = dataSourceList;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting data sources", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeResultSet(resultSet2);
                SleuthkitCase.closeStatement(statement2);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeResultSet(resultSet2);
        SleuthkitCase.closeStatement(statement2);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public DataSource getDataSource(long objectId) throws TskDataException, TskCoreException {
        ResultSet resultSet2;
        Statement statement2;
        ResultSet resultSet;
        Statement statement;
        CaseDbConnection connection;
        AbstractContent dataSource;
        block10: {
            dataSource = null;
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            statement = null;
            resultSet = null;
            statement2 = null;
            resultSet2 = null;
            try {
                statement = connection.createStatement();
                statement2 = connection.createStatement();
                resultSet = connection.executeQuery(statement, "SELECT ds.device_id, ds.time_zone, img.type, img.ssize, img.size, img.md5, img.sha1, img.sha256, img.display_name FROM data_source_info AS ds LEFT JOIN tsk_image_info AS img ON ds.obj_id = img.obj_id WHERE ds.obj_id = " + objectId);
                if (resultSet.next()) {
                    String deviceId = resultSet.getString("device_id");
                    String timezone = resultSet.getString("time_zone");
                    String type = resultSet.getString("type");
                    if (type == null) {
                        resultSet2 = connection.executeQuery(statement2, "SELECT name FROM tsk_files WHERE tsk_files.obj_id = " + objectId);
                        String dsName = resultSet2.next() ? resultSet2.getString("name") : "";
                        TskData.TSK_FS_NAME_TYPE_ENUM dirType = TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
                        TskData.TSK_FS_META_TYPE_ENUM metaType = TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
                        TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
                        short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
                        String parentPath = "/";
                        dataSource = new LocalFilesDataSource(this, objectId, objectId, deviceId, dsName, dirType, metaType, dirFlag, metaFlags, timezone, null, TskData.FileKnown.UNKNOWN, parentPath);
                    } else {
                        Long ssize = resultSet.getLong("ssize");
                        Long size = resultSet.getLong("size");
                        String md5 = resultSet.getString("md5");
                        String sha1 = resultSet.getString("sha1");
                        String sha256 = resultSet.getString("sha256");
                        String name = resultSet.getString("display_name");
                        List<String> imagePaths = this.getImagePathsById(objectId);
                        if (name == null) {
                            if (imagePaths.size() > 0) {
                                String path = imagePaths.get(0);
                                name = new java.io.File(path).getName();
                            } else {
                                name = "";
                            }
                        }
                        dataSource = new Image(this, objectId, Long.valueOf(type), deviceId, ssize, name, imagePaths.toArray(new String[imagePaths.size()]), timezone, md5, sha1, sha256, size);
                    }
                    break block10;
                }
                throw new TskDataException(String.format("There is no data source with obj_id = %d", objectId));
            }
            catch (SQLException ex) {
                try {
                    throw new TskCoreException(String.format("Error getting data source with obj_id = %d", objectId), ex);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(resultSet);
                    SleuthkitCase.closeStatement(statement);
                    SleuthkitCase.closeResultSet(resultSet2);
                    SleuthkitCase.closeStatement(statement2);
                    connection.close();
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeResultSet(resultSet2);
        SleuthkitCase.closeStatement(statement2);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return dataSource;
    }

    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(int artifactTypeID) throws TskCoreException {
        return this.getArtifactsHelper("blackboard_artifacts.artifact_type_id = " + artifactTypeID);
    }

    public long getBlackboardArtifactsCount(long objId) throws TskCoreException {
        long l;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_ARTIFACTS_FROM_SOURCE);
            statement.clearParameters();
            statement.setLong(1, objId);
            rs = connection.executeQuery(statement);
            long count = 0L;
            if (rs.next()) {
                count = rs.getLong("count");
            }
            l = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting number of blackboard artifacts by content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    public long getBlackboardArtifactsTypeCount(int artifactTypeID) throws TskCoreException {
        long l;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_ARTIFACTS_OF_TYPE);
            statement.clearParameters();
            statement.setInt(1, artifactTypeID);
            rs = connection.executeQuery(statement);
            long count = 0L;
            if (rs.next()) {
                count = rs.getLong("count");
            }
            l = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting number of blackboard artifacts by type", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, String value) throws TskCoreException {
        ArrayList<BlackboardArtifact> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT DISTINCT arts.artifact_id AS artifact_id, arts.obj_id AS obj_id, arts.artifact_obj_id AS artifact_obj_id, arts.data_source_obj_id AS data_source_obj_id, arts.artifact_type_id AS artifact_type_id, types.type_name AS type_name, types.display_name AS display_name,  arts.review_status_id AS review_status_id FROM blackboard_artifacts AS arts, blackboard_attributes AS attrs, blackboard_artifact_types AS types WHERE arts.artifact_id = attrs.artifact_id  AND attrs.attribute_type_id = " + attrType.getTypeID() + " AND attrs.value_text = '" + value + "' AND types.artifact_type_id=arts.artifact_type_id AND arts.review_status_id !=" + BlackboardArtifact.ReviewStatus.REJECTED.getID());
            ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
            while (rs.next()) {
                artifacts.add(new BlackboardArtifact(this, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id"))));
            }
            arrayList = artifacts;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifacts by attribute", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, String subString, boolean startsWith) throws TskCoreException {
        ArrayList<BlackboardArtifact> arrayList;
        String valSubStr = "%" + subString;
        if (!startsWith) {
            valSubStr = valSubStr + "%";
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT DISTINCT arts.artifact_id AS artifact_id,  arts.obj_id AS obj_id, arts.artifact_obj_id AS artifact_obj_id, arts.data_source_obj_id AS data_source_obj_id, arts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name, types.display_name AS display_name,  arts.review_status_id AS review_status_id  FROM blackboard_artifacts AS arts, blackboard_attributes AS attrs, blackboard_artifact_types AS types  WHERE arts.artifact_id = attrs.artifact_id  AND attrs.attribute_type_id = " + attrType.getTypeID() + " AND LOWER(attrs.value_text) LIKE LOWER('" + valSubStr + "') AND types.artifact_type_id=arts.artifact_type_id  AND arts.review_status_id !=" + BlackboardArtifact.ReviewStatus.REJECTED.getID());
            ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
            while (rs.next()) {
                artifacts.add(new BlackboardArtifact(this, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id"))));
            }
            arrayList = artifacts;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifacts by attribute. " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, int value) throws TskCoreException {
        ArrayList<BlackboardArtifact> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT DISTINCT arts.artifact_id AS artifact_id,  arts.obj_id AS obj_id, arts.artifact_obj_id AS artifact_obj_id, arts.data_source_obj_id AS data_source_obj_id, arts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name, types.display_name AS display_name,  arts.review_status_id AS review_status_id   FROM blackboard_artifacts AS arts, blackboard_attributes AS attrs, blackboard_artifact_types AS types WHERE arts.artifact_id = attrs.artifact_id  AND attrs.attribute_type_id = " + attrType.getTypeID() + " AND attrs.value_int32 = " + value + " AND types.artifact_type_id=arts.artifact_type_id  AND arts.review_status_id !=" + BlackboardArtifact.ReviewStatus.REJECTED.getID());
            ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
            while (rs.next()) {
                artifacts.add(new BlackboardArtifact(this, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id"))));
            }
            arrayList = artifacts;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifacts by attribute", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, long value) throws TskCoreException {
        ArrayList<BlackboardArtifact> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT DISTINCT arts.artifact_id AS artifact_id,  arts.obj_id AS obj_id, arts.artifact_obj_id AS artifact_obj_id, arts.data_source_obj_id AS data_source_obj_id, arts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name, types.display_name AS display_name,  arts.review_status_id AS review_status_id  FROM blackboard_artifacts AS arts, blackboard_attributes AS attrs, blackboard_artifact_types AS types  WHERE arts.artifact_id = attrs.artifact_id  AND attrs.attribute_type_id = " + attrType.getTypeID() + " AND attrs.value_int64 = " + value + " AND types.artifact_type_id=arts.artifact_type_id  AND arts.review_status_id !=" + BlackboardArtifact.ReviewStatus.REJECTED.getID());
            ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
            while (rs.next()) {
                artifacts.add(new BlackboardArtifact(this, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id"))));
            }
            arrayList = artifacts;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifacts by attribute. " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, double value) throws TskCoreException {
        ArrayList<BlackboardArtifact> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT DISTINCT arts.artifact_id AS artifact_id,  arts.obj_id AS obj_id, arts.artifact_obj_id AS artifact_obj_id, arts.data_source_obj_id AS data_source_obj_id, arts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name, types.display_name AS display_name,  arts.review_status_id AS review_status_id  FROM blackboard_artifacts AS arts, blackboard_attributes AS attrs, blackboard_artifact_types AS types  WHERE arts.artifact_id = attrs.artifact_id  AND attrs.attribute_type_id = " + attrType.getTypeID() + " AND attrs.value_double = " + value + " AND types.artifact_type_id=arts.artifact_type_id  AND arts.review_status_id !=" + BlackboardArtifact.ReviewStatus.REJECTED.getID());
            ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
            while (rs.next()) {
                artifacts.add(new BlackboardArtifact(this, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id"))));
            }
            arrayList = artifacts;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifacts by attribute", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, byte value) throws TskCoreException {
        ArrayList<BlackboardArtifact> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT DISTINCT arts.artifact_id AS artifact_id,  arts.obj_id AS obj_id, arts.artifact_obj_id AS artifact_obj_id, arts.data_source_obj_id AS data_source_obj_id, arts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name, types.display_name AS display_name,  arts.review_status_id AS review_status_id  FROM blackboard_artifacts AS arts, blackboard_attributes AS attrs, blackboard_artifact_types AS types  WHERE arts.artifact_id = attrs.artifact_id  AND attrs.attribute_type_id = " + attrType.getTypeID() + " AND attrs.value_byte = " + value + " AND types.artifact_type_id=arts.artifact_type_id  AND arts.review_status_id !=" + BlackboardArtifact.ReviewStatus.REJECTED.getID());
            ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
            while (rs.next()) {
                artifacts.add(new BlackboardArtifact(this, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id"))));
            }
            arrayList = artifacts;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifacts by attribute", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public Iterable<BlackboardArtifact.Type> getArtifactTypes() throws TskCoreException {
        ArrayList<BlackboardArtifact.Type> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT artifact_type_id, type_name, display_name FROM blackboard_artifact_types");
            ArrayList<BlackboardArtifact.Type> artifactTypes = new ArrayList<BlackboardArtifact.Type>();
            while (rs.next()) {
                artifactTypes.add(new BlackboardArtifact.Type(rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name")));
            }
            arrayList = artifactTypes;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting artifact types", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public ArrayList<BlackboardArtifact.ARTIFACT_TYPE> getBlackboardArtifactTypesInUse() throws TskCoreException {
        ArrayList<BlackboardArtifact.ARTIFACT_TYPE> arrayList;
        String typeIdList = "";
        for (int i = 0; i < BlackboardArtifact.ARTIFACT_TYPE.values().length; ++i) {
            typeIdList = typeIdList + BlackboardArtifact.ARTIFACT_TYPE.values()[i].getTypeID();
            if (i >= BlackboardArtifact.ARTIFACT_TYPE.values().length - 1) continue;
            typeIdList = typeIdList + ", ";
        }
        String query = "SELECT DISTINCT artifact_type_id FROM blackboard_artifacts WHERE artifact_type_id IN (" + typeIdList + ")";
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, query);
            ArrayList<BlackboardArtifact.ARTIFACT_TYPE> usedArts = new ArrayList<BlackboardArtifact.ARTIFACT_TYPE>();
            while (rs.next()) {
                usedArts.add(BlackboardArtifact.ARTIFACT_TYPE.fromID(rs.getInt("artifact_type_id")));
            }
            arrayList = usedArts;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting artifact types in use", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<BlackboardArtifact.Type> getArtifactTypesInUse() throws TskCoreException {
        ArrayList<BlackboardArtifact.Type> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT DISTINCT arts.artifact_type_id AS artifact_type_id, types.type_name AS type_name, types.display_name AS display_name FROM blackboard_artifact_types AS types INNER JOIN blackboard_artifacts AS arts ON arts.artifact_type_id = types.artifact_type_id");
            ArrayList<BlackboardArtifact.Type> uniqueArtifactTypes = new ArrayList<BlackboardArtifact.Type>();
            while (rs.next()) {
                uniqueArtifactTypes.add(new BlackboardArtifact.Type(rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name")));
            }
            arrayList = uniqueArtifactTypes;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attribute types", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<BlackboardAttribute.Type> getAttributeTypes() throws TskCoreException {
        ArrayList<BlackboardAttribute.Type> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT attribute_type_id, type_name, display_name, value_type FROM blackboard_attribute_types");
            ArrayList<BlackboardAttribute.Type> attribute_types = new ArrayList<BlackboardAttribute.Type>();
            while (rs.next()) {
                attribute_types.add(new BlackboardAttribute.Type(rs.getInt("attribute_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.fromType(rs.getLong("value_type"))));
            }
            arrayList = attribute_types;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attribute types", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public int getBlackboardAttributeTypesCount() throws TskCoreException {
        int n;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT COUNT(*) AS count FROM blackboard_attribute_types");
            int count = 0;
            if (rs.next()) {
                count = rs.getInt("count");
            }
            n = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting number of blackboard artifacts by type", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return n;
    }

    ArrayList<BlackboardArtifact> getArtifactsHelper(String whereClause) throws TskCoreException {
        ArrayList<BlackboardArtifact> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            Statement statement = connection.createStatement();
            String query = "SELECT blackboard_artifacts.artifact_id AS artifact_id, blackboard_artifacts.obj_id AS obj_id, blackboard_artifacts.artifact_obj_id AS artifact_obj_id, blackboard_artifacts.data_source_obj_id AS data_source_obj_id, blackboard_artifact_types.artifact_type_id AS artifact_type_id, blackboard_artifact_types.type_name AS type_name, blackboard_artifact_types.display_name AS display_name, blackboard_artifacts.review_status_id AS review_status_id FROM blackboard_artifacts, blackboard_artifact_types WHERE blackboard_artifacts.artifact_type_id = blackboard_artifact_types.artifact_type_id  AND blackboard_artifacts.review_status_id !=" + BlackboardArtifact.ReviewStatus.REJECTED.getID() + " AND " + whereClause;
            rs = connection.executeQuery(statement, query);
            ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
            while (rs.next()) {
                artifacts.add(new BlackboardArtifact(this, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id"))));
            }
            arrayList = artifacts;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting or creating a blackboard artifact", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    private long getArtifactsCountHelper(int artifactTypeID, long obj_id) throws TskCoreException {
        long l;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_ARTIFACTS_BY_SOURCE_AND_TYPE);
            statement.clearParameters();
            statement.setLong(1, obj_id);
            statement.setInt(2, artifactTypeID);
            rs = connection.executeQuery(statement);
            long count = 0L;
            if (rs.next()) {
                count = rs.getLong("count");
            }
            l = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifact count", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(String artifactTypeName, long obj_id) throws TskCoreException {
        return this.getArtifactsHelper("blackboard_artifacts.obj_id = " + obj_id + " AND blackboard_artifact_types.type_name = '" + artifactTypeName + "';");
    }

    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(int artifactTypeID, long obj_id) throws TskCoreException {
        return this.getArtifactsHelper("blackboard_artifacts.obj_id = " + obj_id + " AND blackboard_artifact_types.artifact_type_id = " + artifactTypeID + ";");
    }

    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(BlackboardArtifact.ARTIFACT_TYPE artifactType, long obj_id) throws TskCoreException {
        return this.getBlackboardArtifacts(artifactType.getTypeID(), obj_id);
    }

    public long getBlackboardArtifactsCount(String artifactTypeName, long obj_id) throws TskCoreException {
        int artifactTypeID = this.getArtifactType(artifactTypeName).getTypeID();
        if (artifactTypeID == -1) {
            return 0L;
        }
        return this.getArtifactsCountHelper(artifactTypeID, obj_id);
    }

    public long getBlackboardArtifactsCount(int artifactTypeID, long obj_id) throws TskCoreException {
        return this.getArtifactsCountHelper(artifactTypeID, obj_id);
    }

    public long getBlackboardArtifactsCount(BlackboardArtifact.ARTIFACT_TYPE artifactType, long obj_id) throws TskCoreException {
        return this.getArtifactsCountHelper(artifactType.getTypeID(), obj_id);
    }

    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(String artifactTypeName) throws TskCoreException {
        return this.getArtifactsHelper("blackboard_artifact_types.type_name = '" + artifactTypeName + "';");
    }

    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(BlackboardArtifact.ARTIFACT_TYPE artifactType) throws TskCoreException {
        return this.getArtifactsHelper("blackboard_artifact_types.artifact_type_id = " + artifactType.getTypeID() + ";");
    }

    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardArtifact.ARTIFACT_TYPE artifactType, BlackboardAttribute.ATTRIBUTE_TYPE attrType, String value) throws TskCoreException {
        ArrayList<BlackboardArtifact> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT DISTINCT arts.artifact_id AS artifact_id, arts.obj_id AS obj_id, arts.artifact_obj_id as artifact_obj_id, arts.data_source_obj_id AS data_source_obj_id, arts.artifact_type_id AS artifact_type_id, types.type_name AS type_name, types.display_name AS display_name,arts.review_status_id AS review_status_id FROM blackboard_artifacts AS arts, blackboard_attributes AS attrs, blackboard_artifact_types AS types WHERE arts.artifact_id = attrs.artifact_id AND attrs.attribute_type_id = " + attrType.getTypeID() + " AND arts.artifact_type_id = " + artifactType.getTypeID() + " AND attrs.value_text = '" + value + "' AND types.artifact_type_id=arts.artifact_type_id AND arts.review_status_id !=" + BlackboardArtifact.ReviewStatus.REJECTED.getID());
            ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
            while (rs.next()) {
                artifacts.add(new BlackboardArtifact(this, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id"))));
            }
            arrayList = artifacts;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifacts by artifact type and attribute. " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public BlackboardArtifact getBlackboardArtifact(long artifactID) throws TskCoreException {
        ResultSet rs;
        CaseDbConnection connection;
        block5: {
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            rs = null;
            Statement s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT arts.artifact_id AS artifact_id, arts.obj_id AS obj_id, arts.artifact_obj_id as artifact_obj_id, arts.data_source_obj_id AS data_source_obj_id, arts.artifact_type_id AS artifact_type_id, types.type_name AS type_name, types.display_name AS display_name,arts.review_status_id AS review_status_id FROM blackboard_artifacts AS arts, blackboard_artifact_types AS types WHERE arts.artifact_id = " + artifactID + " AND arts.artifact_type_id = types.artifact_type_id");
            if (!rs.next()) break block5;
            BlackboardArtifact blackboardArtifact = new BlackboardArtifact(this, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id")));
            SleuthkitCase.closeResultSet(rs);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return blackboardArtifact;
        }
        try {
            try {
                throw new TskCoreException("No blackboard artifact with id " + artifactID);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting a blackboard artifact. " + ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public void addBlackboardAttribute(BlackboardAttribute attr, int artifactTypeId) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            this.addBlackBoardAttribute(attr, artifactTypeId, connection);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error adding blackboard attribute " + attr.toString(), ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public void addBlackboardAttributes(Collection<BlackboardAttribute> attributes, int artifactTypeId) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            connection.beginTransaction();
            for (BlackboardAttribute attr : attributes) {
                this.addBlackBoardAttribute(attr, artifactTypeId, connection);
            }
            connection.commitTransaction();
        }
        catch (SQLException ex) {
            connection.rollbackTransaction();
            throw new TskCoreException("Error adding blackboard attributes", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    private void addBlackBoardAttribute(BlackboardAttribute attr, int artifactTypeId, CaseDbConnection connection) throws SQLException, TskCoreException {
        PreparedStatement statement;
        switch (attr.getAttributeType().getValueType()) {
            case STRING: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_STRING_ATTRIBUTE);
                statement.clearParameters();
                statement.setString(7, attr.getValueString());
                break;
            }
            case BYTE: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_BYTE_ATTRIBUTE);
                statement.clearParameters();
                statement.setBytes(7, attr.getValueBytes());
                break;
            }
            case INTEGER: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_INT_ATTRIBUTE);
                statement.clearParameters();
                statement.setInt(7, attr.getValueInt());
                break;
            }
            case LONG: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LONG_ATTRIBUTE);
                statement.clearParameters();
                statement.setLong(7, attr.getValueLong());
                break;
            }
            case DOUBLE: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_DOUBLE_ATTRIBUTE);
                statement.clearParameters();
                statement.setDouble(7, attr.getValueDouble());
                break;
            }
            case DATETIME: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LONG_ATTRIBUTE);
                statement.clearParameters();
                statement.setLong(7, attr.getValueLong());
                break;
            }
            default: {
                throw new TskCoreException("Unrecognized artifact attribute value type");
            }
        }
        statement.setLong(1, attr.getArtifactID());
        statement.setInt(2, artifactTypeId);
        statement.setString(3, attr.getSourcesCSV());
        statement.setString(4, "");
        statement.setInt(5, attr.getAttributeType().getTypeID());
        statement.setLong(6, attr.getAttributeType().getValueType().getType());
        connection.executeUpdate(statement);
    }

    String addSourceToArtifactAttribute(BlackboardAttribute attr, String source) throws TskCoreException {
        String string;
        if (null == source || source.isEmpty()) {
            throw new TskCoreException("Attempt to add null or empty source module name to artifact attribute");
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        Statement queryStmt = null;
        Statement updateStmt = null;
        ResultSet result = null;
        String newSources = "";
        try {
            connection.beginTransaction();
            String valueClause = "";
            BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE valueType = attr.getAttributeType().getValueType();
            if (BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.BYTE != valueType) {
                switch (valueType) {
                    case STRING: {
                        valueClause = " value_text = '" + SleuthkitCase.escapeSingleQuotes(attr.getValueString()) + "'";
                        break;
                    }
                    case INTEGER: {
                        valueClause = " value_int32 = " + attr.getValueInt();
                        break;
                    }
                    case LONG: 
                    case DATETIME: {
                        valueClause = " value_int64 = " + attr.getValueLong();
                        break;
                    }
                    case DOUBLE: {
                        valueClause = " value_double = " + attr.getValueDouble();
                        break;
                    }
                    default: {
                        throw new TskCoreException(String.format("Unrecognized value type for attribute %s", attr.getDisplayString()));
                    }
                }
                String query = "SELECT source FROM blackboard_attributes WHERE artifact_id = " + attr.getArtifactID() + " AND attribute_type_id = " + attr.getAttributeType().getTypeID() + " AND value_type = " + attr.getAttributeType().getValueType().getType() + " AND " + valueClause + ";";
                queryStmt = connection.createStatement();
                updateStmt = connection.createStatement();
                result = connection.executeQuery(queryStmt, query);
            } else {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ATTR_BY_VALUE_BYTE);
                statement.clearParameters();
                statement.setLong(1, attr.getArtifactID());
                statement.setLong(2, attr.getAttributeType().getTypeID());
                statement.setBytes(3, attr.getValueBytes());
                result = connection.executeQuery(statement);
            }
            while (result.next()) {
                HashSet<String> uniqueSources;
                String oldSources = result.getString("source");
                newSources = null != oldSources && !oldSources.isEmpty() ? (!(uniqueSources = new HashSet<String>(Arrays.asList(oldSources.split(",")))).contains(source) ? oldSources + "," + source : oldSources) : source;
                if (BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.BYTE != valueType) {
                    String update = "UPDATE blackboard_attributes SET source = '" + newSources + "' WHERE artifact_id = " + attr.getArtifactID() + " AND attribute_type_id = " + attr.getAttributeType().getTypeID() + " AND value_type = " + attr.getAttributeType().getValueType().getType() + " AND " + valueClause + ";";
                    connection.executeUpdate(updateStmt, update);
                    continue;
                }
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_ATTR_BY_VALUE_BYTE);
                statement.clearParameters();
                statement.setString(1, newSources);
                statement.setLong(2, attr.getArtifactID());
                statement.setLong(3, attr.getAttributeType().getTypeID());
                statement.setBytes(4, attr.getValueBytes());
                connection.executeUpdate(statement);
            }
            connection.commitTransaction();
            string = newSources;
        }
        catch (SQLException ex) {
            try {
                connection.rollbackTransaction();
                throw new TskCoreException(String.format("Error adding source module to attribute %s", attr.getDisplayString()), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(result);
                SleuthkitCase.closeStatement(updateStmt);
                SleuthkitCase.closeStatement(queryStmt);
                connection.close();
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(result);
        SleuthkitCase.closeStatement(updateStmt);
        SleuthkitCase.closeStatement(queryStmt);
        connection.close();
        this.releaseSingleUserCaseWriteLock();
        return string;
    }

    public BlackboardAttribute.Type addArtifactAttributeType(String attrTypeString, BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE valueType, String displayName) throws TskCoreException, TskDataException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block6: {
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseWriteLock();
            s = null;
            rs = null;
            connection.beginTransaction();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT attribute_type_id FROM blackboard_attribute_types WHERE type_name = '" + attrTypeString + "'");
            if (rs.next()) break block6;
            rs.close();
            rs = connection.executeQuery(s, "SELECT MAX(attribute_type_id) AS highest_id FROM blackboard_attribute_types");
            int maxID = 0;
            if (rs.next()) {
                maxID = rs.getInt("highest_id");
                maxID = maxID < 10000 ? 10000 : ++maxID;
            }
            connection.executeUpdate(s, "INSERT INTO blackboard_attribute_types (attribute_type_id, type_name, display_name, value_type) VALUES ('" + maxID + "', '" + attrTypeString + "', '" + displayName + "', '" + valueType.getType() + "')");
            BlackboardAttribute.Type type = new BlackboardAttribute.Type(maxID, attrTypeString, displayName, valueType);
            this.typeIdToAttributeTypeMap.put(type.getTypeID(), type);
            this.typeNameToAttributeTypeMap.put(type.getTypeName(), type);
            connection.commitTransaction();
            BlackboardAttribute.Type type2 = type;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
            return type2;
        }
        try {
            try {
                throw new TskDataException("The attribute type that was added was already within the system.");
            }
            catch (SQLException ex) {
                connection.rollbackTransaction();
                throw new TskCoreException("Error adding attribute type", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
    }

    public BlackboardAttribute.Type getAttributeType(String attrTypeName) throws TskCoreException {
        BlackboardAttribute.Type type;
        if (this.typeNameToAttributeTypeMap.containsKey(attrTypeName)) {
            return this.typeNameToAttributeTypeMap.get(attrTypeName);
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT attribute_type_id, type_name, display_name, value_type FROM blackboard_attribute_types WHERE type_name = '" + attrTypeName + "'");
            BlackboardAttribute.Type type2 = null;
            if (rs.next()) {
                type2 = new BlackboardAttribute.Type(rs.getInt("attribute_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.fromType(rs.getLong("value_type")));
                this.typeIdToAttributeTypeMap.put(type2.getTypeID(), type2);
                this.typeNameToAttributeTypeMap.put(attrTypeName, type2);
            }
            type = type2;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attribute type id", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return type;
    }

    private BlackboardAttribute.Type getAttributeType(int typeID) throws TskCoreException {
        BlackboardAttribute.Type type;
        if (this.typeIdToAttributeTypeMap.containsKey(typeID)) {
            return this.typeIdToAttributeTypeMap.get(typeID);
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT attribute_type_id, type_name, display_name, value_type FROM blackboard_attribute_types WHERE attribute_type_id = " + typeID + "");
            BlackboardAttribute.Type type2 = null;
            if (rs.next()) {
                type2 = new BlackboardAttribute.Type(rs.getInt("attribute_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.fromType(rs.getLong("value_type")));
                this.typeIdToAttributeTypeMap.put(typeID, type2);
                this.typeNameToAttributeTypeMap.put(type2.getTypeName(), type2);
            }
            type = type2;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attribute type id", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return type;
    }

    public BlackboardArtifact.Type getArtifactType(String artTypeName) throws TskCoreException {
        BlackboardArtifact.Type type;
        if (this.typeNameToArtifactTypeMap.containsKey(artTypeName)) {
            return this.typeNameToArtifactTypeMap.get(artTypeName);
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT artifact_type_id, type_name, display_name FROM blackboard_artifact_types WHERE type_name = '" + artTypeName + "'");
            BlackboardArtifact.Type type2 = null;
            if (rs.next()) {
                type2 = new BlackboardArtifact.Type(rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"));
                this.typeIdToArtifactTypeMap.put(type2.getTypeID(), type2);
                this.typeNameToArtifactTypeMap.put(artTypeName, type2);
            }
            type = type2;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting artifact type from the database", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return type;
    }

    BlackboardArtifact.Type getArtifactType(int artTypeId) throws TskCoreException {
        BlackboardArtifact.Type type;
        if (this.typeIdToArtifactTypeMap.containsKey(artTypeId)) {
            return this.typeIdToArtifactTypeMap.get(artTypeId);
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT artifact_type_id, type_name, display_name FROM blackboard_artifact_types WHERE artifact_type_id = " + artTypeId + "");
            BlackboardArtifact.Type type2 = null;
            if (rs.next()) {
                type2 = new BlackboardArtifact.Type(rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"));
                this.typeIdToArtifactTypeMap.put(artTypeId, type2);
                this.typeNameToArtifactTypeMap.put(type2.getTypeName(), type2);
            }
            type = type2;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting artifact type from the database", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return type;
    }

    public BlackboardArtifact.Type addBlackboardArtifactType(String artifactTypeName, String displayName) throws TskCoreException, TskDataException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block6: {
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseWriteLock();
            s = null;
            rs = null;
            connection.beginTransaction();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT artifact_type_id FROM blackboard_artifact_types WHERE type_name = '" + artifactTypeName + "'");
            if (rs.next()) break block6;
            rs.close();
            rs = connection.executeQuery(s, "SELECT MAX(artifact_type_id) AS highest_id FROM blackboard_artifact_types");
            int maxID = 0;
            if (rs.next()) {
                maxID = rs.getInt("highest_id");
                maxID = maxID < 10000 ? 10000 : ++maxID;
            }
            connection.executeUpdate(s, "INSERT INTO blackboard_artifact_types (artifact_type_id, type_name, display_name) VALUES ('" + maxID + "', '" + artifactTypeName + "', '" + displayName + "')");
            BlackboardArtifact.Type type = new BlackboardArtifact.Type(maxID, artifactTypeName, displayName);
            this.typeIdToArtifactTypeMap.put(type.getTypeID(), type);
            this.typeNameToArtifactTypeMap.put(type.getTypeName(), type);
            connection.commitTransaction();
            BlackboardArtifact.Type type2 = type;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
            return type2;
        }
        try {
            try {
                throw new TskDataException("The attribute type that was added was already within the system.");
            }
            catch (SQLException ex) {
                connection.rollbackTransaction();
                throw new TskCoreException("Error adding artifact type", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
    }

    public ArrayList<BlackboardAttribute> getBlackboardAttributes(BlackboardArtifact artifact) throws TskCoreException {
        ArrayList<BlackboardAttribute> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            Statement statement = connection.createStatement();
            rs = connection.executeQuery(statement, "SELECT attrs.artifact_id AS artifact_id, attrs.source AS source, attrs.context AS context, attrs.attribute_type_id AS attribute_type_id, attrs.value_type AS value_type, attrs.value_byte AS value_byte, attrs.value_text AS value_text, attrs.value_int32 AS value_int32, attrs.value_int64 AS value_int64, attrs.value_double AS value_double, types.type_name AS type_name, types.display_name AS display_name FROM blackboard_attributes AS attrs, blackboard_attribute_types AS types WHERE attrs.artifact_id = " + artifact.getArtifactID() + " AND attrs.attribute_type_id = types.attribute_type_id");
            ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
            while (rs.next()) {
                BlackboardAttribute.Type attributeType;
                int attributeTypeId = rs.getInt("attribute_type_id");
                String attributeTypeName = rs.getString("type_name");
                if (this.typeIdToAttributeTypeMap.containsKey(attributeTypeId)) {
                    attributeType = this.typeIdToAttributeTypeMap.get(attributeTypeId);
                } else {
                    attributeType = new BlackboardAttribute.Type(attributeTypeId, attributeTypeName, rs.getString("display_name"), BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.fromType(rs.getInt("value_type")));
                    this.typeIdToAttributeTypeMap.put(attributeTypeId, attributeType);
                    this.typeNameToAttributeTypeMap.put(attributeTypeName, attributeType);
                }
                BlackboardAttribute attr = new BlackboardAttribute(rs.getLong("artifact_id"), attributeType, rs.getString("source"), rs.getString("context"), rs.getInt("value_int32"), rs.getLong("value_int64"), rs.getDouble("value_double"), rs.getString("value_text"), rs.getBytes("value_byte"), this);
                attributes.add(attr);
            }
            arrayList = attributes;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attributes for artifact, artifact id = " + artifact.getArtifactID(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public ArrayList<BlackboardAttribute> getMatchingAttributes(String whereClause) throws TskCoreException {
        ArrayList<BlackboardAttribute> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT blackboard_attributes.artifact_id AS artifact_id, blackboard_attributes.source AS source, blackboard_attributes.context AS context, blackboard_attributes.attribute_type_id AS attribute_type_id, blackboard_attributes.value_type AS value_type, blackboard_attributes.value_byte AS value_byte, blackboard_attributes.value_text AS value_text, blackboard_attributes.value_int32 AS value_int32, blackboard_attributes.value_int64 AS value_int64, blackboard_attributes.value_double AS value_double FROM blackboard_attributes " + whereClause);
            ArrayList<BlackboardAttribute> matches = new ArrayList<BlackboardAttribute>();
            while (rs.next()) {
                BlackboardAttribute.Type type = this.getAttributeType(rs.getInt("attribute_type_id"));
                BlackboardAttribute attr = new BlackboardAttribute(rs.getLong("artifact_id"), type, rs.getString("source"), rs.getString("context"), rs.getInt("value_int32"), rs.getLong("value_int64"), rs.getDouble("value_double"), rs.getString("value_text"), rs.getBytes("value_byte"), this);
                matches.add(attr);
            }
            arrayList = matches;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attributes using this where clause: " + whereClause, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public ArrayList<BlackboardArtifact> getMatchingArtifacts(String whereClause) throws TskCoreException {
        ArrayList<BlackboardArtifact> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        Statement s = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT blackboard_artifacts.artifact_id AS artifact_id, blackboard_artifacts.obj_id AS obj_id, blackboard_artifacts.artifact_obj_id AS artifact_obj_id, blackboard_artifacts.data_source_obj_id AS data_source_obj_id, blackboard_artifacts.artifact_type_id AS artifact_type_id, blackboard_artifacts.review_status_id AS review_status_id  FROM blackboard_artifacts " + whereClause);
            ArrayList<BlackboardArtifact> matches = new ArrayList<BlackboardArtifact>();
            while (rs.next()) {
                BlackboardArtifact.Type type = this.getArtifactType(rs.getInt("artifact_type_id"));
                BlackboardArtifact artifact = new BlackboardArtifact(this, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), type.getTypeID(), type.getTypeName(), type.getDisplayName(), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id")));
                matches.add(artifact);
            }
            arrayList = matches;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attributes using this where clause: " + whereClause, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public BlackboardArtifact newBlackboardArtifact(int artifactTypeID, long obj_id) throws TskCoreException {
        BlackboardArtifact.Type type = this.getArtifactType(artifactTypeID);
        return this.newBlackboardArtifact(artifactTypeID, obj_id, type.getTypeName(), type.getDisplayName());
    }

    public BlackboardArtifact newBlackboardArtifact(BlackboardArtifact.ARTIFACT_TYPE artifactType, long obj_id) throws TskCoreException {
        return this.newBlackboardArtifact(artifactType.getTypeID(), obj_id, artifactType.getLabel(), artifactType.getDisplayName());
    }

    private BlackboardArtifact newBlackboardArtifact(int artifact_type_id, long obj_id, String artifactTypeName, String artifactDisplayName) throws TskCoreException {
        BlackboardArtifact blackboardArtifact;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        ResultSet resultSet = null;
        try {
            long artifact_obj_id = this.addObject(obj_id, TskData.ObjectType.ARTIFACT.getObjectType(), connection);
            long data_source_obj_id = this.getDataSourceObjectId(connection, obj_id);
            PreparedStatement statement = null;
            if (this.dbType == TskData.DbType.POSTGRESQL) {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.POSTGRESQL_INSERT_ARTIFACT, 1);
                statement.clearParameters();
                statement.setLong(1, obj_id);
                statement.setLong(2, artifact_obj_id);
                statement.setLong(3, data_source_obj_id);
                statement.setInt(4, artifact_type_id);
            } else {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_ARTIFACT, 1);
                statement.clearParameters();
                ++this.nextArtifactId;
                statement.setLong(1, this.nextArtifactId);
                statement.setLong(2, obj_id);
                statement.setLong(3, artifact_obj_id);
                statement.setLong(4, data_source_obj_id);
                statement.setInt(5, artifact_type_id);
            }
            connection.executeUpdate(statement);
            resultSet = statement.getGeneratedKeys();
            resultSet.next();
            blackboardArtifact = new BlackboardArtifact(this, resultSet.getLong(1), obj_id, artifact_obj_id, data_source_obj_id, artifact_type_id, artifactTypeName, artifactDisplayName, BlackboardArtifact.ReviewStatus.UNDECIDED, true);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error creating a blackboard artifact", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseWriteLock();
        return blackboardArtifact;
    }

    boolean getContentHasChildren(Content content) throws TskCoreException {
        boolean bl;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_CHILD_OBJECTS_BY_PARENT);
            statement.clearParameters();
            statement.setLong(1, content.getId());
            rs = connection.executeQuery(statement);
            boolean hasChildren = false;
            if (rs.next()) {
                hasChildren = rs.getInt("count") > 0;
            }
            bl = hasChildren;
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("Error checking for children of parent " + content, e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return bl;
    }

    int getContentChildrenCount(Content content) throws TskCoreException {
        int n;
        if (!this.getHasChildren(content)) {
            return 0;
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_CHILD_OBJECTS_BY_PARENT);
            statement.clearParameters();
            statement.setLong(1, content.getId());
            rs = connection.executeQuery(statement);
            int countChildren = -1;
            if (rs.next()) {
                countChildren = rs.getInt("count");
            }
            n = countChildren;
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("Error checking for children of parent " + content, e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return n;
    }

    List<Content> getAbstractFileChildren(Content parent, TskData.TSK_DB_FILES_TYPE_ENUM type) throws TskCoreException {
        List<Content> list;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_PARENT_AND_TYPE);
            statement.clearParameters();
            long parentId = parent.getId();
            statement.setLong(1, parentId);
            statement.setShort(2, type.getFileType());
            rs = connection.executeQuery(statement);
            list = this.fileChildren(rs, connection, parentId);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting AbstractFile children for Content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return list;
    }

    List<Content> getAbstractFileChildren(Content parent) throws TskCoreException {
        List<Content> list;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_PARENT);
            statement.clearParameters();
            long parentId = parent.getId();
            statement.setLong(1, parentId);
            rs = connection.executeQuery(statement);
            list = this.fileChildren(rs, connection, parentId);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting AbstractFile children for Content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return list;
    }

    List<Long> getAbstractFileChildrenIds(Content parent, TskData.TSK_DB_FILES_TYPE_ENUM type) throws TskCoreException {
        ArrayList<Long> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_IDS_BY_PARENT_AND_TYPE);
            statement.clearParameters();
            statement.setLong(1, parent.getId());
            statement.setShort(2, type.getFileType());
            rs = connection.executeQuery(statement);
            ArrayList<Long> children = new ArrayList<Long>();
            while (rs.next()) {
                children.add(rs.getLong("obj_id"));
            }
            arrayList = children;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting AbstractFile children for Content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    List<Long> getAbstractFileChildrenIds(Content parent) throws TskCoreException {
        ArrayList<Long> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_IDS_BY_PARENT);
            statement.clearParameters();
            statement.setLong(1, parent.getId());
            rs = connection.executeQuery(statement);
            ArrayList<Long> children = new ArrayList<Long>();
            while (rs.next()) {
                children.add(rs.getLong("obj_id"));
            }
            arrayList = children;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting AbstractFile children for Content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    List<Long> getBlackboardArtifactChildrenIds(Content parent) throws TskCoreException {
        ArrayList<Long> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_OBJECTIDS_BY_PARENT);
            statement.clearParameters();
            statement.setLong(1, parent.getId());
            rs = connection.executeQuery(statement);
            ArrayList<Long> children = new ArrayList<Long>();
            while (rs.next()) {
                children.add(rs.getLong("obj_id"));
            }
            arrayList = children;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting children for BlackboardArtifact", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    List<Content> getBlackboardArtifactChildren(Content parent) throws TskCoreException {
        long parentId = parent.getId();
        ArrayList<BlackboardArtifact> artsArray = this.getArtifactsHelper("blackboard_artifacts.obj_id = " + parentId + ";");
        ArrayList<Content> lc = new ArrayList<Content>();
        lc.addAll(artsArray);
        return lc;
    }

    Collection<ObjectInfo> getChildrenInfo(Content c) throws TskCoreException {
        ArrayList<ObjectInfo> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT tsk_objects.obj_id AS obj_id, tsk_objects.type AS type FROM tsk_objects LEFT JOIN tsk_files ON tsk_objects.obj_id = tsk_files.obj_id WHERE tsk_objects.par_obj_id = " + c.getId() + " ORDER BY tsk_objects.obj_id");
            ArrayList<ObjectInfo> infos = new ArrayList<ObjectInfo>();
            while (rs.next()) {
                infos.add(new ObjectInfo(rs.getLong("obj_id"), TskData.ObjectType.valueOf(rs.getShort("type"))));
            }
            arrayList = infos;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting Children Info for Content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    ObjectInfo getParentInfo(Content c) throws TskCoreException {
        return this.getParentInfo(c.getId());
    }

    ObjectInfo getParentInfo(long contentId) throws TskCoreException {
        ObjectInfo objectInfo;
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block5: {
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            s = null;
            rs = null;
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT parent.obj_id AS obj_id, parent.type AS type FROM tsk_objects AS parent INNER JOIN tsk_objects AS child ON child.par_obj_id = parent.obj_id WHERE child.obj_id = " + contentId);
            if (!rs.next()) break block5;
            ObjectInfo objectInfo2 = new ObjectInfo(rs.getLong("obj_id"), TskData.ObjectType.valueOf(rs.getShort("type")));
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return objectInfo2;
        }
        try {
            objectInfo = null;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting Parent Info for Content: " + contentId, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return objectInfo;
    }

    Directory getParentDirectory(FsContent fsc) throws TskCoreException {
        if (fsc.isRoot()) {
            return null;
        }
        ObjectInfo parentInfo = this.getParentInfo(fsc);
        if (parentInfo == null) {
            return null;
        }
        Directory parent = null;
        if (parentInfo.type != TskData.ObjectType.ABSTRACTFILE) {
            throw new TskCoreException("Parent of FsContent (id: " + fsc.getId() + ") has wrong type to be directory: " + (Object)((Object)parentInfo.type));
        }
        parent = this.getDirectoryById(parentInfo.id, fsc.getFileSystem());
        return parent;
    }

    public Content getContentById(long id) throws TskCoreException {
        TskData.ObjectType type;
        long parentId;
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        Content content;
        block15: {
            content = this.frequentlyUsedContentMap.get(id);
            if (null != content) {
                return content;
            }
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            s = null;
            rs = null;
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_objects WHERE obj_id = " + id + " LIMIT  1");
            if (rs.next()) break block15;
            Content content2 = null;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return content2;
        }
        try {
            parentId = rs.getLong("par_obj_id");
            type = TskData.ObjectType.valueOf(rs.getShort("type"));
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting Content by ID.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        switch (type) {
            case IMG: {
                content = this.getImageById(id);
                this.frequentlyUsedContentMap.put(id, content);
                break;
            }
            case VS: {
                content = this.getVolumeSystemById(id, parentId);
                break;
            }
            case VOL: {
                content = this.getVolumeById(id, parentId);
                this.frequentlyUsedContentMap.put(id, content);
                break;
            }
            case FS: {
                content = this.getFileSystemById(id, parentId);
                this.frequentlyUsedContentMap.put(id, content);
                break;
            }
            case ABSTRACTFILE: {
                content = this.getAbstractFileById(id);
                if (!((AbstractFile)content).isVirtual() && (content instanceof LocalDirectory || !((AbstractFile)content).isRoot())) break;
                this.frequentlyUsedContentMap.put(id, content);
                break;
            }
            case ARTIFACT: {
                content = this.getArtifactById(id);
                break;
            }
            case REPORT: {
                content = this.getReportById(id);
                break;
            }
            default: {
                throw new TskCoreException("Could not obtain Content object with ID: " + id);
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFilePath(long id) {
        ResultSet rs;
        String filePath;
        CaseDbConnection connection;
        block6: {
            try {
                connection = this.connections.getConnection();
            }
            catch (TskCoreException ex) {
                logger.log(Level.SEVERE, "Error getting file path for file " + id, ex);
                return null;
            }
            filePath = null;
            this.acquireSingleUserCaseReadLock();
            rs = null;
            try {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_LOCAL_PATH_FOR_FILE);
                statement.clearParameters();
                statement.setLong(1, id);
                rs = connection.executeQuery(statement);
                if (!rs.next()) break block6;
                filePath = rs.getString("path");
            }
            catch (SQLException ex) {
                try {
                    logger.log(Level.SEVERE, "Error getting file path for file " + id, ex);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(rs);
                    connection.close();
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TskData.EncodingType getEncodingType(long id) {
        ResultSet rs;
        TskData.EncodingType type;
        CaseDbConnection connection;
        block6: {
            try {
                connection = this.connections.getConnection();
            }
            catch (TskCoreException ex) {
                logger.log(Level.SEVERE, "Error getting file path for file " + id, ex);
                return null;
            }
            type = TskData.EncodingType.NONE;
            this.acquireSingleUserCaseReadLock();
            rs = null;
            try {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ENCODING_FOR_FILE);
                statement.clearParameters();
                statement.setLong(1, id);
                rs = connection.executeQuery(statement);
                if (!rs.next()) break block6;
                type = TskData.EncodingType.valueOf(rs.getInt(1));
            }
            catch (SQLException ex) {
                try {
                    logger.log(Level.SEVERE, "Error getting encoding type for file " + id, ex);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(rs);
                    connection.close();
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFileParentPath(long objectId, CaseDbConnection connection) {
        ResultSet rs;
        String parentPath;
        block4: {
            parentPath = null;
            this.acquireSingleUserCaseReadLock();
            rs = null;
            try {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_PATH_FOR_FILE);
                statement.clearParameters();
                statement.setLong(1, objectId);
                rs = connection.executeQuery(statement);
                if (!rs.next()) break block4;
                parentPath = rs.getString("parent_path");
            }
            catch (SQLException ex) {
                try {
                    logger.log(Level.SEVERE, "Error getting file parent_path for file " + objectId, ex);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(rs);
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
                SleuthkitCase.closeResultSet(rs);
                this.releaseSingleUserCaseReadLock();
            }
        }
        SleuthkitCase.closeResultSet(rs);
        this.releaseSingleUserCaseReadLock();
        return parentPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFileName(long objectId, CaseDbConnection connection) {
        ResultSet rs;
        String fileName;
        block4: {
            fileName = null;
            this.acquireSingleUserCaseReadLock();
            rs = null;
            try {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_NAME);
                statement.clearParameters();
                statement.setLong(1, objectId);
                rs = connection.executeQuery(statement);
                if (!rs.next()) break block4;
                fileName = rs.getString("name");
            }
            catch (SQLException ex) {
                try {
                    logger.log(Level.SEVERE, "Error getting file parent_path for file " + objectId, ex);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(rs);
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
                SleuthkitCase.closeResultSet(rs);
                this.releaseSingleUserCaseReadLock();
            }
        }
        SleuthkitCase.closeResultSet(rs);
        this.releaseSingleUserCaseReadLock();
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DerivedFile.DerivedMethod getDerivedMethod(long id) throws TskCoreException {
        ResultSet rs2;
        ResultSet rs1;
        DerivedFile.DerivedMethod method;
        CaseDbConnection connection;
        block4: {
            connection = this.connections.getConnection();
            method = null;
            this.acquireSingleUserCaseReadLock();
            rs1 = null;
            rs2 = null;
            try {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_DERIVED_FILE);
                statement.clearParameters();
                statement.setLong(1, id);
                rs1 = connection.executeQuery(statement);
                if (!rs1.next()) break block4;
                int method_id = rs1.getInt("derived_id");
                String rederive = rs1.getString("rederive");
                method = new DerivedFile.DerivedMethod(method_id, rederive);
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_DERIVATION_METHOD);
                statement.clearParameters();
                statement.setInt(1, method_id);
                rs2 = connection.executeQuery(statement);
                if (!rs2.next()) break block4;
                method.setToolName(rs2.getString("tool_name"));
                method.setToolVersion(rs2.getString("tool_version"));
                method.setOther(rs2.getString("other"));
            }
            catch (SQLException e) {
                try {
                    logger.log(Level.SEVERE, "Error getting derived method for file: " + id, e);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(rs2);
                    SleuthkitCase.closeResultSet(rs1);
                    connection.close();
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
                SleuthkitCase.closeResultSet(rs2);
                SleuthkitCase.closeResultSet(rs1);
                connection.close();
                this.releaseSingleUserCaseReadLock();
            }
        }
        SleuthkitCase.closeResultSet(rs2);
        SleuthkitCase.closeResultSet(rs1);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFile getAbstractFileById(long id) throws TskCoreException {
        try (CaseDbConnection connection = this.connections.getConnection();){
            AbstractFile abstractFile = this.getAbstractFileById(id, connection);
            return abstractFile;
        }
    }

    AbstractFile getAbstractFileById(long objectId, CaseDbConnection connection) throws TskCoreException {
        AbstractFile abstractFile;
        ResultSet rs;
        block5: {
            this.acquireSingleUserCaseReadLock();
            rs = null;
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_BY_ID);
            statement.clearParameters();
            statement.setLong(1, objectId);
            rs = connection.executeQuery(statement);
            List<AbstractFile> files = this.resultSetToAbstractFiles(rs, connection);
            if (files.size() <= 0) break block5;
            AbstractFile abstractFile2 = files.get(0);
            SleuthkitCase.closeResultSet(rs);
            this.releaseSingleUserCaseReadLock();
            return abstractFile2;
        }
        try {
            abstractFile = null;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting file by id, id = " + objectId, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        this.releaseSingleUserCaseReadLock();
        return abstractFile;
    }

    public BlackboardArtifact getArtifactById(long id) throws TskCoreException {
        BlackboardArtifact blackboardArtifact;
        ResultSet rs;
        CaseDbConnection connection;
        block5: {
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            rs = null;
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_BY_ARTIFACT_OBJ_ID);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            List<BlackboardArtifact> artifacts = this.resultSetToArtifacts(rs);
            if (artifacts.size() <= 0) break block5;
            BlackboardArtifact blackboardArtifact2 = artifacts.get(0);
            SleuthkitCase.closeResultSet(rs);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return blackboardArtifact2;
        }
        try {
            blackboardArtifact = null;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting artifacts by artifact_obj_id, artifact_obj_id = " + id, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return blackboardArtifact;
    }

    public BlackboardArtifact getArtifactByArtifactId(long id) throws TskCoreException {
        BlackboardArtifact blackboardArtifact;
        ResultSet rs;
        CaseDbConnection connection;
        block5: {
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            rs = null;
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_BY_ARTIFACT_ID);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            List<BlackboardArtifact> artifacts = this.resultSetToArtifacts(rs);
            if (artifacts.size() <= 0) break block5;
            BlackboardArtifact blackboardArtifact2 = artifacts.get(0);
            SleuthkitCase.closeResultSet(rs);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return blackboardArtifact2;
        }
        try {
            blackboardArtifact = null;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting artifacts by artifact id, artifact id = " + id, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return blackboardArtifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFileSystemId(long fileId, CaseDbConnection connection) {
        long ret;
        ResultSet rs;
        block4: {
            this.acquireSingleUserCaseReadLock();
            rs = null;
            ret = -1L;
            try {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_SYSTEM_BY_OBJECT);
                statement.clearParameters();
                statement.setLong(1, fileId);
                rs = connection.executeQuery(statement);
                if (!rs.next() || (ret = rs.getLong("fs_obj_id")) != 0L) break block4;
                ret = -1L;
            }
            catch (SQLException e) {
                try {
                    logger.log(Level.SEVERE, "Error checking file system id of a file, id = " + fileId, e);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(rs);
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
                SleuthkitCase.closeResultSet(rs);
                this.releaseSingleUserCaseReadLock();
            }
        }
        SleuthkitCase.closeResultSet(rs);
        this.releaseSingleUserCaseReadLock();
        return ret;
    }

    public boolean isFileFromSource(Content dataSource, long fileId) throws TskCoreException {
        boolean bl;
        String query = String.format("SELECT COUNT(*) AS count FROM tsk_files WHERE obj_id = %d AND data_source_obj_id = %d", fileId, dataSource.getId());
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, query);
            resultSet.next();
            bl = resultSet.getLong("count") > 0L;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("Error executing query %s", query), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return bl;
    }

    public List<AbstractFile> findFiles(Content dataSource, String fileName) throws TskCoreException {
        ArrayList<AbstractFile> files = new ArrayList<AbstractFile>();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_DATA_SOURCE_AND_NAME);
            statement.clearParameters();
            statement.setString(1, fileName.toLowerCase());
            statement.setLong(2, dataSource.getId());
            resultSet = connection.executeQuery(statement);
            files.addAll(this.resultSetToAbstractFiles(resultSet, connection));
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException(bundle.getString("SleuthkitCase.findFiles.exception.msg3.text"), e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return files;
    }

    public List<AbstractFile> findFiles(Content dataSource, String fileName, String dirSubString) throws TskCoreException {
        ArrayList<AbstractFile> files = new ArrayList<AbstractFile>();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_DATA_SOURCE_AND_PARENT_PATH_AND_NAME);
            statement.clearParameters();
            statement.setString(1, fileName.toLowerCase());
            statement.setString(2, "%" + dirSubString.toLowerCase() + "%");
            statement.setLong(3, dataSource.getId());
            resultSet = connection.executeQuery(statement);
            files.addAll(this.resultSetToAbstractFiles(resultSet, connection));
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException(bundle.getString("SleuthkitCase.findFiles3.exception.msg3.text"), e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualDirectory addVirtualDirectory(long parentId, String directoryName) throws TskCoreException {
        CaseDbTransaction localTrans = this.beginTransaction();
        localTrans.acquireSingleUserCaseWriteLock();
        try {
            VirtualDirectory newVD = this.addVirtualDirectory(parentId, directoryName, localTrans);
            localTrans.commit();
            localTrans = null;
            VirtualDirectory virtualDirectory = newVD;
            return virtualDirectory;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex2) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
            }
        }
    }

    private long addObject(long parentId, int objectType, CaseDbConnection connection) throws SQLException {
        block6: {
            long l;
            ResultSet resultSet = null;
            this.acquireSingleUserCaseWriteLock();
            try {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_OBJECT, 1);
                statement.clearParameters();
                if (parentId != 0L) {
                    statement.setLong(1, parentId);
                } else {
                    statement.setNull(1, -5);
                }
                statement.setInt(2, objectType);
                connection.executeUpdate(statement);
                resultSet = statement.getGeneratedKeys();
                if (!resultSet.next()) break block6;
                if (parentId != 0L) {
                    this.setHasChildren(parentId);
                }
                l = resultSet.getLong(1);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
            SleuthkitCase.closeResultSet(resultSet);
            this.releaseSingleUserCaseWriteLock();
            return l;
        }
        throw new SQLException("Error inserting object with parent " + parentId + " into tsk_objects");
    }

    public VirtualDirectory addVirtualDirectory(long parentId, String directoryName, CaseDbTransaction transaction) throws TskCoreException {
        if (transaction == null) {
            throw new TskCoreException("Passed null CaseDbTransaction");
        }
        transaction.acquireSingleUserCaseWriteLock();
        ResultSet resultSet = null;
        try {
            CaseDbConnection connection = transaction.getConnection();
            AbstractFile parent = this.getAbstractFileById(parentId, connection);
            String parentPath = parent instanceof AbstractFile ? (this.isRootDirectory(parent, transaction) ? "/" : parent.getParentPath() + parent.getName() + "/") : "/";
            long newObjId = this.addObject(parentId, TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            statement.clearParameters();
            statement.setLong(1, newObjId);
            if (0L != parentId) {
                long parentFs = this.getFileSystemId(parentId, connection);
                if (parentFs != -1L) {
                    statement.setLong(2, parentFs);
                } else {
                    statement.setNull(2, -5);
                }
            } else {
                statement.setNull(2, -5);
            }
            statement.setString(3, directoryName);
            statement.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR.getFileType());
            statement.setShort(5, (short)1);
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            statement.setShort(6, dirType.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            statement.setShort(7, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            statement.setShort(8, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            statement.setShort(9, metaFlags);
            statement.setLong(10, 0L);
            statement.setNull(11, -5);
            statement.setNull(12, -5);
            statement.setNull(13, -5);
            statement.setNull(14, -5);
            statement.setNull(15, 12);
            statement.setByte(16, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            statement.setNull(17, 12);
            statement.setString(18, parentPath);
            long dataSourceObjectId = 0L == parentId ? newObjId : this.getDataSourceObjectId(connection, parentId);
            statement.setLong(19, dataSourceObjectId);
            statement.setString(20, null);
            connection.executeUpdate(statement);
            VirtualDirectory virtualDirectory = new VirtualDirectory(this, newObjId, dataSourceObjectId, directoryName, dirType, metaType, dirFlag, metaFlags, null, TskData.FileKnown.UNKNOWN, parentPath);
            return virtualDirectory;
        }
        catch (SQLException e) {
            throw new TskCoreException("Error creating virtual directory '" + directoryName + "'", e);
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
        }
    }

    public LocalDirectory addLocalDirectory(long parentId, String directoryName) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        CaseDbTransaction localTrans = this.beginTransaction();
        try {
            LocalDirectory newLD = this.addLocalDirectory(parentId, directoryName, localTrans);
            localTrans.commit();
            LocalDirectory localDirectory = newLD;
            return localDirectory;
        }
        catch (TskCoreException ex) {
            try {
                localTrans.rollback();
            }
            catch (TskCoreException ex2) {
                logger.log(Level.SEVERE, String.format("Failed to rollback transaction after exception: %s", ex.getMessage()), ex2);
            }
            throw ex;
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public LocalDirectory addLocalDirectory(long parentId, String directoryName, CaseDbTransaction transaction) throws TskCoreException {
        if (transaction == null) {
            throw new TskCoreException("Passed null CaseDbTransaction");
        }
        transaction.acquireSingleUserCaseWriteLock();
        ResultSet resultSet = null;
        try {
            CaseDbConnection connection = transaction.getConnection();
            AbstractFile parent = this.getAbstractFileById(parentId, connection);
            String parentPath = parent == null || this.isRootDirectory(parent, transaction) ? "/" : parent.getParentPath() + parent.getName() + "/";
            long newObjId = this.addObject(parentId, TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            statement.clearParameters();
            statement.setLong(1, newObjId);
            statement.setNull(2, -5);
            statement.setString(3, directoryName);
            statement.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.LOCAL_DIR.getFileType());
            statement.setShort(5, (short)1);
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            statement.setShort(6, dirType.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            statement.setShort(7, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            statement.setShort(8, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            statement.setShort(9, metaFlags);
            statement.setLong(10, 0L);
            statement.setNull(11, -5);
            statement.setNull(12, -5);
            statement.setNull(13, -5);
            statement.setNull(14, -5);
            statement.setNull(15, 12);
            statement.setByte(16, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            statement.setNull(17, 12);
            statement.setString(18, parentPath);
            long dataSourceObjectId = this.getDataSourceObjectId(connection, parentId);
            statement.setLong(19, dataSourceObjectId);
            statement.setString(20, null);
            connection.executeUpdate(statement);
            LocalDirectory localDirectory = new LocalDirectory(this, newObjId, dataSourceObjectId, directoryName, dirType, metaType, dirFlag, metaFlags, null, TskData.FileKnown.UNKNOWN, parentPath);
            return localDirectory;
        }
        catch (SQLException e) {
            throw new TskCoreException("Error creating local directory '" + directoryName + "'", e);
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
        }
    }

    public LocalFilesDataSource addLocalFilesDataSource(String deviceId, String rootDirectoryName, String timeZone, CaseDbTransaction transaction) throws TskCoreException {
        LocalFilesDataSource localFilesDataSource;
        this.acquireSingleUserCaseWriteLock();
        Statement statement = null;
        try {
            CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.addObject(0L, TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            statement = connection.createStatement();
            statement.executeUpdate("INSERT INTO data_source_info (obj_id, device_id, time_zone) VALUES(" + newObjId + ", '" + deviceId + "', '" + timeZone + "');");
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setNull(2, -5);
            preparedStatement.setString(3, rootDirectoryName);
            preparedStatement.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR.getFileType());
            preparedStatement.setShort(5, (short)1);
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            preparedStatement.setShort(6, TskData.TSK_FS_NAME_TYPE_ENUM.DIR.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            preparedStatement.setShort(7, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            preparedStatement.setShort(8, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            preparedStatement.setShort(9, metaFlags);
            preparedStatement.setLong(10, 0L);
            preparedStatement.setNull(11, -5);
            preparedStatement.setNull(12, -5);
            preparedStatement.setNull(13, -5);
            preparedStatement.setNull(14, -5);
            preparedStatement.setNull(15, 12);
            preparedStatement.setByte(16, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            preparedStatement.setNull(17, 12);
            String parentPath = "/";
            preparedStatement.setString(18, parentPath);
            preparedStatement.setLong(19, newObjId);
            preparedStatement.setString(20, null);
            connection.executeUpdate(preparedStatement);
            localFilesDataSource = new LocalFilesDataSource(this, newObjId, newObjId, deviceId, rootDirectoryName, dirType, metaType, dirFlag, metaFlags, timeZone, null, TskData.FileKnown.UNKNOWN, parentPath);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("Error creating local files data source with device id %s and directory name %s", deviceId, rootDirectoryName), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeStatement(statement);
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseWriteLock();
        return localFilesDataSource;
    }

    public Image addImage(TskData.TSK_IMG_TYPE_ENUM type, long sectorSize, long size, String displayName, List<String> imagePaths, String timezone, String md5, String sha1, String sha256, String deviceId, CaseDbTransaction transaction) throws TskCoreException {
        Image image;
        this.acquireSingleUserCaseWriteLock();
        Statement statement = null;
        try {
            CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.addObject(0L, TskData.ObjectType.IMG.getObjectType(), connection);
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_IMAGE_INFO);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setShort(2, (short)type.getValue());
            preparedStatement.setLong(3, sectorSize);
            preparedStatement.setString(4, timezone);
            preparedStatement.setLong(5, size);
            preparedStatement.setString(6, md5);
            preparedStatement.setString(7, sha1);
            preparedStatement.setString(8, sha256);
            preparedStatement.setString(9, displayName);
            connection.executeUpdate(preparedStatement);
            for (int i = 0; i < imagePaths.size(); ++i) {
                preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_IMAGE_NAME);
                preparedStatement.clearParameters();
                preparedStatement.setLong(1, newObjId);
                preparedStatement.setString(2, imagePaths.get(i));
                preparedStatement.setLong(3, i);
                connection.executeUpdate(preparedStatement);
            }
            preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_DATA_SOURCE_INFO);
            statement = connection.createStatement();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setString(2, deviceId);
            preparedStatement.setString(3, timezone);
            connection.executeUpdate(preparedStatement);
            image = new Image(this, newObjId, type.getValue(), deviceId, sectorSize, displayName, imagePaths.toArray(new String[imagePaths.size()]), timezone, md5, sha1, sha256, size);
        }
        catch (SQLException ex) {
            try {
                if (!imagePaths.isEmpty()) {
                    throw new TskCoreException(String.format("Error adding image with path %s to database", imagePaths.get(0)), ex);
                }
                throw new TskCoreException(String.format("Error adding image with display name %s to database", displayName), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeStatement(statement);
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseWriteLock();
        return image;
    }

    public VolumeSystem addVolumeSystem(long parentObjId, TskData.TSK_VS_TYPE_ENUM type, long imgOffset, long blockSize, CaseDbTransaction transaction) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        try {
            CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.addObject(parentObjId, TskData.ObjectType.VS.getObjectType(), connection);
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_VS_INFO);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setShort(2, (short)type.getVsType());
            preparedStatement.setLong(3, imgOffset);
            preparedStatement.setLong(4, blockSize);
            connection.executeUpdate(preparedStatement);
            VolumeSystem volumeSystem = new VolumeSystem(this, newObjId, "", type.getVsType(), imgOffset, blockSize);
            return volumeSystem;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error creating volume system with parent ID %d and image offset %d", parentObjId, imgOffset), ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public Volume addVolume(long parentObjId, long addr, long start, long length, String desc, long flags, CaseDbTransaction transaction) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        Statement statement = null;
        try {
            CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.addObject(parentObjId, TskData.ObjectType.VOL.getObjectType(), connection);
            PreparedStatement preparedStatement = this.dbType == TskData.DbType.POSTGRESQL ? connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_VS_PART_POSTGRESQL) : connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_VS_PART_SQLITE);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setLong(2, addr);
            preparedStatement.setLong(3, start);
            preparedStatement.setLong(4, length);
            preparedStatement.setString(5, desc);
            preparedStatement.setShort(6, (short)flags);
            connection.executeUpdate(preparedStatement);
            Volume volume = new Volume(this, newObjId, addr, start, length, flags, desc);
            return volume;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error creating volume with address %d and parent ID %d", addr, parentObjId), ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public FileSystem addFileSystem(long parentObjId, long imgOffset, TskData.TSK_FS_TYPE_ENUM type, long blockSize, long blockCount, long rootInum, long firstInum, long lastInum, String displayName, CaseDbTransaction transaction) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        Statement statement = null;
        try {
            CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.addObject(parentObjId, TskData.ObjectType.FS.getObjectType(), connection);
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FS_INFO);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setLong(2, imgOffset);
            preparedStatement.setShort(3, (short)type.getValue());
            preparedStatement.setLong(4, blockSize);
            preparedStatement.setLong(5, blockCount);
            preparedStatement.setLong(6, rootInum);
            preparedStatement.setLong(7, firstInum);
            preparedStatement.setLong(8, lastInum);
            preparedStatement.setString(9, displayName);
            connection.executeUpdate(preparedStatement);
            FileSystem fileSystem = new FileSystem(this, newObjId, displayName, imgOffset, type, blockSize, blockCount, rootInum, firstInum, lastInum);
            return fileSystem;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error creating file system with image offset %d and parent ID %d", imgOffset, parentObjId), ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public List<VirtualDirectory> getVirtualDirectoryRoots() throws TskCoreException {
        ArrayList<VirtualDirectory> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_files WHERE type = " + TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR.getFileType() + " AND obj_id = data_source_obj_id ORDER BY dir_type, LOWER(name)");
            ArrayList<VirtualDirectory> virtDirRootIds = new ArrayList<VirtualDirectory>();
            while (rs.next()) {
                virtDirRootIds.add(this.virtualDirectory(rs, connection));
            }
            arrayList = virtDirRootIds;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting local files virtual folder id", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public final List<LayoutFile> addLayoutFiles(Content parent, List<TskFileRange> fileRanges) throws TskCoreException {
        assert (null != fileRanges);
        if (null == fileRanges) {
            throw new TskCoreException("TskFileRange object is null");
        }
        assert (null != parent);
        if (null == parent) {
            throw new TskCoreException("Conent is null");
        }
        CaseDbTransaction transaction = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            transaction = this.beginTransaction();
            transaction.acquireSingleUserCaseWriteLock();
            CaseDbConnection connection = transaction.getConnection();
            ArrayList<LayoutFile> fileRangeLayoutFiles = new ArrayList<LayoutFile>();
            for (TskFileRange fileRange : fileRanges) {
                long fileRangeId = this.addObject(parent.getId(), TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
                long end_byte_in_parent = fileRange.getByteStart() + fileRange.getByteLen() - 1L;
                PreparedStatement prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
                prepStmt.clearParameters();
                prepStmt.setLong(1, fileRangeId);
                prepStmt.setNull(2, -5);
                prepStmt.setString(3, "Unalloc_" + parent.getId() + "_" + fileRange.getByteStart() + "_" + end_byte_in_parent);
                prepStmt.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.UNALLOC_BLOCKS.getFileType());
                prepStmt.setNull(5, -5);
                prepStmt.setShort(6, TskData.TSK_FS_NAME_TYPE_ENUM.REG.getValue());
                prepStmt.setShort(7, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG.getValue());
                prepStmt.setShort(8, TskData.TSK_FS_NAME_FLAG_ENUM.UNALLOC.getValue());
                prepStmt.setShort(9, TskData.TSK_FS_META_FLAG_ENUM.UNALLOC.getValue());
                prepStmt.setLong(10, fileRange.getByteLen());
                prepStmt.setNull(11, -5);
                prepStmt.setNull(12, -5);
                prepStmt.setNull(13, -5);
                prepStmt.setNull(14, -5);
                prepStmt.setNull(15, 12);
                prepStmt.setByte(16, TskData.FileKnown.UNKNOWN.getFileKnownValue());
                prepStmt.setNull(17, 12);
                prepStmt.setNull(18, 12);
                prepStmt.setLong(19, parent.getId());
                prepStmt.setString(20, null);
                connection.executeUpdate(prepStmt);
                prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LAYOUT_FILE);
                prepStmt.clearParameters();
                prepStmt.setLong(1, fileRangeId);
                prepStmt.setLong(2, fileRange.getByteStart());
                prepStmt.setLong(3, fileRange.getByteLen());
                prepStmt.setLong(4, fileRange.getSequence());
                connection.executeUpdate(prepStmt);
                fileRangeLayoutFiles.add(new LayoutFile(this, fileRangeId, parent.getId(), Long.toString(fileRange.getSequence()), TskData.TSK_DB_FILES_TYPE_ENUM.UNALLOC_BLOCKS, TskData.TSK_FS_NAME_TYPE_ENUM.REG, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG, TskData.TSK_FS_NAME_FLAG_ENUM.UNALLOC, TskData.TSK_FS_META_FLAG_ENUM.UNALLOC.getValue(), fileRange.getByteLen(), 0L, 0L, 0L, 0L, null, TskData.FileKnown.UNKNOWN, parent.getUniquePath(), null));
            }
            transaction.commit();
            transaction = null;
            ArrayList<LayoutFile> arrayList = fileRangeLayoutFiles;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to add layout files to case database", ex);
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            if (null != transaction) {
                try {
                    transaction.rollback();
                }
                catch (TskCoreException ex2) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
            }
        }
    }

    public final List<LayoutFile> addCarvedFiles(CarvingResult carvingResult) throws TskCoreException {
        assert (null != carvingResult);
        if (null == carvingResult) {
            throw new TskCoreException("Carving is null");
        }
        assert (null != carvingResult.getParent());
        if (null == carvingResult.getParent()) {
            throw new TskCoreException("Carving result has null parent");
        }
        assert (null != carvingResult.getCarvedFiles());
        if (null == carvingResult.getCarvedFiles()) {
            throw new TskCoreException("Carving result has null carved files");
        }
        CaseDbTransaction transaction = null;
        Statement statement = null;
        ResultSet resultSet = null;
        long newCacheKey = 0L;
        try {
            VirtualDirectory carvedFilesDir;
            Content root;
            transaction = this.beginTransaction();
            transaction.acquireSingleUserCaseWriteLock();
            CaseDbConnection connection = transaction.getConnection();
            for (root = carvingResult.getParent(); !(null == root || root instanceof FileSystem || root instanceof Volume || root instanceof Image); root = root.getParent()) {
            }
            if (null == root) {
                root = carvingResult.getParent();
            }
            if (null == (carvedFilesDir = this.rootIdsToCarvedFileDirs.get(root.getId()))) {
                List<Content> rootChildren = root instanceof FileSystem ? ((FileSystem)root).getRootDirectory().getChildren() : root.getChildren();
                for (Content child : rootChildren) {
                    if (!(child instanceof VirtualDirectory) || !child.getName().equals("$CarvedFiles")) continue;
                    carvedFilesDir = (VirtualDirectory)child;
                    break;
                }
                if (null == carvedFilesDir) {
                    long parId = root.getId();
                    if (root instanceof FileSystem) {
                        Directory rootDir = ((FileSystem)root).getRootDirectory();
                        parId = rootDir.getId();
                    }
                    carvedFilesDir = this.addVirtualDirectory(parId, "$CarvedFiles", transaction);
                }
                newCacheKey = root.getId();
                this.rootIdsToCarvedFileDirs.put(newCacheKey, carvedFilesDir);
            }
            String parentPath = this.getFileParentPath(carvedFilesDir.getId(), connection) + carvedFilesDir.getName() + "/";
            ArrayList<LayoutFile> carvedFiles = new ArrayList<LayoutFile>();
            for (CarvingResult.CarvedFile carvedFile : carvingResult.getCarvedFiles()) {
                long carvedFileId = this.addObject(carvedFilesDir.getId(), TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
                PreparedStatement prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
                prepStmt.clearParameters();
                prepStmt.setLong(1, carvedFileId);
                if (root instanceof FileSystem) {
                    prepStmt.setLong(2, root.getId());
                } else {
                    prepStmt.setNull(2, -5);
                }
                prepStmt.setString(3, carvedFile.getName());
                prepStmt.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.CARVED.getFileType());
                prepStmt.setShort(5, (short)1);
                prepStmt.setShort(6, TskData.TSK_FS_NAME_TYPE_ENUM.REG.getValue());
                prepStmt.setShort(7, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG.getValue());
                prepStmt.setShort(8, TskData.TSK_FS_NAME_FLAG_ENUM.UNALLOC.getValue());
                prepStmt.setShort(9, TskData.TSK_FS_META_FLAG_ENUM.UNALLOC.getValue());
                prepStmt.setLong(10, carvedFile.getSizeInBytes());
                prepStmt.setNull(11, -5);
                prepStmt.setNull(12, -5);
                prepStmt.setNull(13, -5);
                prepStmt.setNull(14, -5);
                prepStmt.setNull(15, 12);
                prepStmt.setByte(16, TskData.FileKnown.UNKNOWN.getFileKnownValue());
                prepStmt.setNull(17, 12);
                prepStmt.setString(18, parentPath);
                prepStmt.setLong(19, carvedFilesDir.getDataSourceObjectId());
                prepStmt.setString(20, SleuthkitCase.extractExtension(carvedFile.getName()));
                connection.executeUpdate(prepStmt);
                prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LAYOUT_FILE);
                for (TskFileRange tskFileRange : carvedFile.getLayoutInParent()) {
                    prepStmt.clearParameters();
                    prepStmt.setLong(1, carvedFileId);
                    prepStmt.setLong(2, tskFileRange.getByteStart());
                    prepStmt.setLong(3, tskFileRange.getByteLen());
                    prepStmt.setLong(4, tskFileRange.getSequence());
                    connection.executeUpdate(prepStmt);
                }
                carvedFiles.add(new LayoutFile(this, carvedFileId, carvedFilesDir.getDataSourceObjectId(), carvedFile.getName(), TskData.TSK_DB_FILES_TYPE_ENUM.CARVED, TskData.TSK_FS_NAME_TYPE_ENUM.REG, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG, TskData.TSK_FS_NAME_FLAG_ENUM.UNALLOC, TskData.TSK_FS_META_FLAG_ENUM.UNALLOC.getValue(), carvedFile.getSizeInBytes(), 0L, 0L, 0L, 0L, null, TskData.FileKnown.UNKNOWN, parentPath, null));
            }
            transaction.commit();
            transaction = null;
            ArrayList<LayoutFile> arrayList = carvedFiles;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to add carved files to case database", ex);
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            if (null != transaction) {
                try {
                    transaction.rollback();
                }
                catch (TskCoreException ex2) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
                if (0L != newCacheKey) {
                    this.rootIdsToCarvedFileDirs.remove(newCacheKey);
                }
            }
        }
    }

    public DerivedFile addDerivedFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, Content parentObj, String rederiveDetails, String toolName, String toolVersion, String otherDetails, TskData.EncodingType encodingType) throws TskCoreException {
        localPath = localPath.replaceAll("^[/\\\\]+", "");
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            connection.beginTransaction();
            long parentId = parentObj.getId();
            String parentPath = "";
            if (parentObj instanceof BlackboardArtifact) {
                parentPath = parentObj.getUniquePath() + '/' + parentObj.getName() + '/';
            } else if (parentObj instanceof AbstractFile) {
                parentPath = ((AbstractFile)parentObj).getParentPath() + parentObj.getName() + '/';
            }
            long newObjId = this.addObject(parentId, TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            statement.clearParameters();
            statement.setLong(1, newObjId);
            long fsObjId = this.getFileSystemId(parentId, connection);
            if (fsObjId != -1L) {
                statement.setLong(2, fsObjId);
            } else {
                statement.setNull(2, -5);
            }
            statement.setString(3, fileName);
            statement.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.DERIVED.getFileType());
            statement.setShort(5, (short)1);
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = isFile ? TskData.TSK_FS_NAME_TYPE_ENUM.REG : TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            statement.setShort(6, dirType.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = isFile ? TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG : TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            statement.setShort(7, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            statement.setShort(8, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            statement.setShort(9, metaFlags);
            statement.setLong(10, size);
            statement.setLong(11, ctime);
            statement.setLong(12, crtime);
            statement.setLong(13, atime);
            statement.setLong(14, mtime);
            statement.setNull(15, 12);
            statement.setByte(16, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            statement.setNull(17, 12);
            statement.setString(18, parentPath);
            long dataSourceObjId = this.getDataSourceObjectId(connection, parentId);
            statement.setLong(19, dataSourceObjId);
            String extension = SleuthkitCase.extractExtension(fileName);
            statement.setString(20, extension);
            connection.executeUpdate(statement);
            this.addFilePath(connection, newObjId, localPath, encodingType);
            connection.commitTransaction();
            DerivedFile derivedFile = new DerivedFile(this, newObjId, dataSourceObjId, fileName, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, null, null, parentPath, localPath, parentId, null, encodingType, extension);
            return derivedFile;
        }
        catch (SQLException ex) {
            connection.rollbackTransaction();
            throw new TskCoreException("Failed to add derived file to case database", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public DerivedFile updateDerivedFile(DerivedFile derivedFile, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, String mimeType, String rederiveDetails, String toolName, String toolVersion, String otherDetails, TskData.EncodingType encodingType) throws TskCoreException {
        localPath = localPath.replaceAll("^[/\\\\]+", "");
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        ResultSet rs = null;
        try {
            Content parentObj = derivedFile.getParent();
            connection.beginTransaction();
            long parentId = parentObj.getId();
            String parentPath = "";
            if (parentObj instanceof BlackboardArtifact) {
                parentPath = parentObj.getUniquePath() + '/' + parentObj.getName() + '/';
            } else if (parentObj instanceof AbstractFile) {
                parentPath = ((AbstractFile)parentObj).getParentPath() + parentObj.getName() + '/';
            }
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_DERIVED_FILE);
            statement.clearParameters();
            statement.setShort(1, TskData.TSK_DB_FILES_TYPE_ENUM.DERIVED.getFileType());
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = isFile ? TskData.TSK_FS_NAME_TYPE_ENUM.REG : TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            statement.setShort(2, dirType.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = isFile ? TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG : TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            statement.setShort(3, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            statement.setShort(4, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            statement.setShort(5, metaFlags);
            statement.setLong(6, size);
            statement.setLong(7, ctime);
            statement.setLong(8, crtime);
            statement.setLong(9, atime);
            statement.setLong(10, mtime);
            statement.setString(11, mimeType);
            statement.setString(12, String.valueOf(derivedFile.getId()));
            connection.executeUpdate(statement);
            this.updateFilePath(connection, derivedFile.getId(), localPath, encodingType);
            connection.commitTransaction();
            long dataSourceObjId = this.getDataSourceObjectId(connection, parentId);
            String extension = SleuthkitCase.extractExtension(derivedFile.getName());
            DerivedFile derivedFile2 = new DerivedFile(this, derivedFile.getId(), dataSourceObjId, derivedFile.getName(), dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, null, null, parentPath, localPath, parentId, null, encodingType, extension);
            return derivedFile2;
        }
        catch (SQLException ex) {
            connection.rollbackTransaction();
            throw new TskCoreException("Failed to add derived file to case database", ex);
        }
        finally {
            SleuthkitCase.closeResultSet(rs);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, TskData.EncodingType encodingType, AbstractFile parent) throws TskCoreException {
        CaseDbTransaction localTrans = this.beginTransaction();
        try {
            LocalFile created = this.addLocalFile(fileName, localPath, size, ctime, crtime, atime, mtime, isFile, encodingType, parent, localTrans);
            localTrans.commit();
            localTrans = null;
            LocalFile localFile = created;
            return localFile;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex2) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
            }
        }
    }

    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, TskData.EncodingType encodingType, Content parent, CaseDbTransaction transaction) throws TskCoreException {
        return this.addLocalFile(fileName, localPath, size, ctime, crtime, atime, mtime, null, null, null, isFile, encodingType, parent, transaction);
    }

    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, String md5, TskData.FileKnown known, String mimeType, boolean isFile, TskData.EncodingType encodingType, Content parent, CaseDbTransaction transaction) throws TskCoreException {
        CaseDbConnection connection = transaction.getConnection();
        transaction.acquireSingleUserCaseWriteLock();
        Statement queryStatement = null;
        try {
            long objectId = this.addObject(parent.getId(), TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            statement.clearParameters();
            statement.setLong(1, objectId);
            statement.setNull(2, -5);
            statement.setString(3, fileName);
            statement.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.LOCAL.getFileType());
            statement.setShort(5, (short)1);
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = isFile ? TskData.TSK_FS_NAME_TYPE_ENUM.REG : TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            statement.setShort(6, dirType.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = isFile ? TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG : TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            statement.setShort(7, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            statement.setShort(8, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            statement.setShort(9, metaFlags);
            statement.setLong(10, size);
            statement.setLong(11, ctime);
            statement.setLong(12, crtime);
            statement.setLong(13, atime);
            statement.setLong(14, mtime);
            statement.setString(15, md5);
            if (known != null) {
                statement.setByte(16, known.getFileKnownValue());
            } else {
                statement.setByte(16, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            }
            statement.setString(17, mimeType);
            String parentPath = parent instanceof AbstractFile ? (this.isRootDirectory((AbstractFile)parent, transaction) ? "/" : ((AbstractFile)parent).getParentPath() + parent.getName() + "/") : "/";
            statement.setString(18, parentPath);
            long dataSourceObjId = this.getDataSourceObjectId(connection, parent.getId());
            statement.setLong(19, dataSourceObjId);
            String extension = SleuthkitCase.extractExtension(fileName);
            statement.setString(20, extension);
            connection.executeUpdate(statement);
            this.addFilePath(connection, objectId, localPath, encodingType);
            LocalFile localFile = new LocalFile(this, objectId, fileName, TskData.TSK_DB_FILES_TYPE_ENUM.LOCAL, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, mimeType, md5, known, parent.getId(), parentPath, dataSourceObjId, localPath, encodingType, extension);
            return localFile;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Failed to INSERT local file %s (%s) with parent id %d in tsk_files table", fileName, localPath, parent.getId()), ex);
        }
        finally {
            SleuthkitCase.closeStatement(queryStatement);
        }
    }

    private boolean isRootDirectory(AbstractFile file, CaseDbTransaction transaction) throws TskCoreException {
        boolean bl;
        ResultSet resultSet;
        Statement statement;
        block6: {
            block7: {
                CaseDbConnection connection = transaction.getConnection();
                transaction.acquireSingleUserCaseWriteLock();
                statement = null;
                resultSet = null;
                String query = String.format("SELECT ParentRow.type AS parent_type, ParentRow.obj_id AS parent_object_id FROM tsk_objects ParentRow JOIN tsk_objects ChildRow ON ChildRow.par_obj_id = ParentRow.obj_id WHERE ChildRow.obj_id = %s;", file.getId());
                statement = connection.createStatement();
                resultSet = statement.executeQuery(query);
                if (!resultSet.next()) break block6;
                long parentId = resultSet.getLong("parent_object_id");
                if (parentId != 0L) break block7;
                boolean bl2 = true;
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                return bl2;
            }
            int type = resultSet.getInt("parent_type");
            boolean bl3 = type == TskData.ObjectType.IMG.getObjectType() || type == TskData.ObjectType.VS.getObjectType() || type == TskData.ObjectType.VOL.getObjectType() || type == TskData.ObjectType.FS.getObjectType();
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            return bl3;
        }
        try {
            bl = true;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("Failed to lookup parent of file (%s) with id %d", file.getName(), file.getId()), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        return bl;
    }

    public LayoutFile addLayoutFile(String fileName, long size, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, TskData.TSK_FS_META_FLAG_ENUM metaFlag, long ctime, long crtime, long atime, long mtime, List<TskFileRange> fileRanges, Content parent) throws TskCoreException {
        if (null == parent) {
            throw new TskCoreException("Parent can not be null");
        }
        String parentPath = parent instanceof AbstractFile ? ((AbstractFile)parent).getParentPath() + parent.getName() + '/' : "/";
        CaseDbTransaction transaction = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            transaction = this.beginTransaction();
            transaction.acquireSingleUserCaseWriteLock();
            CaseDbConnection connection = transaction.getConnection();
            long newFileId = this.addObject(parent.getId(), TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            PreparedStatement prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            prepStmt.clearParameters();
            prepStmt.setLong(1, newFileId);
            if (0L != parent.getId()) {
                long parentFs = this.getFileSystemId(parent.getId(), connection);
                if (parentFs != -1L) {
                    prepStmt.setLong(2, parentFs);
                } else {
                    prepStmt.setNull(2, -5);
                }
            } else {
                prepStmt.setNull(2, -5);
            }
            prepStmt.setString(3, fileName);
            prepStmt.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.LAYOUT_FILE.getFileType());
            prepStmt.setShort(5, (short)0);
            prepStmt.setShort(6, TskData.TSK_FS_NAME_TYPE_ENUM.REG.getValue());
            prepStmt.setShort(7, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG.getValue());
            prepStmt.setShort(8, dirFlag.getValue());
            prepStmt.setShort(9, metaFlag.getValue());
            prepStmt.setLong(10, size);
            prepStmt.setLong(11, ctime);
            prepStmt.setLong(12, crtime);
            prepStmt.setLong(13, atime);
            prepStmt.setLong(14, mtime);
            prepStmt.setNull(15, 12);
            prepStmt.setByte(16, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            prepStmt.setNull(17, 12);
            prepStmt.setString(18, parentPath);
            prepStmt.setLong(19, parent.getDataSource().getId());
            prepStmt.setString(20, SleuthkitCase.extractExtension(fileName));
            connection.executeUpdate(prepStmt);
            prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LAYOUT_FILE);
            for (TskFileRange tskFileRange : fileRanges) {
                prepStmt.clearParameters();
                prepStmt.setLong(1, newFileId);
                prepStmt.setLong(2, tskFileRange.getByteStart());
                prepStmt.setLong(3, tskFileRange.getByteLen());
                prepStmt.setLong(4, tskFileRange.getSequence());
                connection.executeUpdate(prepStmt);
            }
            LayoutFile layoutFile = new LayoutFile(this, newFileId, parent.getDataSource().getId(), fileName, TskData.TSK_DB_FILES_TYPE_ENUM.LAYOUT_FILE, TskData.TSK_FS_NAME_TYPE_ENUM.REG, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG, dirFlag, metaFlag.getValue(), size, ctime, crtime, atime, mtime, null, TskData.FileKnown.UNKNOWN, parentPath, null);
            transaction.commit();
            transaction = null;
            LayoutFile layoutFile2 = layoutFile;
            return layoutFile2;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to add layout file " + fileName + " to case database", ex);
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            if (null != transaction) {
                try {
                    transaction.rollback();
                }
                catch (TskCoreException ex2) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
            }
        }
    }

    private long getDataSourceObjectId(CaseDbConnection connection, long objectId) throws TskCoreException {
        long l;
        this.acquireSingleUserCaseReadLock();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            long dataSourceObjId;
            statement = connection.createStatement();
            long ancestorId = objectId;
            do {
                dataSourceObjId = ancestorId;
                String query = String.format("SELECT par_obj_id FROM tsk_objects WHERE obj_id = %s;", ancestorId);
                resultSet = statement.executeQuery(query);
                if (!resultSet.next()) {
                    throw new TskCoreException(String.format("tsk_objects table is corrupt, SQL query returned no result: %s", query));
                }
                ancestorId = resultSet.getLong("par_obj_id");
                resultSet.close();
                resultSet = null;
            } while (0L != ancestorId);
            l = dataSourceObjId;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("Error finding root data source for object (obj_id = %d)", objectId), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    private void addFilePath(CaseDbConnection connection, long objId, String path, TskData.EncodingType type) throws SQLException {
        PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LOCAL_PATH);
        statement.clearParameters();
        statement.setLong(1, objId);
        statement.setString(2, path);
        statement.setInt(3, type.getType());
        connection.executeUpdate(statement);
    }

    private void updateFilePath(CaseDbConnection connection, long objId, String path, TskData.EncodingType type) throws SQLException {
        PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_LOCAL_PATH);
        statement.clearParameters();
        statement.setString(1, path);
        statement.setInt(2, type.getType());
        statement.setLong(3, objId);
        connection.executeUpdate(statement);
    }

    public List<AbstractFile> findFiles(Content dataSource, String fileName, AbstractFile parentFile) throws TskCoreException {
        return this.findFiles(dataSource, fileName, parentFile.getName());
    }

    public long countFilesWhere(String sqlWhereClause) throws TskCoreException {
        long l;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT COUNT(*) AS count FROM tsk_files WHERE " + sqlWhereClause);
            rs.next();
            l = rs.getLong("count");
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("SQLException thrown when calling 'SleuthkitCase.countFilesWhere().", e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    public List<AbstractFile> findAllFilesWhere(String sqlWhereClause) throws TskCoreException {
        List<AbstractFile> list;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_files WHERE " + sqlWhereClause);
            list = this.resultSetToAbstractFiles(rs, connection);
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("SQLException thrown when calling 'SleuthkitCase.findAllFilesWhere(): " + sqlWhereClause, e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return list;
    }

    public List<Long> findAllFileIdsWhere(String sqlWhereClause) throws TskCoreException {
        ArrayList<Long> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT obj_id FROM tsk_files WHERE " + sqlWhereClause);
            ArrayList<Long> ret = new ArrayList<Long>();
            while (rs.next()) {
                ret.add(rs.getLong("obj_id"));
            }
            arrayList = ret;
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("SQLException thrown when calling 'SleuthkitCase.findAllFileIdsWhere(): " + sqlWhereClause, e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<AbstractFile> openFiles(Content dataSource, String filePath) throws TskCoreException {
        String path = AbstractFile.createNonUniquePath(filePath).toLowerCase();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == path.length()) {
            path = path.substring(0, lastSlash - 1);
            lastSlash = path.lastIndexOf(47);
        }
        String parentPath = path.substring(0, lastSlash);
        String fileName = path.substring(lastSlash);
        return this.findFiles(dataSource, fileName, parentPath);
    }

    public List<TskFileRange> getFileRanges(long id) throws TskCoreException {
        ArrayList<TskFileRange> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_file_layout WHERE obj_id = " + id + " ORDER BY sequence");
            ArrayList<TskFileRange> ranges = new ArrayList<TskFileRange>();
            while (rs.next()) {
                TskFileRange range = new TskFileRange(rs.getLong("byte_start"), rs.getLong("byte_len"), rs.getLong("sequence"));
                ranges.add(range);
            }
            arrayList = ranges;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting TskFileLayoutRanges by id, id = " + id, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public Image getImageById(long id) throws TskCoreException {
        ResultSet rs2;
        Statement s2;
        ResultSet rs1;
        Statement s1;
        CaseDbConnection connection;
        block9: {
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            s1 = null;
            rs1 = null;
            s2 = null;
            rs2 = null;
            s1 = connection.createStatement();
            rs1 = connection.executeQuery(s1, "SELECT tsk_image_info.type, tsk_image_info.ssize, tsk_image_info.tzone, tsk_image_info.size, tsk_image_info.md5, tsk_image_info.sha1, tsk_image_info.sha256, tsk_image_info.display_name, data_source_info.device_id FROM tsk_image_info INNER JOIN data_source_info ON tsk_image_info.obj_id = data_source_info.obj_id WHERE tsk_image_info.obj_id = " + id);
            if (!rs1.next()) break block9;
            s2 = connection.createStatement();
            rs2 = connection.executeQuery(s2, "SELECT name FROM tsk_image_names WHERE tsk_image_names.obj_id = " + id);
            ArrayList<String> imagePaths = new ArrayList<String>();
            while (rs2.next()) {
                imagePaths.add(rs2.getString("name"));
            }
            long type = rs1.getLong("type");
            long ssize = rs1.getLong("ssize");
            String tzone = rs1.getString("tzone");
            long size = rs1.getLong("size");
            String md5 = rs1.getString("md5");
            String sha1 = rs1.getString("sha1");
            String sha256 = rs1.getString("sha256");
            String name = rs1.getString("display_name");
            if (name == null) {
                if (imagePaths.size() > 0) {
                    String path = (String)imagePaths.get(0);
                    name = new java.io.File(path).getName();
                } else {
                    name = "";
                }
            }
            String device_id = rs1.getString("device_id");
            Image image = new Image(this, id, type, device_id, ssize, name, imagePaths.toArray(new String[imagePaths.size()]), tzone, md5, sha1, sha256, size);
            SleuthkitCase.closeResultSet(rs2);
            SleuthkitCase.closeStatement(s2);
            SleuthkitCase.closeResultSet(rs1);
            SleuthkitCase.closeStatement(s1);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return image;
        }
        try {
            try {
                throw new TskCoreException("No image found for id: " + id);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting Image by id, id = " + id, ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs2);
            SleuthkitCase.closeStatement(s2);
            SleuthkitCase.closeResultSet(rs1);
            SleuthkitCase.closeStatement(s1);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    VolumeSystem getVolumeSystemById(long id, Image parent) throws TskCoreException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block5: {
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            s = null;
            rs = null;
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_vs_info where obj_id = " + id);
            if (!rs.next()) break block5;
            long type = rs.getLong("vs_type");
            long imgOffset = rs.getLong("img_offset");
            long blockSize = rs.getLong("block_size");
            VolumeSystem vs = new VolumeSystem(this, id, "", type, imgOffset, blockSize);
            vs.setParent(parent);
            VolumeSystem volumeSystem = vs;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return volumeSystem;
        }
        try {
            try {
                throw new TskCoreException("No volume system found for id:" + id);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting Volume System by ID.", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    VolumeSystem getVolumeSystemById(long id, long parentId) throws TskCoreException {
        VolumeSystem vs = this.getVolumeSystemById(id, null);
        vs.setParentId(parentId);
        return vs;
    }

    FileSystem getFileSystemById(long id, Image parent) throws TskCoreException {
        return this.getFileSystemByIdHelper(id, parent);
    }

    FileSystem getFileSystemById(long id, long parentId) throws TskCoreException {
        Volume vol = null;
        FileSystem fs = this.getFileSystemById(id, vol);
        fs.setParentId(parentId);
        return fs;
    }

    FileSystem getFileSystemById(long id, Volume parent) throws TskCoreException {
        return this.getFileSystemByIdHelper(id, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getFileSystemByIdHelper(long id, Content parent) throws TskCoreException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block12: {
            Map<Long, FileSystem> map = this.fileSystemIdMap;
            synchronized (map) {
                if (this.fileSystemIdMap.containsKey(id)) {
                    return this.fileSystemIdMap.get(id);
                }
            }
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            s = null;
            rs = null;
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_fs_info where obj_id = " + id);
            if (!rs.next()) break block12;
            TskData.TSK_FS_TYPE_ENUM fsType = TskData.TSK_FS_TYPE_ENUM.valueOf(rs.getInt("fs_type"));
            FileSystem fs = new FileSystem(this, rs.getLong("obj_id"), "", rs.getLong("img_offset"), fsType, rs.getLong("block_size"), rs.getLong("block_count"), rs.getLong("root_inum"), rs.getLong("first_inum"), rs.getLong("last_inum"));
            fs.setParent(parent);
            Object object = this.fileSystemIdMap;
            synchronized (object) {
                this.fileSystemIdMap.put(id, fs);
            }
            object = fs;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return object;
        }
        try {
            try {
                throw new TskCoreException("No file system found for id:" + id);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting File System by ID", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    Volume getVolumeById(long id, VolumeSystem parent) throws TskCoreException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block7: {
            String description;
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            s = null;
            rs = null;
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_vs_parts where obj_id = " + id);
            if (!rs.next()) break block7;
            try {
                description = rs.getString("desc");
            }
            catch (Exception ex) {
                description = rs.getString("descr");
            }
            Volume vol = new Volume(this, rs.getLong("obj_id"), rs.getLong("addr"), rs.getLong("start"), rs.getLong("length"), rs.getLong("flags"), description);
            vol.setParent(parent);
            Volume volume = vol;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return volume;
        }
        try {
            try {
                throw new TskCoreException("No volume found for id:" + id);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting Volume by ID", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    Volume getVolumeById(long id, long parentId) throws TskCoreException {
        Volume vol = this.getVolumeById(id, null);
        vol.setParentId(parentId);
        return vol;
    }

    Directory getDirectoryById(long id, FileSystem parentFs) throws TskCoreException {
        Directory directory;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_files WHERE obj_id = " + id);
            Directory temp = null;
            if (rs.next()) {
                short type = rs.getShort("type");
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.FS.getFileType()) {
                    if (rs.getShort("meta_type") == TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR.getValue() || rs.getShort("meta_type") == TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT_DIR.getValue()) {
                        temp = this.directory(rs, parentFs);
                    }
                } else if (type == TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR.getFileType()) {
                    throw new TskCoreException("Expecting an FS-type directory, got virtual, id: " + id);
                }
            } else {
                throw new TskCoreException("No Directory found for id:" + id);
            }
            directory = temp;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting Directory by ID", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileSystem> getFileSystems(Image image) {
        ArrayList<FileSystem> fileSystems;
        block19: {
            CaseDbConnection connection;
            fileSystems = new ArrayList<FileSystem>();
            try {
                connection = this.connections.getConnection();
            }
            catch (TskCoreException ex) {
                logger.log(Level.SEVERE, "Error getting file systems for image " + image.getId(), ex);
                return fileSystems;
            }
            this.acquireSingleUserCaseReadLock();
            Statement s = null;
            ResultSet rs = null;
            try {
                s = connection.createStatement();
                ArrayList<FileSystem> allFileSystems = new ArrayList<FileSystem>();
                try {
                    rs = connection.executeQuery(s, "SELECT * FROM tsk_fs_info");
                    while (rs.next()) {
                        TskData.TSK_FS_TYPE_ENUM fsType = TskData.TSK_FS_TYPE_ENUM.valueOf(rs.getInt("fs_type"));
                        FileSystem fs = new FileSystem(this, rs.getLong("obj_id"), "", rs.getLong("img_offset"), fsType, rs.getLong("block_size"), rs.getLong("block_count"), rs.getLong("root_inum"), rs.getLong("first_inum"), rs.getLong("last_inum"));
                        fs.setParent(null);
                        allFileSystems.add(fs);
                    }
                }
                catch (SQLException ex) {
                    try {
                        logger.log(Level.SEVERE, "There was a problem while trying to obtain all file systems", ex);
                    }
                    catch (Throwable throwable) {
                        SleuthkitCase.closeResultSet(rs);
                        rs = null;
                        throw throwable;
                    }
                    SleuthkitCase.closeResultSet(rs);
                    rs = null;
                }
                SleuthkitCase.closeResultSet(rs);
                rs = null;
                for (FileSystem fs : allFileSystems) {
                    Long imageID = null;
                    Long currentObjID = fs.getId();
                    while (imageID == null) {
                        try {
                            rs = connection.executeQuery(s, "SELECT * FROM tsk_objects WHERE tsk_objects.obj_id = " + currentObjID);
                            rs.next();
                            currentObjID = rs.getLong("par_obj_id");
                            if (rs.getInt("type") != TskData.ObjectType.IMG.getObjectType()) continue;
                            imageID = rs.getLong("obj_id");
                        }
                        catch (SQLException ex) {
                            logger.log(Level.SEVERE, "There was a problem while trying to obtain this image's file systems", ex);
                        }
                        finally {
                            SleuthkitCase.closeResultSet(rs);
                            rs = null;
                        }
                    }
                    if (imageID.longValue() != image.getId()) continue;
                    fileSystems.add(fs);
                }
                SleuthkitCase.closeResultSet(rs);
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, "Error getting case database connection", ex);
                break block19;
            }
            finally {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
            }
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
        }
        return fileSystems;
    }

    List<Content> getImageChildren(Image img) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(img);
        ArrayList<Content> children = new ArrayList<Content>();
        block7: for (ObjectInfo info : childInfos) {
            if (null == info.type) continue;
            switch (info.type) {
                case VS: {
                    children.add(this.getVolumeSystemById(info.id, img));
                    continue block7;
                }
                case FS: {
                    children.add(this.getFileSystemById(info.id, img));
                    continue block7;
                }
                case ABSTRACTFILE: {
                    AbstractFile f = this.getAbstractFileById(info.id);
                    if (f == null) continue block7;
                    children.add(f);
                    continue block7;
                }
                case ARTIFACT: {
                    BlackboardArtifact art = this.getArtifactById(info.id);
                    if (art == null) continue block7;
                    children.add(art);
                    continue block7;
                }
                case REPORT: {
                    continue block7;
                }
            }
            throw new TskCoreException("Image has child of invalid type: " + (Object)((Object)info.type));
        }
        return children;
    }

    List<Long> getImageChildrenIds(Image img) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(img);
        ArrayList<Long> children = new ArrayList<Long>();
        for (ObjectInfo info : childInfos) {
            if (info.type == TskData.ObjectType.VS || info.type == TskData.ObjectType.FS || info.type == TskData.ObjectType.ABSTRACTFILE || info.type == TskData.ObjectType.ARTIFACT) {
                children.add(info.id);
                continue;
            }
            if (info.type == TskData.ObjectType.REPORT) continue;
            throw new TskCoreException("Image has child of invalid type: " + (Object)((Object)info.type));
        }
        return children;
    }

    List<Content> getVolumeSystemChildren(VolumeSystem vs) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(vs);
        ArrayList<Content> children = new ArrayList<Content>();
        block5: for (ObjectInfo info : childInfos) {
            if (null == info.type) continue;
            switch (info.type) {
                case VOL: {
                    children.add(this.getVolumeById(info.id, vs));
                    continue block5;
                }
                case ABSTRACTFILE: {
                    AbstractFile f = this.getAbstractFileById(info.id);
                    if (f == null) continue block5;
                    children.add(f);
                    continue block5;
                }
                case ARTIFACT: {
                    BlackboardArtifact art = this.getArtifactById(info.id);
                    if (art == null) continue block5;
                    children.add(art);
                    continue block5;
                }
            }
            throw new TskCoreException("VolumeSystem has child of invalid type: " + (Object)((Object)info.type));
        }
        return children;
    }

    List<Long> getVolumeSystemChildrenIds(VolumeSystem vs) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(vs);
        ArrayList<Long> children = new ArrayList<Long>();
        for (ObjectInfo info : childInfos) {
            if (info.type == TskData.ObjectType.VOL || info.type == TskData.ObjectType.ABSTRACTFILE || info.type == TskData.ObjectType.ARTIFACT) {
                children.add(info.id);
                continue;
            }
            throw new TskCoreException("VolumeSystem has child of invalid type: " + (Object)((Object)info.type));
        }
        return children;
    }

    List<Content> getVolumeChildren(Volume vol) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(vol);
        ArrayList<Content> children = new ArrayList<Content>();
        block5: for (ObjectInfo info : childInfos) {
            if (null == info.type) continue;
            switch (info.type) {
                case FS: {
                    children.add(this.getFileSystemById(info.id, vol));
                    continue block5;
                }
                case ABSTRACTFILE: {
                    AbstractFile f = this.getAbstractFileById(info.id);
                    if (f == null) continue block5;
                    children.add(f);
                    continue block5;
                }
                case ARTIFACT: {
                    BlackboardArtifact art = this.getArtifactById(info.id);
                    if (art == null) continue block5;
                    children.add(art);
                    continue block5;
                }
            }
            throw new TskCoreException("Volume has child of invalid type: " + (Object)((Object)info.type));
        }
        return children;
    }

    List<Long> getVolumeChildrenIds(Volume vol) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(vol);
        ArrayList<Long> children = new ArrayList<Long>();
        for (ObjectInfo info : childInfos) {
            if (info.type == TskData.ObjectType.FS || info.type == TskData.ObjectType.ABSTRACTFILE || info.type == TskData.ObjectType.ARTIFACT) {
                children.add(info.id);
                continue;
            }
            throw new TskCoreException("Volume has child of invalid type: " + (Object)((Object)info.type));
        }
        return children;
    }

    public Image addImageInfo(long deviceObjId, List<String> imageFilePaths, String timeZone) throws TskCoreException {
        long imageId = this.caseHandle.addImageInfo(deviceObjId, imageFilePaths, timeZone, this);
        return this.getImageById(imageId);
    }

    public Map<Long, List<String>> getImagePaths() throws TskCoreException {
        LinkedHashMap<Long, List<String>> linkedHashMap;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s1 = null;
        Statement s2 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            s1 = connection.createStatement();
            rs1 = connection.executeQuery(s1, "SELECT obj_id FROM tsk_image_info");
            s2 = connection.createStatement();
            LinkedHashMap<Long, List<String>> imgPaths = new LinkedHashMap<Long, List<String>>();
            while (rs1.next()) {
                long obj_id = rs1.getLong("obj_id");
                rs2 = connection.executeQuery(s2, "SELECT * FROM tsk_image_names WHERE obj_id = " + obj_id);
                ArrayList<String> paths = new ArrayList<String>();
                while (rs2.next()) {
                    paths.add(rs2.getString("name"));
                }
                rs2.close();
                rs2 = null;
                imgPaths.put(obj_id, paths);
            }
            linkedHashMap = imgPaths;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting image paths.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs2);
                SleuthkitCase.closeStatement(s2);
                SleuthkitCase.closeResultSet(rs1);
                SleuthkitCase.closeStatement(s1);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs2);
        SleuthkitCase.closeStatement(s2);
        SleuthkitCase.closeResultSet(rs1);
        SleuthkitCase.closeStatement(s1);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return linkedHashMap;
    }

    private List<String> getImagePathsById(long objectId) throws TskCoreException {
        ArrayList<String> imagePaths = new ArrayList<String>();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT name FROM tsk_image_names WHERE tsk_image_names.obj_id = " + objectId);
            while (resultSet.next()) {
                imagePaths.add(resultSet.getString("name"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("Error getting image names with obj_id = %d", objectId), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return imagePaths;
    }

    public List<Image> getImages() throws TskCoreException {
        Object object;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT obj_id FROM tsk_image_info");
            ArrayList<Long> imageIDs = new ArrayList<Long>();
            while (rs.next()) {
                imageIDs.add(rs.getLong("obj_id"));
            }
            ArrayList<Image> images = new ArrayList<Image>();
            object = imageIDs.iterator();
            while (object.hasNext()) {
                long id = (Long)object.next();
                images.add(this.getImageById(id));
            }
            object = images;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error retrieving images.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return object;
    }

    public void setImagePaths(long obj_id, List<String> paths) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        PreparedStatement statement = null;
        try {
            connection.beginTransaction();
            statement = connection.getPreparedStatement(PREPARED_STATEMENT.DELETE_IMAGE_NAME);
            statement.clearParameters();
            statement.setLong(1, obj_id);
            connection.executeUpdate(statement);
            for (int i = 0; i < paths.size(); ++i) {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_IMAGE_NAME);
                statement.clearParameters();
                statement.setLong(1, obj_id);
                statement.setString(2, paths.get(i));
                statement.setLong(3, i);
                connection.executeUpdate(statement);
            }
            connection.commitTransaction();
        }
        catch (SQLException ex) {
            connection.rollbackTransaction();
            throw new TskCoreException("Error updating image paths.", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    private List<AbstractFile> resultSetToAbstractFiles(ResultSet rs, CaseDbConnection connection) throws SQLException {
        ArrayList<AbstractFile> results = new ArrayList<AbstractFile>();
        try {
            while (rs.next()) {
                short type = rs.getShort("type");
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.FS.getFileType() && rs.getShort("meta_type") != TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT_DIR.getValue()) {
                    FsContent result = rs.getShort("meta_type") == TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR.getValue() ? this.directory(rs, null) : this.file(rs, null);
                    results.add(result);
                    continue;
                }
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR.getFileType() || rs.getShort("meta_type") == TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT_DIR.getValue()) {
                    VirtualDirectory virtDir = this.virtualDirectory(rs, connection);
                    results.add(virtDir);
                    continue;
                }
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.LOCAL_DIR.getFileType()) {
                    LocalDirectory localDir = this.localDirectory(rs);
                    results.add(localDir);
                    continue;
                }
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.UNALLOC_BLOCKS.getFileType() || type == TskData.TSK_DB_FILES_TYPE_ENUM.UNUSED_BLOCKS.getFileType() || type == TskData.TSK_DB_FILES_TYPE_ENUM.CARVED.getFileType() || type == TskData.TSK_DB_FILES_TYPE_ENUM.LAYOUT_FILE.getFileType()) {
                    TskData.TSK_DB_FILES_TYPE_ENUM atype = TskData.TSK_DB_FILES_TYPE_ENUM.valueOf(type);
                    String parentPath = rs.getString("parent_path");
                    if (parentPath == null) {
                        parentPath = "/";
                    }
                    LayoutFile lf = new LayoutFile(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getString("name"), atype, TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), rs.getString("md5"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath, rs.getString("mime_type"));
                    results.add(lf);
                    continue;
                }
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.DERIVED.getFileType()) {
                    DerivedFile df = this.derivedFile(rs, connection, -1L);
                    results.add(df);
                    continue;
                }
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.LOCAL.getFileType()) {
                    LocalFile lf = this.localFile(rs, connection, -1L);
                    results.add(lf);
                    continue;
                }
                if (type != TskData.TSK_DB_FILES_TYPE_ENUM.SLACK.getFileType()) continue;
                SlackFile sf = this.slackFile(rs, null);
                results.add(sf);
            }
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Error getting abstract files from result set", e);
        }
        return results;
    }

    File file(ResultSet rs, FileSystem fs) throws SQLException {
        File f = new File(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getLong("fs_obj_id"), TskData.TSK_FS_ATTR_TYPE_ENUM.valueOf(rs.getShort("attr_type")), rs.getInt("attr_id"), rs.getString("name"), rs.getLong("meta_addr"), rs.getInt("meta_seq"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), (short)rs.getInt("mode"), rs.getInt("uid"), rs.getInt("gid"), rs.getString("md5"), TskData.FileKnown.valueOf(rs.getByte("known")), rs.getString("parent_path"), rs.getString("mime_type"), rs.getString("extension"));
        f.setFileSystem(fs);
        return f;
    }

    Directory directory(ResultSet rs, FileSystem fs) throws SQLException {
        Directory dir = new Directory(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getLong("fs_obj_id"), TskData.TSK_FS_ATTR_TYPE_ENUM.valueOf(rs.getShort("attr_type")), rs.getInt("attr_id"), rs.getString("name"), rs.getLong("meta_addr"), rs.getInt("meta_seq"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), rs.getShort("mode"), rs.getInt("uid"), rs.getInt("gid"), rs.getString("md5"), TskData.FileKnown.valueOf(rs.getByte("known")), rs.getString("parent_path"));
        dir.setFileSystem(fs);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtualDirectory virtualDirectory(ResultSet rs, CaseDbConnection connection) throws SQLException {
        long dsObjId;
        long objId;
        String parentPath;
        block6: {
            ResultSet rsDataSourceInfo;
            Statement s;
            String timeZone;
            String deviceId;
            block5: {
                parentPath = rs.getString("parent_path");
                if (parentPath == null) {
                    parentPath = "";
                }
                if ((objId = rs.getLong("obj_id")) != (dsObjId = rs.getLong("data_source_obj_id"))) break block6;
                deviceId = "";
                timeZone = "";
                s = null;
                rsDataSourceInfo = null;
                this.acquireSingleUserCaseReadLock();
                try {
                    s = connection.createStatement();
                    rsDataSourceInfo = connection.executeQuery(s, "SELECT device_id, time_zone FROM data_source_info WHERE obj_id = " + objId);
                    if (!rsDataSourceInfo.next()) break block5;
                    deviceId = rsDataSourceInfo.getString("device_id");
                    timeZone = rsDataSourceInfo.getString("time_zone");
                }
                catch (SQLException ex) {
                    try {
                        logger.log(Level.SEVERE, "Error data source info for datasource id " + objId, ex);
                    }
                    catch (Throwable throwable) {
                        SleuthkitCase.closeResultSet(rsDataSourceInfo);
                        SleuthkitCase.closeStatement(s);
                        this.releaseSingleUserCaseReadLock();
                        throw throwable;
                    }
                    SleuthkitCase.closeResultSet(rsDataSourceInfo);
                    SleuthkitCase.closeStatement(s);
                    this.releaseSingleUserCaseReadLock();
                }
            }
            SleuthkitCase.closeResultSet(rsDataSourceInfo);
            SleuthkitCase.closeStatement(s);
            this.releaseSingleUserCaseReadLock();
            return new LocalFilesDataSource(this, objId, dsObjId, deviceId, rs.getString("name"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), timeZone, rs.getString("md5"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath);
        }
        VirtualDirectory vd = new VirtualDirectory(this, objId, dsObjId, rs.getString("name"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getString("md5"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath);
        return vd;
    }

    LocalDirectory localDirectory(ResultSet rs) throws SQLException {
        String parentPath = rs.getString("parent_path");
        if (parentPath == null) {
            parentPath = "";
        }
        LocalDirectory ld = new LocalDirectory(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getString("name"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getString("md5"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath);
        return ld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DerivedFile derivedFile(ResultSet rs, CaseDbConnection connection, long parentId) throws SQLException {
        String parentPath;
        boolean hasLocalPath = rs.getBoolean("has_path");
        long objId = rs.getLong("obj_id");
        String localPath = null;
        TskData.EncodingType encodingType = TskData.EncodingType.NONE;
        if (hasLocalPath) {
            ResultSet rsFilePath;
            block6: {
                rsFilePath = null;
                this.acquireSingleUserCaseReadLock();
                try {
                    PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_LOCAL_PATH_AND_ENCODING_FOR_FILE);
                    statement.clearParameters();
                    statement.setLong(1, objId);
                    rsFilePath = connection.executeQuery(statement);
                    if (!rsFilePath.next()) break block6;
                    localPath = rsFilePath.getString("path");
                    encodingType = TskData.EncodingType.valueOf(rsFilePath.getInt("encoding_type"));
                }
                catch (SQLException ex) {
                    try {
                        logger.log(Level.SEVERE, "Error getting encoding type for file " + objId, ex);
                    }
                    catch (Throwable throwable) {
                        SleuthkitCase.closeResultSet(rsFilePath);
                        this.releaseSingleUserCaseReadLock();
                        throw throwable;
                    }
                    SleuthkitCase.closeResultSet(rsFilePath);
                    this.releaseSingleUserCaseReadLock();
                }
            }
            SleuthkitCase.closeResultSet(rsFilePath);
            this.releaseSingleUserCaseReadLock();
        }
        if ((parentPath = rs.getString("parent_path")) == null) {
            parentPath = "";
        }
        DerivedFile df = new DerivedFile(this, objId, rs.getLong("data_source_obj_id"), rs.getString("name"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), rs.getString("md5"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath, localPath, parentId, rs.getString("mime_type"), encodingType, rs.getString("extension"));
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalFile localFile(ResultSet rs, CaseDbConnection connection, long parentId) throws SQLException {
        String parentPath;
        long objId = rs.getLong("obj_id");
        String localPath = null;
        TskData.EncodingType encodingType = TskData.EncodingType.NONE;
        if (rs.getBoolean("has_path")) {
            ResultSet rsFilePath;
            block6: {
                rsFilePath = null;
                this.acquireSingleUserCaseReadLock();
                try {
                    PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_LOCAL_PATH_AND_ENCODING_FOR_FILE);
                    statement.clearParameters();
                    statement.setLong(1, objId);
                    rsFilePath = connection.executeQuery(statement);
                    if (!rsFilePath.next()) break block6;
                    localPath = rsFilePath.getString("path");
                    encodingType = TskData.EncodingType.valueOf(rsFilePath.getInt("encoding_type"));
                }
                catch (SQLException ex) {
                    try {
                        logger.log(Level.SEVERE, "Error getting encoding type for file " + objId, ex);
                    }
                    catch (Throwable throwable) {
                        SleuthkitCase.closeResultSet(rsFilePath);
                        this.releaseSingleUserCaseReadLock();
                        throw throwable;
                    }
                    SleuthkitCase.closeResultSet(rsFilePath);
                    this.releaseSingleUserCaseReadLock();
                }
            }
            SleuthkitCase.closeResultSet(rsFilePath);
            this.releaseSingleUserCaseReadLock();
        }
        if (null == (parentPath = rs.getString("parent_path"))) {
            parentPath = "";
        }
        LocalFile file = new LocalFile(this, objId, rs.getString("name"), TskData.TSK_DB_FILES_TYPE_ENUM.valueOf(rs.getShort("type")), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), rs.getString("mime_type"), rs.getString("md5"), TskData.FileKnown.valueOf(rs.getByte("known")), parentId, parentPath, rs.getLong("data_source_obj_id"), localPath, encodingType, rs.getString("extension"));
        return file;
    }

    SlackFile slackFile(ResultSet rs, FileSystem fs) throws SQLException {
        SlackFile f = new SlackFile(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getLong("fs_obj_id"), TskData.TSK_FS_ATTR_TYPE_ENUM.valueOf(rs.getShort("attr_type")), rs.getInt("attr_id"), rs.getString("name"), rs.getLong("meta_addr"), rs.getInt("meta_seq"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), (short)rs.getInt("mode"), rs.getInt("uid"), rs.getInt("gid"), rs.getString("md5"), TskData.FileKnown.valueOf(rs.getByte("known")), rs.getString("parent_path"), rs.getString("mime_type"), rs.getString("extension"));
        f.setFileSystem(fs);
        return f;
    }

    List<Content> fileChildren(ResultSet rs, CaseDbConnection connection, long parentId) throws SQLException {
        ArrayList<Content> children = new ArrayList<Content>();
        while (rs.next()) {
            TskData.TSK_DB_FILES_TYPE_ENUM type = TskData.TSK_DB_FILES_TYPE_ENUM.valueOf(rs.getShort("type"));
            if (null == type) continue;
            switch (type) {
                case FS: {
                    if (rs.getShort("meta_type") != TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT_DIR.getValue()) {
                        FsContent result = rs.getShort("meta_type") == TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR.getValue() ? this.directory(rs, null) : this.file(rs, null);
                        children.add(result);
                        break;
                    }
                    VirtualDirectory virtDir = this.virtualDirectory(rs, connection);
                    children.add(virtDir);
                    break;
                }
                case VIRTUAL_DIR: {
                    VirtualDirectory virtDir = this.virtualDirectory(rs, connection);
                    children.add(virtDir);
                    break;
                }
                case LOCAL_DIR: {
                    LocalDirectory localDir = this.localDirectory(rs);
                    children.add(localDir);
                    break;
                }
                case UNALLOC_BLOCKS: 
                case UNUSED_BLOCKS: 
                case CARVED: 
                case LAYOUT_FILE: {
                    String parentPath = rs.getString("parent_path");
                    if (parentPath == null) {
                        parentPath = "";
                    }
                    AbstractFile lf = new LayoutFile(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getString("name"), type, TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), rs.getString("md5"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath, rs.getString("mime_type"));
                    children.add(lf);
                    break;
                }
                case DERIVED: {
                    DerivedFile df = this.derivedFile(rs, connection, parentId);
                    children.add(df);
                    break;
                }
                case LOCAL: {
                    AbstractFile lf = this.localFile(rs, connection, parentId);
                    children.add(lf);
                    break;
                }
                case SLACK: {
                    SlackFile sf = this.slackFile(rs, null);
                    children.add(sf);
                    break;
                }
            }
        }
        return children;
    }

    private List<BlackboardArtifact> resultSetToArtifacts(ResultSet rs) throws SQLException, TskCoreException {
        ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
        try {
            while (rs.next()) {
                BlackboardArtifact.Type artifactType = this.getArtifactType(rs.getInt("artifact_type_id"));
                if (artifactType != null) {
                    artifacts.add(new BlackboardArtifact(this, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), rs.getInt("artifact_type_id"), artifactType.getTypeName(), artifactType.getDisplayName(), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id"))));
                    continue;
                }
                throw new TskCoreException("Error looking up artifact type ID " + rs.getInt("artifact_type_id") + " from artifact " + rs.getLong("artifact_id"));
            }
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Error getting artifacts from result set", e);
        }
        return artifacts;
    }

    public CaseDbQuery executeQuery(String query) throws TskCoreException {
        return new CaseDbQuery(query);
    }

    public CaseDbQuery executeInsertOrUpdate(String query) throws TskCoreException {
        return new CaseDbQuery(query, true);
    }

    CaseDbConnection getConnection() throws TskCoreException {
        return this.connections.getConnection();
    }

    SleuthkitJNI.CaseDbHandle getCaseHandle() {
        return this.caseHandle;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void close() {
        this.acquireSingleUserCaseWriteLock();
        try {
            this.connections.close();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error closing database connection pool.", ex);
        }
        this.fileSystemIdMap.clear();
        try {
            if (this.caseHandle != null) {
                this.caseHandle.free();
                this.caseHandle = null;
            }
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error freeing case handle.", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public boolean setKnown(AbstractFile file, TskData.FileKnown fileKnown) throws TskCoreException {
        long id = file.getId();
        TskData.FileKnown currentKnown = file.getKnown();
        if (currentKnown.compareTo(fileKnown) > 0) {
            return false;
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            connection.executeUpdate(statement, "UPDATE tsk_files SET known='" + fileKnown.getFileKnownValue() + "' WHERE obj_id=" + id);
            file.setKnown(fileKnown);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting Known status.", ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
        return true;
    }

    void setFileName(String name, long objId) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_FILE_NAME);
            preparedStatement.clearParameters();
            preparedStatement.setString(1, name);
            preparedStatement.setLong(2, objId);
            connection.executeUpdate(preparedStatement);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating while the name for object ID %d to %s", objId, name), ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void setImageName(String name, long objId) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_IMAGE_NAME);
            preparedStatement.clearParameters();
            preparedStatement.setString(1, name);
            preparedStatement.setLong(2, objId);
            connection.executeUpdate(preparedStatement);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating while the name for object ID %d to %s", objId, name), ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public void setFileMIMEType(AbstractFile file, String mimeType) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        Statement statement = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            connection.executeUpdate(statement, String.format("UPDATE tsk_files SET mime_type = '%s' WHERE obj_id = %d", mimeType, file.getId()));
            file.setMIMEType(mimeType);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error setting MIME type for file (obj_id = %s)", file.getId()), ex);
        }
        finally {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void setMd5Hash(AbstractFile file, String md5Hash) throws TskCoreException {
        if (md5Hash == null) {
            return;
        }
        long id = file.getId();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_FILE_MD5);
            statement.clearParameters();
            statement.setString(1, md5Hash.toLowerCase());
            statement.setLong(2, id);
            connection.executeUpdate(statement);
            file.setMd5Hash(md5Hash.toLowerCase());
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting MD5 hash", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void setMd5ImageHash(Image img, String md5Hash) throws TskCoreException {
        if (md5Hash == null) {
            return;
        }
        long id = img.getId();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_IMAGE_MD5);
            statement.clearParameters();
            statement.setString(1, md5Hash.toLowerCase());
            statement.setLong(2, id);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting MD5 hash", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    String getMd5ImageHash(Image img) throws TskCoreException {
        String string;
        long id = img.getId();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        String hash = "";
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_IMAGE_MD5);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                hash = rs.getString("md5");
            }
            string = hash;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting MD5 hash", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return string;
    }

    void setSha1ImageHash(Image img, String sha1Hash) throws TskCoreException {
        if (sha1Hash == null) {
            return;
        }
        long id = img.getId();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_IMAGE_SHA1);
            statement.clearParameters();
            statement.setString(1, sha1Hash.toLowerCase());
            statement.setLong(2, id);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting SHA1 hash", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    String getSha1ImageHash(Image img) throws TskCoreException {
        String string;
        long id = img.getId();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        String hash = "";
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_IMAGE_SHA1);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                hash = rs.getString("sha1");
            }
            string = hash;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting SHA1 hash", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return string;
    }

    void setSha256ImageHash(Image img, String sha256Hash) throws TskCoreException {
        if (sha256Hash == null) {
            return;
        }
        long id = img.getId();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_IMAGE_SHA256);
            statement.clearParameters();
            statement.setString(1, sha256Hash.toLowerCase());
            statement.setLong(2, id);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting SHA256 hash", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    String getSha256ImageHash(Image img) throws TskCoreException {
        String string;
        long id = img.getId();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        String hash = "";
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_IMAGE_SHA256);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                hash = rs.getString("sha256");
            }
            string = hash;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error setting SHA256 hash", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return string;
    }

    void setAcquisitionDetails(DataSource datasource, String details) throws TskCoreException {
        long id = datasource.getId();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_ACQUISITION_DETAILS);
            statement.clearParameters();
            statement.setString(1, details);
            statement.setLong(2, id);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting acquisition details", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    String getAcquisitionDetails(DataSource datasource) throws TskCoreException {
        String string;
        long id = datasource.getId();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        String hash = "";
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ACQUISITION_DETAILS);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                hash = rs.getString("acquisition_details");
            }
            string = hash;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error setting acquisition details", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return string;
    }

    public void setReviewStatus(BlackboardArtifact artifact, BlackboardArtifact.ReviewStatus newStatus) throws TskCoreException {
        if (newStatus == null) {
            return;
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            connection.executeUpdate(statement, "UPDATE blackboard_artifacts  SET review_status_id=" + newStatus.getID() + " WHERE blackboard_artifacts.artifact_id = " + artifact.getArtifactID());
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting review status", ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public int countFsContentType(TskData.TSK_FS_META_TYPE_ENUM contentType) throws TskCoreException {
        int n;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            Short contentShort = contentType.getValue();
            rs = connection.executeQuery(s, "SELECT COUNT(*) AS count FROM tsk_files WHERE meta_type = '" + contentShort.toString() + "'");
            int count = 0;
            if (rs.next()) {
                count = rs.getInt("count");
            }
            n = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting number of objects.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return n;
    }

    public static String escapeSingleQuotes(String text) {
        String escapedText = null;
        if (text != null) {
            escapedText = text.replaceAll("'", "''");
        }
        return escapedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractFile> findFilesByMd5(String md5Hash) {
        List<AbstractFile> list;
        CaseDbConnection connection;
        if (md5Hash == null) {
            return Collections.emptyList();
        }
        try {
            connection = this.connections.getConnection();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error finding files by md5 hash " + md5Hash, ex);
            return Collections.emptyList();
        }
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_files WHERE  md5 = '" + md5Hash.toLowerCase() + "' AND size > 0");
            list = this.resultSetToAbstractFiles(rs, connection);
            SleuthkitCase.closeResultSet(rs);
        }
        catch (SQLException ex) {
            logger.log(Level.WARNING, "Error querying database.", ex);
            List<AbstractFile> list2 = Collections.emptyList();
            return list2;
        }
        finally {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
        }
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allFilesMd5Hashed() {
        boolean allFilesAreHashed;
        block8: {
            CaseDbConnection connection;
            try {
                connection = this.connections.getConnection();
            }
            catch (TskCoreException ex) {
                logger.log(Level.SEVERE, "Error checking md5 hashing status", ex);
                return false;
            }
            allFilesAreHashed = false;
            this.acquireSingleUserCaseReadLock();
            Statement s = null;
            ResultSet rs = null;
            try {
                s = connection.createStatement();
                rs = connection.executeQuery(s, "SELECT COUNT(*) AS count FROM tsk_files WHERE dir_type = '" + TskData.TSK_FS_NAME_TYPE_ENUM.REG.getValue() + "' AND md5 IS NULL AND size > '0'");
                if (rs.next() && rs.getInt("count") == 0) {
                    allFilesAreHashed = true;
                }
                SleuthkitCase.closeResultSet(rs);
            }
            catch (SQLException ex) {
                logger.log(Level.WARNING, "Failed to query whether all files have MD5 hashes", ex);
                break block8;
            }
            finally {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
            }
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
        }
        return allFilesAreHashed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countFilesMd5Hashed() {
        ResultSet rs;
        Statement s;
        int count;
        CaseDbConnection connection;
        block6: {
            try {
                connection = this.connections.getConnection();
            }
            catch (TskCoreException ex) {
                logger.log(Level.SEVERE, "Error getting database connection for hashed files count", ex);
                return 0;
            }
            count = 0;
            this.acquireSingleUserCaseReadLock();
            s = null;
            rs = null;
            try {
                s = connection.createStatement();
                rs = connection.executeQuery(s, "SELECT COUNT(*) AS count FROM tsk_files WHERE md5 IS NOT NULL AND size > '0'");
                if (!rs.next()) break block6;
                count = rs.getInt("count");
            }
            catch (SQLException ex) {
                try {
                    logger.log(Level.WARNING, "Failed to query for all the files.", ex);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(rs);
                    SleuthkitCase.closeStatement(s);
                    connection.close();
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return count;
    }

    public List<TagName> getAllTagNames() throws TskCoreException {
        ArrayList<TagName> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_TAG_NAMES);
            resultSet = connection.executeQuery(statement);
            ArrayList<TagName> tagNames = new ArrayList<TagName>();
            while (resultSet.next()) {
                tagNames.add(new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.FileKnown.valueOf(resultSet.getByte("knownStatus"))));
            }
            arrayList = tagNames;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error selecting rows from tag_names table", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<TagName> getTagNamesInUse() throws TskCoreException {
        ArrayList<TagName> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_TAG_NAMES_IN_USE);
            resultSet = connection.executeQuery(statement);
            ArrayList<TagName> tagNames = new ArrayList<TagName>();
            while (resultSet.next()) {
                tagNames.add(new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.FileKnown.valueOf(resultSet.getByte("knownStatus"))));
            }
            arrayList = tagNames;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error selecting rows from tag_names table", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<TagName> getTagNamesInUse(long dsObjId) throws TskCoreException {
        ArrayList<TagName> arrayList;
        ArrayList<TagName> tagNames = new ArrayList<TagName>();
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_TAG_NAMES_IN_USE_BY_DATASOURCE);
            statement.setLong(1, dsObjId);
            statement.setLong(2, dsObjId);
            resultSet = connection.executeQuery(statement);
            while (resultSet.next()) {
                tagNames.add(new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.FileKnown.valueOf(resultSet.getByte("knownStatus"))));
            }
            arrayList = tagNames;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Failed to get tag names in use for data source objID : " + dsObjId, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    @Deprecated
    public TagName addTagName(String displayName, String description, TagName.HTML_COLOR color) throws TskCoreException {
        return this.addOrUpdateTagName(displayName, description, color, TskData.FileKnown.UNKNOWN);
    }

    public TagName addOrUpdateTagName(String displayName, String description, TagName.HTML_COLOR color, TskData.FileKnown knownStatus) throws TskCoreException {
        TagName tagName;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement;
            if (this.dbType == TskData.DbType.POSTGRESQL) {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_OR_UPDATE_TAG_NAME_POSTGRES, 1);
                statement.clearParameters();
                statement.setString(5, description);
                statement.setString(6, color.getName());
                statement.setByte(7, knownStatus.getFileKnownValue());
            } else {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_OR_UPDATE_TAG_NAME_SQLITE, 1);
                statement.clearParameters();
            }
            statement.setString(1, displayName);
            statement.setString(2, description);
            statement.setString(3, color.getName());
            statement.setByte(4, knownStatus.getFileKnownValue());
            connection.executeUpdate(statement);
            resultSet = statement.getGeneratedKeys();
            resultSet.next();
            tagName = new TagName(resultSet.getLong(1), displayName, description, color, knownStatus);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error adding row for " + displayName + " tag name to tag_names table", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseWriteLock();
        return tagName;
    }

    public ContentTag addContentTag(Content content, TagName tagName, String comment, long beginByteOffset, long endByteOffset) throws TskCoreException {
        ContentTag contentTag;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        ResultSet resultSet = null;
        try {
            Examiner currentExaminer = this.getCurrentExaminer();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_CONTENT_TAG, 1);
            statement.clearParameters();
            statement.setLong(1, content.getId());
            statement.setLong(2, tagName.getId());
            statement.setString(3, comment);
            statement.setLong(4, beginByteOffset);
            statement.setLong(5, endByteOffset);
            statement.setLong(6, currentExaminer.getId());
            connection.executeUpdate(statement);
            resultSet = statement.getGeneratedKeys();
            resultSet.next();
            contentTag = new ContentTag(resultSet.getLong(1), content, tagName, comment, beginByteOffset, endByteOffset, currentExaminer.getLoginName());
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error adding row to content_tags table (obj_id = " + content.getId() + ", tag_name_id = " + tagName.getId() + ")", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseWriteLock();
        return contentTag;
    }

    public void deleteContentTag(ContentTag tag) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.DELETE_CONTENT_TAG);
            statement.clearParameters();
            statement.setLong(1, tag.getId());
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error deleting row from content_tags table (id = " + tag.getId() + ")", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public List<ContentTag> getAllContentTags() throws TskCoreException {
        ArrayList<ContentTag> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_CONTENT_TAGS);
            resultSet = connection.executeQuery(statement);
            ArrayList<ContentTag> tags = new ArrayList<ContentTag>();
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.FileKnown.valueOf(resultSet.getByte("knownStatus")));
                Content content = this.getContentById(resultSet.getLong("obj_id"));
                tags.add(new ContentTag(resultSet.getLong("tag_id"), content, tagName, resultSet.getString("comment"), resultSet.getLong("begin_byte_offset"), resultSet.getLong("end_byte_offset"), resultSet.getString("login_name")));
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error selecting rows from content_tags table", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public long getContentTagsCountByTagName(TagName tagName) throws TskCoreException {
        ResultSet resultSet;
        CaseDbConnection connection;
        block6: {
            if (tagName.getId() == Tag.ID_NOT_SET) {
                throw new TskCoreException("TagName object is invalid, id not set");
            }
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            resultSet = null;
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_CONTENT_TAGS_BY_TAG_NAME);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block6;
            long l = resultSet.getLong("count");
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return l;
        }
        try {
            try {
                throw new TskCoreException("Error getting content_tags row count for tag name (tag_name_id = " + tagName.getId() + ")");
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting content_tags row count for tag name (tag_name_id = " + tagName.getId() + ")", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public long getContentTagsCountByTagName(TagName tagName, long dsObjId) throws TskCoreException {
        ResultSet resultSet;
        CaseDbConnection connection;
        block6: {
            if (tagName.getId() == Tag.ID_NOT_SET) {
                throw new TskCoreException("TagName object is invalid, id not set");
            }
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            resultSet = null;
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_CONTENT_TAGS_BY_TAG_NAME_BY_DATASOURCE);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            statement.setLong(2, dsObjId);
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block6;
            long l = resultSet.getLong("count");
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return l;
        }
        try {
            try {
                throw new TskCoreException("Error getting content_tags row count for tag name (tag_name_id = " + tagName.getId() + ") for dsObjId = " + dsObjId);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Failed to get content_tags row count for  tag_name_id = " + tagName.getId() + "data source objID : " + dsObjId, ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public ContentTag getContentTagByID(long contentTagID) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        ContentTag tag = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_CONTENT_TAG_BY_ID);
            statement.clearParameters();
            statement.setLong(1, contentTagID);
            resultSet = connection.executeQuery(statement);
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.FileKnown.valueOf(resultSet.getByte("knownStatus")));
                tag = new ContentTag(resultSet.getLong("tag_id"), this.getContentById(resultSet.getLong("obj_id")), tagName, resultSet.getString("comment"), resultSet.getLong("begin_byte_offset"), resultSet.getLong("end_byte_offset"), resultSet.getString("login_name"));
            }
            resultSet.close();
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting content tag with id = " + contentTagID, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return tag;
    }

    public List<ContentTag> getContentTagsByTagName(TagName tagName) throws TskCoreException {
        ArrayList<ContentTag> arrayList;
        if (tagName.getId() == Tag.ID_NOT_SET) {
            throw new TskCoreException("TagName object is invalid, id not set");
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_CONTENT_TAGS_BY_TAG_NAME);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            resultSet = connection.executeQuery(statement);
            ArrayList<ContentTag> tags = new ArrayList<ContentTag>();
            while (resultSet.next()) {
                ContentTag tag = new ContentTag(resultSet.getLong("tag_id"), this.getContentById(resultSet.getLong("obj_id")), tagName, resultSet.getString("comment"), resultSet.getLong("begin_byte_offset"), resultSet.getLong("end_byte_offset"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            resultSet.close();
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting content_tags rows (tag_name_id = " + tagName.getId() + ")", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<ContentTag> getContentTagsByTagName(TagName tagName, long dsObjId) throws TskCoreException {
        ArrayList<ContentTag> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_CONTENT_TAGS_BY_TAG_NAME_BY_DATASOURCE);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            statement.setLong(2, dsObjId);
            resultSet = connection.executeQuery(statement);
            ArrayList<ContentTag> tags = new ArrayList<ContentTag>();
            while (resultSet.next()) {
                ContentTag tag = new ContentTag(resultSet.getLong("tag_id"), this.getContentById(resultSet.getLong("obj_id")), tagName, resultSet.getString("comment"), resultSet.getLong("begin_byte_offset"), resultSet.getLong("end_byte_offset"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            resultSet.close();
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Failed to get content_tags row count for  tag_name_id = " + tagName.getId() + " data source objID : " + dsObjId, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<ContentTag> getContentTagsByContent(Content content) throws TskCoreException {
        ArrayList<ContentTag> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_CONTENT_TAGS_BY_CONTENT);
            statement.clearParameters();
            statement.setLong(1, content.getId());
            resultSet = connection.executeQuery(statement);
            ArrayList<ContentTag> tags = new ArrayList<ContentTag>();
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.FileKnown.valueOf(resultSet.getByte("knownStatus")));
                ContentTag tag = new ContentTag(resultSet.getLong("tag_id"), content, tagName, resultSet.getString("comment"), resultSet.getLong("begin_byte_offset"), resultSet.getLong("end_byte_offset"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting content tags data for content (obj_id = " + content.getId() + ")", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public BlackboardArtifactTag addBlackboardArtifactTag(BlackboardArtifact artifact, TagName tagName, String comment) throws TskCoreException {
        BlackboardArtifactTag blackboardArtifactTag;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        ResultSet resultSet = null;
        try {
            Examiner currentExaminer = this.getCurrentExaminer();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_ARTIFACT_TAG, 1);
            statement.clearParameters();
            statement.setLong(1, artifact.getArtifactID());
            statement.setLong(2, tagName.getId());
            statement.setString(3, comment);
            statement.setLong(4, currentExaminer.getId());
            connection.executeUpdate(statement);
            resultSet = statement.getGeneratedKeys();
            resultSet.next();
            blackboardArtifactTag = new BlackboardArtifactTag(resultSet.getLong(1), artifact, this.getContentById(artifact.getObjectID()), tagName, comment, currentExaminer.getLoginName());
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error adding row to blackboard_artifact_tags table (obj_id = " + artifact.getArtifactID() + ", tag_name_id = " + tagName.getId() + ")", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseWriteLock();
        return blackboardArtifactTag;
    }

    public void deleteBlackboardArtifactTag(BlackboardArtifactTag tag) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.DELETE_ARTIFACT_TAG);
            statement.clearParameters();
            statement.setLong(1, tag.getId());
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error deleting row from blackboard_artifact_tags table (id = " + tag.getId() + ")", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public List<BlackboardArtifactTag> getAllBlackboardArtifactTags() throws TskCoreException {
        ArrayList<BlackboardArtifactTag> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_TAGS);
            resultSet = connection.executeQuery(statement);
            ArrayList<BlackboardArtifactTag> tags = new ArrayList<BlackboardArtifactTag>();
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.FileKnown.valueOf(resultSet.getByte("knownStatus")));
                BlackboardArtifact artifact = this.getBlackboardArtifact(resultSet.getLong("artifact_id"));
                Content content = this.getContentById(artifact.getObjectID());
                BlackboardArtifactTag tag = new BlackboardArtifactTag(resultSet.getLong("tag_id"), artifact, content, tagName, resultSet.getString("comment"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error selecting rows from blackboard_artifact_tags table", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public long getBlackboardArtifactTagsCountByTagName(TagName tagName) throws TskCoreException {
        ResultSet resultSet;
        CaseDbConnection connection;
        block6: {
            if (tagName.getId() == Tag.ID_NOT_SET) {
                throw new TskCoreException("TagName object is invalid, id not set");
            }
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            resultSet = null;
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_ARTIFACTS_BY_TAG_NAME);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block6;
            long l = resultSet.getLong("count");
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return l;
        }
        try {
            try {
                throw new TskCoreException("Error getting blackboard_artifact_tags row count for tag name (tag_name_id = " + tagName.getId() + ")");
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting blackboard artifact_content_tags row count for tag name (tag_name_id = " + tagName.getId() + ")", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public long getBlackboardArtifactTagsCountByTagName(TagName tagName, long dsObjId) throws TskCoreException {
        ResultSet resultSet;
        CaseDbConnection connection;
        block6: {
            if (tagName.getId() == Tag.ID_NOT_SET) {
                throw new TskCoreException("TagName object is invalid, id not set");
            }
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            resultSet = null;
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_ARTIFACTS_BY_TAG_NAME_BY_DATASOURCE);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            statement.setLong(2, dsObjId);
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block6;
            long l = resultSet.getLong("count");
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return l;
        }
        try {
            try {
                throw new TskCoreException("Error getting blackboard_artifact_tags row count for tag name (tag_name_id = " + tagName.getId() + ") for dsObjId = " + dsObjId);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Failed to get blackboard_artifact_tags row count for  tag_name_id = " + tagName.getId() + "data source objID : " + dsObjId, ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public List<BlackboardArtifactTag> getBlackboardArtifactTagsByTagName(TagName tagName) throws TskCoreException {
        ArrayList<BlackboardArtifactTag> arrayList;
        if (tagName.getId() == Tag.ID_NOT_SET) {
            throw new TskCoreException("TagName object is invalid, id not set");
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_TAGS_BY_TAG_NAME);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            resultSet = connection.executeQuery(statement);
            ArrayList<BlackboardArtifactTag> tags = new ArrayList<BlackboardArtifactTag>();
            while (resultSet.next()) {
                BlackboardArtifact artifact = this.getBlackboardArtifact(resultSet.getLong("artifact_id"));
                Content content = this.getContentById(artifact.getObjectID());
                BlackboardArtifactTag tag = new BlackboardArtifactTag(resultSet.getLong("tag_id"), artifact, content, tagName, resultSet.getString("comment"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifact tags data (tag_name_id = " + tagName.getId() + ")", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<BlackboardArtifactTag> getBlackboardArtifactTagsByTagName(TagName tagName, long dsObjId) throws TskCoreException {
        ArrayList<BlackboardArtifactTag> arrayList;
        if (tagName.getId() == Tag.ID_NOT_SET) {
            throw new TskCoreException("TagName object is invalid, id not set");
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_TAGS_BY_TAG_NAME_BY_DATASOURCE);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            statement.setLong(2, dsObjId);
            resultSet = connection.executeQuery(statement);
            ArrayList<BlackboardArtifactTag> tags = new ArrayList<BlackboardArtifactTag>();
            while (resultSet.next()) {
                BlackboardArtifact artifact = this.getBlackboardArtifact(resultSet.getLong("artifact_id"));
                Content content = this.getContentById(artifact.getObjectID());
                BlackboardArtifactTag tag = new BlackboardArtifactTag(resultSet.getLong("tag_id"), artifact, content, tagName, resultSet.getString("comment"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Failed to get blackboard_artifact_tags row count for  tag_name_id = " + tagName.getId() + "data source objID : " + dsObjId, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public BlackboardArtifactTag getBlackboardArtifactTagByID(long artifactTagID) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        BlackboardArtifactTag tag = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_TAG_BY_ID);
            statement.clearParameters();
            statement.setLong(1, artifactTagID);
            resultSet = connection.executeQuery(statement);
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.FileKnown.valueOf(resultSet.getByte("knownStatus")));
                BlackboardArtifact artifact = this.getBlackboardArtifact(resultSet.getLong("artifact_id"));
                Content content = this.getContentById(artifact.getObjectID());
                tag = new BlackboardArtifactTag(resultSet.getLong("tag_id"), artifact, content, tagName, resultSet.getString("comment"), resultSet.getString("login_name"));
            }
            resultSet.close();
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifact tag with id = " + artifactTagID, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return tag;
    }

    public List<BlackboardArtifactTag> getBlackboardArtifactTagsByArtifact(BlackboardArtifact artifact) throws TskCoreException {
        ArrayList<BlackboardArtifactTag> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_TAGS_BY_ARTIFACT);
            statement.clearParameters();
            statement.setLong(1, artifact.getArtifactID());
            resultSet = connection.executeQuery(statement);
            ArrayList<BlackboardArtifactTag> tags = new ArrayList<BlackboardArtifactTag>();
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.FileKnown.valueOf(resultSet.getByte("knownStatus")));
                Content content = this.getContentById(artifact.getObjectID());
                BlackboardArtifactTag tag = new BlackboardArtifactTag(resultSet.getLong("tag_id"), artifact, content, tagName, resultSet.getString("comment"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifact tags data (artifact_id = " + artifact.getArtifactID() + ")", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public void updateImagePath(String newPath, long objectId) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_IMAGE_PATH);
            statement.clearParameters();
            statement.setString(1, newPath);
            statement.setLong(2, objectId);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error updating image path in database for object " + objectId, ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public Report addReport(String localPath, String sourceModuleName, String reportName) throws TskCoreException {
        return this.addReport(localPath, sourceModuleName, reportName, null);
    }

    public Report addReport(String localPath, String sourceModuleName, String reportName, Content parent) throws TskCoreException {
        String relativePath = "";
        long createTime = 0L;
        String localPathLower = localPath.toLowerCase();
        if (localPathLower.startsWith("http")) {
            relativePath = localPathLower;
            createTime = System.currentTimeMillis() / 1000L;
        } else {
            try {
                String casePathLower = this.getDbDirPath().toLowerCase();
                int length = new java.io.File(casePathLower).toURI().relativize(new java.io.File(localPathLower).toURI()).getPath().length();
                relativePath = new java.io.File(localPath.substring(localPathLower.length() - length)).getPath();
            }
            catch (IllegalArgumentException ex) {
                String errorMessage = String.format("Local path %s not in the database directory or one of its subdirectories", localPath);
                throw new TskCoreException(errorMessage, ex);
            }
            try {
                java.io.File tempFile = new java.io.File(localPath);
                createTime = tempFile.lastModified() / 1000L;
            }
            catch (Exception ex) {
                throw new TskCoreException("Could not get create time for report at " + localPath, ex);
            }
        }
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        ResultSet resultSet = null;
        try {
            long parentObjId = 0L;
            if (parent != null) {
                parentObjId = parent.getId();
            }
            long objectId = this.addObject(parentObjId, TskData.ObjectType.REPORT.getObjectType(), connection);
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_REPORT);
            statement.clearParameters();
            statement.setLong(1, objectId);
            statement.setString(2, relativePath);
            statement.setLong(3, createTime);
            statement.setString(4, sourceModuleName);
            statement.setString(5, reportName);
            connection.executeUpdate(statement);
            Report report = new Report(this, objectId, localPath, createTime, sourceModuleName, reportName, parent);
            return report;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error adding report " + localPath + " to reports table", ex);
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public List<Report> getAllReports() throws TskCoreException {
        ArrayList<Report> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_REPORTS);
            resultSet = connection.executeQuery(statement);
            ArrayList<Report> reports = new ArrayList<Report>();
            while (resultSet.next()) {
                String localpath = resultSet.getString("path");
                if (!localpath.toLowerCase().startsWith("http")) {
                    localpath = Paths.get(this.getDbDirPath(), localpath).normalize().toString();
                }
                reports.add(new Report(this, resultSet.getLong("obj_id"), localpath, resultSet.getLong("crtime"), resultSet.getString("src_module_name"), resultSet.getString("report_name"), null));
            }
            arrayList = reports;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error querying reports table", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public Report getReportById(long id) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet resultSet = null;
        Report report = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_REPORT_BY_ID);
            statement.clearParameters();
            statement.setLong(1, id);
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) {
                throw new TskCoreException("No report found for id: " + id);
            }
            report = new Report(this, resultSet.getLong("obj_id"), Paths.get(this.getDbDirPath(), resultSet.getString("path")).normalize().toString(), resultSet.getLong("crtime"), resultSet.getString("src_module_name"), resultSet.getString("report_name"), null);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error querying reports table for id: " + id, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return report;
    }

    public void deleteReport(Report report) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.DELETE_REPORT);
            statement.setLong(1, report.getId());
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error querying reports table", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, "Error closing ResultSet", ex);
            }
        }
    }

    static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, "Error closing Statement", ex);
            }
        }
    }

    void setIngestJobEndDateTime(long ingestJobId, long endDateTime) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            Statement statement = connection.createStatement();
            statement.executeUpdate("UPDATE ingest_jobs SET end_date_time=" + endDateTime + " WHERE ingest_job_id=" + ingestJobId + ";");
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error updating the end date (ingest_job_id = " + ingestJobId + ".", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void setIngestJobStatus(long ingestJobId, IngestJobInfo.IngestJobStatusType status) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        try {
            Statement statement = connection.createStatement();
            statement.executeUpdate("UPDATE ingest_jobs SET status_id=" + status.ordinal() + " WHERE ingest_job_id=" + ingestJobId + ";");
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error ingest job status (ingest_job_id = " + ingestJobId + ".", ex);
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public final IngestJobInfo addIngestJob(Content dataSource, String hostName, List<IngestModuleInfo> ingestModules, Date jobStart, Date jobEnd, IngestJobInfo.IngestJobStatusType status, String settingsDir) throws TskCoreException {
        IngestJobInfo ingestJobInfo;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseWriteLock();
        ResultSet resultSet = null;
        try {
            connection.beginTransaction();
            Statement statement = connection.createStatement();
            PreparedStatement insertStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_INGEST_JOB, 1);
            insertStatement.setLong(1, dataSource.getId());
            insertStatement.setString(2, hostName);
            insertStatement.setLong(3, jobStart.getTime());
            insertStatement.setLong(4, jobEnd.getTime());
            insertStatement.setInt(5, status.ordinal());
            insertStatement.setString(6, settingsDir);
            connection.executeUpdate(insertStatement);
            resultSet = insertStatement.getGeneratedKeys();
            resultSet.next();
            long id = resultSet.getLong(1);
            for (int i = 0; i < ingestModules.size(); ++i) {
                IngestModuleInfo ingestModule = ingestModules.get(i);
                statement.executeUpdate("INSERT INTO ingest_job_modules (ingest_job_id, ingest_module_id, pipeline_position) VALUES (" + id + ", " + ingestModule.getIngestModuleId() + ", " + i + ");");
            }
            resultSet.close();
            resultSet = null;
            connection.commitTransaction();
            ingestJobInfo = new IngestJobInfo(id, dataSource.getId(), hostName, jobStart, "", ingestModules, this);
        }
        catch (SQLException ex) {
            try {
                connection.rollbackTransaction();
                throw new TskCoreException("Error adding the ingest job.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                connection.close();
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        connection.close();
        this.releaseSingleUserCaseWriteLock();
        return ingestJobInfo;
    }

    /*
     * Loose catch block
     */
    public final IngestModuleInfo addIngestModule(String displayName, String factoryClassName, IngestModuleInfo.IngestModuleType type, String version) throws TskCoreException {
        IngestModuleInfo insertStatement2222222222;
        String uniqueName;
        Statement statement;
        ResultSet resultSet;
        CaseDbConnection connection;
        block9: {
            connection = this.connections.getConnection();
            resultSet = null;
            statement = null;
            uniqueName = factoryClassName + "-" + displayName + "-" + type.toString() + "-" + version;
            this.acquireSingleUserCaseWriteLock();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM ingest_modules WHERE unique_name = '" + uniqueName + "'");
            if (resultSet.next()) break block9;
            resultSet.close();
            resultSet = null;
            PreparedStatement insertStatement2222222222 = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_INGEST_MODULE, 1);
            insertStatement2222222222.setString(1, displayName);
            insertStatement2222222222.setString(2, uniqueName);
            insertStatement2222222222.setInt(3, type.ordinal());
            insertStatement2222222222.setString(4, version);
            connection.executeUpdate(insertStatement2222222222);
            resultSet = statement.getGeneratedKeys();
            resultSet.next();
            long id = resultSet.getLong(1);
            resultSet.close();
            resultSet = null;
            IngestModuleInfo ingestModuleInfo = new IngestModuleInfo(id, displayName, uniqueName, type, version);
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.releaseSingleUserCaseWriteLock();
            return ingestModuleInfo;
        }
        try {
            insertStatement2222222222 = new IngestModuleInfo(resultSet.getInt("ingest_module_id"), resultSet.getString("display_name"), resultSet.getString("unique_name"), IngestModuleInfo.IngestModuleType.fromID(resultSet.getInt("type_id")), resultSet.getString("version"));
        }
        catch (SQLException ex) {
            block10: {
                SleuthkitCase.closeStatement(statement);
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT * FROM ingest_modules WHERE unique_name = '" + uniqueName + "'");
                if (!resultSet.next()) break block10;
                IngestModuleInfo id = new IngestModuleInfo(resultSet.getInt("ingest_module_id"), resultSet.getString("display_name"), uniqueName, IngestModuleInfo.IngestModuleType.fromID(resultSet.getInt("type_id")), resultSet.getString("version"));
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                connection.close();
                this.releaseSingleUserCaseWriteLock();
                return id;
            }
            try {
                throw new TskCoreException("Couldn't add new module to database.", ex);
                {
                    catch (SQLException ex1) {
                        throw new TskCoreException("Couldn't add new module to database.", ex1);
                    }
                }
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                connection.close();
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        connection.close();
        this.releaseSingleUserCaseWriteLock();
        return insertStatement2222222222;
    }

    public final List<IngestJobInfo> getIngestJobs() throws TskCoreException {
        ArrayList<IngestJobInfo> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        ResultSet resultSet = null;
        Statement statement = null;
        ArrayList<IngestJobInfo> ingestJobs = new ArrayList<IngestJobInfo>();
        this.acquireSingleUserCaseReadLock();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM ingest_jobs");
            while (resultSet.next()) {
                ingestJobs.add(new IngestJobInfo(resultSet.getInt("ingest_job_id"), resultSet.getLong("obj_id"), resultSet.getString("host_name"), new Date(resultSet.getLong("start_date_time")), new Date(resultSet.getLong("end_date_time")), IngestJobInfo.IngestJobStatusType.fromID(resultSet.getInt("status_id")), resultSet.getString("settings_dir"), this.getIngestModules(resultSet.getInt("ingest_job_id"), connection), this));
            }
            arrayList = ingestJobs;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Couldn't get the ingest jobs.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IngestModuleInfo> getIngestModules(int ingestJobId, CaseDbConnection connection) throws SQLException {
        ArrayList<IngestModuleInfo> arrayList;
        ResultSet resultSet = null;
        Statement statement = null;
        ArrayList<IngestModuleInfo> ingestModules = new ArrayList<IngestModuleInfo>();
        this.acquireSingleUserCaseReadLock();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT ingest_job_modules.ingest_module_id AS ingest_module_id, ingest_job_modules.pipeline_position AS pipeline_position, ingest_modules.display_name AS display_name, ingest_modules.unique_name AS unique_name, ingest_modules.type_id AS type_id, ingest_modules.version AS version FROM ingest_job_modules, ingest_modules WHERE ingest_job_modules.ingest_job_id = " + ingestJobId + " AND ingest_modules.ingest_module_id = ingest_job_modules.ingest_module_id ORDER BY (ingest_job_modules.pipeline_position);");
            while (resultSet.next()) {
                ingestModules.add(new IngestModuleInfo(resultSet.getInt("ingest_module_id"), resultSet.getString("display_name"), resultSet.getString("unique_name"), IngestModuleInfo.IngestModuleType.fromID(resultSet.getInt("type_id")), resultSet.getString("version")));
            }
            arrayList = ingestModules;
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    @Deprecated
    public void addErrorObserver(ErrorObserver observer) {
        this.sleuthkitCaseErrorObservers.add(observer);
    }

    @Deprecated
    public void removeErrorObserver(ErrorObserver observer) {
        int i = this.sleuthkitCaseErrorObservers.indexOf(observer);
        if (i >= 0) {
            this.sleuthkitCaseErrorObservers.remove(i);
        }
    }

    @Deprecated
    public void submitError(String context, String errorMessage) {
        for (ErrorObserver observer : this.sleuthkitCaseErrorObservers) {
            if (observer == null) continue;
            try {
                observer.receiveError(context, errorMessage);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Observer client unable to receive message: {0}, {1}", new Object[]{context, errorMessage, ex});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    long getDataSourceObjectId(long objectId) {
        CaseDbConnection connection = this.connections.getConnection();
        try {
            long l = this.getDataSourceObjectId(connection, objectId);
            connection.close();
            return l;
        }
        catch (Throwable throwable) {
            try {
                connection.close();
                throw throwable;
            }
            catch (TskCoreException ex) {
                logger.log(Level.SEVERE, "Error getting data source object id for a file", ex);
                return 0L;
            }
        }
    }

    @Deprecated
    public long getLastObjectId() throws TskCoreException {
        long l;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_MAX_OBJECT_ID);
            rs = connection.executeQuery(statement);
            long id = -1L;
            if (rs.next()) {
                id = rs.getLong("max_obj_id");
            }
            l = id;
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("Error getting last object id", e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    @Deprecated
    public List<FsContent> findFilesWhere(String sqlWhereClause) throws TskCoreException {
        ArrayList<FsContent> arrayList;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_files WHERE " + sqlWhereClause);
            ArrayList<FsContent> results = new ArrayList<FsContent>();
            List<AbstractFile> temp = this.resultSetToAbstractFiles(rs, connection);
            for (AbstractFile f : temp) {
                TskData.TSK_DB_FILES_TYPE_ENUM type = f.getType();
                if (!type.equals((Object)TskData.TSK_DB_FILES_TYPE_ENUM.FS)) continue;
                results.add((FsContent)f);
            }
            arrayList = results;
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("SQLException thrown when calling 'SleuthkitCase.findFilesWhere().", e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    @Deprecated
    public int getArtifactTypeID(String artifactTypeName) throws TskCoreException {
        int n;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT artifact_type_id FROM blackboard_artifact_types WHERE type_name = '" + artifactTypeName + "'");
            int typeId = -1;
            if (rs.next()) {
                typeId = rs.getInt("artifact_type_id");
            }
            n = typeId;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting artifact type id", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return n;
    }

    @Deprecated
    public ArrayList<BlackboardArtifact.ARTIFACT_TYPE> getBlackboardArtifactTypes() throws TskCoreException {
        return new ArrayList<BlackboardArtifact.ARTIFACT_TYPE>(Arrays.asList(BlackboardArtifact.ARTIFACT_TYPE.values()));
    }

    @Deprecated
    public int addArtifactType(String artifactTypeName, String displayName) throws TskCoreException {
        try {
            return this.addBlackboardArtifactType(artifactTypeName, displayName).getTypeID();
        }
        catch (TskDataException ex) {
            throw new TskCoreException("Failed to add artifact type.", ex);
        }
    }

    @Deprecated
    public int addAttrType(String attrTypeString, String displayName) throws TskCoreException {
        try {
            return this.addArtifactAttributeType(attrTypeString, BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING, displayName).getTypeID();
        }
        catch (TskDataException ex) {
            throw new TskCoreException("Couldn't add new attribute type");
        }
    }

    @Deprecated
    public int getAttrTypeID(String attrTypeName) throws TskCoreException {
        int n;
        CaseDbConnection connection = this.connections.getConnection();
        this.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT attribute_type_id FROM blackboard_attribute_types WHERE type_name = '" + attrTypeName + "'");
            int typeId = -1;
            if (rs.next()) {
                typeId = rs.getInt("attribute_type_id");
            }
            n = typeId;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attribute type id", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.releaseSingleUserCaseReadLock();
        return n;
    }

    @Deprecated
    public String getAttrTypeString(int attrTypeID) throws TskCoreException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block5: {
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            s = null;
            rs = null;
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT type_name FROM blackboard_attribute_types WHERE attribute_type_id = " + attrTypeID);
            if (!rs.next()) break block5;
            String string = rs.getString("type_name");
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return string;
        }
        try {
            try {
                throw new TskCoreException("No type with that id");
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting or creating a attribute type name", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    @Deprecated
    public String getAttrTypeDisplayName(int attrTypeID) throws TskCoreException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block5: {
            connection = this.connections.getConnection();
            this.acquireSingleUserCaseReadLock();
            s = null;
            rs = null;
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT display_name FROM blackboard_attribute_types WHERE attribute_type_id = " + attrTypeID);
            if (!rs.next()) break block5;
            String string = rs.getString("display_name");
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            return string;
        }
        try {
            try {
                throw new TskCoreException("No type with that id");
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting or creating a attribute type name", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    @Deprecated
    public ArrayList<BlackboardAttribute.ATTRIBUTE_TYPE> getBlackboardAttributeTypes() throws TskCoreException {
        return new ArrayList<BlackboardAttribute.ATTRIBUTE_TYPE>(Arrays.asList(BlackboardAttribute.ATTRIBUTE_TYPE.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ResultSet runQuery(String query) throws SQLException {
        CaseDbConnection connection;
        try {
            connection = this.connections.getConnection();
        }
        catch (TskCoreException ex) {
            throw new SQLException("Error getting connection for ad hoc query", ex);
        }
        this.acquireSingleUserCaseReadLock();
        try {
            ResultSet resultSet = connection.executeQuery(connection.createStatement(), query);
            return resultSet;
        }
        finally {
            connection.close();
            this.releaseSingleUserCaseReadLock();
        }
    }

    @Deprecated
    public void closeRunQuery(ResultSet resultSet) throws SQLException {
        Statement statement = resultSet.getStatement();
        resultSet.close();
        if (statement != null) {
            statement.close();
        }
    }

    @Deprecated
    public LayoutFile addCarvedFile(String carvedFileName, long carvedFileSize, long containerId, List<TskFileRange> data) throws TskCoreException {
        CarvingResult.CarvedFile carvedFile = new CarvingResult.CarvedFile(carvedFileName, carvedFileSize, data);
        ArrayList<CarvingResult.CarvedFile> files = new ArrayList<CarvingResult.CarvedFile>();
        files.add(carvedFile);
        Content parent = this.getContentById(containerId);
        if (!(parent instanceof FileSystem || parent instanceof Volume || parent instanceof Image)) {
            throw new TskCoreException(String.format("Parent (id =%d) is not an file system, volume or image", containerId));
        }
        CarvingResult carvingResult = new CarvingResult(parent, files);
        return this.addCarvedFiles(carvingResult).get(0);
    }

    @Deprecated
    public List<LayoutFile> addCarvedFiles(List<CarvedFileContainer> filesToAdd) throws TskCoreException {
        ArrayList<CarvingResult.CarvedFile> carvedFiles = new ArrayList<CarvingResult.CarvedFile>();
        for (CarvedFileContainer container : filesToAdd) {
            CarvingResult.CarvedFile carvedFile = new CarvingResult.CarvedFile(container.getName(), container.getSize(), container.getRanges());
            carvedFiles.add(carvedFile);
        }
        Content parent = this.getContentById(filesToAdd.get(0).getId());
        if (!(parent instanceof FileSystem || parent instanceof Volume || parent instanceof Image)) {
            throw new TskCoreException(String.format("Parent (id =%d) is not an file system, volume or image", parent.getId()));
        }
        CarvingResult carvingResult = new CarvingResult(parent, carvedFiles);
        return this.addCarvedFiles(carvingResult);
    }

    @Deprecated
    public DerivedFile addDerivedFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, AbstractFile parentFile, String rederiveDetails, String toolName, String toolVersion, String otherDetails) throws TskCoreException {
        return this.addDerivedFile(fileName, localPath, size, ctime, crtime, atime, mtime, isFile, parentFile, rederiveDetails, toolName, toolVersion, otherDetails, TskData.EncodingType.NONE);
    }

    @Deprecated
    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, AbstractFile parent, CaseDbTransaction transaction) throws TskCoreException {
        return this.addLocalFile(fileName, localPath, size, ctime, crtime, atime, mtime, isFile, TskData.EncodingType.NONE, parent, transaction);
    }

    @Deprecated
    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, AbstractFile parent) throws TskCoreException {
        return this.addLocalFile(fileName, localPath, size, ctime, crtime, atime, mtime, isFile, TskData.EncodingType.NONE, parent);
    }

    @Deprecated
    public SleuthkitJNI.CaseDbHandle.AddImageProcess makeAddImageProcess(String timezone, boolean addUnallocSpace, boolean noFatFsOrphans) {
        return this.caseHandle.initAddImageProcess(timezone, addUnallocSpace, noFatFsOrphans, "", this);
    }

    @Deprecated
    public void acquireExclusiveLock() {
        this.acquireSingleUserCaseWriteLock();
    }

    @Deprecated
    public void releaseExclusiveLock() {
        this.releaseSingleUserCaseWriteLock();
    }

    @Deprecated
    public void acquireSharedLock() {
        this.acquireSingleUserCaseReadLock();
    }

    @Deprecated
    public void releaseSharedLock() {
        this.releaseSingleUserCaseReadLock();
    }

    @Deprecated
    public static interface ErrorObserver {
        public void receiveError(String var1, String var2);

        public static enum Context {
            IMAGE_READ_ERROR("Image File Read Error"),
            DATABASE_READ_ERROR("Database Read Error");

            private final String contextString;

            private Context(String context) {
                this.contextString = context;
            }

            public String getContextString() {
                return this.contextString;
            }
        }
    }

    public final class CaseDbQuery
    implements AutoCloseable {
        private ResultSet resultSet;
        private CaseDbConnection connection;

        private CaseDbQuery(String query) throws TskCoreException {
            this(query, false);
        }

        private CaseDbQuery(String query, boolean allowWriteQuery) throws TskCoreException {
            if (!allowWriteQuery && !query.regionMatches(true, 0, "SELECT", 0, "SELECT".length())) {
                throw new TskCoreException("Unsupported query: Only SELECT queries are supported.");
            }
            try {
                this.connection = SleuthkitCase.this.connections.getConnection();
            }
            catch (TskCoreException ex) {
                throw new TskCoreException("Error getting connection for query: ", ex);
            }
            try {
                SleuthkitCase.this.acquireSingleUserCaseReadLock();
                this.resultSet = this.connection.executeQuery(this.connection.createStatement(), query);
            }
            catch (SQLException ex) {
                SleuthkitCase.this.releaseSingleUserCaseReadLock();
                throw new TskCoreException("Error executing query: ", ex);
            }
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        @Override
        public void close() throws TskCoreException {
            try {
                if (this.resultSet != null) {
                    Statement statement = this.resultSet.getStatement();
                    if (statement != null) {
                        statement.close();
                    }
                    this.resultSet.close();
                }
                this.connection.close();
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error closing query: ", ex);
            }
            finally {
                SleuthkitCase.this.releaseSingleUserCaseReadLock();
            }
        }
    }

    public static final class CaseDbTransaction {
        private final CaseDbConnection connection;
        private boolean hasWriteLock = false;
        private SleuthkitCase sleuthkitCase;

        private CaseDbTransaction(SleuthkitCase sleuthkitCase, CaseDbConnection connection) throws TskCoreException {
            this.connection = connection;
            this.sleuthkitCase = sleuthkitCase;
            try {
                this.connection.beginTransaction();
            }
            catch (SQLException ex) {
                throw new TskCoreException("Failed to create transaction on case database", ex);
            }
        }

        CaseDbConnection getConnection() {
            return this.connection;
        }

        void acquireSingleUserCaseWriteLock() {
            if (!this.hasWriteLock) {
                this.hasWriteLock = true;
                this.sleuthkitCase.acquireSingleUserCaseWriteLock();
            }
        }

        public void commit() throws TskCoreException {
            try {
                this.connection.commitTransaction();
            }
            catch (SQLException ex) {
                throw new TskCoreException("Failed to commit transaction on case database", ex);
            }
            finally {
                this.close();
            }
        }

        public void rollback() throws TskCoreException {
            try {
                this.connection.rollbackTransactionWithThrow();
            }
            catch (SQLException ex) {
                throw new TskCoreException("Case database transaction rollback failed", ex);
            }
            finally {
                this.close();
            }
        }

        void close() {
            this.connection.close();
            if (this.hasWriteLock) {
                this.sleuthkitCase.releaseSingleUserCaseWriteLock();
                this.hasWriteLock = false;
            }
        }
    }

    private final class PostgreSQLConnection
    extends CaseDbConnection {
        private final String COMMUNICATION_ERROR;
        private final String SYSTEM_ERROR;
        private final String UNKNOWN_STATE;
        private static final int MAX_RETRIES = 3;

        PostgreSQLConnection(Connection conn) {
            super(conn);
            this.COMMUNICATION_ERROR = PSQLState.COMMUNICATION_ERROR.getState();
            this.SYSTEM_ERROR = PSQLState.SYSTEM_ERROR.getState();
            this.UNKNOWN_STATE = PSQLState.UNKNOWN_STATE.getState();
        }

        @Override
        void executeUpdate(Statement statement, String update, int generateKeys) throws SQLException {
            CaseDbConnection.ExecuteStatementUpdateGenerateKeys executeStatementUpdateGenerateKeys = new CaseDbConnection.ExecuteStatementUpdateGenerateKeys(statement, update, generateKeys);
            this.executeCommand(executeStatementUpdateGenerateKeys);
        }

        @Override
        PreparedStatement prepareStatement(String sqlStatement, int generateKeys) throws SQLException {
            CaseDbConnection.PrepareStatementGenerateKeys prepareStatementGenerateKeys = new CaseDbConnection.PrepareStatementGenerateKeys(this.getConnection(), sqlStatement, generateKeys);
            this.executeCommand(prepareStatementGenerateKeys);
            return prepareStatementGenerateKeys.getPreparedStatement();
        }

        @Override
        void executeCommand(DbCommand command) throws SQLException {
            SQLException lastException = null;
            for (int retries = 0; retries < 3; ++retries) {
                try {
                    command.execute();
                    lastException = null;
                    break;
                }
                catch (SQLException ex) {
                    lastException = ex;
                    String sqlState = ex.getSQLState();
                    if (sqlState == null || sqlState.equals(this.COMMUNICATION_ERROR) || sqlState.equals(this.SYSTEM_ERROR) || sqlState.equals(this.UNKNOWN_STATE)) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException exp) {
                            Logger.getLogger(SleuthkitCase.class.getName()).log(Level.WARNING, "Unexpectedly unable to wait for database.", exp);
                        }
                        continue;
                    }
                    throw ex;
                }
            }
            if (lastException != null) {
                throw lastException;
            }
        }
    }

    private final class SQLiteConnection
    extends CaseDbConnection {
        private static final int DATABASE_LOCKED_ERROR = 0;
        private static final int SQLITE_BUSY_ERROR = 5;

        SQLiteConnection(Connection conn) {
            super(conn);
        }

        @Override
        void executeCommand(DbCommand command) throws SQLException {
            int retryCounter = 0;
            while (true) {
                try {
                    command.execute();
                }
                catch (SQLException ex) {
                    if ((ex.getErrorCode() == 5 || ex.getErrorCode() == 0) && retryCounter < 20) {
                        try {
                            ++retryCounter;
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException exp) {
                            Logger.getLogger(SleuthkitCase.class.getName()).log(Level.WARNING, "Unexpectedly unable to wait for database.", exp);
                        }
                        continue;
                    }
                    throw ex;
                }
                break;
            }
        }
    }

    abstract class CaseDbConnection {
        static final int SLEEP_LENGTH_IN_MILLISECONDS = 5000;
        static final int MAX_RETRIES = 20;
        private final Connection connection;
        private final Map<PREPARED_STATEMENT, PreparedStatement> preparedStatements;

        abstract void executeCommand(DbCommand var1) throws SQLException;

        CaseDbConnection(Connection connection) {
            this.connection = connection;
            this.preparedStatements = new EnumMap<PREPARED_STATEMENT, PreparedStatement>(PREPARED_STATEMENT.class);
        }

        boolean isOpen() {
            return this.connection != null;
        }

        PreparedStatement getPreparedStatement(PREPARED_STATEMENT statementKey) throws SQLException {
            return this.getPreparedStatement(statementKey, 2);
        }

        PreparedStatement getPreparedStatement(PREPARED_STATEMENT statementKey, int generateKeys) throws SQLException {
            PreparedStatement statement;
            if (this.preparedStatements.containsKey((Object)statementKey)) {
                statement = this.preparedStatements.get((Object)statementKey);
            } else {
                statement = this.prepareStatement(statementKey.getSQL(), generateKeys);
                this.preparedStatements.put(statementKey, statement);
            }
            return statement;
        }

        PreparedStatement prepareStatement(String sqlStatement, int generateKeys) throws SQLException {
            PrepareStatement prepareStatement = new PrepareStatement(this.getConnection(), sqlStatement);
            this.executeCommand(prepareStatement);
            return prepareStatement.getPreparedStatement();
        }

        Statement createStatement() throws SQLException {
            CreateStatement createStatement = new CreateStatement(this.connection);
            this.executeCommand(createStatement);
            return createStatement.getStatement();
        }

        void beginTransaction() throws SQLException {
            SetAutoCommit setAutoCommit = new SetAutoCommit(this.connection, false);
            this.executeCommand(setAutoCommit);
        }

        void commitTransaction() throws SQLException {
            Commit commit = new Commit(this.connection);
            this.executeCommand(commit);
            SetAutoCommit setAutoCommit = new SetAutoCommit(this.connection, true);
            this.executeCommand(setAutoCommit);
        }

        void rollbackTransaction() {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "Error rolling back transaction", e);
            }
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "Error restoring auto-commit", e);
            }
        }

        void rollbackTransactionWithThrow() throws SQLException {
            try {
                this.connection.rollback();
            }
            finally {
                this.connection.setAutoCommit(true);
            }
        }

        ResultSet executeQuery(Statement statement, String query) throws SQLException {
            ExecuteQuery queryCommand = new ExecuteQuery(statement, query);
            this.executeCommand(queryCommand);
            return queryCommand.getResultSet();
        }

        ResultSet executeQuery(PreparedStatement statement) throws SQLException {
            ExecutePreparedStatementQuery executePreparedStatementQuery = new ExecutePreparedStatementQuery(statement);
            this.executeCommand(executePreparedStatementQuery);
            return executePreparedStatementQuery.getResultSet();
        }

        void executeUpdate(Statement statement, String update) throws SQLException {
            this.executeUpdate(statement, update, 2);
        }

        void executeUpdate(Statement statement, String update, int generateKeys) throws SQLException {
            ExecuteStatementUpdate executeStatementUpdate = new ExecuteStatementUpdate(statement, update);
            this.executeCommand(executeStatementUpdate);
        }

        void executeUpdate(PreparedStatement statement) throws SQLException {
            ExecutePreparedStatementUpdate executePreparedStatementUpdate = new ExecutePreparedStatementUpdate(statement);
            this.executeCommand(executePreparedStatementUpdate);
        }

        void close() {
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, "Unable to close connection to case database", ex);
            }
        }

        Connection getConnection() {
            return this.connection;
        }

        private class PrepareStatementGenerateKeys
        implements DbCommand {
            private final Connection connection;
            private final String input;
            private final int generateKeys;
            private PreparedStatement preparedStatement = null;

            PrepareStatementGenerateKeys(Connection connection, String input, int generateKeysInput) {
                this.connection = connection;
                this.input = input;
                this.generateKeys = generateKeysInput;
            }

            PreparedStatement getPreparedStatement() {
                return this.preparedStatement;
            }

            @Override
            public void execute() throws SQLException {
                this.preparedStatement = this.connection.prepareStatement(this.input, this.generateKeys);
            }
        }

        private class PrepareStatement
        implements DbCommand {
            private final Connection connection;
            private final String input;
            private PreparedStatement preparedStatement = null;

            PrepareStatement(Connection connection, String input) {
                this.connection = connection;
                this.input = input;
            }

            PreparedStatement getPreparedStatement() {
                return this.preparedStatement;
            }

            @Override
            public void execute() throws SQLException {
                this.preparedStatement = this.connection.prepareStatement(this.input);
            }
        }

        private class ExecuteStatementUpdateGenerateKeys
        implements DbCommand {
            private final Statement statement;
            private final int generateKeys;
            private final String updateCommand;

            ExecuteStatementUpdateGenerateKeys(Statement statement, String updateCommand, int generateKeys) {
                this.statement = statement;
                this.generateKeys = generateKeys;
                this.updateCommand = updateCommand;
            }

            @Override
            public void execute() throws SQLException {
                this.statement.executeUpdate(this.updateCommand, this.generateKeys);
            }
        }

        private class ExecuteStatementUpdate
        implements DbCommand {
            private final Statement statement;
            private final String updateCommand;

            ExecuteStatementUpdate(Statement statement, String updateCommand) {
                this.statement = statement;
                this.updateCommand = updateCommand;
            }

            @Override
            public void execute() throws SQLException {
                this.statement.executeUpdate(this.updateCommand);
            }
        }

        private class ExecutePreparedStatementUpdate
        implements DbCommand {
            private final PreparedStatement preparedStatement;

            ExecutePreparedStatementUpdate(PreparedStatement preparedStatement) {
                this.preparedStatement = preparedStatement;
            }

            @Override
            public void execute() throws SQLException {
                this.preparedStatement.executeUpdate();
            }
        }

        private class ExecutePreparedStatementQuery
        implements DbCommand {
            private final PreparedStatement preparedStatement;
            private ResultSet resultSet;

            ExecutePreparedStatementQuery(PreparedStatement preparedStatement) {
                this.preparedStatement = preparedStatement;
            }

            ResultSet getResultSet() {
                return this.resultSet;
            }

            @Override
            public void execute() throws SQLException {
                this.resultSet = this.preparedStatement.executeQuery();
            }
        }

        private class ExecuteQuery
        implements DbCommand {
            private final Statement statement;
            private final String query;
            private ResultSet resultSet;

            ExecuteQuery(Statement statement, String query) {
                this.statement = statement;
                this.query = query;
            }

            ResultSet getResultSet() {
                return this.resultSet;
            }

            @Override
            public void execute() throws SQLException {
                this.resultSet = this.statement.executeQuery(this.query);
            }
        }

        private class Commit
        implements DbCommand {
            private final Connection connection;

            Commit(Connection connection) {
                this.connection = connection;
            }

            @Override
            public void execute() throws SQLException {
                this.connection.commit();
            }
        }

        private class SetAutoCommit
        implements DbCommand {
            private final Connection connection;
            private final boolean mode;

            SetAutoCommit(Connection connection, boolean mode) {
                this.connection = connection;
                this.mode = mode;
            }

            @Override
            public void execute() throws SQLException {
                this.connection.setAutoCommit(this.mode);
            }
        }

        private class CreateStatement
        implements DbCommand {
            private final Connection connection;
            private Statement statement = null;

            CreateStatement(Connection connection) {
                this.connection = connection;
            }

            Statement getStatement() {
                return this.statement;
            }

            @Override
            public void execute() throws SQLException {
                this.statement = this.connection.createStatement();
            }
        }
    }

    private final class PostgreSQLConnections
    extends ConnectionPool {
        PostgreSQLConnections(String host, int port, String dbName, String userName, String password) throws PropertyVetoException, UnsupportedEncodingException {
            ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
            comboPooledDataSource.setDriverClass("org.postgresql.Driver");
            comboPooledDataSource.setJdbcUrl("jdbc:postgresql://" + host + ":" + port + "/" + URLEncoder.encode(dbName, StandardCharsets.UTF_8.toString()));
            comboPooledDataSource.setUser(userName);
            comboPooledDataSource.setPassword(password);
            comboPooledDataSource.setAcquireIncrement(2);
            comboPooledDataSource.setInitialPoolSize(5);
            comboPooledDataSource.setMinPoolSize(5);
            comboPooledDataSource.setMaxPoolSize(20);
            comboPooledDataSource.setMaxStatements(200);
            comboPooledDataSource.setMaxStatementsPerConnection(20);
            this.setPooledDataSource((PooledDataSource)comboPooledDataSource);
        }

        @Override
        public CaseDbConnection getPooledConnection() throws SQLException {
            return new PostgreSQLConnection(this.getPooledDataSource().getConnection());
        }
    }

    private final class SQLiteConnections
    extends ConnectionPool {
        private final Map<String, String> configurationOverrides;

        SQLiteConnections(String dbPath) throws SQLException {
            this.configurationOverrides = new HashMap<String, String>();
            this.configurationOverrides.put("acquireIncrement", "2");
            this.configurationOverrides.put("initialPoolSize", "5");
            this.configurationOverrides.put("minPoolSize", "5");
            this.configurationOverrides.put("maxPoolSize", "20");
            this.configurationOverrides.put("maxStatements", "200");
            this.configurationOverrides.put("maxStatementsPerConnection", "20");
            SQLiteConfig config = new SQLiteConfig();
            config.setSynchronous(SQLiteConfig.SynchronousMode.OFF);
            config.setReadUncommited(true);
            config.enforceForeignKeys(true);
            SQLiteDataSource unpooled = new SQLiteDataSource(config);
            unpooled.setUrl("jdbc:sqlite:" + dbPath);
            this.setPooledDataSource((PooledDataSource)DataSources.pooledDataSource((javax.sql.DataSource)unpooled, this.configurationOverrides));
        }

        @Override
        public CaseDbConnection getPooledConnection() throws SQLException {
            return new SQLiteConnection(this.getPooledDataSource().getConnection());
        }
    }

    private abstract class ConnectionPool {
        private PooledDataSource pooledDataSource = null;

        CaseDbConnection getConnection() throws TskCoreException {
            if (this.pooledDataSource == null) {
                throw new TskCoreException("Error getting case database connection - case is closed");
            }
            try {
                return this.getPooledConnection();
            }
            catch (SQLException exp) {
                throw new TskCoreException(exp.getMessage());
            }
        }

        void close() throws TskCoreException {
            if (this.pooledDataSource != null) {
                try {
                    this.pooledDataSource.close();
                }
                catch (SQLException exp) {
                    throw new TskCoreException(exp.getMessage());
                }
                finally {
                    this.pooledDataSource = null;
                }
            }
        }

        abstract CaseDbConnection getPooledConnection() throws SQLException;

        public PooledDataSource getPooledDataSource() {
            return this.pooledDataSource;
        }

        public void setPooledDataSource(PooledDataSource pooledDataSource) {
            this.pooledDataSource = pooledDataSource;
        }
    }

    private static enum PREPARED_STATEMENT {
        SELECT_ARTIFACTS_BY_TYPE("SELECT artifact_id, obj_id FROM blackboard_artifacts WHERE artifact_type_id = ?"),
        COUNT_ARTIFACTS_OF_TYPE("SELECT COUNT(*) AS count FROM blackboard_artifacts WHERE artifact_type_id = ? AND review_status_id != " + BlackboardArtifact.ReviewStatus.REJECTED.getID()),
        COUNT_ARTIFACTS_FROM_SOURCE("SELECT COUNT(*) AS count FROM blackboard_artifacts WHERE obj_id = ? AND review_status_id != " + BlackboardArtifact.ReviewStatus.REJECTED.getID()),
        COUNT_ARTIFACTS_BY_SOURCE_AND_TYPE("SELECT COUNT(*) AS count FROM blackboard_artifacts WHERE obj_id = ? AND artifact_type_id = ? AND review_status_id != " + BlackboardArtifact.ReviewStatus.REJECTED.getID()),
        SELECT_FILES_BY_PARENT("SELECT tsk_files.* FROM tsk_objects INNER JOIN tsk_files ON tsk_objects.obj_id=tsk_files.obj_id WHERE (tsk_objects.par_obj_id = ? ) ORDER BY tsk_files.meta_type DESC, LOWER(tsk_files.name)"),
        SELECT_FILES_BY_PARENT_AND_TYPE("SELECT tsk_files.* FROM tsk_objects INNER JOIN tsk_files ON tsk_objects.obj_id=tsk_files.obj_id WHERE (tsk_objects.par_obj_id = ? AND tsk_files.type = ? ) ORDER BY tsk_files.dir_type, LOWER(tsk_files.name)"),
        SELECT_FILE_IDS_BY_PARENT("SELECT tsk_files.obj_id AS obj_id FROM tsk_objects INNER JOIN tsk_files ON tsk_objects.obj_id=tsk_files.obj_id WHERE (tsk_objects.par_obj_id = ?)"),
        SELECT_FILE_IDS_BY_PARENT_AND_TYPE("SELECT tsk_files.obj_id AS obj_id FROM tsk_objects INNER JOIN tsk_files ON tsk_objects.obj_id=tsk_files.obj_id WHERE (tsk_objects.par_obj_id = ? AND tsk_files.type = ? )"),
        SELECT_FILE_BY_ID("SELECT * FROM tsk_files WHERE obj_id = ? LIMIT 1"),
        SELECT_ARTIFACT_BY_ARTIFACT_OBJ_ID("SELECT * FROM blackboard_artifacts WHERE artifact_obj_id = ? LIMIT 1"),
        SELECT_ARTIFACT_BY_ARTIFACT_ID("SELECT * FROM blackboard_artifacts WHERE artifact_id = ? LIMIT 1"),
        INSERT_ARTIFACT("INSERT INTO blackboard_artifacts (artifact_id, obj_id, artifact_obj_id, data_source_obj_id, artifact_type_id, review_status_id) VALUES (?, ?, ?, ?, ?," + BlackboardArtifact.ReviewStatus.UNDECIDED.getID() + ")"),
        POSTGRESQL_INSERT_ARTIFACT("INSERT INTO blackboard_artifacts (artifact_id, obj_id, artifact_obj_id, data_source_obj_id, artifact_type_id, review_status_id) VALUES (DEFAULT, ?, ?, ?, ?," + BlackboardArtifact.ReviewStatus.UNDECIDED.getID() + ")"),
        INSERT_STRING_ATTRIBUTE("INSERT INTO blackboard_attributes (artifact_id, artifact_type_id, source, context, attribute_type_id, value_type, value_text) VALUES (?,?,?,?,?,?,?)"),
        INSERT_BYTE_ATTRIBUTE("INSERT INTO blackboard_attributes (artifact_id, artifact_type_id, source, context, attribute_type_id, value_type, value_byte) VALUES (?,?,?,?,?,?,?)"),
        INSERT_INT_ATTRIBUTE("INSERT INTO blackboard_attributes (artifact_id, artifact_type_id, source, context, attribute_type_id, value_type, value_int32) VALUES (?,?,?,?,?,?,?)"),
        INSERT_LONG_ATTRIBUTE("INSERT INTO blackboard_attributes (artifact_id, artifact_type_id, source, context, attribute_type_id, value_type, value_int64) VALUES (?,?,?,?,?,?,?)"),
        INSERT_DOUBLE_ATTRIBUTE("INSERT INTO blackboard_attributes (artifact_id, artifact_type_id, source, context, attribute_type_id, value_type, value_double) VALUES (?,?,?,?,?,?,?)"),
        SELECT_FILES_BY_DATA_SOURCE_AND_NAME("SELECT * FROM tsk_files WHERE LOWER(name) LIKE LOWER(?) AND LOWER(name) NOT LIKE LOWER('%journal%') AND data_source_obj_id = ?"),
        SELECT_FILES_BY_DATA_SOURCE_AND_PARENT_PATH_AND_NAME("SELECT * FROM tsk_files WHERE LOWER(name) LIKE LOWER(?) AND LOWER(name) NOT LIKE LOWER('%journal%') AND LOWER(parent_path) LIKE LOWER(?) AND data_source_obj_id = ?"),
        UPDATE_FILE_MD5("UPDATE tsk_files SET md5 = ? WHERE obj_id = ?"),
        UPDATE_IMAGE_MD5("UPDATE tsk_image_info SET md5 = ? WHERE obj_id = ?"),
        UPDATE_IMAGE_SHA1("UPDATE tsk_image_info SET sha1 = ? WHERE obj_id = ?"),
        UPDATE_IMAGE_SHA256("UPDATE tsk_image_info SET sha256 = ? WHERE obj_id = ?"),
        SELECT_IMAGE_MD5("SELECT md5 FROM tsk_image_info WHERE obj_id = ?"),
        SELECT_IMAGE_SHA1("SELECT sha1 FROM tsk_image_info WHERE obj_id = ?"),
        SELECT_IMAGE_SHA256("SELECT sha256 FROM tsk_image_info WHERE obj_id = ?"),
        UPDATE_ACQUISITION_DETAILS("UPDATE data_source_info SET acquisition_details = ? WHERE obj_id = ?"),
        SELECT_ACQUISITION_DETAILS("SELECT acquisition_details FROM data_source_info WHERE obj_id = ?"),
        SELECT_LOCAL_PATH_FOR_FILE("SELECT path FROM tsk_files_path WHERE obj_id = ?"),
        SELECT_ENCODING_FOR_FILE("SELECT encoding_type FROM tsk_files_path WHERE obj_id = ?"),
        SELECT_LOCAL_PATH_AND_ENCODING_FOR_FILE("SELECT path, encoding_type FROM tsk_files_path WHERE obj_id = ?"),
        SELECT_PATH_FOR_FILE("SELECT parent_path FROM tsk_files WHERE obj_id = ?"),
        SELECT_FILE_NAME("SELECT name FROM tsk_files WHERE obj_id = ?"),
        SELECT_DERIVED_FILE("SELECT derived_id, rederive FROM tsk_files_derived WHERE obj_id = ?"),
        SELECT_FILE_DERIVATION_METHOD("SELECT tool_name, tool_version, other FROM tsk_files_derived_method WHERE derived_id = ?"),
        SELECT_MAX_OBJECT_ID("SELECT MAX(obj_id) AS max_obj_id FROM tsk_objects"),
        INSERT_OBJECT("INSERT INTO tsk_objects (par_obj_id, type) VALUES (?, ?)"),
        INSERT_FILE("INSERT INTO tsk_files (obj_id, fs_obj_id, name, type, has_path, dir_type, meta_type, dir_flags, meta_flags, size, ctime, crtime, atime, mtime, md5, known, mime_type, parent_path, data_source_obj_id,extension) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"),
        UPDATE_DERIVED_FILE("UPDATE tsk_files SET type = ?, dir_type = ?, meta_type = ?, dir_flags = ?,  meta_flags = ?, size= ?, ctime= ?, crtime= ?, atime= ?, mtime= ?, mime_type = ?  WHERE obj_id = ?"),
        INSERT_LAYOUT_FILE("INSERT INTO tsk_file_layout (obj_id, byte_start, byte_len, sequence) VALUES (?, ?, ?, ?)"),
        INSERT_LOCAL_PATH("INSERT INTO tsk_files_path (obj_id, path, encoding_type) VALUES (?, ?, ?)"),
        UPDATE_LOCAL_PATH("UPDATE tsk_files_path SET path = ?, encoding_type = ? WHERE obj_id = ?"),
        COUNT_CHILD_OBJECTS_BY_PARENT("SELECT COUNT(obj_id) AS count FROM tsk_objects WHERE par_obj_id = ?"),
        SELECT_FILE_SYSTEM_BY_OBJECT("SELECT fs_obj_id from tsk_files WHERE obj_id=?"),
        SELECT_TAG_NAMES("SELECT * FROM tag_names"),
        SELECT_TAG_NAMES_IN_USE("SELECT * FROM tag_names WHERE tag_name_id IN (SELECT tag_name_id from content_tags UNION SELECT tag_name_id FROM blackboard_artifact_tags)"),
        SELECT_TAG_NAMES_IN_USE_BY_DATASOURCE("SELECT * FROM tag_names WHERE tag_name_id IN ( SELECT content_tags.tag_name_id as tag_name_id FROM content_tags as content_tags, tsk_files as tsk_files WHERE content_tags.obj_id = tsk_files.obj_id AND tsk_files.data_source_obj_id =  ? UNION SELECT artifact_tags.tag_name_id as tag_name_id  FROM blackboard_artifact_tags as artifact_tags, blackboard_artifacts AS arts  WHERE artifact_tags.artifact_id = arts.artifact_id AND arts.data_source_obj_id =  ? )"),
        INSERT_TAG_NAME("INSERT INTO tag_names (display_name, description, color, knownStatus) VALUES (?, ?, ?, ?)"),
        INSERT_CONTENT_TAG("INSERT INTO content_tags (obj_id, tag_name_id, comment, begin_byte_offset, end_byte_offset, examiner_id) VALUES (?, ?, ?, ?, ?, ?)"),
        DELETE_CONTENT_TAG("DELETE FROM content_tags WHERE tag_id = ?"),
        COUNT_CONTENT_TAGS_BY_TAG_NAME("SELECT COUNT(*) AS count FROM content_tags WHERE tag_name_id = ?"),
        COUNT_CONTENT_TAGS_BY_TAG_NAME_BY_DATASOURCE("SELECT COUNT(*) AS count FROM content_tags as content_tags, tsk_files as tsk_files WHERE content_tags.obj_id = tsk_files.obj_id AND content_tags.tag_name_id = ?  AND tsk_files.data_source_obj_id = ? "),
        SELECT_CONTENT_TAGS("SELECT content_tags.tag_id, content_tags.obj_id, content_tags.tag_name_id, content_tags.comment, content_tags.begin_byte_offset, content_tags.end_byte_offset, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name FROM content_tags INNER JOIN tag_names ON content_tags.tag_name_id = tag_names.tag_name_id LEFT OUTER JOIN tsk_examiners ON content_tags.examiner_id = tsk_examiners.examiner_id"),
        SELECT_CONTENT_TAGS_BY_TAG_NAME("SELECT content_tags.tag_id, content_tags.obj_id, content_tags.tag_name_id, content_tags.comment, content_tags.begin_byte_offset, content_tags.end_byte_offset, tsk_examiners.login_name FROM content_tags LEFT OUTER JOIN tsk_examiners ON content_tags.examiner_id = tsk_examiners.examiner_id WHERE tag_name_id = ?"),
        SELECT_CONTENT_TAGS_BY_TAG_NAME_BY_DATASOURCE("SELECT content_tags.tag_id, content_tags.obj_id, content_tags.tag_name_id, content_tags.comment, content_tags.begin_byte_offset, content_tags.end_byte_offset, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name FROM content_tags as content_tags, tsk_files as tsk_files LEFT OUTER JOIN tsk_examiners ON content_tags.examiner_id = tsk_examiners.examiner_id WHERE content_tags.obj_id = tsk_files.obj_id AND content_tags.tag_name_id = ? AND tsk_files.data_source_obj_id = ? "),
        SELECT_CONTENT_TAG_BY_ID("SELECT content_tags.tag_id, content_tags.obj_id, content_tags.tag_name_id, content_tags.comment, content_tags.begin_byte_offset, content_tags.end_byte_offset, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name FROM content_tags INNER JOIN tag_names ON content_tags.tag_name_id = tag_names.tag_name_id LEFT OUTER JOIN tsk_examiners ON content_tags.examiner_id = tsk_examiners.examiner_id WHERE tag_id = ?"),
        SELECT_CONTENT_TAGS_BY_CONTENT("SELECT content_tags.tag_id, content_tags.obj_id, content_tags.tag_name_id, content_tags.comment, content_tags.begin_byte_offset, content_tags.end_byte_offset, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name FROM content_tags INNER JOIN tag_names ON content_tags.tag_name_id = tag_names.tag_name_id LEFT OUTER JOIN tsk_examiners ON content_tags.examiner_id = tsk_examiners.examiner_id WHERE content_tags.obj_id = ?"),
        INSERT_ARTIFACT_TAG("INSERT INTO blackboard_artifact_tags (artifact_id, tag_name_id, comment, examiner_id) VALUES (?, ?, ?, ?)"),
        DELETE_ARTIFACT_TAG("DELETE FROM blackboard_artifact_tags WHERE tag_id = ?"),
        SELECT_ARTIFACT_TAGS("SELECT blackboard_artifact_tags.tag_id, blackboard_artifact_tags.artifact_id, blackboard_artifact_tags.tag_name_id, blackboard_artifact_tags.comment, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name FROM blackboard_artifact_tags INNER JOIN tag_names ON blackboard_artifact_tags.tag_name_id = tag_names.tag_name_id LEFT OUTER JOIN tsk_examiners ON blackboard_artifact_tags.examiner_id = tsk_examiners.examiner_id"),
        COUNT_ARTIFACTS_BY_TAG_NAME("SELECT COUNT(*) AS count FROM blackboard_artifact_tags WHERE tag_name_id = ?"),
        COUNT_ARTIFACTS_BY_TAG_NAME_BY_DATASOURCE("SELECT COUNT(*) AS count FROM blackboard_artifact_tags as artifact_tags, blackboard_artifacts AS arts WHERE artifact_tags.artifact_id = arts.artifact_id AND artifact_tags.tag_name_id = ? AND arts.data_source_obj_id =  ? "),
        SELECT_ARTIFACT_TAGS_BY_TAG_NAME("SELECT blackboard_artifact_tags.tag_id, blackboard_artifact_tags.artifact_id, blackboard_artifact_tags.tag_name_id, blackboard_artifact_tags.comment, tsk_examiners.login_name FROM blackboard_artifact_tags LEFT OUTER JOIN tsk_examiners ON blackboard_artifact_tags.examiner_id = tsk_examiners.examiner_id WHERE tag_name_id = ?"),
        SELECT_ARTIFACT_TAGS_BY_TAG_NAME_BY_DATASOURCE("SELECT SELECT artifact_tags.tag_id, artifact_tags.artifact_id, artifact_tags.tag_name_id, artifact_tags.comment, arts.obj_id, arts.artifact_obj_id, arts.data_source_obj_id, arts.artifact_type_id, arts.review_status_id, tsk_examiners.login_name FROM blackboard_artifact_tags as artifact_tags, blackboard_artifacts AS arts LEFT OUTER JOIN tsk_examiners ON artifact_tags.examiner_id = tsk_examiners.examiner_id WHERE artifact_tags.artifact_id = arts.artifact_id AND artifact_tags.tag_name_id = ?  AND arts.data_source_obj_id =  ? "),
        SELECT_ARTIFACT_TAG_BY_ID("SELECT blackboard_artifact_tags.tag_id, blackboard_artifact_tags.artifact_id, blackboard_artifact_tags.tag_name_id, blackboard_artifact_tags.comment, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name FROM blackboard_artifact_tags INNER JOIN tag_names ON blackboard_artifact_tags.tag_name_id = tag_names.tag_name_id  LEFT OUTER JOIN tsk_examiners ON blackboard_artifact_tags.examiner_id = tsk_examiners.examiner_id WHERE blackboard_artifact_tags.tag_id = ?"),
        SELECT_ARTIFACT_TAGS_BY_ARTIFACT("SELECT blackboard_artifact_tags.tag_id, blackboard_artifact_tags.artifact_id, blackboard_artifact_tags.tag_name_id, blackboard_artifact_tags.comment, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name FROM blackboard_artifact_tags INNER JOIN tag_names ON blackboard_artifact_tags.tag_name_id = tag_names.tag_name_id LEFT OUTER JOIN tsk_examiners ON blackboard_artifact_tags.examiner_id = tsk_examiners.examiner_id WHERE blackboard_artifact_tags.artifact_id = ?"),
        SELECT_REPORTS("SELECT * FROM reports"),
        SELECT_REPORT_BY_ID("SELECT * FROM reports WHERE obj_id = ?"),
        INSERT_REPORT("INSERT INTO reports (obj_id, path, crtime, src_module_name, report_name) VALUES (?, ?, ?, ?, ?)"),
        DELETE_REPORT("DELETE FROM reports WHERE reports.obj_id = ?"),
        INSERT_INGEST_JOB("INSERT INTO ingest_jobs (obj_id, host_name, start_date_time, end_date_time, status_id, settings_dir) VALUES (?, ?, ?, ?, ?, ?)"),
        INSERT_INGEST_MODULE("INSERT INTO ingest_modules (display_name, unique_name, type_id, version) VALUES(?, ?, ?, ?)"),
        SELECT_ATTR_BY_VALUE_BYTE("SELECT source FROM blackboard_attributes WHERE artifact_id = ? AND attribute_type_id = ? AND value_type = 4 AND value_byte = ?"),
        UPDATE_ATTR_BY_VALUE_BYTE("UPDATE blackboard_attributes SET source = ? WHERE artifact_id = ? AND attribute_type_id = ? AND value_type = 4 AND value_byte = ?"),
        UPDATE_IMAGE_PATH("UPDATE tsk_image_names SET name = ? WHERE obj_id = ?"),
        SELECT_ARTIFACT_OBJECTIDS_BY_PARENT("SELECT blackboard_artifacts.artifact_obj_id AS artifact_obj_id FROM tsk_objects INNER JOIN blackboard_artifacts ON tsk_objects.obj_id=blackboard_artifacts.obj_id WHERE (tsk_objects.par_obj_id = ?)"),
        INSERT_OR_UPDATE_TAG_NAME_POSTGRES("INSERT INTO tag_names (display_name, description, color, knownStatus) VALUES (?, ?, ?, ?) ON CONFLICT (display_name) DO UPDATE SET description = ?, color = ?, knownStatus = ?"),
        INSERT_OR_UPDATE_TAG_NAME_SQLITE("WITH new (display_name, description, color, knownStatus) AS ( VALUES(?, ?, ?, ?)) INSERT OR REPLACE INTO tag_names (tag_name_id, display_name, description, color, knownStatus) SELECT old.tag_name_id, new.display_name, new.description, new.color, new.knownStatus FROM new LEFT JOIN tag_names AS old ON new.display_name = old.display_name"),
        SELECT_EXAMINER_BY_ID("SELECT * FROM tsk_examiners WHERE examiner_id = ?"),
        SELECT_EXAMINER_BY_LOGIN_NAME("SELECT * FROM tsk_examiners WHERE login_name = ?"),
        UPDATE_FILE_NAME("UPDATE tsk_files SET name = ? WHERE obj_id = ?"),
        UPDATE_IMAGE_NAME("UPDATE tsk_image_info SET display_name = ? WHERE obj_id = ?"),
        DELETE_IMAGE_NAME("DELETE FROM tsk_image_names WHERE obj_id = ?"),
        INSERT_IMAGE_NAME("INSERT INTO tsk_image_names (obj_id, name, sequence) VALUES (?, ?, ?)"),
        INSERT_IMAGE_INFO("INSERT INTO tsk_image_info (obj_id, type, ssize, tzone, size, md5, sha1, sha256, display_name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)"),
        INSERT_DATA_SOURCE_INFO("INSERT INTO data_source_info (obj_id, device_id, time_zone) VALUES (?, ?, ?)"),
        INSERT_VS_INFO("INSERT INTO tsk_vs_info (obj_id, vs_type, img_offset, block_size) VALUES (?, ?, ?, ?)"),
        INSERT_VS_PART_SQLITE("INSERT INTO tsk_vs_parts (obj_id, addr, start, length, desc, flags) VALUES (?, ?, ?, ?, ?, ?)"),
        INSERT_VS_PART_POSTGRESQL("INSERT INTO tsk_vs_parts (obj_id, addr, start, length, descr, flags) VALUES (?, ?, ?, ?, ?, ?)"),
        INSERT_FS_INFO("INSERT INTO tsk_fs_info (obj_id, img_offset, fs_type, block_size, block_count, root_inum, first_inum, last_inum, display_name)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

        private final String sql;

        private PREPARED_STATEMENT(String sql) {
            this.sql = sql;
        }

        String getSQL() {
            return this.sql;
        }
    }

    private static interface DbCommand {
        public void execute() throws SQLException;
    }

    static class ObjectInfo {
        private long id;
        private TskData.ObjectType type;

        ObjectInfo(long id, TskData.ObjectType type) {
            this.id = id;
            this.type = type;
        }

        long getId() {
            return this.id;
        }

        TskData.ObjectType getType() {
            return this.type;
        }
    }
}

