/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.sleuthkit.datamodel.EncodedFileUtil;
import org.sleuthkit.datamodel.TskData;

public class EncodedFileOutputStream
extends BufferedOutputStream {
    private TskData.EncodingType type;

    public EncodedFileOutputStream(OutputStream out, TskData.EncodingType type) throws IOException {
        super(out);
        this.type = type;
        this.writeHeader();
    }

    public EncodedFileOutputStream(OutputStream out, int size, TskData.EncodingType type) throws IOException {
        super(out, size);
        this.type = type;
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        this.write(EncodedFileUtil.getEncodedHeader(this.type), 0, EncodedFileUtil.getHeaderLength());
    }

    @Override
    public void write(int b) throws IOException {
        super.write(EncodedFileUtil.encodeByte((byte)b, this.type));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] encodedData = new byte[b.length];
        for (int i = 0; i < b.length; ++i) {
            encodedData[i] = EncodedFileUtil.encodeByte(b[i], this.type);
        }
        super.write(encodedData, off, len);
    }
}

