/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;

public class DerivedFile
extends AbstractFile {
    private volatile DerivedMethod derivedMethod;
    private static final Logger logger = Logger.getLogger(DerivedFile.class.getName());
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private boolean hasDerivedMethod = true;

    DerivedFile(SleuthkitCase db, long objId, long dataSourceObjectId, String name, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, String md5Hash, TskData.FileKnown knownState, String parentPath, String localPath, long parentId, String mimeType, TskData.EncodingType encodingType, String extension) {
        super(db, objId, dataSourceObjectId, TskData.TSK_FS_ATTR_TYPE_ENUM.TSK_FS_ATTR_TYPE_DEFAULT, 0, name, TskData.TSK_DB_FILES_TYPE_ENUM.LOCAL, 0L, 0, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, (short)0, 0, 0, md5Hash, knownState, parentPath, mimeType, extension);
        this.setLocalFilePath(localPath);
        this.setEncodingType(encodingType);
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    public synchronized DerivedMethod getDerivedMethod() throws TskCoreException {
        if (this.derivedMethod == null && this.hasDerivedMethod) {
            try {
                this.derivedMethod = this.getSleuthkitCase().getDerivedMethod(this.getId());
                if (this.derivedMethod == null) {
                    this.hasDerivedMethod = false;
                }
            }
            catch (TskCoreException e) {
                String msg = MessageFormat.format(bundle.getString("DerviedFile.derivedMethod.exception.msg1.text"), this.getId());
                logger.log(Level.WARNING, msg, e);
                throw new TskCoreException(msg, e);
            }
        }
        return this.derivedMethod;
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public <T> T accept(ContentVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String toString(boolean preserveState) {
        return super.toString(preserveState) + "DerivedFile{derivedMethod=" + this.derivedMethod + ", hasDerivedMethod=" + this.hasDerivedMethod + '}';
    }

    @Deprecated
    protected DerivedFile(SleuthkitCase db, long objId, String name, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, String md5Hash, TskData.FileKnown knownState, String parentPath, String localPath, long parentId) {
        this(db, objId, db.getDataSourceObjectId(objId), name, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, md5Hash, knownState, parentPath, localPath, parentId, null, TskData.EncodingType.NONE, null);
    }

    public static class DerivedMethod {
        private final int derivedId;
        private String toolName;
        private String toolVersion;
        private String other;
        private String rederiveDetails;

        public DerivedMethod(int derivedId, String rederiveDetails) {
            this.derivedId = derivedId;
            this.rederiveDetails = rederiveDetails;
            if (this.rederiveDetails == null) {
                this.rederiveDetails = "";
            }
            this.toolName = "";
            this.toolVersion = "";
            this.other = "";
        }

        void setToolName(String toolName) {
            this.toolName = toolName;
        }

        void setToolVersion(String toolVersion) {
            this.toolVersion = toolVersion;
        }

        void setOther(String other) {
            this.other = other;
        }

        public int getDerivedId() {
            return this.derivedId;
        }

        public String getToolName() {
            return this.toolName;
        }

        public String getToolVersion() {
            return this.toolVersion;
        }

        public String getOther() {
            return this.other;
        }

        public String getRederiveDetails() {
            return this.rederiveDetails;
        }

        public String toString() {
            return "DerivedMethod{derived_id=" + this.derivedId + ", toolName=" + this.toolName + ", toolVersion=" + this.toolVersion + ", other=" + this.other + ", rederiveDetails=" + this.rederiveDetails + '}';
        }
    }
}

