import base64
import re
import urlparse
import os
from redteamcore import Resource
from redteamcore import ResourceConnectorFactory

CVE_STRING = r'CVE-\d{4}-\d{1,}'
CVE_PATTERN = re.compile(CVE_STRING)


class ExploitSource(Resource):
    """
    ExploitSource is the source of an exploit or exploits.
    """
    def __init__(self, source_name, location):
        super(ExploitSource, self).__init__(location)
        self.token = 0

        self.source_name = source_name


    def exploits(self):
        exploits = []
        if isinstance(self.data, list):
            for location in self.data:
                data = Resource(location).read()
                exploit = ExploitSource.generate_exploit(data, location, self.source_name)
                exploits.append(exploit)
        elif isinstance(self.data, str):
            exploits.append(ExploitSource.generate_exploit(self.data, self.location, self.source_name))
        return exploits

    @classmethod
    def generate_exploit(cls, data, location, source_name):
        matches = re.findall(CVE_STRING, data, re.MULTILINE)
        if ResourceConnectorFactory.location_is_url(location):
            location_path = urlparse.urlparse(location).path
        elif os.path.isfile(location):
            location_path = location
        location_base = os.path.basename(location_path)
        eid = os.path.splitext(location_base)[0]

        exploit = dict(source=source_name,
                       cves=list(set(matches)),
                       id=eid,
                       exploit=base64.b64encode(data))
        return exploit
