# MAEC Malware Action Classes

# Copyright (c) 2018, The MITRE Corporation
# All rights reserved

from mixbox import fields
from mixbox import idgen

from cybox.core import Action
from cybox.objects.code_object import Code

import maec
from . import _namespace
import maec.bindings.maec_bundle as bundle_binding


class Parameter(maec.Entity):
    _namespace = _namespace
    _binding = bundle_binding
    _binding_class = bundle_binding.ParameterType

    ordinal_position = fields.TypedField("ordinal_position")
    name = fields.TypedField("name")
    value = fields.TypedField("value")


class ParameterList(maec.EntityList):
    _binding_class = bundle_binding.ParameterListType
    _namespace = _namespace
    parameter = fields.TypedField("Parameter", Parameter, multiple=True)


class APICall(maec.Entity):
    _namespace = _namespace
    _binding = bundle_binding
    _binding_class = bundle_binding.APICallType

    function_name = fields.TypedField("function_name")
    normalized_function_name = fields.TypedField("normalized_function_name")
    address = fields.TypedField("Address")
    return_value = fields.TypedField("Return_Value")
    parameters = fields.TypedField("Parameters", ParameterList)


class ActionImplementation(maec.Entity):
    _namespace = _namespace
    _binding = bundle_binding
    _binding_class = bundle_binding.ActionImplementationType

    id_ = fields.TypedField("id")
    type_ = fields.TypedField("type_", key_name = "type")
    #compatible_platforms TODO: Add support
    api_call = fields.TypedField("API_Call", APICall)
    code = fields.TypedField("Code", Code, multiple = True)


class MalwareAction(Action):
    _binding = bundle_binding
    _binding_class = bundle_binding.MalwareActionType
    _namespace = _namespace

    implementation = fields.TypedField("Implementation", ActionImplementation)

    def __init__(self):
        super(MalwareAction, self).__init__()
        self.id_ =  idgen.create_id(prefix="action")
