# Out-EncryptedScript

## SYNOPSIS
Encrypts text files/scripts.

PowerSploit Function: Out-EncryptedScript  
Author: Matthew Graeber (@mattifestation)  
License: BSD 3-Clause  
Required Dependencies: None  
Optional Dependencies: None

## SYNTAX

```
Out-EncryptedScript [-ScriptPath] <String> [-Password] <SecureString> [-Salt] <String>
 [[-InitializationVector] <String>] [[-FilePath] <String>]
```

## DESCRIPTION
Out-EncryptedScript will encrypt a script (or any text file for that
matter) and output the results to a minimally obfuscated script -
evil.ps1 by default.

## EXAMPLES

### -------------------------- EXAMPLE 1 --------------------------
```
$Password = ConvertTo-SecureString 'Password123!' -AsPlainText -Force
```

Out-EncryptedScript .\Naughty-Script.ps1 $Password salty

Description
-----------
Encrypt the contents of this file with a password and salt.
This will
make analysis of the script impossible without the correct password
and salt combination.
This command will generate evil.ps1 that can
dropped onto the victim machine.
It only consists of a decryption
function 'de' and the base64-encoded ciphertext.

### -------------------------- EXAMPLE 2 --------------------------
```
[String] $cmd = Get-Content .\evil.ps1
```

Invoke-Expression $cmd
$decrypted = de password salt
Invoke-Expression $decrypted

Description
-----------
This series of instructions assumes you've already encrypted a script
and named it evil.ps1.
The contents are then decrypted and the
unencrypted script is called via Invoke-Expression

## PARAMETERS

### -ScriptPath
Path to this script

```yaml
Type: String
Parameter Sets: (All)
Aliases: 

Required: True
Position: 1
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -Password
Password to encrypt/decrypt the script

```yaml
Type: SecureString
Parameter Sets: (All)
Aliases: 

Required: True
Position: 2
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -Salt
Salt value for encryption/decryption.
This can be any string value.

```yaml
Type: String
Parameter Sets: (All)
Aliases: 

Required: True
Position: 3
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -InitializationVector
Specifies a 16-character the initialization vector to be used.
This
is randomly generated by default.

```yaml
Type: String
Parameter Sets: (All)
Aliases: 

Required: False
Position: 4
Default value: ((1..16 | ForEach-Object {[Char](Get-Random -Min 0x41 -Max 0x5B)}) -join '')
Accept pipeline input: False
Accept wildcard characters: False
```

### -FilePath
{{Fill FilePath Description}}

```yaml
Type: String
Parameter Sets: (All)
Aliases: 

Required: False
Position: 5
Default value: .\evil.ps1
Accept pipeline input: False
Accept wildcard characters: False
```

## INPUTS

## OUTPUTS

## NOTES
This command can be used to encrypt any text-based file/script

## RELATED LINKS

