/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.spider;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.parosproxy.paros.core.spider.QueueItem;
import org.parosproxy.paros.core.spider.SpiderListener;
import org.parosproxy.paros.core.spider.SpiderParam;
import org.parosproxy.paros.core.spider.SpiderThread;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;

public class Spider {
    private static Log log = LogFactory.getLog(class$org$parosproxy$paros$core$spider$Spider == null ? (class$org$parosproxy$paros$core$spider$Spider = Spider.class$("org.parosproxy.paros.core.spider.Spider")) : class$org$parosproxy$paros$core$spider$Spider);
    private HttpSender httpSender = null;
    private boolean isSubmitForm = true;
    private Vector listenerList = new Vector();
    private ConnectionParam connectionParam = null;
    private Vector queue = new Vector();
    private SpiderThread[] spiderThread = null;
    private SpiderParam spiderParam = null;
    private HashSet seedHostNameSet = new HashSet();
    private int[] depthQueueCount = null;
    private Session session = null;
    private Model model = null;
    private boolean isStop = false;
    private TreeSet visitedGetMethod = null;
    private TreeSet queuedGetMethod = null;
    private Vector visitedPostMethod = new Vector();
    static /* synthetic */ Class class$org$parosproxy$paros$core$spider$Spider;

    public Spider(SpiderParam spiderParam, ConnectionParam connectionParam, Model model) {
        this.connectionParam = connectionParam;
        this.spiderParam = spiderParam;
        this.model = model;
        this.session = model.getSession();
        this.spiderThread = new SpiderThread[spiderParam.getThread()];
        this.depthQueueCount = new int[spiderParam.getMaxDepth() + 1];
        this.visitedGetMethod = new TreeSet();
        this.queuedGetMethod = new TreeSet();
    }

    public void addSpiderListener(SpiderListener spiderListener) {
        this.listenerList.add(spiderListener);
    }

    public void addSeed(URI uRI) {
        try {
            HttpMessage httpMessage = new HttpMessage(uRI);
            this.addSeed(httpMessage);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            httpMalformedHeaderException.printStackTrace();
        }
    }

    public synchronized void addSeed(HttpMessage httpMessage) {
        URI uRI = httpMessage.getRequestHeader().getURI();
        String string = null;
        int n = 80;
        try {
            log.info("seeding " + httpMessage.getRequestHeader().getURI().toString());
            string = uRI.getHost();
            n = uRI.getPort();
            if (n > 0) {
                string = string + ":" + Integer.toString(n);
            }
            this.seedHostNameSet.add(string);
            this.addQueue(httpMessage, 0);
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQueue(HttpMessage httpMessage, int n) {
        QueueItem queueItem = null;
        if (n > this.spiderParam.getMaxDepth() || this.isInVisitedLink(httpMessage)) {
            return false;
        }
        Vector vector = this.queue;
        synchronized (vector) {
            try {
                if (this.isQueued(httpMessage)) {
                    return false;
                }
                queueItem = new QueueItem(this.session, 4, httpMessage);
            }
            catch (Exception exception) {
                return false;
            }
            queueItem.setDepth(n);
            if (this.queue.size() > 0) {
                for (int i = this.queue.size() - 1; i >= 0; --i) {
                    QueueItem queueItem2 = (QueueItem)this.queue.get(i);
                    if (queueItem.getDepth() >= queueItem2.getDepth()) {
                        if (i + 1 <= this.queue.size() - 1) {
                            this.queue.add(i + 1, queueItem);
                        } else {
                            this.queue.add(queueItem);
                        }
                    } else {
                        if (i != 0) continue;
                        this.queue.add(0, queueItem);
                    }
                    break;
                }
            } else {
                this.queue.add(queueItem);
            }
            if (n < this.depthQueueCount.length) {
                int n2 = n;
                this.depthQueueCount[n2] = this.depthQueueCount[n2] + 1;
            }
        }
        if (this.queue.size() % 50 == 0) {
            this.queue.trimToSize();
        }
        return true;
    }

    void checkIfAllThreadCompleted() {
        for (int i = 0; i < this.spiderThread.length; ++i) {
            if (this.spiderThread[i].isCompleted()) continue;
            return;
        }
        this.notifyListenerSpiderComplete();
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }

    public Vector getQueue() {
        return this.queue;
    }

    private void notifyListenerFoundURI(HttpMessage httpMessage, boolean bl) {
        SpiderListener spiderListener = null;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            spiderListener = (SpiderListener)this.listenerList.get(i);
            spiderListener.foundURI(httpMessage, bl);
        }
    }

    private void notifyListenerSpiderComplete() {
        SpiderListener spiderListener = null;
        this.notifyListenerSpiderProgress(null, 100);
        for (int i = 0; i < this.listenerList.size(); ++i) {
            spiderListener = (SpiderListener)this.listenerList.get(i);
            spiderListener.spiderComplete();
        }
        log.info("Spider completed");
        this.getHttpSender().shutdown();
        this.isStop = true;
    }

    synchronized void SpiderProgress(QueueItem queueItem) {
        int n = 100 / (this.spiderParam.getMaxDepth() + 1);
        int n2 = n * queueItem.getDepth();
        int n3 = 0;
        for (int i = 0; i < this.queue.size(); ++i) {
            QueueItem queueItem2 = (QueueItem)this.queue.get(i);
            if (queueItem2 == null || queueItem2.getDepth() > queueItem.getDepth()) continue;
            ++n3;
        }
        n2 += n * (this.depthQueueCount[queueItem.getDepth()] - n3) / this.depthQueueCount[queueItem.getDepth()];
        try {
            this.notifyListenerSpiderProgress(queueItem.getMessage().getRequestHeader().getURI(), n2);
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void notifyListenerSpiderProgress(URI uRI, int n) {
        SpiderListener spiderListener = null;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            spiderListener = (SpiderListener)this.listenerList.get(i);
            spiderListener.spiderProgress(uRI, n, this.visitedPostMethod.size() + this.visitedGetMethod.size(), this.queue.size());
        }
    }

    private void notifyListenerReadURI(HttpMessage httpMessage) {
        SpiderListener spiderListener = null;
        log.info("crawled " + httpMessage.getRequestHeader().getURI().toString());
        for (int i = 0; i < this.listenerList.size(); ++i) {
            spiderListener = (SpiderListener)this.listenerList.get(i);
            spiderListener.readURI(httpMessage);
        }
    }

    public void removeSpiderListener(SpiderListener spiderListener) {
        this.listenerList.remove(spiderListener);
    }

    public SpiderParam getSpiderParam() {
        return this.spiderParam;
    }

    public void setSpiderParam(SpiderParam spiderParam) {
        this.spiderParam = spiderParam;
    }

    public void start() {
        log.info("spider started.");
        this.isStop = false;
        this.httpSender = new HttpSender(this.connectionParam, true);
        this.httpSender.setFollowRedirect(true);
        for (int i = 0; i < this.spiderThread.length; ++i) {
            if (this.spiderThread[i] != null && this.spiderThread[i].isAlive()) {
                this.spiderThread[i].setStop(true);
            }
            this.spiderThread[i] = new SpiderThread(this);
            this.spiderThread[i].start();
        }
    }

    public void stop() {
        this.getHttpSender().shutdown();
        for (int i = 0; i < this.spiderThread.length; ++i) {
            this.spiderThread[i].setStop(true);
            try {
                this.spiderThread[i].join(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        log.info("spider stopped.");
        this.isStop = true;
    }

    public boolean isSeedScope(URI uRI) {
        boolean bl = false;
        String string = null;
        try {
            string = uRI.getHost();
            if (uRI.getPort() > 0) {
                string = string + ":" + uRI.getPort();
            }
            String[] stringArray = this.seedHostNameSet.toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !string.endsWith(stringArray[i])) continue;
                return true;
            }
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
        return false;
    }

    void foundURI(HttpMessage httpMessage, int n) {
        try {
            if (this.isNeglectFound(httpMessage)) {
                httpMessage.getRequestHeader().setMethod("GET");
                if (!this.isInVisitedLink(httpMessage)) {
                    this.notifyListenerFoundURI(httpMessage, true);
                    this.addVisitedLink(httpMessage);
                }
            } else if (this.addQueue(httpMessage, n)) {
                this.notifyListenerFoundURI(httpMessage, false);
            }
        }
        catch (URIException uRIException) {
            // empty catch block
        }
    }

    void readURI(HttpMessage httpMessage) {
        this.notifyListenerReadURI(httpMessage);
    }

    boolean isInVisitedLink(HttpMessage httpMessage) {
        if (httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("GET")) {
            return this.isVisitedGetMethod(httpMessage);
        }
        try {
            if (this.model.getDb().getTableHistory().containsURI(this.session.getSessionId(), 5, httpMessage.getRequestHeader().getMethod(), httpMessage.getRequestHeader().getURI().toString(), httpMessage.getRequestBody().toString())) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addVisitedLink(HttpMessage httpMessage) {
        if (httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("GET")) {
            TreeSet treeSet = this.visitedGetMethod;
            synchronized (treeSet) {
                this.visitedGetMethod.add(httpMessage.getRequestHeader().getURI().toString());
            }
            return;
        }
        QueueItem queueItem = null;
        try {
            queueItem = new QueueItem(this.session, 5, httpMessage);
        }
        catch (Exception exception) {
            return;
        }
        Vector vector = this.visitedPostMethod;
        synchronized (vector) {
            this.visitedPostMethod.add(queueItem);
        }
    }

    boolean isQueued(HttpMessage httpMessage) {
        try {
            return this.model.getDb().getTableHistory().containsURI(this.session.getSessionId(), 4, httpMessage.getRequestHeader().getMethod(), httpMessage.getRequestHeader().getURI().toString(), httpMessage.getRequestBody().toString());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVisitedGetMethod(HttpMessage httpMessage) {
        String string = httpMessage.getRequestHeader().getURI().toString();
        TreeSet treeSet = this.visitedGetMethod;
        synchronized (treeSet) {
            if (this.visitedGetMethod.contains(string)) {
                return true;
            }
        }
        return false;
    }

    private boolean isNeglectFound(HttpMessage httpMessage) throws URIException {
        boolean bl = false;
        URI uRI = httpMessage.getRequestHeader().getURI();
        if (!uRI.getScheme().equalsIgnoreCase("HTTP") && !uRI.getScheme().equalsIgnoreCase("HTTPS")) {
            return true;
        }
        String string = uRI.getHost().toUpperCase();
        return !this.isSeedScope(uRI) && !this.getSpiderParam().isInScope(string);
    }

    public boolean isStop() {
        return this.isStop;
    }

    boolean isAllThreadEmptyQueue() {
        for (int i = 0; i < this.spiderThread.length; ++i) {
            if (this.spiderThread[i].isEmptyQueue()) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

