/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import net.sourceforge.openstego.util.LabelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkerTask
extends SwingWorker<Object, Void> {
    private static LabelUtil labelUtil = LabelUtil.getInstance("OpenStego");
    protected JFrame parent;
    protected Object data;
    protected JProgressBar progressBar;
    protected JButton cancelButton;
    protected GlassPane glass;

    public WorkerTask(JFrame parent, Object data, boolean determinate) {
        this.parent = parent;
        this.data = data;
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setPreferredSize(new Dimension(300, 20));
        this.progressBar.setValue(0);
        if (determinate) {
            this.progressBar.setStringPainted(true);
        } else {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setStringPainted(false);
        }
        this.glass = new GlassPane();
        this.glass.setSize(parent.getSize());
        this.glass.setOpaque(false);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createBevelBorder(0));
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 1;
        g.anchor = 17;
        g.gridx = 0;
        g.gridy = 0;
        g.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)new JLabel(labelUtil.getString("gui.label.progress.processing")), g);
        g.fill = 1;
        g.gridx = 0;
        g.gridy = 1;
        g.insets = new Insets(0, 10, 10, 10);
        panel.add((Component)this.progressBar, g);
        this.cancelButton = new JButton(labelUtil.getString("gui.label.progress.cancel"));
        g.fill = 0;
        g.anchor = 13;
        g.gridx = 0;
        g.gridy = 2;
        g.insets = new Insets(0, 10, 10, 10);
        panel.add((Component)this.cancelButton, g);
        this.glass.setLayout(new GridBagLayout());
        g.fill = 0;
        g.anchor = 10;
        g.gridx = 0;
        g.gridy = 0;
        this.glass.add((Component)panel, g);
        this.parent.setGlassPane(this.glass);
    }

    @Override
    protected void done() {
        this.glass.setVisible(false);
    }

    public void start() {
        Listener listener = new Listener(this);
        this.glass.setVisible(true);
        this.cancelButton.addActionListener(listener);
        this.addPropertyChangeListener(listener);
        this.execute();
    }

    class GlassPane
    extends JPanel
    implements MouseListener,
    FocusListener {
        public GlassPane() {
            this.addMouseListener(this);
            this.addFocusListener(this);
        }

        public void paintComponent(Graphics g) {
            g.setColor(new Color(0.5f, 0.5f, 0.5f, 0.5f));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.requestFocus();
            }
            super.setVisible(visible);
        }

        public void focusLost(FocusEvent fe) {
            if (this.isVisible()) {
                this.requestFocus();
            }
        }

        public void focusGained(FocusEvent fe) {
        }

        public void mouseClicked(MouseEvent arg0) {
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }

        public void mousePressed(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }
    }

    class Listener
    implements PropertyChangeListener,
    ActionListener {
        WorkerTask task;

        public Listener(WorkerTask task) {
            this.task = task;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("progress".equals(evt.getPropertyName())) {
                int progress = (Integer)evt.getNewValue();
                this.task.progressBar.setValue(progress);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.task.cancel(true);
        }
    }
}

