/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JAccordion
extends JPanel
implements ActionListener {
    private static final Color BORDER_COLOR = Color.DARK_GRAY.brighter();
    private JPanel topPanel = new JPanel(new GridLayout(1, 1));
    private JPanel bottomPanel = new JPanel(new GridLayout(1, 1));
    private Map<String, TabInfo> tabs = new LinkedHashMap<String, TabInfo>();
    private int visibleTab = 0;
    private JPanel visibleComponent = null;

    public JAccordion() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, BORDER_COLOR));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.topPanel, c);
        c.gridy = 2;
        this.add((Component)this.bottomPanel, c);
        this.visibleComponent = new JPanel();
        this.visibleComponent.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BORDER_COLOR));
    }

    public void addTab(String name, JComponent component) {
        this.addTab(name, null, component);
    }

    public void addTab(String name, Icon icon, JComponent component) {
        component.setOpaque(false);
        TabInfo tabInfo = new TabInfo(name, icon, component);
        tabInfo.getHeader().getButton().addActionListener(this);
        this.tabs.put(name, tabInfo);
        this.render();
    }

    public void removeTab(String name) {
        this.tabs.remove(name);
        this.render();
    }

    public int getVisibleTab() {
        return this.visibleTab;
    }

    public void setVisibleTab(int visibleTab) {
        if (visibleTab > 0 && visibleTab < this.tabs.size() - 1) {
            this.visibleTab = visibleTab;
            this.render();
        }
    }

    public void render() {
        int totalTabs = this.tabs.size();
        int topTabs = this.visibleTab + 1;
        int bottomTabs = totalTabs - topTabs;
        Iterator<String> itr = this.tabs.keySet().iterator();
        this.topPanel.removeAll();
        GridLayout topLayout = (GridLayout)this.topPanel.getLayout();
        topLayout.setRows(topTabs);
        TabInfo tabInfo = null;
        for (int i = 0; i < topTabs; ++i) {
            String tabName = itr.next();
            tabInfo = this.tabs.get(tabName);
            this.topPanel.add(tabInfo.getHeader());
        }
        this.topPanel.validate();
        this.visibleComponent.removeAll();
        this.visibleComponent.add((Component)tabInfo.getComponent(), "North");
        this.visibleComponent.validate();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.visibleComponent, c);
        this.bottomPanel.removeAll();
        GridLayout bottomLayout = (GridLayout)this.bottomPanel.getLayout();
        bottomLayout.setRows(bottomTabs);
        for (int i = 0; i < bottomTabs; ++i) {
            String tabName = itr.next();
            tabInfo = this.tabs.get(tabName);
            this.bottomPanel.add(tabInfo.getHeader());
        }
        this.bottomPanel.validate();
        this.validate();
    }

    public void actionPerformed(ActionEvent e) {
        int currentTab = 0;
        for (String tabName : this.tabs.keySet()) {
            TabInfo tabInfo = this.tabs.get(tabName);
            if (tabInfo.getHeader().getButton() == e.getSource()) {
                this.visibleTab = currentTab;
                this.render();
                return;
            }
            ++currentTab;
        }
    }

    class GradientPanel
    extends JPanel {
        private Color startColor;
        private Color endColor;

        public GradientPanel(Color startColor, Color endColor) {
            this.startColor = startColor;
            this.endColor = endColor;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int panelHeight = this.getHeight();
            int panelWidth = this.getWidth();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.startColor, 0.0f, panelHeight, this.endColor);
            if (g instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)g;
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, panelWidth, panelHeight);
            }
        }
    }

    class TabHeader
    extends GradientPanel {
        private JButton button;

        public TabHeader(String name) {
            this(name, null);
        }

        public TabHeader(String name, Icon icon) {
            super(new JPanel().getBackground(), new JPanel().getBackground().darker());
            this.createButton(name, icon);
            this.setLayout(new GridLayout(1, 1));
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BORDER_COLOR));
            this.add(this.button);
        }

        public JButton getButton() {
            return this.button;
        }

        private void createButton(String name, Icon icon) {
            this.button = new JButton(name, icon);
            this.button.setContentAreaFilled(false);
            this.button.setOpaque(false);
            this.button.setMargin(new Insets(3, 3, 3, 3));
            this.button.setFont(this.button.getFont().deriveFont(1));
            this.button.setFocusable(false);
        }
    }

    class TabInfo {
        private String name;
        private TabHeader header;
        private JComponent component;

        public TabInfo(String name, JComponent component) {
            this(name, null, component);
        }

        public TabInfo(String name, Icon icon, JComponent component) {
            this.name = name;
            this.component = component;
            this.header = new TabHeader(name, icon);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TabHeader getHeader() {
            return this.header;
        }

        public JComponent getComponent() {
            return this.component;
        }
    }
}

