/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.util.dwt;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.openstego.util.dwt.Filter;
import net.sourceforge.openstego.util.dwt.FilterGH;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterXMLReader {
    private FilterXMLReader() {
    }

    public static Map<Integer, FilterGH> parse(String fileURI) {
        HashMap<Integer, FilterGH> filterGHMap = new HashMap<Integer, FilterGH>();
        DocumentBuilder db = null;
        Document dom = null;
        Element el = null;
        NodeList nl = null;
        FilterGH filterGH = null;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            dom = db.parse(db.getClass().getResourceAsStream(fileURI));
            nl = dom.getDocumentElement().getElementsByTagName("filterGH");
            if (nl != null && nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    el = (Element)nl.item(i);
                    filterGH = FilterXMLReader.getFilterGH(el);
                    filterGHMap.put(filterGH.getId(), filterGH);
                }
            }
            return filterGHMap;
        }
        catch (ParserConfigurationException pcEx) {
            pcEx.printStackTrace();
            throw new IllegalArgumentException("Invalid Filter XML file");
        }
        catch (SAXException saxEx) {
            saxEx.printStackTrace();
            throw new IllegalArgumentException("Invalid Filter XML file");
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            throw new IllegalArgumentException("Invalid Filter XML file");
        }
    }

    private static FilterGH getFilterGH(Element el) {
        FilterGH filterGH = new FilterGH();
        Element innerEl = null;
        NodeList nl = null;
        Filter filter = null;
        filterGH.setId(new Integer(el.getAttribute("id")));
        filterGH.setName(el.getAttribute("name"));
        filterGH.setType(el.getAttribute("type"));
        nl = el.getElementsByTagName("filter");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                innerEl = (Element)nl.item(i);
                filter = FilterXMLReader.getFilter(innerEl);
                filter.setHiPass((i & 1) != 1);
                if (i == 0) {
                    filterGH.setG(filter);
                    continue;
                }
                if (i == 1) {
                    filterGH.setH(filter);
                    continue;
                }
                if (i == 2) {
                    filterGH.setGi(filter);
                    continue;
                }
                if (i != 3) continue;
                filterGH.setHi(filter);
            }
        }
        return filterGH;
    }

    private static Filter getFilter(Element el) {
        Filter filter = new Filter();
        Element innerEl = null;
        NodeList nl = null;
        double[] data = null;
        filter.setType(el.getAttribute("type"));
        filter.setStart(Integer.parseInt(el.getAttribute("start")));
        filter.setEnd(Integer.parseInt(el.getAttribute("end")));
        nl = el.getElementsByTagName("data");
        if (nl != null && nl.getLength() > 0) {
            data = new double[nl.getLength()];
            for (int i = 0; i < nl.getLength(); ++i) {
                innerEl = (Element)nl.item(i);
                data[i] = Double.parseDouble(innerEl.getFirstChild().getNodeValue());
            }
        }
        filter.setData(data);
        return filter;
    }
}

