/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.util.dwt;

import java.util.Map;
import net.sourceforge.openstego.util.ImageUtil;
import net.sourceforge.openstego.util.dwt.DWTUtil;
import net.sourceforge.openstego.util.dwt.FilterGH;
import net.sourceforge.openstego.util.dwt.FilterXMLReader;
import net.sourceforge.openstego.util.dwt.Image;
import net.sourceforge.openstego.util.dwt.ImageTree;

public class DWT {
    private static Map<Integer, FilterGH> filterGHMap = null;
    private String filterFile = "/net/sourceforge/openstego/util/dwt/filters.xml";
    private FilterGH[] filters = null;
    private int method = 0;
    private int cols = 0;
    private int rows = 0;
    private int level = 0;

    public DWT(int cols, int rows, int filterID, int level, int method) {
        if (filterGHMap == null) {
            filterGHMap = FilterXMLReader.parse(this.filterFile);
        }
        this.filters = new FilterGH[level + 1];
        for (int i = 0; i <= level; ++i) {
            this.filters[i] = filterGHMap.get(new Integer(filterID));
        }
        this.level = level;
        this.method = method;
        this.cols = cols;
        this.rows = rows;
    }

    public ImageTree forwardDWT(int[][] pixels) {
        Image image = null;
        ImageTree tree = null;
        image = new Image(this.cols, this.rows);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                DWTUtil.setPixel(image, j, i, pixels[i][j]);
            }
        }
        tree = DWTUtil.waveletTransform(image, this.level, this.filters, this.method);
        return tree;
    }

    public ImageTree forwardDWTwp(int[][] pixels) {
        Image image = null;
        ImageTree tree = null;
        image = new Image(this.cols, this.rows);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                DWTUtil.setPixel(image, j, i, pixels[i][j]);
            }
        }
        tree = DWTUtil.waveletTransformWp(image, 0, this.level, this.filters, this.method);
        return tree;
    }

    public void inverseDWT(ImageTree dwts, int[][] pixels) {
        Image image = null;
        image = DWTUtil.inverseTransform(dwts, this.filters, this.method + 1);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                pixels[i][j] = ImageUtil.pixelRange((int)(DWTUtil.getPixel(image, j, i) + 0.5));
            }
        }
    }
}

