/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.openstego.OpenStegoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private StringUtil() {
    }

    public static String getHexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (int i = 0; i < raw.length; ++i) {
            int byteVal = raw[i] & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[byteVal >>> 4];
            hex[index++] = HEX_CHAR_TABLE[byteVal & 0xF];
        }
        return new String(hex);
    }

    public static long passwordHash(String password) {
        long DEFAULT_HASH = 98234782L;
        byte[] byteHash = null;
        String hexString = null;
        if (password == null || password.equals("")) {
            return 98234782L;
        }
        try {
            byteHash = MessageDigest.getInstance("MD5").digest(password.getBytes());
            hexString = StringUtil.getHexString(byteHash);
            hexString = hexString.substring(0, 15);
            return Long.parseLong(hexString, 16);
        }
        catch (NoSuchAlgorithmException nsaEx) {
            return 98234782L;
        }
    }

    public static List<String> getStringLines(String input) throws OpenStegoException {
        String str = null;
        ArrayList<String> stringList = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(input));
            while ((str = reader.readLine()) != null) {
                if ((str = str.trim()).equals("") || str.startsWith("#")) continue;
                stringList.add(str.trim());
            }
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
        return stringList;
    }

    public static boolean isNullOrEmpty(String val) {
        return val == null || val.length() == 0;
    }
}

