/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class LabelUtil {
    private static Map<String, ResourceBundle> map = new HashMap<String, ResourceBundle>();
    private static Map<String, LabelUtil> namespaceMap = new HashMap<String, LabelUtil>();
    private String namespace = null;

    public static void addNamespace(String namespace, String bundle) {
        map.put(namespace, ResourceBundle.getBundle(bundle, Locale.getDefault()));
    }

    public static LabelUtil getInstance(String namespace) {
        LabelUtil util = null;
        util = namespaceMap.get(namespace);
        if (util == null) {
            util = new LabelUtil(namespace);
            namespaceMap.put(namespace, util);
        }
        return util;
    }

    protected LabelUtil(String namespace) {
        this.namespace = namespace;
    }

    public String getString(String key) {
        return map.get(this.namespace).getString(key);
    }

    public String getString(String key, Object ... parameters) {
        return MessageFormat.format(this.getString(key), parameters);
    }
}

