/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.util;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.sourceforge.openstego.OpenStegoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtil {
    private CommonUtil() {
    }

    public static byte[] getStreamBytes(InputStream is) throws OpenStegoException {
        int BUF_SIZE = 512;
        ByteArrayOutputStream bos = null;
        int bytesRead = 0;
        byte[] data = null;
        try {
            data = new byte[512];
            bos = new ByteArrayOutputStream();
            while ((bytesRead = is.read(data, 0, 512)) >= 0) {
                bos.write(data, 0, bytesRead);
            }
            is.close();
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
    }

    public static byte[] getFileBytes(File file) throws OpenStegoException {
        try {
            return CommonUtil.getStreamBytes(new FileInputStream(file));
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
    }

    public static void writeFile(byte[] fileData, String fileName) throws OpenStegoException {
        File file = null;
        if (fileName != null) {
            file = new File(fileName);
        }
        CommonUtil.writeFile(fileData, file);
    }

    public static void writeFile(byte[] fileData, File file) throws OpenStegoException {
        OutputStream os = null;
        try {
            os = file == null ? System.out : new FileOutputStream(file);
            os.write(fileData);
            os.close();
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
    }

    public static void setEnabled(JTextField textField, boolean enabled) {
        if (enabled) {
            textField.setEnabled(true);
            textField.setBackground(Color.WHITE);
        } else {
            textField.setEnabled(false);
            textField.setBackground(UIManager.getColor("Panel.background"));
        }
    }

    public static List<File> parseFileList(String fileList, String delimiter) {
        int index = 0;
        StringTokenizer tokenizer = null;
        String fileName = null;
        String dirName = null;
        ArrayList<File> output = new ArrayList<File>();
        File fileDir = null;
        File[] arrFile = null;
        if (fileList == null) {
            return output;
        }
        tokenizer = new StringTokenizer(fileList, delimiter);
        while (tokenizer.hasMoreTokens()) {
            fileName = tokenizer.nextToken().trim();
            index = fileName.lastIndexOf(File.separator);
            if (index >= 0) {
                dirName = fileName.substring(0, index);
                fileName = fileName.substring(index + 1);
            } else {
                dirName = ".";
            }
            fileName = CommonUtil.replaceWildcards(fileName);
            fileDir = new File(dirName.equals("") ? "." : dirName);
            arrFile = fileDir.listFiles(new WildcardFilenameFilter(fileName));
            for (int i = 0; i < arrFile.length; ++i) {
                output.add(arrFile[i]);
            }
        }
        return output;
    }

    public static int byteToInt(int b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        return i;
    }

    private static String replaceWildcards(String input) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '*') {
                buffer.append(".*");
                continue;
            }
            if (chars[i] == '?') {
                buffer.append(".{1}");
                continue;
            }
            if ("+()^$.{}[]|\\".indexOf(chars[i]) != -1) {
                buffer.append('\\').append(chars[i]);
                continue;
            }
            buffer.append(chars[i]);
        }
        return buffer.toString();
    }

    public static int floorHalf(int num) {
        if ((num & 1) == 1) {
            return (num - 1) / 2;
        }
        return num / 2;
    }

    public static int ceilingHalf(int num) {
        if ((num & 1) == 1) {
            return (num + 1) / 2;
        }
        return num / 2;
    }

    public static int mod(int num, int div) {
        if (num < 0) {
            return div - -num % div;
        }
        return num % div;
    }

    public static int max(int x, int y) {
        return x > y ? x : y;
    }

    public static double max(double x, double y) {
        return x > y ? x : y;
    }

    public static int min(int x, int y) {
        return x < y ? x : y;
    }

    public static double min(double x, double y) {
        return x < y ? x : y;
    }

    static class WildcardFilenameFilter
    implements FilenameFilter {
        String filter = null;

        public WildcardFilenameFilter(String filter) {
            this.filter = filter.toLowerCase();
        }

        public boolean accept(File dir, String name) {
            return name.toLowerCase().matches(this.filter);
        }
    }
}

