/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import net.sourceforge.openstego.ui.EmbedPanel;
import net.sourceforge.openstego.ui.EmbedWatermarkPanel;
import net.sourceforge.openstego.ui.ExtractPanel;
import net.sourceforge.openstego.ui.GenerateSignaturePanel;
import net.sourceforge.openstego.ui.VerifyWatermarkPanel;
import net.sourceforge.openstego.util.LabelUtil;
import net.sourceforge.openstego.util.ui.JAccordion;

public class OpenStegoFrame
extends JFrame {
    private static final long serialVersionUID = -880718904125121559L;
    private static final boolean toggleUiHack = false;
    private static LabelUtil labelUtil = LabelUtil.getInstance("OpenStego");
    private JMenuBar topMenuBar;
    private JMenu fileMenu;
    private JMenuItem fileExitMenuItem;
    private JMenu helpMenu;
    private JMenuItem helpAboutMenuItem;
    private JPanel mainContentPane;
    private JScrollPane accordionPane;
    private JAccordion accordion;
    private JPanel dhPanel;
    private JPanel wmPanel;
    private ButtonGroup actionButtonGroup = new ButtonGroup();
    private JToggleButton embedButton;
    private JToggleButton extractButton;
    private JToggleButton genSigButton;
    private JToggleButton signWmButton;
    private JToggleButton verifyWmButton;
    private JPanel headerPanel;
    private JLabel header;
    private JPanel mainPanel;
    private EmbedPanel embedPanel;
    private ExtractPanel extractPanel;
    private GenerateSignaturePanel genSigPanel;
    private EmbedWatermarkPanel embedWmPanel;
    private VerifyWatermarkPanel verifyWmPanel;

    public OpenStegoFrame() {
        this.initialize();
        this.setActionCommands();
        this.setupUI();
    }

    public JMenuBar getTopMenuBar() {
        if (this.topMenuBar == null) {
            this.topMenuBar = new JMenuBar();
            this.topMenuBar.add(this.getFileMenu());
            this.topMenuBar.add(this.getHelpMenu());
        }
        return this.topMenuBar;
    }

    public JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu(labelUtil.getString("gui.menu.file"));
            this.fileMenu.setMnemonic(70);
            this.fileMenu.add(this.getFileExitMenuItem());
        }
        return this.fileMenu;
    }

    public JMenuItem getFileExitMenuItem() {
        if (this.fileExitMenuItem == null) {
            this.fileExitMenuItem = new JMenuItem(labelUtil.getString("gui.menu.file.exit"));
            this.fileExitMenuItem.setMnemonic(88);
        }
        return this.fileExitMenuItem;
    }

    public JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu(labelUtil.getString("gui.menu.help"));
            this.helpMenu.setMnemonic(72);
            this.helpMenu.add(this.getHelpAboutMenuItem());
        }
        return this.helpMenu;
    }

    public JMenuItem getHelpAboutMenuItem() {
        if (this.helpAboutMenuItem == null) {
            this.helpAboutMenuItem = new JMenuItem(labelUtil.getString("gui.menu.help.about"));
            this.helpAboutMenuItem.setMnemonic(65);
        }
        return this.helpAboutMenuItem;
    }

    public JPanel getMainContentPane() {
        if (this.mainContentPane == null) {
            this.mainContentPane = new JPanel();
            this.mainContentPane.setLayout(new GridBagLayout());
            GridBagConstraints g = new GridBagConstraints();
            g.gridx = 0;
            g.gridy = 0;
            g.gridheight = 2;
            g.weightx = 0.0;
            g.fill = 3;
            this.mainContentPane.add((Component)this.getAccordionPane(), g);
            g = new GridBagConstraints();
            g.gridx = 1;
            g.gridy = 0;
            g.weighty = 0.0;
            g.fill = 2;
            this.mainContentPane.add((Component)this.getHeaderPanel(), g);
            g = new GridBagConstraints();
            g.gridx = 1;
            g.gridy = 1;
            g.weightx = 1.0;
            g.weighty = 1.0;
            g.fill = 1;
            this.mainContentPane.add((Component)this.getMainPanel(), g);
        }
        return this.mainContentPane;
    }

    public JScrollPane getAccordionPane() {
        if (this.accordionPane == null) {
            this.accordionPane = new JScrollPane();
            this.accordionPane.setBorder(null);
            this.accordionPane.setViewportView(this.getAccordion());
            this.accordionPane.setPreferredSize(new Dimension(200, 0));
        }
        return this.accordionPane;
    }

    public JAccordion getAccordion() {
        if (this.accordion == null) {
            this.accordion = new JAccordion();
            this.accordion.addTab(labelUtil.getString("gui.label.tabHeader.dataHiding"), this.getDhPanel());
            this.accordion.addTab(labelUtil.getString("gui.label.tabHeader.watermarking"), this.getWmPanel());
        }
        return this.accordion;
    }

    public JPanel getDhPanel() {
        if (this.dhPanel == null) {
            this.dhPanel = new JPanel();
            this.dhPanel.setLayout(new GridLayout(0, 1));
            this.dhPanel.add(this.getEmbedButton());
            this.dhPanel.add(this.getExtractButton());
        }
        return this.dhPanel;
    }

    public JPanel getWmPanel() {
        if (this.wmPanel == null) {
            this.wmPanel = new JPanel();
            this.wmPanel.setLayout(new GridLayout(0, 1));
            this.wmPanel.add(this.getGenSigButton());
            this.wmPanel.add(this.getSignWmButton());
            this.wmPanel.add(this.getVerifyWmButton());
        }
        return this.wmPanel;
    }

    public JToggleButton getEmbedButton() {
        if (this.embedButton == null) {
            this.embedButton = new JToggleButton(labelUtil.getString("gui.label.tab.dhEmbed"), new ImageIcon(this.getClass().getResource("/image/EmbedIcon.png")), true);
            this.embedButton.setVerticalTextPosition(3);
            this.embedButton.setHorizontalTextPosition(0);
            this.embedButton.setFocusable(false);
            this.actionButtonGroup.add(this.embedButton);
        }
        return this.embedButton;
    }

    public JToggleButton getExtractButton() {
        if (this.extractButton == null) {
            this.extractButton = new JToggleButton(labelUtil.getString("gui.label.tab.dhExtract"), new ImageIcon(this.getClass().getResource("/image/ExtractIcon.png")));
            this.extractButton.setVerticalTextPosition(3);
            this.extractButton.setHorizontalTextPosition(0);
            this.extractButton.setFocusable(false);
            this.actionButtonGroup.add(this.extractButton);
        }
        return this.extractButton;
    }

    public JToggleButton getGenSigButton() {
        if (this.genSigButton == null) {
            this.genSigButton = new JToggleButton(labelUtil.getString("gui.label.tab.wmGenSig"), new ImageIcon(this.getClass().getResource("/image/EmbedIcon.png")));
            this.genSigButton.setVerticalTextPosition(3);
            this.genSigButton.setHorizontalTextPosition(0);
            this.genSigButton.setFocusable(false);
            this.actionButtonGroup.add(this.genSigButton);
        }
        return this.genSigButton;
    }

    public JToggleButton getSignWmButton() {
        if (this.signWmButton == null) {
            this.signWmButton = new JToggleButton(labelUtil.getString("gui.label.tab.wmEmbed"), new ImageIcon(this.getClass().getResource("/image/EmbedIcon.png")));
            this.signWmButton.setVerticalTextPosition(3);
            this.signWmButton.setHorizontalTextPosition(0);
            this.signWmButton.setFocusable(false);
            this.actionButtonGroup.add(this.signWmButton);
        }
        return this.signWmButton;
    }

    public JToggleButton getVerifyWmButton() {
        if (this.verifyWmButton == null) {
            this.verifyWmButton = new JToggleButton(labelUtil.getString("gui.label.tab.wmVerify"), new ImageIcon(this.getClass().getResource("/image/ExtractIcon.png")));
            this.verifyWmButton.setVerticalTextPosition(3);
            this.verifyWmButton.setHorizontalTextPosition(0);
            this.verifyWmButton.setFocusable(false);
            this.actionButtonGroup.add(this.verifyWmButton);
        }
        return this.verifyWmButton;
    }

    public JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, Color.DARK_GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.headerPanel.setLayout(new GridLayout());
            this.headerPanel.add(this.getHeader());
        }
        return this.headerPanel;
    }

    public JLabel getHeader() {
        if (this.header == null) {
            this.header = new JLabel();
            this.header.setFont(this.header.getFont().deriveFont(1, this.header.getFont().getSize2D() + 3.0f));
        }
        return this.header;
    }

    public JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.DARK_GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.mainPanel.setLayout(new GridLayout());
        }
        return this.mainPanel;
    }

    public EmbedPanel getEmbedPanel() {
        if (this.embedPanel == null) {
            this.embedPanel = new EmbedPanel();
        }
        return this.embedPanel;
    }

    public ExtractPanel getExtractPanel() {
        if (this.extractPanel == null) {
            this.extractPanel = new ExtractPanel();
        }
        return this.extractPanel;
    }

    public GenerateSignaturePanel getGenSigPanel() {
        if (this.genSigPanel == null) {
            this.genSigPanel = new GenerateSignaturePanel();
        }
        return this.genSigPanel;
    }

    public EmbedWatermarkPanel getEmbedWmPanel() {
        if (this.embedWmPanel == null) {
            this.embedWmPanel = new EmbedWatermarkPanel();
        }
        return this.embedWmPanel;
    }

    public VerifyWatermarkPanel getVerifyWmPanel() {
        if (this.verifyWmPanel == null) {
            this.verifyWmPanel = new VerifyWatermarkPanel();
        }
        return this.verifyWmPanel;
    }

    private void setupUI() {
        if (Locale.getDefault().getLanguage().equals(Locale.JAPANESE.getLanguage())) {
            Object key = null;
            Object value = null;
            Enumeration keys = UIManager.getDefaults().keys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                value = UIManager.get(key);
                if (!(value instanceof FontUIResource)) continue;
                UIManager.put(key, ((FontUIResource)value).deriveFont(12.0f));
            }
            this.getMainContentPane().setFont(new Font("Japanese", 0, 12));
        }
    }

    private void initialize() {
        this.setContentPane(this.getMainContentPane());
        this.setTitle(labelUtil.getString("gui.window.title"));
        this.setJMenuBar(this.getTopMenuBar());
        this.getMainPanel().add(this.getEmbedPanel());
        this.getHeader().setText(labelUtil.getString("gui.label.panelHeader.dhEmbed"));
    }

    private void setActionCommands() {
        this.getFileExitMenuItem().setActionCommand("MENU_FILE_EXIT");
        this.getHelpAboutMenuItem().setActionCommand("MENU_HELP_ABOUT");
        this.getEmbedButton().setActionCommand("SWITCH_DH_EMBED");
        this.getExtractButton().setActionCommand("SWITCH_DH_EXTRACT");
        this.getGenSigButton().setActionCommand("SWITCH_WM_GENSIG");
        this.getSignWmButton().setActionCommand("SWITCH_WM_EMBED");
        this.getVerifyWmButton().setActionCommand("SWITCH_WM_VERIFY");
        this.getEmbedPanel().getMsgFileButton().setActionCommand("BROWSE_DH_EMB_MSGFILE");
        this.getEmbedPanel().getCoverFileButton().setActionCommand("BROWSE_DH_EMB_CVRFILE");
        this.getEmbedPanel().getStegoFileButton().setActionCommand("BROWSE_DH_EMB_STGFILE");
        this.getEmbedPanel().getRunEmbedButton().setActionCommand("RUN_DH_EMBED");
        this.getExtractPanel().getInputStegoFileButton().setActionCommand("BROWSE_DH_EXT_STGFILE");
        this.getExtractPanel().getOutputFolderButton().setActionCommand("BROWSE_DH_EXT_OUTDIR");
        this.getExtractPanel().getRunExtractButton().setActionCommand("RUN_DH_EXTRACT");
        this.getGenSigPanel().getSignatureFileButton().setActionCommand("BROWSE_WM_GSG_SIGFILE");
        this.getGenSigPanel().getRunGenSigButton().setActionCommand("RUN_WM_GENSIG");
        this.getEmbedWmPanel().getFileForWmButton().setActionCommand("BROWSE_WM_EMB_INPFILE");
        this.getEmbedWmPanel().getSignatureFileButton().setActionCommand("BROWSE_WM_EMB_SIGFILE");
        this.getEmbedWmPanel().getOutputWmFileButton().setActionCommand("BROWSE_WM_EMB_OUTFILE");
        this.getEmbedWmPanel().getRunEmbedWmButton().setActionCommand("RUN_WM_EMBED");
        this.getVerifyWmPanel().getInputFileButton().setActionCommand("BROWSE_WM_VER_INPFILE");
        this.getVerifyWmPanel().getSignatureFileButton().setActionCommand("BROWSE_WM_VER_SIGFILE");
        this.getVerifyWmPanel().getRunVerifyWmButton().setActionCommand("RUN_WM_VERIFY");
    }

    public static interface ActionCommands {
        public static final String MENU_FILE_EXIT = "MENU_FILE_EXIT";
        public static final String MENU_HELP_ABOUT = "MENU_HELP_ABOUT";
        public static final String SWITCH_DH_EMBED = "SWITCH_DH_EMBED";
        public static final String SWITCH_DH_EXTRACT = "SWITCH_DH_EXTRACT";
        public static final String SWITCH_WM_GENSIG = "SWITCH_WM_GENSIG";
        public static final String SWITCH_WM_EMBED = "SWITCH_WM_EMBED";
        public static final String SWITCH_WM_VERIFY = "SWITCH_WM_VERIFY";
        public static final String BROWSE_DH_EMB_MSGFILE = "BROWSE_DH_EMB_MSGFILE";
        public static final String BROWSE_DH_EMB_CVRFILE = "BROWSE_DH_EMB_CVRFILE";
        public static final String BROWSE_DH_EMB_STGFILE = "BROWSE_DH_EMB_STGFILE";
        public static final String RUN_DH_EMBED = "RUN_DH_EMBED";
        public static final String BROWSE_DH_EXT_STGFILE = "BROWSE_DH_EXT_STGFILE";
        public static final String BROWSE_DH_EXT_OUTDIR = "BROWSE_DH_EXT_OUTDIR";
        public static final String RUN_DH_EXTRACT = "RUN_DH_EXTRACT";
        public static final String BROWSE_WM_GSG_SIGFILE = "BROWSE_WM_GSG_SIGFILE";
        public static final String RUN_WM_GENSIG = "RUN_WM_GENSIG";
        public static final String BROWSE_WM_EMB_INPFILE = "BROWSE_WM_EMB_INPFILE";
        public static final String BROWSE_WM_EMB_SIGFILE = "BROWSE_WM_EMB_SIGFILE";
        public static final String BROWSE_WM_EMB_OUTFILE = "BROWSE_WM_EMB_OUTFILE";
        public static final String RUN_WM_EMBED = "RUN_WM_EMBED";
        public static final String BROWSE_WM_VER_INPFILE = "BROWSE_WM_VER_INPFILE";
        public static final String BROWSE_WM_VER_SIGFILE = "BROWSE_WM_VER_SIGFILE";
        public static final String RUN_WM_VERIFY = "RUN_WM_VERIFY";
    }
}

