/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.plugin.template.image;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.openstego.OpenStegoConfig;
import net.sourceforge.openstego.OpenStegoException;
import net.sourceforge.openstego.WatermarkingPlugin;
import net.sourceforge.openstego.ui.OpenStegoUI;
import net.sourceforge.openstego.ui.PluginEmbedOptionsUI;
import net.sourceforge.openstego.util.ImageUtil;
import net.sourceforge.openstego.util.cmd.CmdLineOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WMImagePluginTemplate
extends WatermarkingPlugin {
    protected static List<String> readFormats = null;
    protected static List<String> writeFormats = null;

    @Override
    public final byte[] getDiff(byte[] stegoData, String stegoFileName, byte[] coverData, String coverFileName, String diffFileName) throws OpenStegoException {
        BufferedImage stegoImage = null;
        BufferedImage coverImage = null;
        BufferedImage diffImage = null;
        stegoImage = ImageUtil.byteArrayToImage(stegoData, stegoFileName);
        coverImage = ImageUtil.byteArrayToImage(coverData, coverFileName);
        diffImage = ImageUtil.getDiffImage(stegoImage, coverImage);
        return ImageUtil.imageToByteArray(diffImage, diffFileName, this);
    }

    @Override
    public List<String> getReadableFileExtensions() throws OpenStegoException {
        if (readFormats != null) {
            return readFormats;
        }
        String format = null;
        String[] formats = null;
        readFormats = new ArrayList<String>();
        formats = ImageIO.getReaderFormatNames();
        for (int i = 0; i < formats.length; ++i) {
            format = formats[i].toLowerCase();
            if (format.indexOf("jpeg") >= 0 && format.indexOf("2000") >= 0) {
                format = "jp2";
            }
            if (readFormats.contains(format)) continue;
            readFormats.add(format);
        }
        Collections.sort(readFormats);
        return readFormats;
    }

    @Override
    public List<String> getWritableFileExtensions() throws OpenStegoException {
        if (writeFormats != null) {
            return writeFormats;
        }
        String format = null;
        String[] formats = null;
        writeFormats = new ArrayList<String>();
        formats = ImageIO.getWriterFormatNames();
        for (int i = 0; i < formats.length; ++i) {
            format = formats[i].toLowerCase();
            if (format.indexOf("jpeg") >= 0 && format.indexOf("2000") >= 0) {
                format = "jp2";
            }
            if (writeFormats.contains(format)) continue;
            writeFormats.add(format);
        }
        Collections.sort(writeFormats);
        return writeFormats;
    }

    @Override
    public PluginEmbedOptionsUI getEmbedOptionsUI(OpenStegoUI stegoUI) throws OpenStegoException {
        return null;
    }

    @Override
    public void populateStdCmdLineOptions(CmdLineOptions options) throws OpenStegoException {
    }

    @Override
    public Class<? extends OpenStegoConfig> getConfigClass() {
        return OpenStegoConfig.class;
    }
}

