/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.plugin.randlsb;

import java.awt.image.BufferedImage;
import java.io.IOException;
import net.sourceforge.openstego.OpenStegoException;
import net.sourceforge.openstego.plugin.lsb.LSBConfig;
import net.sourceforge.openstego.plugin.lsb.LSBDataHeader;
import net.sourceforge.openstego.plugin.lsb.LSBPlugin;
import net.sourceforge.openstego.plugin.randlsb.RandomLSBInputStream;
import net.sourceforge.openstego.plugin.randlsb.RandomLSBOutputStream;
import net.sourceforge.openstego.util.ImageUtil;
import net.sourceforge.openstego.util.LabelUtil;

public class RandomLSBPlugin
extends LSBPlugin {
    public static final String NAMESPACE = "RandomLSB";
    private static LabelUtil labelUtil = LabelUtil.getInstance("RandomLSB");

    public RandomLSBPlugin() {
        LabelUtil.addNamespace(NAMESPACE, "net.sourceforge.openstego.resource.RandomLSBPluginLabels");
    }

    public String getName() {
        return NAMESPACE;
    }

    public String getDescription() {
        return labelUtil.getString("plugin.description");
    }

    public byte[] embedData(byte[] msg, String msgFileName, byte[] cover, String coverFileName, String stegoFileName) throws OpenStegoException {
        int numOfPixels = 0;
        BufferedImage image = null;
        RandomLSBOutputStream lsbOS = null;
        try {
            if (cover == null) {
                numOfPixels = (int)((double)(LSBDataHeader.getMaxHeaderSize() * 8) / 3.0);
                image = ImageUtil.generateRandomImage(numOfPixels += (int)((double)(msg.length * 8) / (3.0 * (double)((LSBConfig)this.config).getMaxBitsUsedPerChannel())));
            } else {
                image = ImageUtil.byteArrayToImage(cover, coverFileName);
            }
            lsbOS = new RandomLSBOutputStream(image, msg.length, msgFileName, this.config);
            lsbOS.write(msg);
            lsbOS.close();
            return ImageUtil.imageToByteArray(lsbOS.getImage(), stegoFileName, this);
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
    }

    public String extractMsgFileName(byte[] stegoData, String stegoFileName) throws OpenStegoException {
        RandomLSBInputStream lsbIS = null;
        lsbIS = new RandomLSBInputStream(ImageUtil.byteArrayToImage(stegoData, stegoFileName), this.config);
        return lsbIS.getDataHeader().getFileName();
    }

    public byte[] extractData(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        int bytesRead = 0;
        byte[] data = null;
        LSBDataHeader header = null;
        RandomLSBInputStream lsbIS = null;
        try {
            lsbIS = new RandomLSBInputStream(ImageUtil.byteArrayToImage(stegoData, stegoFileName), this.config);
            header = lsbIS.getDataHeader();
            data = new byte[header.getDataLength()];
            bytesRead = lsbIS.read(data, 0, data.length);
            if (bytesRead != data.length) {
                throw new OpenStegoException(null, "LSB", 1);
            }
            lsbIS.close();
            return data;
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    public String getUsage() throws OpenStegoException {
        LSBConfig defaultConfig = new LSBConfig();
        return labelUtil.getString("plugin.usage", new Integer(defaultConfig.getMaxBitsUsedPerChannel()));
    }
}

