/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.plugin.randlsb;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import net.sourceforge.openstego.OpenStegoConfig;
import net.sourceforge.openstego.OpenStegoException;
import net.sourceforge.openstego.plugin.lsb.LSBConfig;
import net.sourceforge.openstego.plugin.lsb.LSBDataHeader;
import net.sourceforge.openstego.util.StringUtil;

public class RandomLSBOutputStream
extends OutputStream {
    private BufferedImage image = null;
    private int channelBitsUsed = 1;
    private int dataLength = 0;
    private String fileName = null;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private OpenStegoConfig config = null;
    private boolean[][][][] bitWritten = null;
    private Random rand = null;

    public RandomLSBOutputStream(BufferedImage image, int dataLength, String fileName, OpenStegoConfig config) throws OpenStegoException {
        if (image == null) {
            throw new OpenStegoException(null, "LSB", 2);
        }
        this.dataLength = dataLength;
        this.imgWidth = image.getWidth();
        this.imgHeight = image.getHeight();
        this.config = config;
        switch (image.getType()) {
            case 1: {
                this.image = image;
                break;
            }
            default: {
                this.image = new BufferedImage(this.imgWidth, this.imgHeight, 1);
                for (int x = 0; x < this.imgWidth; ++x) {
                    for (int y = 0; y < this.imgHeight; ++y) {
                        this.image.setRGB(x, y, image.getRGB(x, y));
                    }
                }
            }
        }
        this.channelBitsUsed = 1;
        this.fileName = fileName;
        this.rand = new Random(StringUtil.passwordHash(config.getPassword()));
        this.writeHeader();
    }

    private void writeHeader() throws OpenStegoException {
        int channelBits = 1;
        int noOfPixels = 0;
        int headerSize = 0;
        LSBDataHeader header = null;
        try {
            noOfPixels = this.imgWidth * this.imgHeight;
            header = new LSBDataHeader(this.dataLength, channelBits, this.fileName, this.config);
            headerSize = header.getHeaderSize();
            while ((double)(noOfPixels * 3 * channelBits) / 8.0 < (double)(headerSize + this.dataLength)) {
                if (++channelBits <= ((LSBConfig)this.config).getMaxBitsUsedPerChannel()) continue;
                throw new OpenStegoException(null, "LSB", 3);
            }
            header.setChannelBitsUsed(channelBits);
            this.bitWritten = new boolean[this.imgWidth][this.imgHeight][3][channelBits];
            for (int i = 0; i < this.imgWidth; ++i) {
                for (int j = 0; j < this.imgHeight; ++j) {
                    for (int k = 0; k < channelBits; ++k) {
                        this.bitWritten[i][j][0][k] = false;
                        this.bitWritten[i][j][1][k] = false;
                        this.bitWritten[i][j][2][k] = false;
                    }
                }
            }
            this.write(header.getHeaderData());
            this.channelBitsUsed = channelBits;
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    public void write(int data) throws IOException {
        boolean bitValue = false;
        int x = 0;
        int y = 0;
        int channel = 0;
        int bit = 0;
        for (int i = 0; i < 8; ++i) {
            boolean bl = bitValue = (data >> 7 - i & 1) == 1;
            while (this.bitWritten[x = this.rand.nextInt(this.imgWidth)][y = this.rand.nextInt(this.imgHeight)][channel = this.rand.nextInt(3)][bit = this.rand.nextInt(this.channelBitsUsed)]) {
            }
            this.bitWritten[x][y][channel][bit] = true;
            this.setPixelBit(x, y, channel, bit, bitValue);
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    private void setPixelBit(int x, int y, int channel, int bit, boolean bitValue) {
        int pixel = 0;
        int newColor = 0;
        int newPixel = 0;
        pixel = this.image.getRGB(x, y);
        if (bitValue) {
            newPixel = pixel | 1 << bit + channel * 8;
        } else {
            newColor = -2;
            for (int i = 0; i < bit + channel * 8; ++i) {
                newColor = newColor << 1 | 1;
            }
            newPixel = pixel & newColor;
        }
        this.image.setRGB(x, y, newPixel);
    }
}

