/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.plugin.randlsb;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import net.sourceforge.openstego.OpenStegoConfig;
import net.sourceforge.openstego.OpenStegoException;
import net.sourceforge.openstego.plugin.lsb.LSBDataHeader;
import net.sourceforge.openstego.util.StringUtil;

public class RandomLSBInputStream
extends InputStream {
    private BufferedImage image = null;
    private LSBDataHeader dataHeader = null;
    private int channelBitsUsed = 1;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private OpenStegoConfig config = null;
    private boolean[][][][] bitRead = null;
    private Random rand = null;

    public RandomLSBInputStream(BufferedImage image, OpenStegoConfig config) throws OpenStegoException {
        if (image == null) {
            throw new OpenStegoException(null, "LSB", 2);
        }
        this.image = image;
        this.channelBitsUsed = 1;
        this.config = config;
        this.imgWidth = image.getWidth();
        this.imgHeight = image.getHeight();
        this.bitRead = new boolean[this.imgWidth][this.imgHeight][3][1];
        for (int i = 0; i < this.imgWidth; ++i) {
            for (int j = 0; j < this.imgHeight; ++j) {
                this.bitRead[i][j][0][0] = false;
                this.bitRead[i][j][1][0] = false;
                this.bitRead[i][j][2][0] = false;
            }
        }
        this.rand = new Random(StringUtil.passwordHash(config.getPassword()));
        this.readHeader();
    }

    private void readHeader() throws OpenStegoException {
        boolean[][][][] oldBitRead = null;
        this.dataHeader = new LSBDataHeader(this, this.config);
        this.channelBitsUsed = this.dataHeader.getChannelBitsUsed();
        if (this.channelBitsUsed > 1) {
            oldBitRead = this.bitRead;
            this.bitRead = new boolean[this.imgWidth][this.imgHeight][3][this.channelBitsUsed];
            for (int i = 0; i < this.imgWidth; ++i) {
                for (int j = 0; j < this.imgHeight; ++j) {
                    this.bitRead[i][j][0][0] = oldBitRead[i][j][0][0];
                    this.bitRead[i][j][1][0] = oldBitRead[i][j][1][0];
                    this.bitRead[i][j][2][0] = oldBitRead[i][j][2][0];
                    for (int k = 1; k < this.channelBitsUsed; ++k) {
                        this.bitRead[i][j][0][k] = false;
                        this.bitRead[i][j][1][k] = false;
                        this.bitRead[i][j][2][k] = false;
                    }
                }
            }
        }
    }

    public int read() throws IOException {
        byte[] bitSet = new byte[8];
        int x = 0;
        int y = 0;
        int channel = 0;
        int bit = 0;
        for (int i = 0; i < 8; ++i) {
            while (this.bitRead[x = this.rand.nextInt(this.imgWidth)][y = this.rand.nextInt(this.imgHeight)][channel = this.rand.nextInt(3)][bit = this.rand.nextInt(this.channelBitsUsed)]) {
            }
            this.bitRead[x][y][channel][bit] = true;
            bitSet[i] = (byte)this.getPixelBit(x, y, channel, bit);
        }
        return (bitSet[0] << 7) + (bitSet[1] << 6) + (bitSet[2] << 5) + (bitSet[3] << 4) + (bitSet[4] << 3) + (bitSet[5] << 2) + (bitSet[6] << 1) + (bitSet[7] << 0);
    }

    public LSBDataHeader getDataHeader() {
        return this.dataHeader;
    }

    public int getPixelBit(int x, int y, int channel, int bit) {
        return this.image.getRGB(x, y) >> channel * 8 + bit & 1;
    }
}

