/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.plugin.lsb;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import net.sourceforge.openstego.OpenStegoConfig;
import net.sourceforge.openstego.OpenStegoException;
import net.sourceforge.openstego.plugin.lsb.LSBConfig;
import net.sourceforge.openstego.plugin.lsb.LSBDataHeader;
import net.sourceforge.openstego.plugin.lsb.LSBEmbedOptionsUI;
import net.sourceforge.openstego.plugin.lsb.LSBErrors;
import net.sourceforge.openstego.plugin.lsb.LSBInputStream;
import net.sourceforge.openstego.plugin.lsb.LSBOutputStream;
import net.sourceforge.openstego.plugin.template.image.DHImagePluginTemplate;
import net.sourceforge.openstego.ui.OpenStegoUI;
import net.sourceforge.openstego.ui.PluginEmbedOptionsUI;
import net.sourceforge.openstego.util.ImageUtil;
import net.sourceforge.openstego.util.LabelUtil;
import net.sourceforge.openstego.util.cmd.CmdLineOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LSBPlugin
extends DHImagePluginTemplate {
    private static LabelUtil labelUtil = LabelUtil.getInstance("LSB");
    public static final String NAMESPACE = "LSB";

    public LSBPlugin() {
        LabelUtil.addNamespace(NAMESPACE, "net.sourceforge.openstego.resource.LSBPluginLabels");
        new LSBErrors();
    }

    @Override
    public String getName() {
        return NAMESPACE;
    }

    @Override
    public String getDescription() {
        return labelUtil.getString("plugin.description");
    }

    @Override
    public byte[] embedData(byte[] msg, String msgFileName, byte[] cover, String coverFileName, String stegoFileName) throws OpenStegoException {
        int numOfPixels = 0;
        BufferedImage image = null;
        LSBOutputStream lsbOS = null;
        try {
            if (cover == null) {
                numOfPixels = (int)((double)(LSBDataHeader.getMaxHeaderSize() * 8) / 3.0);
                image = ImageUtil.generateRandomImage(numOfPixels += (int)((double)(msg.length * 8) / (3.0 * (double)((LSBConfig)this.config).getMaxBitsUsedPerChannel())));
            } else {
                image = ImageUtil.byteArrayToImage(cover, coverFileName);
            }
            lsbOS = new LSBOutputStream(image, msg.length, msgFileName, this.config);
            lsbOS.write(msg);
            lsbOS.close();
            return ImageUtil.imageToByteArray(lsbOS.getImage(), stegoFileName, this);
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
    }

    @Override
    public String extractMsgFileName(byte[] stegoData, String stegoFileName) throws OpenStegoException {
        LSBInputStream lsbIS = null;
        lsbIS = new LSBInputStream(ImageUtil.byteArrayToImage(stegoData, stegoFileName), this.config);
        return lsbIS.getDataHeader().getFileName();
    }

    @Override
    public byte[] extractData(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        int bytesRead = 0;
        byte[] data = null;
        LSBDataHeader header = null;
        LSBInputStream lsbIS = null;
        try {
            lsbIS = new LSBInputStream(ImageUtil.byteArrayToImage(stegoData, stegoFileName), this.config);
            header = lsbIS.getDataHeader();
            data = new byte[header.getDataLength()];
            bytesRead = lsbIS.read(data, 0, data.length);
            if (bytesRead != data.length) {
                throw new OpenStegoException(null, NAMESPACE, 1);
            }
            lsbIS.close();
            return data;
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    @Override
    public List<String> getWritableFileExtensions() throws OpenStegoException {
        if (writeFormats != null) {
            return writeFormats;
        }
        super.getWritableFileExtensions();
        String format = null;
        String[] compTypes = null;
        Iterator<ImageWriter> iter = null;
        ImageWriteParam writeParam = null;
        block2: for (int i = writeFormats.size() - 1; i >= 0; --i) {
            format = (String)writeFormats.get(i);
            iter = ImageIO.getImageWritersBySuffix(format);
            while (iter.hasNext()) {
                writeParam = iter.next().getDefaultWriteParam();
                try {
                    writeParam.setCompressionMode(2);
                    compTypes = writeParam.getCompressionTypes();
                    if (compTypes.length > 0) {
                        writeParam.setCompressionType(compTypes[0]);
                    }
                    writeFormats.remove(i);
                }
                catch (UnsupportedOperationException uoEx) {
                    continue block2;
                }
                if (!writeParam.isCompressionLossless()) continue;
            }
        }
        writeFormats.remove("gif");
        writeFormats.remove("wbmp");
        return writeFormats;
    }

    @Override
    public PluginEmbedOptionsUI getEmbedOptionsUI(OpenStegoUI stegoUI) throws OpenStegoException {
        return new LSBEmbedOptionsUI(stegoUI);
    }

    @Override
    public void populateStdCmdLineOptions(CmdLineOptions options) throws OpenStegoException {
        options.add("-b", "--maxBitsUsedPerChannel", 1, true);
    }

    @Override
    public Class<? extends OpenStegoConfig> getConfigClass() {
        return LSBConfig.class;
    }

    @Override
    public String getUsage() throws OpenStegoException {
        LSBConfig defaultConfig = new LSBConfig();
        return labelUtil.getString("plugin.usage", new Integer(defaultConfig.getMaxBitsUsedPerChannel()));
    }
}

