/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.plugin.lsb;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.openstego.OpenStegoConfig;
import net.sourceforge.openstego.OpenStegoException;
import net.sourceforge.openstego.plugin.lsb.LSBConfig;
import net.sourceforge.openstego.ui.OpenStegoUI;
import net.sourceforge.openstego.ui.PluginEmbedOptionsUI;
import net.sourceforge.openstego.util.CommonUtil;
import net.sourceforge.openstego.util.LabelUtil;

public class LSBEmbedOptionsUI
extends PluginEmbedOptionsUI {
    private static final long serialVersionUID = 6168148599483165215L;
    private static LabelUtil labelUtil = LabelUtil.getInstance("LSB");
    private JCheckBox randomImgCheckBox = new JCheckBox();
    private JComboBox maxBitsComboBox = null;
    private OpenStegoUI stegoUI = null;

    public LSBEmbedOptionsUI(OpenStegoUI stegoUI) {
        this.stegoUI = stegoUI;
        GridBagConstraints gridBagConstraints = null;
        JLabel label = null;
        Object[] maxBitsList = new Object[8];
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        label = new JLabel(labelUtil.getString("gui.label.option.useRandomImage"));
        this.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        label = new JLabel(labelUtil.getString("gui.label.option.maxBitsPerChannel"));
        this.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.randomImgCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        for (int i = 0; i < 8; ++i) {
            maxBitsList[i] = new Integer(i + 1);
        }
        this.maxBitsComboBox = new JComboBox<Object>(maxBitsList);
        this.maxBitsComboBox.setPreferredSize(new Dimension(40, 20));
        this.add((Component)this.maxBitsComboBox, gridBagConstraints);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LSBEmbedOptionsUI.this.useRandomImgChanged();
            }
        };
        this.randomImgCheckBox.addChangeListener(changeListener);
        this.useRandomImgChanged();
    }

    private void useRandomImgChanged() {
        JTextField coverFileTextField = this.stegoUI.getEmbedPanel().getCoverFileTextField();
        JButton coverFileButton = this.stegoUI.getEmbedPanel().getCoverFileButton();
        if (this.randomImgCheckBox.isSelected()) {
            CommonUtil.setEnabled(coverFileTextField, false);
            coverFileTextField.setText("");
            coverFileButton.setEnabled(false);
        } else {
            CommonUtil.setEnabled(coverFileTextField, true);
            coverFileButton.setEnabled(true);
            coverFileTextField.requestFocus();
        }
    }

    public boolean validateEmbedAction() throws OpenStegoException {
        return true;
    }

    public void setGUIFromConfig(OpenStegoConfig config) throws OpenStegoException {
        this.maxBitsComboBox.setSelectedItem(new Integer(((LSBConfig)config).getMaxBitsUsedPerChannel()));
    }

    public void setConfigFromGUI(OpenStegoConfig config) throws OpenStegoException {
        ((LSBConfig)config).setMaxBitsUsedPerChannel((Integer)this.maxBitsComboBox.getSelectedItem());
    }
}

