/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.plugin.lsb;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import net.sourceforge.openstego.OpenStegoConfig;
import net.sourceforge.openstego.OpenStegoException;
import net.sourceforge.openstego.util.CommonUtil;

public class LSBDataHeader {
    public static final byte[] DATA_STAMP = "OPENSTEGO".getBytes();
    public static final byte[] HEADER_VERSION = new byte[]{1};
    private static final int FIXED_HEADER_LENGTH = 8;
    private int dataLength = 0;
    private int channelBitsUsed = 0;
    private byte[] fileName = null;
    private OpenStegoConfig config = null;

    public LSBDataHeader(int dataLength, int channelBitsUsed, String fileName, OpenStegoConfig config) {
        this.dataLength = dataLength;
        this.channelBitsUsed = channelBitsUsed;
        this.config = config;
        if (fileName == null) {
            this.fileName = new byte[0];
        } else {
            try {
                this.fileName = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unEx) {
                this.fileName = fileName.getBytes();
            }
        }
    }

    public LSBDataHeader(InputStream dataInStream, OpenStegoConfig config) throws OpenStegoException {
        int stampLen = 0;
        int versionLen = 0;
        byte fileNameLen = 0;
        int channelBits = 0;
        byte[] header = null;
        byte[] stamp = null;
        byte[] version = null;
        stampLen = DATA_STAMP.length;
        versionLen = HEADER_VERSION.length;
        header = new byte[8];
        stamp = new byte[stampLen];
        version = new byte[versionLen];
        try {
            dataInStream.read(stamp, 0, stampLen);
            if (!new String(stamp).equals(new String(DATA_STAMP))) {
                throw new OpenStegoException(null, "LSB", 6);
            }
            dataInStream.read(version, 0, versionLen);
            if (!new String(version).equals(new String(HEADER_VERSION))) {
                throw new OpenStegoException(null, "LSB", 7);
            }
            dataInStream.read(header, 0, 8);
            this.dataLength = CommonUtil.byteToInt(header[0]) + (CommonUtil.byteToInt(header[1]) << 8) + (CommonUtil.byteToInt(header[2]) << 16) + (CommonUtil.byteToInt(header[3]) << 32);
            channelBits = header[4];
            fileNameLen = header[5];
            config.setUseCompression(header[6] == 1);
            config.setUseEncryption(header[7] == 1);
            if (fileNameLen == 0) {
                this.fileName = new byte[0];
            } else {
                this.fileName = new byte[fileNameLen];
                dataInStream.read(this.fileName, 0, fileNameLen);
            }
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
        this.channelBitsUsed = channelBits;
        this.config = config;
    }

    public byte[] getHeaderData() {
        byte[] out = null;
        int stampLen = 0;
        int versionLen = 0;
        int currIndex = 0;
        stampLen = DATA_STAMP.length;
        versionLen = HEADER_VERSION.length;
        out = new byte[stampLen + versionLen + 8 + this.fileName.length];
        System.arraycopy(DATA_STAMP, 0, out, currIndex, stampLen);
        System.arraycopy(HEADER_VERSION, 0, out, currIndex += stampLen, versionLen);
        currIndex += versionLen;
        out[currIndex++] = (byte)(this.dataLength & 0xFF);
        out[currIndex++] = (byte)((this.dataLength & 0xFF00) >> 8);
        out[currIndex++] = (byte)((this.dataLength & 0xFF0000) >> 16);
        out[currIndex++] = (byte)((this.dataLength & 0xFF000000) >> 32);
        out[currIndex++] = (byte)this.channelBitsUsed;
        out[currIndex++] = (byte)this.fileName.length;
        out[currIndex++] = (byte)(this.config.isUseCompression() ? 1 : 0);
        out[currIndex++] = (byte)(this.config.isUseEncryption() ? 1 : 0);
        if (this.fileName.length > 0) {
            System.arraycopy(this.fileName, 0, out, currIndex, this.fileName.length);
            currIndex += this.fileName.length;
        }
        return out;
    }

    public int getChannelBitsUsed() {
        return this.channelBitsUsed;
    }

    public void setChannelBitsUsed(int channelBitsUsed) {
        this.channelBitsUsed = channelBitsUsed;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String getFileName() {
        String name = null;
        try {
            name = new String(this.fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException unEx) {
            name = new String(this.fileName);
        }
        return name;
    }

    public int getHeaderSize() {
        return DATA_STAMP.length + HEADER_VERSION.length + 8 + this.fileName.length;
    }

    public static int getMaxHeaderSize() {
        return DATA_STAMP.length + HEADER_VERSION.length + 8 + 256;
    }
}

