/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego.plugin.lsb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.openstego.OpenStegoConfig;
import net.sourceforge.openstego.OpenStegoException;
import net.sourceforge.openstego.util.cmd.CmdLineOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LSBConfig
extends OpenStegoConfig {
    public static final String MAX_BITS_USED_PER_CHANNEL = "maxBitsUsedPerChannel";
    private int maxBitsUsedPerChannel = 3;
    private String imageFileExtension = "png";

    public LSBConfig() {
    }

    public LSBConfig(Map<String, String> propMap) throws OpenStegoException {
        this.addProperties(propMap);
    }

    public LSBConfig(CmdLineOptions options) throws OpenStegoException {
        super(options);
        HashMap<String, String> map = new HashMap<String, String>();
        if (options.getOption("-b") != null) {
            map.put(MAX_BITS_USED_PER_CHANNEL, options.getOptionValue("-b"));
        }
        this.addProperties(map);
    }

    @Override
    protected void addProperties(Map<String, String> propMap) throws OpenStegoException {
        super.addProperties(propMap);
        Iterator<String> keys = null;
        String key2 = null;
        String value = null;
        for (String key2 : propMap.keySet()) {
            if (!key2.equals(MAX_BITS_USED_PER_CHANNEL)) continue;
            value = propMap.get(key2).toString().trim();
            try {
                this.maxBitsUsedPerChannel = Integer.parseInt(value);
            }
            catch (NumberFormatException nfEx) {
                throw new OpenStegoException((Throwable)nfEx, "LSB", 4, value);
            }
            if (this.maxBitsUsedPerChannel >= 1 && this.maxBitsUsedPerChannel <= 8) continue;
            throw new OpenStegoException(null, "LSB", 5, value);
        }
    }

    public int getMaxBitsUsedPerChannel() {
        return this.maxBitsUsedPerChannel;
    }

    public void setMaxBitsUsedPerChannel(int maxBitsUsedPerChannel) {
        this.maxBitsUsedPerChannel = maxBitsUsedPerChannel;
    }

    public String getImageFileExtension() {
        return this.imageFileExtension;
    }

    public void setImageFileExtension(String imageFileExtension) {
        this.imageFileExtension = imageFileExtension;
    }
}

