/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.openstego.util.LabelUtil;

public class OpenStegoException
extends Exception {
    private static final long serialVersionUID = 668241029491685413L;
    static final int UNHANDLED_EXCEPTION = 0;
    public static final int INVALID_PASSWORD = 1;
    public static final int INVALID_USE_COMPR_VALUE = 2;
    public static final int INVALID_USE_ENCRYPT_VALUE = 3;
    public static final int INVALID_KEY_NAME = 4;
    public static final int CORRUPT_DATA = 5;
    public static final int NO_VALID_PLUGIN = 6;
    public static final int IMAGE_TYPE_INVALID = 7;
    public static final int IMAGE_FILE_INVALID = 8;
    public static final int NO_PLUGIN_SPECIFIED = 9;
    public static final int PLUGIN_DOES_NOT_SUPPORT_WM = 10;
    public static final int PLUGIN_NOT_FOUND = 11;
    public static final int IMAGE_SIZE_MISMATCH = 12;
    public static final int OUT_OF_MEMORY = 13;
    public static final int PLUGIN_DOES_NOT_SUPPORT_DH = 14;
    public static final int PWD_MANDATORY_FOR_GENSIG = 15;
    private static Map<String, String> errMsgKeyMap = new HashMap<String, String>();
    private int errorCode = 0;
    private String namespace = null;

    public OpenStegoException(Throwable cause) {
        this(cause, "OpenStego", 0, (Object[])null);
    }

    public OpenStegoException(Throwable cause, String namespace, int errorCode) {
        this(cause, namespace, errorCode, (Object[])null);
    }

    public OpenStegoException(Throwable cause, String namespace, int errorCode, String param) {
        this(cause, namespace, errorCode, new Object[]{param});
    }

    public OpenStegoException(Throwable cause, String namespace, int errorCode, Object ... params) {
        super(namespace == "OpenStego" && errorCode == 0 ? cause.toString() : LabelUtil.getInstance(namespace).getString(errMsgKeyMap.get(namespace + errorCode), params), cause);
        this.namespace = namespace;
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static void addErrorCode(String namespace, int errorCode, String labelKey) {
        errMsgKeyMap.put(namespace + errorCode, labelKey);
    }

    static {
        OpenStegoException.addErrorCode("OpenStego", 1, "err.config.password.invalid");
        OpenStegoException.addErrorCode("OpenStego", 2, "err.config.useCompression.invalid");
        OpenStegoException.addErrorCode("OpenStego", 3, "err.config.useEncryption.invalid");
        OpenStegoException.addErrorCode("OpenStego", 4, "err.config.invalidKey");
        OpenStegoException.addErrorCode("OpenStego", 5, "err.corruptData");
        OpenStegoException.addErrorCode("OpenStego", 6, "err.noValidPlugin");
        OpenStegoException.addErrorCode("OpenStego", 7, "err.image.type.invalid");
        OpenStegoException.addErrorCode("OpenStego", 8, "err.image.file.invalid");
        OpenStegoException.addErrorCode("OpenStego", 9, "err.plugin.notSpecified");
        OpenStegoException.addErrorCode("OpenStego", 10, "err.plugin.wmNotSupported");
        OpenStegoException.addErrorCode("OpenStego", 14, "err.plugin.dhNotSupported");
        OpenStegoException.addErrorCode("OpenStego", 11, "err.plugin.notFound");
        OpenStegoException.addErrorCode("OpenStego", 12, "err.image.size.mismatch");
        OpenStegoException.addErrorCode("OpenStego", 15, "err.gensig.pwdMandatory");
    }
}

