/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego;

import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.sourceforge.openstego.OpenStegoException;

public class OpenStegoCrypto {
    private final byte[] SALT = new byte[]{40, 95, 113, -55, 30, 53, 10, 98};
    private final int ITER_COUNT = 7;
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;

    public OpenStegoCrypto(String password) throws OpenStegoException {
        PBEKeySpec keySpec = null;
        SecretKey secretKey = null;
        PBEParameterSpec algoParamSpec = null;
        try {
            if (password == null) {
                password = "";
            }
            keySpec = new PBEKeySpec(password.toCharArray(), this.SALT, this.ITER_COUNT);
            secretKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.encryptCipher = Cipher.getInstance(secretKey.getAlgorithm());
            this.decryptCipher = Cipher.getInstance(secretKey.getAlgorithm());
            algoParamSpec = new PBEParameterSpec(this.SALT, this.ITER_COUNT);
            this.encryptCipher.init(1, (Key)secretKey, algoParamSpec);
            this.decryptCipher.init(2, (Key)secretKey, algoParamSpec);
        }
        catch (Exception ex) {
            if (ex instanceof OpenStegoException) {
                throw (OpenStegoException)ex;
            }
            throw new OpenStegoException(ex);
        }
    }

    public byte[] encrypt(byte[] input) throws OpenStegoException {
        try {
            return this.encryptCipher.doFinal(input);
        }
        catch (Exception ex) {
            if (ex instanceof OpenStegoException) {
                throw (OpenStegoException)ex;
            }
            throw new OpenStegoException(ex);
        }
    }

    public byte[] decrypt(byte[] input) throws OpenStegoException {
        try {
            return this.decryptCipher.doFinal(input);
        }
        catch (BadPaddingException bpEx) {
            throw new OpenStegoException(bpEx, "OpenStego", 1);
        }
        catch (Exception ex) {
            if (ex instanceof OpenStegoException) {
                throw (OpenStegoException)ex;
            }
            throw new OpenStegoException(ex);
        }
    }
}

