/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openstego;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.openstego.OpenStegoException;
import net.sourceforge.openstego.util.cmd.CmdLineOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenStegoConfig {
    public static final String USE_COMPRESSION = "useCompression";
    public static final String USE_ENCRYPTION = "useEncryption";
    public static final String PASSWORD = "password";
    private boolean useCompression = true;
    private boolean useEncryption = false;
    private String password = null;

    public OpenStegoConfig() {
    }

    public OpenStegoConfig(Map<String, String> propMap) throws OpenStegoException {
        this.addProperties(propMap);
    }

    public OpenStegoConfig(CmdLineOptions options) throws OpenStegoException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (options.getOption("-c") != null) {
            map.put(USE_COMPRESSION, "true");
        }
        if (options.getOption("-C") != null) {
            map.put(USE_COMPRESSION, "false");
        }
        if (options.getOption("-e") != null) {
            map.put(USE_ENCRYPTION, "true");
        }
        if (options.getOption("-E") != null) {
            map.put(USE_ENCRYPTION, "false");
        }
        if (options.getOption("-p") != null) {
            map.put(PASSWORD, options.getOptionValue("-p"));
        }
        this.addProperties(map);
    }

    protected void addProperties(Map<String, String> propMap) throws OpenStegoException {
        Iterator<String> keys = null;
        String key2 = null;
        String value = null;
        for (String key2 : propMap.keySet()) {
            if (key2.equals(USE_COMPRESSION)) {
                value = propMap.get(key2).toString().trim();
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("y") || value.equals("1")) {
                    this.useCompression = true;
                    continue;
                }
                if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("n") || value.equals("0")) {
                    this.useCompression = false;
                    continue;
                }
                throw new OpenStegoException(null, "OpenStego", 2, value);
            }
            if (key2.equals(USE_ENCRYPTION)) {
                value = propMap.get(key2).toString().trim();
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("y") || value.equals("1")) {
                    this.useEncryption = true;
                    continue;
                }
                if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("n") || value.equals("0")) {
                    this.useEncryption = false;
                    continue;
                }
                throw new OpenStegoException(null, "OpenStego", 3, value);
            }
            if (!key2.equals(PASSWORD)) continue;
            this.password = propMap.get(key2).toString();
        }
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean isUseEncryption() {
        return this.useEncryption;
    }

    public void setUseEncryption(boolean useEncryption) {
        this.useEncryption = useEncryption;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

