/*
 * Decompiled with CFR 0.152.
 */
package net.cqure;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import net.cqure.MSSQLInstance;
import net.cqure.MSSQLOptions;
import net.cqure.MSSQLProbeReply;
import net.cqure.SimpleLogger;
import net.cqure.storage.StorageInterface;

public class MSSQLProbe
extends Thread {
    private final int NO_ERROR = 0;
    private final int ERROR_TIMEOUT = 1000;
    private final int ERROR_TOO_MANY_OPEN_FILES = 1001;
    private byte[] m_bProbeData = new byte[]{2};
    private DatagramSocket m_oSocket = null;
    private String m_strSource = null;
    private String m_strTarget = null;
    private int m_nTimeout = 3000;
    private int m_nPacketSize = 3500;
    private int m_nError = 0;

    public MSSQLProbe(String strTarget, String strSource) {
        this.m_strTarget = strTarget;
        if (strSource != null) {
            this.m_strSource = strSource;
        }
        this.m_nTimeout = Integer.parseInt((String)MSSQLOptions.getInstance().get("timeout"));
    }

    public MSSQLProbe(String strTarget) {
        this(strTarget, null);
    }

    private void sendProbe() throws Exception {
        this.m_oSocket = this.m_strSource != null ? new DatagramSocket(new InetSocketAddress(this.m_strSource, 1434)) : new DatagramSocket();
        this.m_oSocket.setSoTimeout(this.m_nTimeout);
        this.m_oSocket.setBroadcast(true);
        SimpleLogger.getInstance().logDebug("Sending probe to: " + this.m_strTarget);
        this.m_oSocket.send(new DatagramPacket(this.m_bProbeData, this.m_bProbeData.length, InetAddress.getByName(this.m_strTarget), 1434));
    }

    private void printInstances(MSSQLInstance[] instances) {
        MSSQLInstance[] mSSQLInstanceArray = instances;
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            MSSQLInstance oInstance = mSSQLInstanceArray[n2];
            System.out.println(oInstance.toString());
            ++n2;
        }
    }

    private void recvAnswer() throws IOException {
        DatagramPacket oPacket = new DatagramPacket(new byte[this.m_nPacketSize], this.m_nPacketSize);
        StorageInterface oStorage = (StorageInterface)MSSQLOptions.getInstance().get("storage");
        SimpleLogger.getInstance().logDebug("waiting " + this.m_nTimeout + " ms for responses ...");
        try {
            this.m_oSocket.receive(oPacket);
        }
        catch (SocketTimeoutException e) {
            SimpleLogger.getInstance().logDebug("Probe" + this.getId() + " timed out after " + this.m_nTimeout + " ms ...");
            return;
        }
        MSSQLProbeReply oReply = new MSSQLProbeReply(oPacket);
        oReply.processPacket();
        SimpleLogger.getInstance().logInfo("reply recieved from: " + oPacket.getAddress().toString());
        if (oStorage == null) {
            this.printInstances(oReply.getMSSQLInstances());
        } else {
            try {
                MSSQLInstance[] mSSQLInstanceArray = oReply.getMSSQLInstances();
                int n = mSSQLInstanceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MSSQLInstance oInstance = mSSQLInstanceArray[n2];
                    oStorage.addMSSQLInstances(oInstance);
                    ++n2;
                }
            }
            catch (Exception e) {
                SimpleLogger.getInstance().logError("failed to store instances ...");
                this.printInstances(oReply.getMSSQLInstances());
            }
        }
        this.m_oSocket.close();
    }

    public int getError() {
        return this.m_nError;
    }

    public String getTarget() {
        return this.m_strTarget;
    }

    public String getSource() {
        return this.m_strSource;
    }

    public void run() {
        try {
            this.sendProbe();
            this.recvAnswer();
        }
        catch (IOException e1) {
            System.err.println("ERROR: Sending probe to: " + this.m_strTarget + ", " + e1.getMessage());
            this.m_nError = 1001;
        }
        catch (Exception e) {
            System.err.println("ERROR: Sending probe to: " + this.m_strTarget + ", " + e.getMessage());
            e.printStackTrace();
        }
    }
}

