/*
 * Decompiled with CFR 0.152.
 */
package net.cqure;

import net.cqure.exception.InvalidAddressException;

class AddressOctet {
    private int m_nMin = 0;
    private int m_nMax = 0;
    private int m_nCur = 0;

    public AddressOctet(String strOctet) throws InvalidAddressException {
        if (strOctet.equals("*")) {
            this.m_nMin = 0;
            this.m_nMax = 255;
            this.m_nCur = 0;
        } else if (strOctet.contains("-")) {
            String[] aRange = strOctet.split("-");
            if (2 != aRange.length) {
                throw new InvalidAddressException("Invalid octet: " + strOctet);
            }
            this.m_nMin = Integer.parseInt(aRange[0]);
            this.m_nMax = Integer.parseInt(aRange[1]);
            this.m_nCur = this.m_nMin;
            if (this.m_nMin < 0 || this.m_nMax > 255) {
                throw new InvalidAddressException("Invalid octet: " + strOctet);
            }
        } else {
            this.m_nCur = this.m_nMax = (this.m_nMin = Integer.parseInt(strOctet));
        }
    }

    public void reset() {
        this.m_nCur = this.m_nMin;
    }

    public int getNextOctet() {
        int n = -1;
        if (this.m_nCur < this.m_nMax) {
            n = this.m_nCur;
        }
        ++this.m_nCur;
        return n;
    }

    public int getOctet() {
        return this.m_nCur;
    }
}

