# An attempt to exploit {#host}.
class Mdm::ExploitAttempt < ApplicationRecord
  
  #
  # Associations
  #

  # Host that was attempted to be exploited.
  #
  # @return [Mdm::Host]
  belongs_to :host,
             class_name: 'Mdm::Host',
             counter_cache: :exploit_attempt_count,
             inverse_of: :exploit_attempts

  # Loot gathers from the successful exploit.
  #
  # @return [Mdm::Loot, nil]
  belongs_to :loot,
             class_name: 'Mdm::Loot',
             inverse_of: :exploit_attempt

  # The service being exploited on {#host}.
  #
  # @return [Mdm::Service, nil]
  belongs_to :service,
             class_name: 'Mdm::Service',
             inverse_of: :exploit_attempts

  # The session that was established when this attempt was successful.
  #
  # @return [Mdm::Session]
  # @return [nil] if session was not established.
  belongs_to :session,
             class_name: 'Mdm::Session',
             inverse_of: :exploit_attempt

  # The vulnerability that was attempted to be exploited.
  #
  # @return [Mdm::Vuln, nil]
  belongs_to :vuln,
             class_name: 'Mdm::Vuln',
             inverse_of: :exploit_attempts

  #
  # Attributes
  #

  # @!attribute attempted_at
  #   When the attempt was made.
  #
  #   @return [DateTime]

  # @!attribute exploited
  #   Whether the attempt was successful.
  #
  #   @return [true] attempt was successful.
  #   @return [false] attempt was not successful.

  # @!attribute fail_detail
  #   A more verbose reason (compared to {#fail_reason} for the failure.
  #
  #   @return [String, nil]

  # @!attribute fail_reason
  #   Summary of why the attempt failed if {#exploited} is `false`.  For more details see {#fail_detail}.
  #
  #   @return [String, nil]

  # @!attribute host_id
  #   Foreign key to look up {#host}.
  #
  #   @return [Integer]

  # @!attribute  module
  #   The full name of the exploit module that made the attempt.
  #
  #   @return [String]
  #   @todo Remove deprecated Mdm::Exploit#module (MSP-9281)

  # @!attribute port
  #   The port on {#host} which the exploit was attempted.
  #
  #   @return [Integer]
  #   @todo Mdm::ExploitAttempt#port and Mdm::ExploitAttempt#proto are obsolete and should be removed (MSP-9284)

  # @!attribute proto
  #   The protocol name used on {#port}.
  #
  #   @return [String]
  #   @todo Mdm::ExploitAttempt#port and Mdm::ExploitAttempt#proto are obsolete and should be removed (MSP-9284)

  # @!attribute username
  #   Name of user that made the attempt.  May be an {Mdm::User#name} or a system username.
  #
  #   @return [String]

  #
  # Validations
  #

  validates :host_id, :presence => true

  Metasploit::Concern.run(self)
end
