/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.util.ui.HtmlUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ImportTutorialPanel
extends JPanel {
    private final String _htmlText;
    private JCheckBox _dontShowAgainCheckBox;
    private JButton _popOutButton;
    private JEditorPane _tutorialEditorPane;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public ImportTutorialPanel(String htmlText) {
        this._htmlText = htmlText;
        this.initComponents();
        this._tutorialEditorPane.setContentType("text/html");
        this._tutorialEditorPane.setText(this._htmlText);
        this._tutorialEditorPane.setCaretPosition(0);
    }

    public boolean showTutorialAgain() {
        return !this._dontShowAgainCheckBox.isSelected();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this._tutorialEditorPane = new JEditorPane();
        this.jPanel2 = new JPanel();
        this._dontShowAgainCheckBox = new JCheckBox();
        this._popOutButton = new JButton();
        this.setMinimumSize(new Dimension(640, 480));
        this.setPreferredSize(new Dimension(700, 480));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(UIManager.getLookAndFeelDefaults().getColor("darculaMod.borderColor")));
        this.jScrollPane1.setMinimumSize(new Dimension(640, 480));
        this.jScrollPane1.setPreferredSize(new Dimension(700, 480));
        this._tutorialEditorPane.setEditable(false);
        this._tutorialEditorPane.setText(NbBundle.getMessage(ImportTutorialPanel.class, (String)"ImportTutorialPanel._tutorialEditorPane.text"));
        this._tutorialEditorPane.setPreferredSize(new Dimension(112, 240));
        this._tutorialEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                ImportTutorialPanel.this._tutorialEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this._tutorialEditorPane);
        this.add((Component)this.jScrollPane1, "Center");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.jPanel2.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this._dontShowAgainCheckBox, (String)NbBundle.getMessage(ImportTutorialPanel.class, (String)"ImportTutorialPanel._dontShowAgainCheckBox.text"));
        this.jPanel2.add((Component)this._dontShowAgainCheckBox, "West");
        Mnemonics.setLocalizedText((AbstractButton)this._popOutButton, (String)NbBundle.getMessage(ImportTutorialPanel.class, (String)"ImportTutorialPanel._popOutButton.text"));
        this._popOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportTutorialPanel.this._popOutButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this._popOutButton, "East");
        this.add((Component)this.jPanel2, "South");
    }

    private void _popOutButtonActionPerformed(ActionEvent evt) {
        String title = "Tabular Import - Tutorial";
        HtmlUIUtils.showModelExcludeHtmlFrame((String)title, (String)this._htmlText);
    }

    private void _tutorialEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String desc = evt.getDescription();
            if (desc == null || !desc.startsWith("#")) {
                return;
            }
            desc = desc.substring(1);
            this._tutorialEditorPane.scrollToReference(desc);
        }
    }
}

