/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.graph;

import com.paterva.maltego.ui.graph.actions.SelectionMode;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import y.base.Edge;
import y.base.Node;
import y.view.Bend;
import y.view.Graph2D;
import y.view.SelectionBoxMode;

public class SelectionBoxViewMode
extends SelectionBoxMode {
    protected boolean belongsToSelection(Node node, Rectangle2D rd) {
        Graph2D g2D = this.getGraph2D();
        return rd.contains(g2D.getCenterX(node), g2D.getCenterY(node));
    }

    protected boolean belongsToSelection(Edge edge, Rectangle2D rd) {
        Graph2D g2D = this.getGraph2D();
        return g2D.getRealizer(edge).pathIntersects(rd, false);
    }

    protected boolean belongsToSelection(Bend bend, Rectangle2D rd) {
        return false;
    }

    protected void selectionBoxAction(Rectangle rctngl, boolean bln) {
        Graph2D g2D = this.getGraph2D();
        g2D.firePreEvent();
        if (!bln) {
            g2D.unselectAll();
        }
        boolean selectNodes = SelectionMode.isEntities();
        MouseEvent lastClick = this.getLastReleaseEvent();
        if (lastClick != null && (lastClick.isControlDown() || lastClick.isAltDown())) {
            boolean bl = selectNodes = !selectNodes;
        }
        if (selectNodes) {
            g2D.unselectEdges();
            for (Node node : g2D.getNodeArray()) {
                if (!this.belongsToSelection(node, (Rectangle2D)rctngl)) continue;
                g2D.setSelected(node, true);
            }
        } else {
            g2D.unselectNodes();
            for (Edge edge : g2D.getEdgeArray()) {
                if (!this.belongsToSelection(edge, (Rectangle2D)rctngl)) continue;
                g2D.setSelected(edge, true);
            }
        }
        g2D.firePostEvent();
        g2D.updateViews();
    }
}

