/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.graph;

import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphLink;
import com.paterva.maltego.graph.table.ui.graph.ConnectivityNodeRealizer;
import com.paterva.maltego.graph.table.ui.graph.DeleteLinksAction;
import com.paterva.maltego.graph.table.ui.graph.SelectionBoxViewMode;
import com.paterva.maltego.ui.graph.view2d.MacOSXEditMode;
import com.paterva.maltego.ui.graph.view2d.MouseWheelZoomListener;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLayouter;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Node;
import y.base.NodeCursor;
import y.layout.BufferedLayouter;
import y.layout.GraphLayoutLineWrapper;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.circular.CircularLayouter;
import y.layout.hierarchic.HierarchicLayouter;
import y.view.Arrow;
import y.view.CreateEdgeMode;
import y.view.EdgeRealizer;
import y.view.EditMode;
import y.view.Graph2D;
import y.view.Graph2DLayoutExecutor;
import y.view.Graph2DView;
import y.view.Graph2DViewActions;
import y.view.LayoutMorpher;
import y.view.NodeRealizer;
import y.view.PolyLineEdgeRealizer;
import y.view.ViewMode;

public class ConnectivityPanel
extends JPanel {
    private Graph2DView _graphView;
    private Map<TabularGraphEntity, Node> _entityMap;
    private Map<TabularGraphLink, Edge> _linkMap;
    private JButton _blockLayoutButton;
    private JButton _circularLayoutButton;
    private JPanel _graphViewPanel;
    private JButton _hierarchicalLayoutButton;
    private JButton _wrapLayoutButton;
    private JButton _zoomButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextArea jTextArea1;

    public ConnectivityPanel() {
        this.initComponents();
        this._graphView = new Graph2DView();
        this.registerViewActions();
        this._graphView.setAntialiasedPainting(true);
        this._graphView.putClientProperty((Object)"selectionbox.linecolor", (Object)new Color(35, 106, 109));
        this._graphView.putClientProperty((Object)"selectionbox.fillcolor", (Object)new Color(217, 242, 241, 70));
        this._graphView.addViewMode((ViewMode)this.createEditMode());
        this._graphViewPanel.add((Component)this._graphView);
        this._blockLayoutButton.setToolTipText("Block Layout");
        this._hierarchicalLayoutButton.setToolTipText("Hierarchical Layout");
        this._circularLayoutButton.setToolTipText("Circular Layout");
        this._wrapLayoutButton.setToolTipText("Wrap Layout");
        this._zoomButton.setToolTipText("Zoom to Fit");
        this._hierarchicalLayoutButton.setVisible(false);
    }

    private void registerViewActions() {
        Graph2DViewActions actions = new Graph2DViewActions(this._graphView);
        ActionMap amap = this._graphView.getCanvasComponent().getActionMap();
        if (amap != null) {
            amap.put("DELETE_SELECTION", (Action)SystemAction.get(DeleteLinksAction.class));
            InputMap imap = actions.createDefaultInputMap(amap);
            this._graphView.getCanvasComponent().setInputMap(0, imap);
        }
        this._graphView.getCanvasComponent().addMouseWheelListener((MouseWheelListener)new MouseWheelZoomListener());
    }

    private EditMode createEditMode() {
        MacOSXEditMode mode = new MacOSXEditMode();
        mode.allowBendCreation(false);
        mode.allowEdgeCreation(true);
        mode.allowLabelSelection(false);
        mode.allowMoveLabels(false);
        mode.allowMovePorts(false);
        mode.allowNodeCreation(false);
        mode.allowNodeEditing(false);
        mode.allowResizeNodes(false);
        mode.setSelectionBoxMode((ViewMode)new SelectionBoxViewMode());
        ViewMode createEdgeMode = mode.getCreateEdgeMode();
        if (createEdgeMode instanceof CreateEdgeMode) {
            ((CreateEdgeMode)createEdgeMode).allowSelfloopCreation(false);
        }
        return mode;
    }

    public void setTabularGraph(TabularGraph tabularGraph, JTabbedPane mcTabbedPane) {
        if (mcTabbedPane != null && mcTabbedPane.getTabCount() >= 4) {
            if (tabularGraph.getLinks().size() > 0) {
                mcTabbedPane.setEnabledAt(3, true);
            } else {
                mcTabbedPane.setEnabledAt(3, false);
            }
        }
        Graph2D graph2D = new Graph2D();
        this._graphView.setGraph2D(graph2D);
        this.addEntities(tabularGraph);
        this.addLinks(tabularGraph);
        graph2D.addGraphListener(ge -> {
            if (ge.getType() == 1) {
                Edge edge = (Edge)ge.getData();
                graph2D.setLabelText(edge, this.getNextName(graph2D));
            }
            if ((ge.getType() == 1 || ge.getType() == 5) && mcTabbedPane != null) {
                if (graph2D.getEdgeList().size() > 0) {
                    mcTabbedPane.setEnabledAt(3, true);
                } else {
                    mcTabbedPane.setEnabledAt(3, false);
                }
            }
        });
        this.layoutGraph(false, this.getDefaultLayouter());
        SwingUtilities.invokeLater(this::zoomToFit);
    }

    private String getNextName(Graph2D graph2D) {
        String name = null;
        int i = 0;
        do {
            String n;
            if (this.getEdge(graph2D, n = Integer.toString(++i)) != null) continue;
            name = n;
        } while (name == null);
        return name;
    }

    private Edge getEdge(Graph2D graph2D, String name) {
        EdgeCursor edges = graph2D.edges();
        while (edges.ok()) {
            Edge e = edges.edge();
            if (name.equals(graph2D.getLabelText(e))) {
                return e;
            }
            edges.next();
        }
        return null;
    }

    private void addEntities(TabularGraph tabularGraph) {
        Graph2D g2D = this._graphView.getGraph2D();
        List entities = tabularGraph.getEntities();
        this._entityMap = new HashMap<TabularGraphEntity, Node>();
        g2D.setDefaultNodeRealizer((NodeRealizer)ConnectivityNodeRealizer.create());
        int index = 0;
        for (TabularGraphEntity entity : entities) {
            Node node = g2D.createNode();
            ConnectivityNodeRealizer nr = (ConnectivityNodeRealizer)g2D.getRealizer(node);
            nr.setUserData(entity);
            nr.setEntityIndex(++index);
            g2D.setLabelText(node, this.getEntityName(tabularGraph, entity));
            this._entityMap.put(entity, node);
        }
    }

    private void addLinks(TabularGraph tabularGraph) {
        Graph2D g2D = this._graphView.getGraph2D();
        List links = tabularGraph.getLinks();
        this._linkMap = new HashMap<TabularGraphLink, Edge>();
        g2D.setDefaultEdgeRealizer((EdgeRealizer)this.createEdgeRealizer());
        for (TabularGraphLink link : links) {
            Node sourceNode = this._entityMap.get(link.getSource());
            Node targetNode = this._entityMap.get(link.getTarget());
            Edge edge = g2D.createEdge(sourceNode, targetNode);
            g2D.setLabelText(edge, Integer.toString(link.getIndex()));
            this._linkMap.put(link, edge);
        }
    }

    private PolyLineEdgeRealizer createEdgeRealizer() {
        NakedEdgeRealizer er = new NakedEdgeRealizer();
        er.setSourceArrow(Arrow.NONE);
        er.setSmoothedBends(true);
        er.setTargetArrow(Arrow.STANDARD);
        er.setLineColor(MaltegoLinkSpec.getDefaultManualLinkColor());
        er.getLabel().setTextColor(MaltegoLinkSpec.getDefaultManualLinkColor());
        return er;
    }

    private String getEntityName(TabularGraph tabularGraph, TabularGraphEntity entity) {
        int[] columns;
        StringBuilder sb = new StringBuilder();
        String[] columnNames = tabularGraph.getColumnNames();
        for (int i : columns = entity.getColumns()) {
            if (i != columns[0]) {
                sb.append(", ");
            }
            if (columnNames != null) {
                sb.append(columnNames[i]);
                continue;
            }
            sb.append("Column").append(i + 1);
        }
        String name = sb.toString();
        int limit = 20;
        if (name.length() > limit) {
            name = name.substring(0, limit) + "...";
        }
        return name;
    }

    public List<TabularGraphLink> getLinksRemoved() {
        ArrayList<TabularGraphLink> links = new ArrayList<TabularGraphLink>();
        EdgeList edgeList = this._graphView.getGraph2D().getEdgeList();
        Iterator<Map.Entry<TabularGraphLink, Edge>> itr = this._linkMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<TabularGraphLink, Edge> entry = itr.next();
            Edge edge = entry.getValue();
            if (edgeList.contains((Object)edge)) continue;
            TabularGraphLink link = entry.getKey();
            links.add(link);
            itr.remove();
        }
        return links;
    }

    public List<TabularGraphLink> getLinksAdded() {
        ArrayList<TabularGraphLink> links = new ArrayList<TabularGraphLink>();
        Graph2D graph2D = this._graphView.getGraph2D();
        EdgeCursor edges = graph2D.edges();
        while (edges.ok()) {
            Edge edge = edges.edge();
            if (this.getLink(edge) == null) {
                TabularGraphEntity source = this.getEntity(edge.source());
                TabularGraphEntity target = this.getEntity(edge.target());
                DefaultTabularGraphLink link = new DefaultTabularGraphLink(source, target);
                link.setIndex(Integer.parseInt(graph2D.getLabelText(edge)));
                links.add((TabularGraphLink)link);
                this._linkMap.put((TabularGraphLink)link, edge);
            }
            edges.next();
        }
        return links;
    }

    private TabularGraphLink getLink(Edge edge) {
        for (Map.Entry<TabularGraphLink, Edge> entry : this._linkMap.entrySet()) {
            if (!edge.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private TabularGraphEntity getEntity(Node node) {
        for (Map.Entry<TabularGraphEntity, Node> entry : this._entityMap.entrySet()) {
            if (!node.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private Layouter getDefaultLayouter() {
        NodeCursor nodes = this._graphView.getGraph2D().nodes();
        while (nodes.ok()) {
            Node node = nodes.node();
            if (node.outDegree() > 1) {
                return new CircularLayouter();
            }
            nodes.next();
        }
        return this.getWrapLayouter();
    }

    private void layoutGraph(boolean morph, Layouter layouter) {
        if (morph) {
            LayoutMorpher layoutMorpher = new LayoutMorpher();
            layoutMorpher.setSmoothViewTransform(true);
            layoutMorpher.setKeepZoomFactor(false);
            Graph2DLayoutExecutor executor = new Graph2DLayoutExecutor(3);
            executor.setLayoutMorpher(layoutMorpher);
            executor.doLayout(this._graphView, layouter);
        } else {
            new BufferedLayouter(layouter).doLayout((LayoutGraph)this._graphView.getGraph2D());
        }
    }

    private void zoomToFit() {
        this._graphView.fitContent();
        this._graphView.updateView();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._blockLayoutButton = new JButton();
        this._hierarchicalLayoutButton = new JButton();
        this._circularLayoutButton = new JButton();
        this._wrapLayoutButton = new JButton();
        this._zoomButton = new JButton();
        this._graphViewPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jTextArea1 = new JTextArea();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0));
        this._blockLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/ui/resources/LayoutBlock.png")));
        this._blockLayoutButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._blockLayoutButton.text"));
        this._blockLayoutButton.setPreferredSize(new Dimension(30, 25));
        this._blockLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectivityPanel.this._blockLayoutButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this._blockLayoutButton);
        this._hierarchicalLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/ui/resources/LayoutHierarchical.png")));
        this._hierarchicalLayoutButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._hierarchicalLayoutButton.text"));
        this._hierarchicalLayoutButton.setPreferredSize(new Dimension(30, 25));
        this._hierarchicalLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectivityPanel.this._hierarchicalLayoutButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this._hierarchicalLayoutButton);
        this._circularLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/ui/resources/LayoutCircular.png")));
        this._circularLayoutButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._circularLayoutButton.text"));
        this._circularLayoutButton.setPreferredSize(new Dimension(30, 25));
        this._circularLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectivityPanel.this._circularLayoutButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this._circularLayoutButton);
        this._wrapLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/ui/resources/LayoutWrap.png")));
        this._wrapLayoutButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._wrapLayoutButton.text"));
        this._wrapLayoutButton.setPreferredSize(new Dimension(30, 25));
        this._wrapLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectivityPanel.this._wrapLayoutButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this._wrapLayoutButton);
        this._zoomButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/ui/resources/Zoom.png")));
        this._zoomButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._zoomButton.text"));
        this._zoomButton.setPreferredSize(new Dimension(30, 25));
        this._zoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectivityPanel.this._zoomButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this._zoomButton);
        this.add((Component)this.jPanel1, "North");
        this._graphViewPanel.setBorder(BorderFactory.createLineBorder(UIManager.getLookAndFeelDefaults().getColor("darculaMod.borderColor")));
        this._graphViewPanel.setPreferredSize(new Dimension(500, 200));
        this._graphViewPanel.setLayout(new BorderLayout());
        this.add((Component)this._graphViewPanel, "Center");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel.jPanel2.border.title")));
        this.jPanel2.setLayout(new BorderLayout());
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(2);
        this.jTextArea1.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jPanel2.add((Component)this.jTextArea1, "Center");
        this.add((Component)this.jPanel2, "South");
        this.jPanel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel.jPanel2.AccessibleContext.accessibleName"));
    }

    private void _hierarchicalLayoutButtonActionPerformed(ActionEvent evt) {
        this.layoutGraph(true, (Layouter)new HierarchicLayouter());
    }

    private void _zoomButtonActionPerformed(ActionEvent evt) {
        this.zoomToFit();
    }

    private void _circularLayoutButtonActionPerformed(ActionEvent evt) {
        this.layoutGraph(true, (Layouter)new CircularLayouter());
    }

    private void _blockLayoutButtonActionPerformed(ActionEvent evt) {
        this.layoutGraph(true, (Layouter)new MaltegoLayouter());
    }

    private void _wrapLayoutButtonActionPerformed(ActionEvent evt) {
        this.layoutGraph(true, (Layouter)this.getWrapLayouter());
    }

    private GraphLayoutLineWrapper getWrapLayouter() {
        HierarchicLayouter hierarchicLayouter = new HierarchicLayouter();
        hierarchicLayouter.setLayoutOrientation((byte)1);
        GraphLayoutLineWrapper lineWrapper = new GraphLayoutLineWrapper();
        lineWrapper.setCoreLayouter((Layouter)hierarchicLayouter);
        return lineWrapper;
    }

    private static class NakedEdgeRealizer
    extends PolyLineEdgeRealizer {
        public NakedEdgeRealizer() {
        }

        private NakedEdgeRealizer(EdgeRealizer er) {
            super(er);
        }

        public EdgeRealizer createCopy(EdgeRealizer er) {
            return new NakedEdgeRealizer(er);
        }

        protected void paintBends(Graphics2D gd) {
        }

        protected void paintHighlightedBends(Graphics2D gd) {
        }

        protected void paintPorts(Graphics2D gd) {
        }
    }
}

