/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.graph;

import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.ui.wizard.IndexPainter;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.ui.graph.view2d.EntityRealizerConstants;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.RoundRectHotSpotPainter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Map;
import y.view.AbstractCustomNodePainter;
import y.view.GenericNodeRealizer;
import y.view.NodeLabel;
import y.view.NodeRealizer;

public class ConnectivityNodeRealizer
extends GenericNodeRealizer {
    private static String _config;
    private int _entityIndex;

    public static ConnectivityNodeRealizer create() {
        if (_config == null) {
            _config = "ConnectivityNodeRealizer";
            GenericNodeRealizer.Factory factory = GenericNodeRealizer.getFactory();
            Map implementationsMap = factory.createDefaultConfigurationMap();
            ConnectivityImagePainter painter = new ConnectivityImagePainter();
            RoundRectHotSpotPainter hsp = new RoundRectHotSpotPainter();
            implementationsMap.put(GenericNodeRealizer.Painter.class, painter);
            implementationsMap.put(GenericNodeRealizer.HotSpotPainter.class, hsp);
            factory.addConfiguration(_config, implementationsMap);
        }
        return new ConnectivityNodeRealizer(_config);
    }

    private ConnectivityNodeRealizer(String config) {
        super(config);
        NodeLabel label = this.getLabel();
        label.setModel((byte)1);
        label.setPosition((byte)101);
        label.setFont(NodeRealizerSettings.getDefault().getValueLabelFont());
        label.setTextColor(NodeRealizerSettings.getDefault().getValueLabelColor());
        label.setDistance(15.0);
    }

    public ConnectivityNodeRealizer(NodeRealizer nr) {
        super(nr);
    }

    public NodeRealizer createCopy(NodeRealizer nr) {
        return new ConnectivityNodeRealizer(nr);
    }

    public void setEntityIndex(int index) {
        this._entityIndex = index;
    }

    public int getEntityIndex() {
        return this._entityIndex;
    }

    public void setLabelText(String string) {
        super.setLabelText(string);
        this.updateSizeNode();
    }

    protected void updateSizeNode() {
        double h = EntityRealizerConstants.IMAGE_SIZE + 6;
        double w = EntityRealizerConstants.IMAGE_SIZE + 3;
        NodeLabel bottom = this.getLabel();
        bottom.calculateSize();
        w += 68.0;
        w = Math.max(w, bottom.getWidth() + 4.0);
        this.setSize(w, h += 2.0 * (6.0 + bottom.getHeight()));
    }

    private static class ConnectivityImagePainter
    extends AbstractCustomNodePainter {
        private ConnectivityImagePainter() {
        }

        protected void paintNode(NodeRealizer nr, Graphics2D gd, boolean bln) {
            ConnectivityNodeRealizer cnr = (ConnectivityNodeRealizer)nr;
            TabularGraphEntity entity = (TabularGraphEntity)cnr.getUserData();
            EntityImageFactory factory = EntityImageFactory.getDefault();
            Image image = factory.getTypeImage(entity.getEntitySpecName(), null);
            Dimension d = this.calcScaledSize(image.getWidth(null), image.getHeight(null), 48.0f);
            double imageX = (nr.getWidth() - d.getWidth()) / 2.0 + nr.getX();
            double imageY = (nr.getHeight() - d.getHeight()) / 2.0 + nr.getY() - 15.0;
            gd.drawImage(image, (int)imageX, (int)imageY, (int)d.getWidth(), (int)d.getHeight(), null);
            double indexX = imageX;
            double indexY = imageY + d.getHeight() - 5.0;
            IndexPainter.paint(gd, cnr.getEntityIndex(), gd.getFont(), (int)indexX, (int)indexY);
        }

        private Dimension calcScaledSize(int imgWidth, int imgHeight, float scaleTo) {
            Dimension d = new Dimension((int)scaleTo, (int)scaleTo);
            double ratio = (double)imgWidth / (double)imgHeight;
            if (ratio > 1.0) {
                d.setSize(scaleTo, (double)scaleTo / ratio);
            } else if (ratio < 1.0) {
                d.setSize((double)scaleTo * ratio, scaleTo);
            }
            return d;
        }
    }
}

