/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.exp.wizard;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.table.io.exp.GraphTableBuilder;
import com.paterva.maltego.graph.table.io.exp.TabularGraphExportResult;
import com.paterva.maltego.graph.table.io.exp.TabularGraphFileExporter;
import com.paterva.maltego.graph.table.ui.exp.wizard.TabularExportFailurePanel;
import com.paterva.maltego.graph.table.ui.exp.wizard.TabularExportSuccessPanel;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import y.view.Graph2D;

class TabularExportProgressController
extends PassFailProgressController<TabularGraphExportResult, TabularExportSuccessPanel, TabularExportFailurePanel> {
    public TabularExportProgressController() {
        this.setName("Export");
        this.setDescription("The summary of the progress to export a graph to a table structured file is shown below.");
    }

    protected TabularExportSuccessPanel createPassComponent() {
        return new TabularExportSuccessPanel();
    }

    protected TabularExportFailurePanel createFailComponent() {
        return new TabularExportFailurePanel("Data write error!");
    }

    protected void pass(WizardDescriptor descriptor, TabularExportSuccessPanel component, TabularGraphExportResult result) {
        component.setResult(result);
    }

    protected void fail(TabularExportFailurePanel failurePanel, Exception e) {
        if (e == null) {
            failurePanel.setError(null);
        } else {
            failurePanel.setError(e.getMessage());
        }
    }

    protected TabularGraphExportResult doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws Exception {
        Graph2D viewGraph = (Graph2D)descriptor.getProperty("viewGraph");
        TabularGraphFileExporter exporter = (TabularGraphFileExporter)descriptor.getProperty("fileExporter");
        boolean removeDuplicateRows = (Boolean)descriptor.getProperty("removeDuplicates");
        boolean selectionOnly = (Boolean)descriptor.getProperty("exportSelection");
        boolean separateLinks = (Boolean)descriptor.getProperty("separateLinks");
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)viewGraph);
        if (!GraphSelection.forGraph((GraphID)graphID).hasSelectedEntities()) {
            selectionOnly = false;
        }
        GraphTableBuilder builder = (GraphTableBuilder)descriptor.getProperty("tableBuilder");
        builder.setViewGraph(viewGraph).setSelectionOnly(selectionOnly).setDistinct(removeDuplicateRows).setSeparateLinks(separateLinks);
        exporter.setGraphTableBuilder(builder);
        return exporter.export(handle);
    }

    public boolean canBack() {
        return false;
    }
}

