/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.exp.wizard;

import com.paterva.maltego.graph.table.io.exp.TabularGraphFileExporter;
import com.paterva.maltego.util.ui.dialog.SaveFileController;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;

class TabularExportFileController
extends SaveFileController {
    public TabularExportFileController() {
        super(null, null);
        this.setDescription("Choose the name, file type and location on your file system to save the table structured file.");
    }

    public void readSettings(WizardDescriptor settings) {
        super.readSettings(settings);
        TabularGraphFileExporter[] exporters = (TabularGraphFileExporter[])settings.getProperty("exporters");
        this.populateFileTypes(exporters);
    }

    private void populateFileTypes(TabularGraphFileExporter[] exporters) {
        JFileChooser component = (JFileChooser)this.component();
        component.resetChoosableFileFilters();
        component.setAcceptAllFileFilterUsed(false);
        ArrayList<String> extensions = new ArrayList<String>();
        for (TabularGraphFileExporter exporter : exporters) {
            String extension = exporter.getExtension();
            component.addChoosableFileFilter(new FileNameExtensionFilter(exporter.getFileTypeDescription(), extension));
            extensions.add(extension);
        }
        this.setFileExtensions(extensions.toArray(new String[extensions.size()]));
    }

    public void validate() throws WizardValidationException {
        super.validate();
        File file = this.getSelectedFile();
        TabularGraphFileExporter[] exporters = (TabularGraphFileExporter[])this.getDescriptor().getProperty("exporters");
        TabularGraphFileExporter exporter = null;
        for (TabularGraphFileExporter graphTableImporter : exporters) {
            if (!file.getName().endsWith("." + graphTableImporter.getExtension())) continue;
            exporter = graphTableImporter;
            break;
        }
        if (exporter == null) {
            String error = "No exporter found for the selected file type";
            throw new WizardValidationException((JComponent)this.component(), error, error);
        }
        this.getDescriptor().putProperty("fileExporter", exporter);
        exporter.setFile(file);
    }
}

