/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.exp.wizard;

import com.paterva.maltego.util.ui.dialog.ChangeEventPropagator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TabularExportConfigPanel
extends JPanel {
    private final ChangeEventPropagator changeSupport = new ChangeEventPropagator((Object)this);
    public static final int FORMAT_ENTITY_PAIR = 0;
    public static final int FORMAT_ENTITY_DATA = 1;
    public static final int FORMAT_PROP_FLAT_MAP = 2;
    private JCheckBox _duplicatesCheckBox;
    private JRadioButton _selectionRadioButton;
    private JRadioButton _wholeGraphRadioButton;
    private JRadioButton entityDataRB;
    private JRadioButton entityPairRB;
    private ButtonGroup formatBG;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTable previewTable;
    private JRadioButton propFlatMapRB;
    private JCheckBox separateLinkCB;

    public TabularExportConfigPanel() {
        this.initComponents();
        this._duplicatesCheckBox.addChangeListener((ChangeListener)this.changeSupport);
        this._selectionRadioButton.addChangeListener((ChangeListener)this.changeSupport);
        this._wholeGraphRadioButton.addChangeListener((ChangeListener)this.changeSupport);
        this.entityDataRB.addChangeListener((ChangeListener)this.changeSupport);
        this.entityPairRB.addChangeListener((ChangeListener)this.changeSupport);
        this.propFlatMapRB.addChangeListener((ChangeListener)this.changeSupport);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void setHasSelection(boolean hasSelection) {
        this._wholeGraphRadioButton.setEnabled(hasSelection);
        this._selectionRadioButton.setEnabled(hasSelection);
    }

    public boolean hasSelection() {
        return this._wholeGraphRadioButton.isEnabled();
    }

    public void setExportSelectionOnly(boolean exportSelectionOnly) {
        if (exportSelectionOnly) {
            this._selectionRadioButton.setSelected(true);
        } else {
            this._wholeGraphRadioButton.setSelected(true);
        }
    }

    public int getContentFormat() {
        if (this.entityDataRB.isSelected()) {
            return 1;
        }
        if (this.propFlatMapRB.isSelected()) {
            return 2;
        }
        return 0;
    }

    public void setContentFormat(int contentFormat) {
        this.entityPairRB.setSelected(0 == contentFormat);
        this.entityDataRB.setSelected(1 == contentFormat);
        this.propFlatMapRB.setSelected(2 == contentFormat);
    }

    public boolean isExportSelectionOnly() {
        return this._selectionRadioButton.isSelected();
    }

    public void setRemoveDuplicateRows(boolean removeDuplicates) {
        this._duplicatesCheckBox.setSelected(removeDuplicates);
    }

    public boolean isRemoveDuplicateRows() {
        return this._duplicatesCheckBox.isSelected();
    }

    public void setPreviewData(TableModel dataModel) {
        this.previewTable.setModel(dataModel);
        this.resizeColumns();
    }

    public void setSeparateLinkState(boolean state) {
        this.separateLinkCB.setEnabled(state);
    }

    public boolean getSeparateLinkState() {
        return this.separateLinkCB.isEnabled() && this.separateLinkCB.isSelected();
    }

    private void resizeColumns() {
        float count;
        boolean autoResize = true;
        if (this.getContentFormat() > 0 && (count = (float)this.jScrollPane1.getWidth() / 85.0f) < (float)this.previewTable.getColumnCount()) {
            autoResize = false;
        }
        this.previewTable.setAutoResizeMode(autoResize ? 4 : 0);
    }

    private void initComponents() {
        ButtonGroup selectionButtonGroup = new ButtonGroup();
        this.formatBG = new ButtonGroup();
        this.jPanel1 = new JPanel();
        JLabel selectionLabel = new JLabel();
        this._wholeGraphRadioButton = new JRadioButton();
        this._selectionRadioButton = new JRadioButton();
        this._duplicatesCheckBox = new JCheckBox();
        this.entityPairRB = new JRadioButton();
        this.entityDataRB = new JRadioButton();
        this.propFlatMapRB = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.previewTable = new JTable();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.separateLinkCB = new JCheckBox();
        this.setLayout(new BoxLayout(this, 2));
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)selectionLabel, (String)NbBundle.getMessage(TabularExportConfigPanel.class, (String)"TabularExportConfigPanel.selectionLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 12, 3, 3);
        this.jPanel1.add((Component)selectionLabel, gridBagConstraints);
        selectionButtonGroup.add(this._wholeGraphRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this._wholeGraphRadioButton, (String)NbBundle.getMessage(TabularExportConfigPanel.class, (String)"TabularExportConfigPanel._wholeGraphRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 18, 0, 3);
        this.jPanel1.add((Component)this._wholeGraphRadioButton, gridBagConstraints);
        selectionButtonGroup.add(this._selectionRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this._selectionRadioButton, (String)NbBundle.getMessage(TabularExportConfigPanel.class, (String)"TabularExportConfigPanel._selectionRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 18, 0, 3);
        this.jPanel1.add((Component)this._selectionRadioButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._duplicatesCheckBox, (String)NbBundle.getMessage(TabularExportConfigPanel.class, (String)"TabularExportConfigPanel._duplicatesCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 3, 3);
        this.jPanel1.add((Component)this._duplicatesCheckBox, gridBagConstraints);
        this.formatBG.add(this.entityPairRB);
        this.entityPairRB.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.entityPairRB, (String)NbBundle.getMessage(TabularExportConfigPanel.class, (String)"TabularExportConfigPanel.entityPairRB.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 18, 0, 3);
        this.jPanel1.add((Component)this.entityPairRB, gridBagConstraints);
        this.formatBG.add(this.entityDataRB);
        Mnemonics.setLocalizedText((AbstractButton)this.entityDataRB, (String)NbBundle.getMessage(TabularExportConfigPanel.class, (String)"TabularExportConfigPanel.entityDataRB.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 18, 0, 3);
        this.jPanel1.add((Component)this.entityDataRB, gridBagConstraints);
        this.formatBG.add(this.propFlatMapRB);
        Mnemonics.setLocalizedText((AbstractButton)this.propFlatMapRB, (String)NbBundle.getMessage(TabularExportConfigPanel.class, (String)"TabularExportConfigPanel.propFlatMapRB.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 18, 0, 3);
        this.jPanel1.add((Component)this.propFlatMapRB, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TabularExportConfigPanel.class, (String)"TabularExportConfigPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 12, 3, 3);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(TabularExportConfigPanel.class, (String)"TabularExportConfigPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 12, 3, 3);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setPreferredSize(new Dimension(500, 250));
        this.jScrollPane1.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent evt) {
            }

            @Override
            public void ancestorResized(HierarchyEvent evt) {
                TabularExportConfigPanel.this.jScrollPane1AncestorResized(evt);
            }
        });
        this.previewTable.setBorder(BorderFactory.createBevelBorder(1));
        this.previewTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.previewTable.setAutoResizeMode(0);
        this.previewTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.previewTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 12, 5, 12);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TabularExportConfigPanel.class, (String)"TabularExportConfigPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 24, 3, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.separateLinkCB, (String)NbBundle.getMessage(TabularExportConfigPanel.class, (String)"TabularExportConfigPanel.separateLinkCB.text"));
        this.separateLinkCB.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 23;
        this.jPanel1.add((Component)this.separateLinkCB, gridBagConstraints);
        this.add(this.jPanel1);
    }

    private void jScrollPane1AncestorResized(HierarchyEvent evt) {
        this.resizeColumns();
    }
}

