/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.exp.wizard;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.table.io.exp.EntityDataTableBuilder;
import com.paterva.maltego.graph.table.io.exp.EntityPairTableBuilder;
import com.paterva.maltego.graph.table.io.exp.GraphTableBuilder;
import com.paterva.maltego.graph.table.io.exp.PropertyFlatMapBuilder;
import com.paterva.maltego.graph.table.ui.exp.wizard.ExportTableModel;
import com.paterva.maltego.graph.table.ui.exp.wizard.TabularExportConfigPanel;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;
import y.view.Graph2D;

public class TabularExportConfigController
extends ValidatingController<TabularExportConfigPanel>
implements ChangeListener {
    private ExportTableModel dataModel;
    private Map<Integer, GraphTableBuilder> builderMap;

    public TabularExportConfigController() {
        this.setName("Settings");
        this.setDescription("Choose which part of the graph you want to export. Duplicate rows can optionally be limited to 1 row by checking the \"Remove duplicate rows\" checkbox (typically where different links have corresponding start and end entities)");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/graph/table/ui/resources/ExportTabularGraph.png".replace(".png", "48.png"), (boolean)true));
        this.dataModel = new ExportTableModel();
        this.dataModel.setRowLimit(20);
        this.builderMap = new HashMap<Integer, GraphTableBuilder>();
        this.builderMap.put(0, (GraphTableBuilder)new EntityPairTableBuilder());
        this.builderMap.put(1, (GraphTableBuilder)new EntityDataTableBuilder());
        this.builderMap.put(2, (GraphTableBuilder)new PropertyFlatMapBuilder());
    }

    protected TabularExportConfigPanel createComponent() {
        TabularExportConfigPanel component = new TabularExportConfigPanel();
        component.addChangeListener(this.changeListener());
        component.addChangeListener(this);
        return component;
    }

    protected void readSettings(WizardDescriptor settings) {
        Graph2D viewGraph = (Graph2D)settings.getProperty("viewGraph");
        boolean exportSelectionOnly = (Boolean)settings.getProperty("exportSelection");
        boolean removeDuplicates = (Boolean)settings.getProperty("removeDuplicates");
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)viewGraph);
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        boolean hasSelection = selection.hasSelectedEntities();
        int contentFormat = 0;
        GraphTableBuilder builder = (GraphTableBuilder)settings.getProperty("tableBuilder");
        if (builder == null) {
            builder = this.builderMap.get(contentFormat);
        }
        if (builder instanceof EntityDataTableBuilder) {
            contentFormat = 1;
        }
        builder.setViewGraph(viewGraph).setSelectionOnly(exportSelectionOnly).setDistinct(removeDuplicates);
        this.dataModel.setTableBuilder(builder);
        ((TabularExportConfigPanel)this.component()).setHasSelection(hasSelection);
        ((TabularExportConfigPanel)this.component()).setExportSelectionOnly(hasSelection && exportSelectionOnly);
        ((TabularExportConfigPanel)this.component()).setRemoveDuplicateRows(removeDuplicates);
        ((TabularExportConfigPanel)this.component()).setContentFormat(contentFormat);
        ((TabularExportConfigPanel)this.component()).setPreviewData(this.dataModel);
    }

    protected void storeSettings(WizardDescriptor settings) {
        if (((TabularExportConfigPanel)this.component()).hasSelection()) {
            settings.putProperty("exportSelection", (Object)((TabularExportConfigPanel)this.component()).isExportSelectionOnly());
        }
        settings.putProperty("removeDuplicates", (Object)((TabularExportConfigPanel)this.component()).isRemoveDuplicateRows());
        settings.putProperty("separateLinks", (Object)((TabularExportConfigPanel)this.component()).getSeparateLinkState());
        int contentFormat = ((TabularExportConfigPanel)this.component()).getContentFormat();
        settings.putProperty("tableBuilder", (Object)this.builderMap.get(contentFormat));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        WizardDescriptor settings = this.getDescriptor();
        Graph2D viewGraph = (Graph2D)settings.getProperty("viewGraph");
        boolean distinct = ((TabularExportConfigPanel)this.component()).isRemoveDuplicateRows();
        boolean selectionOnly = ((TabularExportConfigPanel)this.component()).hasSelection() & ((TabularExportConfigPanel)this.component()).isExportSelectionOnly();
        int contentFormat = ((TabularExportConfigPanel)this.component()).getContentFormat();
        GraphTableBuilder builder = this.builderMap.get(contentFormat);
        builder.setViewGraph(viewGraph).setSelectionOnly(selectionOnly).setDistinct(distinct);
        this.dataModel.setTableBuilder(builder);
        ((TabularExportConfigPanel)this.component()).setPreviewData(this.dataModel);
        ((TabularExportConfigPanel)this.component()).setSeparateLinkState(0 != contentFormat);
    }
}

