/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.structures;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ViewLink {
    private final Set<LinkID> _collection;
    private final LinkEntityIDs _entities;

    public ViewLink(EntityID sourceID, EntityID targetID) {
        this._entities = new LinkEntityIDs(sourceID, targetID);
        this._collection = new HashSet<LinkID>();
    }

    public ViewLink(LinkEntityIDs entities) {
        this._entities = new LinkEntityIDs(entities);
        this._collection = new HashSet<LinkID>();
    }

    public ViewLink(EntityID sourceID, EntityID targetID, Set<LinkID> collection) {
        this._entities = new LinkEntityIDs(sourceID, targetID);
        this._collection = collection;
    }

    public ViewLink(LinkEntityIDs entities, Set<LinkID> collection) {
        this._entities = new LinkEntityIDs(entities);
        this._collection = collection;
    }

    public ViewLink(ViewLink viewLink) {
        this._entities = new LinkEntityIDs(viewLink._entities);
        this._collection = new HashSet<LinkID>();
        this._collection.addAll(viewLink._collection);
    }

    public Set<LinkID> getCollection() {
        return this._collection;
    }

    public LinkEntityIDs getEntities() {
        return this._entities;
    }

    public boolean isCollection() {
        return !this._collection.isEmpty();
    }

    public String toString() {
        return "ViewLink{_collection=" + this._collection + ", _entities=" + this._entities + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this._collection);
        hash = 89 * hash + Objects.hashCode(this._entities);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewLink other = (ViewLink)obj;
        if (!Objects.equals(this._collection, other._collection)) {
            return false;
        }
        return Objects.equals(this._entities, other._entities);
    }
}

