/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.collect;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.tools.CollectionUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionNodeLayoutReader
implements GraphLayoutReader {
    private static final Point ORIGIN_POINT = new Point(0, 0);
    public static final List<Point> STRAIGHT_PATH = Arrays.asList(ORIGIN_POINT, ORIGIN_POINT);
    private final GraphLayoutReader _modelReader;
    private final InMemoryCollectionNodes _collectionNodes;

    public CollectionNodeLayoutReader(GraphLayoutReader modelReader, InMemoryCollectionNodes collectionNodes) {
        this._modelReader = modelReader;
        this._collectionNodes = collectionNodes;
    }

    public GraphLayoutReader getModelReader() {
        return this._modelReader;
    }

    public int getEntityCount() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getLinkCount() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean exists(EntityID entityID) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean exists(LinkID linkID) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<EntityID, Point> getAllCenters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<LinkID, List<Point>> getAllPaths() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<EntityID, Point> getCenters(Collection<EntityID> entities) throws GraphStoreException {
        Map<EntityID, Set<EntityID>> modelEntitiesMap = this._collectionNodes.getModelEntitiesMap(entities);
        HashSet modelEntities = new HashSet();
        for (Map.Entry<EntityID, Set<EntityID>> entry : modelEntitiesMap.entrySet()) {
            modelEntities.addAll(entry.getValue());
        }
        HashMap<EntityID, Point> viewCentersMap = new HashMap<EntityID, Point>();
        Map modelCentersMap = this._modelReader.getCenters(modelEntities);
        for (EntityID viewEntityID : entities) {
            Set<EntityID> modelEntityIDs = modelEntitiesMap.get(viewEntityID);
            ArrayList<Point> modelCentersList = new ArrayList<Point>();
            for (EntityID modelEntityID : modelEntityIDs) {
                modelCentersList.add((Point)modelCentersMap.get(modelEntityID));
            }
            viewCentersMap.put(viewEntityID, CollectionUtils.getMean(modelCentersList));
        }
        return viewCentersMap;
    }

    public Point getCenter(EntityID entity) throws GraphStoreException {
        Set<EntityID> modelEntities = this._collectionNodes.getModelEntities(entity);
        Map centers = this._modelReader.getCenters(modelEntities);
        return CollectionUtils.getMean(centers.values());
    }

    public Map<LinkID, List<Point>> getPaths(Collection<LinkID> links) throws GraphStoreException {
        Map<LinkID, Set<LinkID>> modelLinksMap = this._collectionNodes.getModelLinksMap(links);
        HashSet modelLinks = new HashSet();
        for (Map.Entry<LinkID, Set<LinkID>> entry : modelLinksMap.entrySet()) {
            modelLinks.addAll(entry.getValue());
        }
        HashMap<LinkID, List<Point>> viewPathsMap = new HashMap<LinkID, List<Point>>();
        Map modelPathsMap = this._modelReader.getPaths(modelLinks);
        for (LinkID viewLinkID : links) {
            Set<LinkID> modelLinkIDs = modelLinksMap.get(viewLinkID);
            HashMap<LinkID, List<Point>> paths = new HashMap<LinkID, List<Point>>();
            for (LinkID modelLinkID : modelLinkIDs) {
                paths.put(modelLinkID, (List<Point>)modelPathsMap.get(modelLinkID));
            }
            viewPathsMap.put(viewLinkID, this.getViewPath(paths));
        }
        return viewPathsMap;
    }

    public List<Point> getPath(LinkID link) throws GraphStoreException {
        Set<LinkID> modelLinks = this._collectionNodes.getModelLinks(link);
        Map modelPaths = this._modelReader.getPaths(modelLinks);
        return this.getViewPath(modelPaths);
    }

    private List<Point> getViewPath(Map<LinkID, List<Point>> modelPaths) {
        List<Point> viewPath = null;
        for (Map.Entry<LinkID, List<Point>> entry : modelPaths.entrySet()) {
            List<Point> modelPath = entry.getValue();
            if (viewPath == null) {
                viewPath = modelPath;
                continue;
            }
            if (viewPath.equals(modelPath)) continue;
            viewPath = STRAIGHT_PATH;
            break;
        }
        return viewPath;
    }
}

