/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.collect;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.views.collect.CollectionSettings;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.ribbon.JFlowRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.internal.ui.ribbon.JFlowBandControlPanel;

public class CollectionMinEntityAmountAction
extends JFlowRibbonBand {
    private static final int UPPER_LIMIT = 255;
    private static final int NEVER_COLLECT = Integer.MAX_VALUE;
    private JSpinner _spinner;
    private JSlider _slider;
    private Map<Integer, Integer> _sliderMap;
    private boolean _mouseDown = false;
    private boolean _isUpdatingSettings = false;
    private boolean _isUpdatingSpinner = false;
    private boolean _isUpdatingSlider = false;
    private GraphID _topGraphID = null;

    public CollectionMinEntityAmountAction() {
        super("Options", null);
        this.initComponents();
        ArrayList<CoreRibbonResizePolicies.FlowThreeRows> policyList = new ArrayList<CoreRibbonResizePolicies.FlowThreeRows>();
        policyList.add(new CoreRibbonResizePolicies.FlowThreeRows((JFlowBandControlPanel)this.getControlPanel()));
        this.setResizePolicies(policyList);
    }

    private void initComponents() {
        TransparentPanel panel = new TransparentPanel();
        int initialValue = 25;
        SpinnerNumberModel spinnerMolel = new SpinnerNumberModel(initialValue, CollectionSettings.getDefault().getLowerLimitMinRequiredEntitiesPerNode(), 255, 1);
        this._spinner = new JSpinner(spinnerMolel);
        this._spinner.setToolTipText("The minimum amount of entites per collection-node");
        Dimension spinnerPrefSize = this._spinner.getPreferredSize();
        this._spinner.setPreferredSize(new Dimension(Math.min(spinnerPrefSize.width, 60), spinnerPrefSize.height));
        this._spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!CollectionMinEntityAmountAction.this._isUpdatingSpinner) {
                    CollectionMinEntityAmountAction.this._isUpdatingSpinner = true;
                    int newValue = (Integer)CollectionMinEntityAmountAction.this._spinner.getValue();
                    CollectionSettings.getDefault().setMinRequiredEntitiesPerNode(CollectionMinEntityAmountAction.this._topGraphID, newValue);
                    CollectionMinEntityAmountAction.this._isUpdatingSpinner = false;
                }
            }
        });
        this._spinner.setEnabled(false);
        TransparentPanel spinnerPanel = new TransparentPanel();
        spinnerPanel.add(this._spinner);
        spinnerPanel.setBorder(new EmptyBorder(12, 0, 12, 0));
        TransparentPanel sliderPanel = new TransparentPanel();
        int minorTickSpacing = 55;
        int majorTickSpacing = minorTickSpacing * 2;
        int ticks = 25;
        int max = minorTickSpacing * (ticks - 1);
        this._slider = new JSlider(0, max, 550){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 300;
                return size;
            }
        };
        this._slider.setOpaque(false);
        this._slider.setSnapToTicks(false);
        this._slider.setPaintLabels(true);
        this._slider.setPaintTicks(true);
        this._slider.setPaintTrack(true);
        this._slider.setMinorTickSpacing(minorTickSpacing);
        this._slider.setMajorTickSpacing(majorTickSpacing);
        this._sliderMap = new TreeMap<Integer, Integer>();
        for (int i = 0; i <= max; ++i) {
            int value = i <= 7 * minorTickSpacing ? i / minorTickSpacing + 3 : (i <= 15 * minorTickSpacing ? (i - 7 * minorTickSpacing) / 11 + 10 : (i <= 20 * minorTickSpacing ? (int)((double)(i - 15 * minorTickSpacing) / 5.5 + 50.0) : (i <= 22 * minorTickSpacing ? (int)((double)(i - 20 * minorTickSpacing) / 1.1 + 100.0) : (i <= 23 * minorTickSpacing ? i - 22 * minorTickSpacing + 200 : (i < 24 * minorTickSpacing ? 255 : Integer.MAX_VALUE)))));
            this._sliderMap.put(i, value);
        }
        Hashtable<Integer, GreyLabel> hashtable = new Hashtable<Integer, GreyLabel>();
        int previousValue = 0;
        for (int i = 0; i <= max; ++i) {
            Integer value = this._sliderMap.get(i);
            boolean showLabel = value != previousValue && (value == 3 || value == 8 || value == 25 || value == 50 || value == 100 || value > 255);
            previousValue = value;
            if (!showLabel) continue;
            String label = i == max ? "Never" : Integer.toString(value);
            hashtable.put(i, new GreyLabel(label));
        }
        this._slider.setLabelTable(hashtable);
        sliderPanel.add(this._slider);
        panel.add((Component)spinnerPanel, "Center");
        TransparentPanel outerSliderPanel = new TransparentPanel();
        TransparentPanel innerSliderPanel = new TransparentPanel();
        TransparentPanel moreLessPanel = new TransparentPanel();
        moreLessPanel.add(new GreyLabel("More"));
        moreLessPanel.add((Component)new GreyLabel("Less"), "East");
        moreLessPanel.setBorder(new EmptyBorder(0, 14, 0, 14));
        innerSliderPanel.add((Component)moreLessPanel, "North");
        innerSliderPanel.add(sliderPanel);
        GreyLabel simplifyLabel = new GreyLabel("Simplify Graph");
        simplifyLabel.setHorizontalAlignment(0);
        outerSliderPanel.add((Component)simplifyLabel, "North");
        outerSliderPanel.add(innerSliderPanel);
        this.addFlowComponent(outerSliderPanel);
        this.addFlowComponent(panel);
        this.onSettingsUpdated();
        this._slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CollectionMinEntityAmountAction.this._mouseDown = true;
                CollectionMinEntityAmountAction.this._slider.setSnapToTicks(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CollectionMinEntityAmountAction.this._mouseDown = false;
                CollectionMinEntityAmountAction.this._slider.setSnapToTicks(false);
                CollectionMinEntityAmountAction.this.onSliderChanged();
            }
        });
        this._slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!CollectionMinEntityAmountAction.this._mouseDown) {
                    CollectionMinEntityAmountAction.this.onSliderChanged();
                }
            }
        });
        this._slider.setEnabled(false);
        CollectionSettings.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!CollectionMinEntityAmountAction.this._isUpdatingSettings) {
                    CollectionMinEntityAmountAction.this._isUpdatingSettings = true;
                    CollectionMinEntityAmountAction.this.onSettingsUpdated();
                    CollectionMinEntityAmountAction.this._isUpdatingSettings = false;
                }
            }
        });
        GraphEditorRegistry.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("topmost".equals(evt.getPropertyName())) {
                    CollectionMinEntityAmountAction.this.update();
                }
            }
        });
    }

    private void update() {
        GraphID graphID = this.getViewGraphID();
        if (this._topGraphID != graphID) {
            this._topGraphID = graphID;
            this.onSettingsUpdated();
        }
    }

    private GraphID getViewGraphID() {
        GraphCookie cookie;
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        if (tc != null && (cookie = (GraphCookie)tc.getLookup().lookup(GraphCookie.class)) != null) {
            return cookie.getGraphID();
        }
        return null;
    }

    private void onSettingsUpdated() {
        boolean hasTopGraph = this._topGraphID != null;
        this._slider.setEnabled(hasTopGraph);
        this._spinner.setEnabled(hasTopGraph);
        if (hasTopGraph) {
            CollectionSettings settings = CollectionSettings.getDefault();
            int value = settings.getMinRequiredEntitiesPerNode(this._topGraphID);
            boolean enabled = settings.isEnabled(this._topGraphID);
            if (!this._isUpdatingSlider) {
                int sliderValue = Integer.MAX_VALUE;
                if (enabled) {
                    for (Map.Entry<Integer, Integer> entry : this._sliderMap.entrySet()) {
                        if (value != entry.getValue()) continue;
                        sliderValue = entry.getKey();
                        break;
                    }
                }
                this._slider.setValue(sliderValue);
            }
            if (!this._isUpdatingSpinner) {
                this._spinner.setValue(value);
                this._spinner.setEnabled(enabled);
            }
        }
    }

    private void onSliderChanged() {
        if (!this._isUpdatingSlider && this._topGraphID != null) {
            this._isUpdatingSlider = true;
            int sliderValue = this._slider.getValue();
            int value = this._sliderMap.get(sliderValue);
            boolean isNever = value == Integer.MAX_VALUE;
            CollectionSettings settings = CollectionSettings.getDefault();
            settings.setEnabled(this._topGraphID, !isNever);
            if (!isNever) {
                settings.setMinRequiredEntitiesPerNode(this._topGraphID, value);
            }
            this._isUpdatingSlider = false;
        }
    }

    private static class GreyLabel
    extends JLabel {
        public GreyLabel(String text) {
            super(text);
            this.setForeground(new Color(70, 70, 70));
        }
    }

    private static class TransparentPanel
    extends JPanel {
        public TransparentPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
        }
    }
}

