/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.imgfactory.impl.CachedImageFactory;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.ImageCache;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageCallback;
import java.awt.Image;

public class IconResourceImageFactory
extends ImageCache {
    private ImageCache _delegate;

    public IconResourceImageFactory() {
        this(new CachedImageFactory());
    }

    public IconResourceImageFactory(ImageCache delegate) {
        this._delegate = delegate;
    }

    public Image getImage(GraphID graphID, Object imageKey, ImageCallback cb) {
        return this.getImage(graphID, imageKey, -1, -1, cb);
    }

    public Image getImage(GraphID graphID, Object imageKey, int width, int height, ImageCallback cb) {
        if (!this.contains(imageKey) && imageKey instanceof String) {
            String imageKeyStr = imageKey.toString();
            if (FastURL.isFastURL((String)imageKeyStr)) {
                imageKey = new FastURL(imageKeyStr);
            } else {
                IconSize resourceSize = IconResourceImageFactory.getResourceSize(width, height);
                if (cb != null && cb.getClass().getName().contains("EmptyImgCallback")) {
                    cb = null;
                }
                return IconRegistry.forGraphID((GraphID)graphID).loadImage((String)imageKey, resourceSize, cb).orElse(null);
            }
        }
        return this._delegate.getImage(graphID, imageKey, width, height, cb);
    }

    private static IconSize getResourceSize(int width, int height) {
        int size = IconResourceImageFactory.positiveMin(width, height);
        IconSize resourceSize = size < 0 ? IconSize.MASSIVE : (size <= 20 ? IconSize.TINY : (size <= 28 ? IconSize.SMALL : (size <= 38 ? IconSize.MEDIUM : (size <= 52 ? IconSize.LARGE : IconSize.MASSIVE))));
        return resourceSize;
    }

    private static int positiveMin(int a, int b) {
        if (a < 0 && b < 0) {
            return -1;
        }
        if (a < 0 && b > 0) {
            return b;
        }
        if (a > 0 && b < 0) {
            return a;
        }
        return Math.min(a, b);
    }

    public void addImage(Object newImageKey, Image image) {
        this._delegate.addImage(newImageKey, image);
    }

    public Image resizeImage(GraphID graphID, Object newImageKey, Image originalImage, int width, int height, ImageCallback cb) {
        return this._delegate.resizeImage(graphID, newImageKey, originalImage, width, height, cb);
    }

    public boolean contains(Object imageKey) {
        return this._delegate.contains(imageKey);
    }

    public void remove(Object imageKey) {
        this._delegate.remove(imageKey);
    }

    public boolean mustResize(Image image, int requestedWidth, int requestedHeight) {
        return this._delegate.mustResize(image, requestedWidth, requestedHeight);
    }

    public void resetFailedImages() {
        this._delegate.resetFailedImages();
    }
}

