/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.icons;

import com.paterva.maltego.imgfactoryapi.IconUtils;
import com.paterva.maltego.imgfactoryapi.ReadOnlyIconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.XmlSerializer;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

public abstract class IconResourceRegistry
extends ReadOnlyIconRegistry {
    private static IconResourceRegistry _default;

    public static synchronized IconResourceRegistry getDefault() {
        if (_default == null && (_default = (IconResourceRegistry)((Object)Lookup.getDefault().lookup(IconResourceRegistry.class))) == null) {
            _default = new Default();
        }
        return _default;
    }

    private static class IconPathAndAliases {
        private final String _path;
        private final Set<String> _aliases;

        public IconPathAndAliases(String path, Set<String> aliases) {
            Args.notNullOrBlank((String)path, (String)"path");
            Args.notNull(aliases, (String)"aliases");
            this._path = path;
            this._aliases = aliases;
        }

        public String getPath() {
            return this._path;
        }

        public Set<String> getAliases() {
            return this._aliases;
        }
    }

    @Root(name="Icon", strict=false)
    private static class IconStub {
        @Attribute(name="name", required=true)
        private String _name;
        @Attribute(name="path", required=true)
        private String _path;
        @ElementList(name="Aliases", entry="Alias", required=false)
        private List<String> _aliases;

        private IconStub() {
        }

        public String getName() {
            return this._name;
        }

        public String getPath() {
            return this._path;
        }

        public Set<String> getAliases() {
            return this._aliases != null ? new LinkedHashSet<String>(this._aliases) : Collections.emptySet();
        }
    }

    @Root(name="Icons", strict=false)
    private static class IconsStub {
        @Attribute(name="basedir", required=false)
        private String _baseDir;
        @ElementList(name="Icons", type=IconStub.class, required=true, inline=true)
        private List<IconStub> _icons;

        private IconsStub() {
        }

        public List<IconStub> icons() {
            if (this._icons == null) {
                this._icons = new ArrayList<IconStub>();
            }
            return this._icons;
        }

        public String getBaseDir() {
            return this._baseDir;
        }

        public String getAbsolutePath(String path) {
            String basedir;
            if (this._baseDir != null && (basedir = this._baseDir.trim()).length() > 0) {
                if (basedir.endsWith("/")) {
                    basedir = basedir.substring(0, basedir.length() - 1);
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                return basedir + "/" + path;
            }
            return path;
        }
    }

    public static class Default
    extends IconResourceRegistry {
        private final FileObject _configRoot;
        private LinkedHashMap<String, TreeMap<String, IconPathAndAliases>> _categories;

        public Default() {
            this(FileUtil.getConfigRoot());
        }

        public Default(FileObject configRoot) {
            this._configRoot = configRoot;
        }

        private LinkedHashMap<String, TreeMap<String, IconPathAndAliases>> categories() {
            this.init();
            return this._categories;
        }

        private synchronized void init() {
            if (this._categories == null) {
                FileObject icons;
                this._categories = new LinkedHashMap();
                FileObject maltego = this._configRoot.getFileObject("Maltego");
                if (maltego != null && (icons = maltego.getFileObject("IconBrowser")) != null) {
                    TreeMap tempCategories = new TreeMap();
                    for (FileObject category : icons.getChildren()) {
                        Enumeration iconFileEnum = category.getData(false);
                        TreeMap<String, IconPathAndAliases> namePathMap = new TreeMap<String, IconPathAndAliases>(String.CASE_INSENSITIVE_ORDER);
                        while (iconFileEnum.hasMoreElements()) {
                            namePathMap.putAll(this.loadFile((FileObject)iconFileEnum.nextElement()));
                        }
                        tempCategories.put(category.getName().trim(), namePathMap);
                    }
                    this._categories.putAll(tempCategories);
                }
            }
        }

        private TreeMap<String, IconPathAndAliases> loadFile(FileObject fo) {
            Args.notNull((Object)fo, (String)"fo");
            TreeMap<String, IconPathAndAliases> namePathMap = new TreeMap<String, IconPathAndAliases>(String.CASE_INSENSITIVE_ORDER);
            try (InputStream in = fo.getInputStream();){
                XmlSerializer serializer = new XmlSerializer();
                IconsStub stub = (IconsStub)serializer.read(IconsStub.class, in);
                for (IconStub icon : stub.icons()) {
                    String name = icon.getName().trim();
                    String path = stub.getAbsolutePath(icon.getPath());
                    Set<String> aliases = icon.getAliases();
                    if (aliases == null) {
                        aliases = Collections.emptySet();
                    }
                    namePathMap.put(name, new IconPathAndAliases(path, aliases));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return namePathMap;
        }

        private Optional<String> getPath(RegistryIcon icon) {
            IconPathAndAliases pathAndAliases;
            Args.notNull((Object)icon, (String)"icon");
            LinkedHashMap<String, TreeMap<String, IconPathAndAliases>> categories = this.categories();
            TreeMap<String, IconPathAndAliases> namePathMap = categories.get(icon.getCategory());
            if (namePathMap != null && (pathAndAliases = namePathMap.get(icon.getName())) != null) {
                return Optional.ofNullable(pathAndAliases.getPath());
            }
            return Optional.empty();
        }

        public List<RegistryIcon> getIcons() {
            return this.getIcons((String __) -> true);
        }

        public List<RegistryIcon> getIcons(String category) {
            return this.getIcons((String cat) -> cat.equals(category));
        }

        private List<RegistryIcon> getIcons(Predicate<String> categoryFilter) {
            return this.categories().entrySet().stream().filter(entry -> categoryFilter.test((String)entry.getKey())).map(entry -> this.toRegistryIcons((String)entry.getKey(), (Map)entry.getValue())).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private List<RegistryIcon> toRegistryIcons(String category, Map<String, IconPathAndAliases> nameMap) {
            Args.notNullOrBlank((String)category, (String)"category");
            Args.notNull(nameMap, (String)"nameMap");
            return nameMap.entrySet().stream().map(entry -> this.toRegistryIcon(category, (String)entry.getKey(), ((IconPathAndAliases)entry.getValue()).getAliases(), Collections.emptySet())).collect(Collectors.toList());
        }

        public boolean contains(RegistryIcon icon) {
            Args.notNull((Object)icon, (String)"icon");
            TreeMap<String, IconPathAndAliases> namesMap = this.categories().get(icon.getCategory());
            return namesMap != null && namesMap.containsKey(icon.getName());
        }

        public Set<String> getCategories() {
            Set<String> set = this.categories().keySet();
            return Collections.unmodifiableSet(set);
        }

        public Set<String> getIconNames(String category) {
            Args.notNullOrBlank((String)category, (String)"category");
            TreeMap<String, IconPathAndAliases> nameMap = this.categories().get(category);
            return nameMap != null ? nameMap.keySet() : Collections.emptySet();
        }

        public Optional<Image> loadImage(RegistryIcon icon, IconSize resourceSize) {
            Args.notNull((Object)icon, (String)"icon");
            Args.notNull((Object)resourceSize, (String)"resourceSize");
            Optional<String> resourcePathOpt = this.getPath(icon);
            if (!resourcePathOpt.isPresent()) {
                return Optional.empty();
            }
            String resourcePath = resourcePathOpt.get();
            Image img = ImageUtilities.loadImage((String)resourceSize.addPostfix(resourcePath));
            if (img == null) {
                img = IconSize.getBiggestForIconType((String)resourcePath, (IconSize)resourceSize);
            }
            if (img != null) {
                boolean mustResize = true;
                boolean svg = ImageUtils.isSVGFile((String)resourcePath);
                if (!svg) {
                    BufferedImage bImg = (BufferedImage)img;
                    boolean bl = resourceSize == IconSize.MASSIVE ? IconUtils.mustResize((BufferedImage)bImg, (IconSize)IconSize.LARGE) && IconUtils.mustResize((BufferedImage)bImg, (IconSize)IconSize.MASSIVE) : (mustResize = IconUtils.mustResize((BufferedImage)bImg, (IconSize)resourceSize));
                }
                if (mustResize) {
                    img = ImageUtils.smartSize((BufferedImage)((BufferedImage)img), (double)resourceSize.getSize());
                }
            }
            return Optional.ofNullable(img);
        }
    }
}

