/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.ui;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.typing.descriptor.TypeSpecDisplayNameComparator;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.util.ui.components.LabelGroupWithBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class FindSettingsPanel
extends JPanel {
    public static final String PROP_FIND = "findInFilesSearch";
    private static final String ALL = "<All>";
    private transient ChangeListener _toggleListener;
    private transient ChangeListener _itemsListener;
    private FileChooserBuilder _builder;
    private boolean _updating = false;
    private JButton _browseButton;
    private JCheckBox _caseCheckBox;
    private JCheckBox _displayInfoCheckBox;
    private JCheckBox _entitiesCheckBox;
    private JComboBox _entityTypeComboBox;
    private JLabel _errorLabel;
    private JTextField _findTextField;
    private JCheckBox _linksCheckBox;
    private JCheckBox _notesCheckBox;
    private JCheckBox _propertiesCheckBox;
    private JCheckBox _recursiveCheckBox;
    private JCheckBox _regexCheckBox;
    private JButton _searchButton;
    private JCheckBox _valueCheckBox;
    private JTextField _whereTextField;
    private LabelGroupWithBackground jLabel1;
    private LabelGroupWithBackground jLabel2;
    private LabelGroupWithBackground jLabel3;
    private LabelGroupWithBackground jLabel4;

    public FindSettingsPanel() {
        this.initComponents();
        LabelGroupWithBackground.groupLabels((LabelGroupWithBackground[])new LabelGroupWithBackground[]{this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4});
        this._builder = new FileChooserBuilder(GraphDataObject.class);
        this._builder.setDirectoriesOnly(true);
        this._builder.setTitle("Select a folder");
        this._builder.setApproveText("Select Folder");
        File previousDir = this._builder.createFileChooser().getCurrentDirectory();
        if (previousDir != null) {
            this._whereTextField.setText(previousDir.getAbsolutePath());
        }
        this._toggleListener = new ToggleListener();
        this._valueCheckBox.setSelected(true);
        this._valueCheckBox.addChangeListener(this._toggleListener);
        this._propertiesCheckBox.addChangeListener(this._toggleListener);
        this._displayInfoCheckBox.addChangeListener(this._toggleListener);
        this._notesCheckBox.addChangeListener(this._toggleListener);
        this._itemsListener = new ItemsListener();
        this._entitiesCheckBox.setSelected(true);
        this._entitiesCheckBox.addChangeListener(this._itemsListener);
        this._linksCheckBox.addChangeListener(this._itemsListener);
        SearchActionListener searchActionListener = new SearchActionListener();
        this._searchButton.addActionListener(searchActionListener);
        ClearErrorListener clearErrorListener = new ClearErrorListener();
        this._whereTextField.getDocument().addDocumentListener(clearErrorListener);
        this._findTextField.getDocument().addDocumentListener(clearErrorListener);
        this._findTextField.addActionListener(searchActionListener);
        this._errorLabel.setText("");
        this.populateTypeCombo();
        this._regexCheckBox.setVisible(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._findTextField.requestFocusInWindow();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._valueCheckBox.setEnabled(enabled);
        this._propertiesCheckBox.setEnabled(enabled);
        this._displayInfoCheckBox.setEnabled(enabled);
        this._notesCheckBox.setEnabled(enabled);
        this._whereTextField.setEnabled(enabled);
        this._browseButton.setEnabled(enabled);
        this._recursiveCheckBox.setEnabled(enabled);
        this._findTextField.setEnabled(enabled);
        this._caseCheckBox.setEnabled(enabled);
        this._entitiesCheckBox.setEnabled(enabled);
        this._linksCheckBox.setEnabled(enabled);
        this._searchButton.setEnabled(enabled);
        this._regexCheckBox.setEnabled(enabled);
    }

    public boolean isSearchEntities() {
        return this._entitiesCheckBox.isSelected();
    }

    public void setSearchEntities(boolean searchEntities) {
        this._updating = true;
        this._entitiesCheckBox.setSelected(searchEntities);
        this._updating = false;
    }

    public boolean isSearchLinks() {
        return this._linksCheckBox.isSelected();
    }

    public void setSearchLinks(boolean searchLinks) {
        this._updating = true;
        this._linksCheckBox.setSelected(searchLinks);
        this._updating = false;
    }

    public boolean isSearchValue() {
        return this._valueCheckBox.isSelected();
    }

    public void setSearchValue(boolean searchValue) {
        this._updating = true;
        this._valueCheckBox.setSelected(searchValue);
        this._updating = false;
    }

    public boolean isSearchProperties() {
        return this._propertiesCheckBox.isSelected();
    }

    public void setSearchProperties(boolean searchProperties) {
        this._updating = true;
        this._propertiesCheckBox.setSelected(searchProperties);
        this._updating = false;
    }

    public boolean isSearchDisplayInfo() {
        return this._displayInfoCheckBox.isSelected();
    }

    public void setSearchDisplayInfo(boolean searchDisplayInfo) {
        this._updating = true;
        this._displayInfoCheckBox.setSelected(searchDisplayInfo);
        this._updating = false;
    }

    public boolean isSearchNotes() {
        return this._notesCheckBox.isSelected();
    }

    public void setSearchNotes(boolean searchNotes) {
        this._updating = true;
        this._notesCheckBox.setSelected(searchNotes);
        this._updating = false;
    }

    public boolean isCaseSensitive() {
        return this._caseCheckBox.isSelected();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseCheckBox.setSelected(caseSensitive);
    }

    public boolean isRecursive() {
        return this._recursiveCheckBox.isSelected();
    }

    public void setRecursive(boolean recursive) {
        this._recursiveCheckBox.setSelected(recursive);
    }

    public String getPath() {
        return this._whereTextField.getText();
    }

    public String getSearchString() {
        return this._findTextField.getText();
    }

    public void setSearchString(String text) {
        this._findTextField.setText(text);
    }

    public void setError(String error) {
        if (!error.isEmpty()) {
            error = "Error: " + error;
        }
        this._errorLabel.setText(error);
    }

    public Object getEntityType() {
        return this._entityTypeComboBox.getSelectedItem();
    }

    public void setIsRegex(boolean isRegex) {
        this._regexCheckBox.setSelected(isRegex);
    }

    public boolean isRegex() {
        return this._regexCheckBox.isSelected();
    }

    private void initComponents() {
        this._whereTextField = new JTextField();
        this._findTextField = new JTextField();
        this._browseButton = new JButton();
        this._searchButton = new JButton();
        this._recursiveCheckBox = new JCheckBox();
        this._caseCheckBox = new JCheckBox();
        this._entitiesCheckBox = new JCheckBox();
        this._linksCheckBox = new JCheckBox();
        this._valueCheckBox = new JCheckBox();
        this._propertiesCheckBox = new JCheckBox();
        this._errorLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this._displayInfoCheckBox = new JCheckBox();
        this._notesCheckBox = new JCheckBox();
        this._entityTypeComboBox = new JComboBox();
        this._regexCheckBox = new JCheckBox();
        this.jLabel1 = new LabelGroupWithBackground();
        this.jLabel2 = new LabelGroupWithBackground();
        this.jLabel3 = new LabelGroupWithBackground();
        this.jLabel4 = new LabelGroupWithBackground();
        this.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 6));
        this.setLayout(new GridBagLayout());
        this._whereTextField.setText(NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._whereTextField.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 53;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.add((Component)this._whereTextField, gridBagConstraints);
        this._findTextField.setText(NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._findTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 53;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.add((Component)this._findTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._browseButton, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._browseButton.text"));
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindSettingsPanel.this._browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this._browseButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._searchButton, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._searchButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this._searchButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._recursiveCheckBox, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._recursiveCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this._recursiveCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._caseCheckBox, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._caseCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this._caseCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._entitiesCheckBox, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._entitiesCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this._entitiesCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._linksCheckBox, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._linksCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this._linksCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._valueCheckBox, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._valueCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this._valueCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._propertiesCheckBox, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._propertiesCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.add((Component)this._propertiesCheckBox, gridBagConstraints);
        this._errorLabel.setForeground(new Color(204, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this._errorLabel, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._errorLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this._errorLabel, gridBagConstraints);
        jPanel2.setMinimumSize(new Dimension(0, 0));
        jPanel2.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel2, gridBagConstraints);
        jPanel3.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this._displayInfoCheckBox, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._displayInfoCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        jPanel3.add((Component)this._displayInfoCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._notesCheckBox, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._notesCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        jPanel3.add((Component)this._notesCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel3, gridBagConstraints);
        this._entityTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.add((Component)this._entityTypeComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._regexCheckBox, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel._regexCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this._regexCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(FindSettingsPanel.class, (String)"FindSettingsPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
    }

    private void _browseButtonActionPerformed(ActionEvent evt) {
        File folder;
        JFileChooser fc = this._builder.createFileChooser();
        if (0 == fc.showOpenDialog(WindowManager.getDefault().getMainWindow()) && (folder = fc.getSelectedFile()).isDirectory()) {
            String path = folder.getAbsolutePath();
            NbPreferences.forModule(FileChooserBuilder.class).put(GraphDataObject.class.getName(), path);
            this._whereTextField.setText(path);
        }
    }

    private void populateTypeCombo() {
        this._entityTypeComboBox.removeAllItems();
        ArrayList specs = new ArrayList(EntityRegistry.getDefault().getAllVisible());
        Collections.sort(specs, new TypeSpecDisplayNameComparator());
        this._entityTypeComboBox.addItem(ALL);
        for (MaltegoEntitySpec spec : specs) {
            this._entityTypeComboBox.addItem(spec);
        }
    }

    public void savePath() {
        String path = this.getPath();
        NbPreferences.forModule(FileChooserBuilder.class).put(GraphDataObject.class.getName(), path);
    }

    private class ClearErrorListener
    implements DocumentListener {
        private ClearErrorListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            FindSettingsPanel.this.setError("");
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FindSettingsPanel.this.setError("");
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            FindSettingsPanel.this.setError("");
        }
    }

    private class SearchActionListener
    implements ActionListener {
        private SearchActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindSettingsPanel.this.firePropertyChange(FindSettingsPanel.PROP_FIND, null, null);
        }
    }

    private class ItemsListener
    implements ChangeListener {
        private ItemsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(FindSettingsPanel.this._updating || FindSettingsPanel.this._entitiesCheckBox.isSelected() || FindSettingsPanel.this._linksCheckBox.isSelected())) {
                FindSettingsPanel.this._entitiesCheckBox.setSelected(true);
            }
            FindSettingsPanel.this._entityTypeComboBox.setEnabled(FindSettingsPanel.this._entitiesCheckBox.isSelected());
        }
    }

    private class ToggleListener
    implements ChangeListener {
        private ToggleListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(FindSettingsPanel.this._updating || FindSettingsPanel.this._valueCheckBox.isSelected() || FindSettingsPanel.this._propertiesCheckBox.isSelected() || FindSettingsPanel.this._displayInfoCheckBox.isSelected() || FindSettingsPanel.this._notesCheckBox.isSelected())) {
                FindSettingsPanel.this._valueCheckBox.setSelected(true);
            }
        }
    }
}

