/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.impl;

import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.find.files.FindInFilesInput;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.StringUtilities;
import java.util.regex.Matcher;

public class SnippetBuilder {
    private static final int SNIPPET_MARGIN = 10;
    private final SpecRegistry _registry;
    private final FindInFilesInput _input;
    private final String _searchText;

    public SnippetBuilder(SpecRegistry registry, FindInFilesInput input) {
        this._registry = registry;
        this._input = input;
        this._searchText = this.getText(this._input.getText());
    }

    public String buildSnippet(MaltegoPart part) {
        String notes;
        DisplayInformationCollection infos;
        PropertyDescriptorCollection descs;
        if (StringUtilities.isNullOrEmpty((String)this._input.getText())) {
            return "<everything>";
        }
        StringBuilder sb = new StringBuilder();
        PropertyDescriptor displayValuePd = null;
        if (this._input.isSearchValue()) {
            String dispExpr = InheritanceHelper.getDisplayValueExpression((SpecRegistry)this._registry, (TypedPropertyBag)part);
            displayValuePd = part.getProperties().get(dispExpr);
            String value = part.getDisplayString();
            if (this.match(value)) {
                sb.append("Value:");
                this.appendSnippets(sb, value);
            }
        }
        if (this._input.isSearchProperties() && (descs = part.getProperties()) != null) {
            for (PropertyDescriptor d : descs) {
                Object value;
                if (d.equals(displayValuePd) || !this.matches(value = part.getValue(d))) continue;
                String text = value.toString();
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(d.getDisplayName());
                sb.append(":");
                this.appendSnippets(sb, text);
            }
        }
        if (this._input.isSearchDisplayInfo() && (infos = part.getDisplayInformation()) != null) {
            boolean isFirst = true;
            for (DisplayInformation info : infos) {
                String value = info.getValue();
                if (!this.match(value)) continue;
                if (isFirst) {
                    isFirst = false;
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append("Display Info:");
                }
                this.appendSnippets(sb, value);
            }
        }
        if (this._input.isSearchNotes() && this.match(notes = part.getNotes())) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("Notes:");
            this.appendSnippets(sb, notes);
        }
        return sb.toString();
    }

    private boolean matches(Object value) {
        if (value == null) {
            return false;
        }
        if (this._input.isRegex()) {
            return this._input.matches(value.toString());
        }
        return this.getText(value.toString()).contains(this._searchText);
    }

    private boolean match(String text) {
        if (this._input.isRegex()) {
            return this._input.matches(text);
        }
        return text != null && this.getText(text).contains(this._searchText);
    }

    private String getText(String text) {
        if (!this._input.isCaseSensitive()) {
            return text.toLowerCase();
        }
        return text;
    }

    private void appendSnippets(StringBuilder sb, String value) {
        int snippetEnd;
        if (this._input.isRegex()) {
            this.appendSnippetsRegex(sb, value);
            return;
        }
        do {
            int indexOf = this.getText(value).indexOf(this._searchText);
            int snippetStart = 0;
            if (indexOf > 10) {
                sb.append("...");
                snippetStart = indexOf - 10;
            }
            int nextMatch = indexOf;
            do {
                snippetEnd = nextMatch + this._searchText.length();
            } while ((nextMatch = this.getText(value).indexOf(this._searchText, snippetEnd)) > 0 && nextMatch - snippetEnd < 10);
            snippetEnd += 10;
            snippetEnd = Math.min(snippetEnd, value.length());
            sb.append(value.substring(snippetStart, snippetEnd));
        } while (this.match(value = value.substring(snippetEnd)));
        if (!value.isEmpty()) {
            sb.append("...");
        }
    }

    private void appendSnippetsRegex(StringBuilder sb, String value) {
        Matcher matcher = this._input.getPattern().matcher(value);
        boolean prevEnd = false;
        while (matcher.find()) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            sb.append(value.substring(matchStart, matchEnd));
        }
    }
}

