/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.impl;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.find.files.FindInFilesInput;
import com.paterva.maltego.find.files.FindInFilesResult;
import com.paterva.maltego.find.files.impl.SnippetBuilder;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.imex.AbstractMaltegoInputHandler;
import com.paterva.maltego.ui.graph.imex.LinkInputHandlerProvider;
import com.paterva.maltego.ui.graph.imex.MaltegoLinkIO;
import com.paterva.maltego.util.StringUtilities;
import java.util.concurrent.atomic.AtomicBoolean;
import org.w3c.dom.Node;
import y.base.DataAcceptor;
import y.io.graphml.input.GraphMLParseException;
import y.io.graphml.input.InputHandler;
import y.io.graphml.input.QueryInputHandlersEvent;
import y.util.DataAcceptorAdapter;

public class FindLinkInputHandlerProvider
extends LinkInputHandlerProvider {
    private FindInFilesInput _input;
    private FindInFilesResult _result;
    private LinkRegistry _registry;
    private SnippetBuilder _snippetBuilder;
    private AtomicBoolean _cancelled;

    public FindLinkInputHandlerProvider(MaltegoLinkIO reader, FindInFilesInput input, FindInFilesResult result, AtomicBoolean cancelled) {
        super(reader);
        this._input = input;
        this._result = result;
        this._registry = LinkRegistry.getDefault();
        this._snippetBuilder = new SnippetBuilder((SpecRegistry)this._registry, this._input);
        this._cancelled = cancelled;
    }

    protected InputHandler getInputHandler(QueryInputHandlersEvent event) throws GraphMLParseException {
        LinkInputHandler handler = new LinkInputHandler();
        handler.setDataAcceptor(this.getDataAcceptor(event));
        handler.initializeFromKeyDefinition(event.getContext(), event.getKeyDefinition());
        return handler;
    }

    protected DataAcceptor getDataAcceptor(QueryInputHandlersEvent event) {
        return new DataAcceptorAdapter(){

            public void set(Object node, Object link) {
                if (!FindLinkInputHandlerProvider.this._cancelled.get() && link instanceof MaltegoLink) {
                    MaltegoLink maltegoLink = (MaltegoLink)link;
                    String snippet = FindLinkInputHandlerProvider.this._snippetBuilder.buildSnippet((MaltegoPart)maltegoLink);
                    if (!StringUtilities.isNullOrEmpty((String)snippet)) {
                        FindInFilesResult.Part part = new FindInFilesResult.Part();
                        part.setPart((MaltegoPart)maltegoLink);
                        part.setMatchSnippet(snippet);
                        FindLinkInputHandlerProvider.this._result.getMatchedParts().add(part);
                    }
                }
            }
        };
    }

    private class LinkInputHandler
    extends AbstractMaltegoInputHandler {
        private LinkInputHandler() {
        }

        public String getNodeLocalName() {
            return "MaltegoLink";
        }

        public MaltegoLink read(Node node) throws GraphMLParseException {
            String text;
            if (!FindLinkInputHandlerProvider.this._cancelled.get() && (FindLinkInputHandlerProvider.this._input.isRegex() ? FindLinkInputHandlerProvider.this._input.matches(node.getTextContent()) : StringUtilities.isNullOrEmpty((String)(text = FindLinkInputHandlerProvider.this._input.getText())) || node.getTextContent().toLowerCase().contains(text.toLowerCase()))) {
                return FindLinkInputHandlerProvider.this.getReader().read(node);
            }
            return null;
        }
    }
}

