/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.impl;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.find.files.FindInFilesInput;
import com.paterva.maltego.find.files.FindInFilesResult;
import com.paterva.maltego.find.files.impl.SnippetBuilder;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.imex.AbstractMaltegoInputHandler;
import com.paterva.maltego.ui.graph.imex.EntityInputHandlerProvider;
import com.paterva.maltego.ui.graph.imex.MaltegoEntityIO;
import com.paterva.maltego.util.StringUtilities;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.w3c.dom.Node;
import y.base.DataAcceptor;
import y.io.graphml.input.GraphMLParseException;
import y.io.graphml.input.InputHandler;
import y.io.graphml.input.QueryInputHandlersEvent;
import y.util.DataAcceptorAdapter;

public class FindEntityInputHandlerProvider
extends EntityInputHandlerProvider {
    private FindInFilesInput _input;
    private FindInFilesResult _result;
    private EntityRegistry _registry;
    private SnippetBuilder _snippetBuilder;
    private AtomicBoolean _cancelled;

    public FindEntityInputHandlerProvider(EntityFactory factory, MaltegoEntityIO reader, FindInFilesInput input, FindInFilesResult result, AtomicBoolean cancelled) {
        super(factory, reader);
        this._input = input;
        this._result = result;
        this._registry = EntityRegistry.getDefault();
        this._snippetBuilder = new SnippetBuilder((SpecRegistry)this._registry, this._input);
        this._cancelled = cancelled;
    }

    protected InputHandler getInputHandler(QueryInputHandlersEvent event) throws GraphMLParseException {
        EntityInputHandler handler = new EntityInputHandler();
        handler.setDataAcceptor(this.getDataAcceptor(event));
        handler.initializeFromKeyDefinition(event.getContext(), event.getKeyDefinition());
        return handler;
    }

    protected DataAcceptor getDataAcceptor(QueryInputHandlersEvent event) {
        return new DataAcceptorAdapter(){

            public void set(Object node, Object entity) {
                String snippet;
                MaltegoEntity maltegoEntity;
                if (!FindEntityInputHandlerProvider.this._cancelled.get() && entity instanceof MaltegoEntity && FindEntityInputHandlerProvider.this.isValidType(maltegoEntity = (MaltegoEntity)entity) && !StringUtilities.isNullOrEmpty((String)(snippet = FindEntityInputHandlerProvider.this._snippetBuilder.buildSnippet((MaltegoPart)maltegoEntity)))) {
                    FindInFilesResult.Part part = new FindInFilesResult.Part();
                    part.setPart((MaltegoPart)maltegoEntity);
                    part.setMatchSnippet(snippet);
                    FindEntityInputHandlerProvider.this._result.getMatchedParts().add(part);
                }
            }
        };
    }

    private boolean isValidType(MaltegoEntity maltegoEntity) {
        String typeName = this._input.getEntityType();
        String entityTypeName = maltegoEntity.getTypeName();
        if (!StringUtilities.isNullOrEmpty((String)typeName) && !typeName.equals(entityTypeName)) {
            List inheritedSpecs = InheritanceHelper.getInheritanceList((SpecRegistry)this._registry, (String)entityTypeName);
            return inheritedSpecs != null && inheritedSpecs.contains(typeName);
        }
        return true;
    }

    private class EntityInputHandler
    extends AbstractMaltegoInputHandler {
        private EntityInputHandler() {
        }

        public String getNodeLocalName() {
            return "MaltegoEntity";
        }

        public MaltegoEntity read(Node node) throws GraphMLParseException {
            String text;
            if (!FindEntityInputHandlerProvider.this._cancelled.get() && (FindEntityInputHandlerProvider.this._input.isRegex() ? FindEntityInputHandlerProvider.this._input.matches(node.getTextContent()) : StringUtilities.isNullOrEmpty((String)(text = FindEntityInputHandlerProvider.this._input.getText())) || node.getTextContent().toLowerCase().contains(text.toLowerCase()))) {
                return FindEntityInputHandlerProvider.this.getReader().read(node, FindEntityInputHandlerProvider.this.getFactory());
            }
            return null;
        }
    }
}

