/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.find.files.FindInFilesResult;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.paterva.maltego.ui.graph.view2d.ZoomAndFlasher;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import y.base.Graph;
import y.view.Graph2D;

public class SelectEntityAction
extends NodeAction {
    public String getName() {
        return "Select";
    }

    protected boolean enable(Node[] nodes) {
        return nodes.length > 0;
    }

    protected void performAction(Node[] nodes) {
        HashMap<Node, ArrayList<Node>> nodesPerGraph = new HashMap<Node, ArrayList<Node>>();
        for (Node node : nodes) {
            Node parentNode = node.getParentNode();
            ArrayList<Node> childNodes = (ArrayList<Node>)nodesPerGraph.get(parentNode);
            if (childNodes == null) {
                childNodes = new ArrayList<Node>();
                nodesPerGraph.put(parentNode, childNodes);
            }
            childNodes.add(node);
        }
        for (Map.Entry entry : nodesPerGraph.entrySet()) {
            Node parentNode = (Node)entry.getKey();
            FindInFilesResult result = (FindInFilesResult)parentNode.getLookup().lookup(FindInFilesResult.class);
            if (result == null) continue;
            try {
                File file = new File(result.getFolderPath(), result.getGraphName());
                FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                if (fo == null) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("The file was not found:\n" + file.getAbsolutePath()), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    continue;
                }
                DataObject dataObject = DataObject.find((FileObject)fo);
                if (dataObject == null) continue;
                OpenCookie open = (OpenCookie)dataObject.getLookup().lookup(OpenCookie.class);
                open.open();
                Timer timer = new Timer(200, null);
                timer.addActionListener(new SelectTimerListener(dataObject, (List)entry.getValue(), timer));
                timer.setInitialDelay(0);
                timer.setRepeats(true);
                timer.start();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private Set<EntityID> getMatchingEntities(Graph graph, List<Node> nodes) {
        HashSet<EntityID> toSelect = new HashSet<EntityID>();
        for (Node node : nodes) {
            MaltegoEntity foundEntity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class);
            if (foundEntity == null) continue;
            toSelect.add((EntityID)foundEntity.getID());
        }
        return toSelect;
    }

    private GraphViewCookie getGraphViewCookie(DataObject dao) {
        Set topComponents = GraphEditorRegistry.getDefault().getOpen();
        for (TopComponent topComponent : topComponents) {
            DataObject dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class);
            if (!dao.equals(dataObject)) continue;
            return (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class);
        }
        return null;
    }

    private void zoomToSelection(GraphViewCookie cookie) {
        ZoomToSelectionAction zoomAction = (ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class);
        if (zoomAction != null) {
            zoomAction.zoomToSelection(cookie);
        }
    }

    class SelectTimerListener
    implements ActionListener {
        private final DataObject _dataObject;
        private final List<Node> _nodes;
        private final Timer _timer;

        public SelectTimerListener(DataObject dao, List<Node> nodes, Timer timer) {
            this._dataObject = dao;
            this._nodes = nodes;
            this._timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Graph2D graph;
            Graph2D graph2D = null;
            GraphViewCookie cookie = SelectEntityAction.this.getGraphViewCookie(this._dataObject);
            if (cookie != null && (graph = cookie.getGraphView().getViewGraph()) instanceof Graph2D) {
                graph2D = graph;
            }
            if (graph2D != null) {
                if (graph2D.isEmpty()) return;
                this._timer.stop();
                try {
                    WindowUtil.showWaitCursor();
                    Set toSelect = SelectEntityAction.this.getMatchingEntities((Graph)graph2D, this._nodes);
                    GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph2D);
                    if (toSelect == null || toSelect.isEmpty()) return;
                    GraphSelection.forGraph((GraphID)graphID).setSelectedModelEntities((Collection)toSelect);
                    if (toSelect.size() == 1) {
                        try {
                            EntityID entityID = (EntityID)toSelect.iterator().next();
                            ZoomAndFlasher.instance().zoomAndFlash(graphID, entityID);
                            return;
                        }
                        catch (GraphStoreException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        return;
                    }
                    SelectEntityAction.this.zoomToSelection(cookie);
                    return;
                }
                finally {
                    WindowUtil.hideWaitCursor();
                }
            } else {
                this._timer.stop();
            }
        }
    }
}

