/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.customicons.imex.IconConfig;
import com.paterva.maltego.customicons.imex.IconDescriptor;
import com.paterva.maltego.customicons.imex.IconFileEntry;
import com.paterva.maltego.customicons.imex.IconMetadata;
import com.paterva.maltego.customicons.imex.IconMetadataEntry;
import com.paterva.maltego.customicons.imex.SelectableCategory;
import com.paterva.maltego.customicons.imex.SelectableIcon;
import com.paterva.maltego.customicons.imex.Util;
import com.paterva.maltego.imgfactory.icons.IconLayerRegistry;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class IconExporter
extends ConfigExporter {
    public Config getCurrentConfig() {
        IconLayerRegistry iconRegistry = IconLayerRegistry.getDefault();
        List<IconDescriptor> descriptors = Util.createDescriptors(iconRegistry);
        List<IconMetadata> metadatas = Util.getIconMetadatas(iconRegistry);
        List<SelectableCategory> createSelectables = Util.createSelectables(descriptors, metadatas);
        return new IconConfig(createSelectables);
    }

    public int saveConfig(MaltegoArchiveWriter writer, Config config) throws IOException {
        int num = 0;
        IconConfig iconConfig = (IconConfig)config;
        for (SelectableCategory selectableCategory : iconConfig.getSelectedCategories()) {
            for (SelectableIcon selectableIcon : selectableCategory.getSelectedIcons()) {
                for (IconDescriptor iconDescriptor : selectableIcon.getIcons()) {
                    IconFileEntry entry = new IconFileEntry(iconDescriptor);
                    writer.write((Entry)entry);
                }
                Optional<IconMetadata> metadata = selectableIcon.getMetadata();
                if (metadata.isPresent()) {
                    IconMetadataEntry entry = new IconMetadataEntry(metadata.get());
                    writer.write((Entry)entry);
                }
                ++num;
            }
        }
        return num;
    }
}

